/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.swing;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import org.xBaseJ.DBF;
import org.xBaseJ.awt.dbfFileFilter;
import org.xBaseJ.swing.dbfCreateModel;
import org.xBaseJ.xBaseJException;

public class dbfCreate
extends JFrame
implements ActionListener,
WindowListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    Vector names;
    String fname = null;
    JTable table;
    JMenuBar menuBar;
    JMenu menuFile;
    JMenu menuType;
    JMenu menuField;
    JMenuItem menuCreate;
    JMenuItem menuOpen;
    JCheckBoxMenuItem typeIV;
    JCheckBoxMenuItem typeIII;
    JCheckBoxMenuItem typeFP;
    JMenuItem menuInsertBefore;
    JMenuItem menuInsertAfter;
    JMenuItem menuDelete;
    JScrollPane tableScrollPane;
    dbfCreateModel tableModel;
    private String lastDirectory = "./.";

    public dbfCreate() {
        this.setTitle("org.xBaseJ Version: 2.1.R Create dBase File: unnamed");
        this.tableModel = new dbfCreateModel();
        this.table = new JTable(this.tableModel);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.setUpColumnModel();
        this.tableScrollPane = new JScrollPane(this.table);
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.menuFile = new JMenu("File");
        this.menuBar.add(this.menuFile);
        this.menuOpen = new JMenuItem("Copy from...");
        this.menuCreate = new JMenuItem("Create...");
        this.menuFile.add(this.menuOpen);
        this.menuFile.add(this.menuCreate);
        this.menuField = new JMenu("Field");
        this.menuBar.add(this.menuField);
        this.menuInsertBefore = new JMenuItem("Insert before");
        this.menuInsertAfter = new JMenuItem("Insert after");
        this.menuDelete = new JMenuItem("Delete");
        this.menuField.add(this.menuInsertBefore);
        this.menuField.add(this.menuInsertAfter);
        this.menuField.add(this.menuDelete);
        this.menuType = new JMenu("Type: dBaseIV");
        this.menuBar.add(this.menuType);
        this.typeIV = new JCheckBoxMenuItem("dBaseIV", true);
        this.menuType.add(this.typeIV);
        this.typeIII = new JCheckBoxMenuItem("dBaseIII", false);
        this.menuType.add(this.typeIII);
        this.typeFP = new JCheckBoxMenuItem("FoxPro", false);
        this.menuType.add(this.typeFP);
        this.getContentPane().setLayout(new GridLayout(1, 0));
        Dimension min = new Dimension(200, 150);
        this.tableScrollPane.setMinimumSize(min);
        this.getContentPane().add(this.tableScrollPane);
        this.menuOpen.addActionListener(this);
        this.menuCreate.addActionListener(this);
        this.menuInsertBefore.addActionListener(this);
        this.menuInsertAfter.addActionListener(this);
        this.menuDelete.addActionListener(this);
        this.typeIV.addActionListener(this);
        this.typeIII.addActionListener(this);
        this.typeFP.addActionListener(this);
        this.addWindowListener(this);
    }

    public void actionPerformed(ActionEvent ae) {
        File fil;
        JFileChooser jfc;
        if (ae.getSource() == this.menuOpen) {
            jfc = new JFileChooser(new File(this.lastDirectory + "/*.dbf"));
            jfc.addChoosableFileFilter(new dbfFileFilter());
            jfc.showOpenDialog(this);
            fil = jfc.getSelectedFile();
            if (fil == null) {
                this.repaint();
                return;
            }
            this.setCursor(new Cursor(3));
            this.lastDirectory = fil.getPath();
            this.fname = fil.getAbsolutePath();
            this.getContentPane().remove(this.tableScrollPane);
            try {
                DBF dbf = new DBF(this.fname);
                this.tableModel = new dbfCreateModel(dbf);
                this.setTitle("Create dBase File: " + fil.getName());
                if (dbf.getVersion() == 4 || dbf.getVersion() == -117) {
                    this.menuType.setText("Type: dBaseIV");
                    this.typeIV.setState(true);
                    this.typeIII.setState(false);
                    this.typeFP.setState(false);
                } else if (dbf.getVersion() == 3 || dbf.getVersion() == -125) {
                    this.menuType.setText("Type: dBaseIII");
                    this.typeIV.setState(false);
                    this.typeIII.setState(true);
                    this.typeFP.setState(false);
                } else if (dbf.getVersion() == -11) {
                    this.menuType.setText("Type: FoxPro");
                    this.typeIV.setState(false);
                    this.typeIII.setState(false);
                    this.typeFP.setState(true);
                }
            }
            catch (xBaseJException xex) {
                JOptionPane.showMessageDialog(this, xex.getMessage(), "xBaseJException Occurred", 0);
                this.repaint();
                return;
            }
            catch (IOException ioex) {
                JOptionPane.showMessageDialog(this, ioex.getMessage(), "IOException Occurred", 0);
                this.repaint();
                return;
            }
            this.table = new JTable(this.tableModel);
            this.table.setAutoResizeMode(0);
            this.table.getSelectionModel().addListSelectionListener(this);
            this.setUpColumnModel();
            this.tableScrollPane = new JScrollPane(this.table);
            Dimension min = new Dimension(200, 150);
            this.tableScrollPane.setMinimumSize(min);
            this.getContentPane().add(this.tableScrollPane);
            this.table.revalidate();
            this.table.repaint();
            this.validate();
            this.setCursor(new Cursor(0));
        }
        if (ae.getSource() == this.menuCreate) {
            int resp;
            jfc = new JFileChooser(new File(this.lastDirectory + "/*.dbf"));
            jfc.addChoosableFileFilter(new dbfFileFilter());
            jfc.showSaveDialog(this);
            fil = jfc.getSelectedFile();
            if (fil == null) {
                this.repaint();
                return;
            }
            if (fil.exists() && (resp = JOptionPane.showConfirmDialog(this, "File " + fil.getName() + " already exists.  Do you want to replace it?", "File Already Exists", 0)) != 0) {
                this.repaint();
                return;
            }
            this.setCursor(new Cursor(3));
            this.lastDirectory = fil.getPath();
            this.fname = fil.getAbsolutePath();
            this.setCursor(new Cursor(3));
            TableCellEditor editor = this.table.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            int type = -1;
            if (this.typeIII.getState()) {
                type = 3;
            }
            type = this.typeFP.getState() ? -11 : 4;
            try {
                this.tableModel.create(fil, type);
            }
            catch (xBaseJException xex) {
                JOptionPane.showMessageDialog(this, xex.getMessage(), "xBaseJException Occurred", 0);
                this.repaint();
                this.setCursor(new Cursor(0));
                return;
            }
            catch (NumberFormatException nfex) {
                JOptionPane.showMessageDialog(this, nfex.getMessage(), "NumberFormatException Occurred", 0);
                this.repaint();
                this.setCursor(new Cursor(0));
                return;
            }
            catch (IOException ioex) {
                JOptionPane.showMessageDialog(this, ioex.getMessage(), "IOException Occurred", 0);
                this.repaint();
                this.setCursor(new Cursor(0));
                return;
            }
            this.setCursor(new Cursor(0));
            this.setTitle("Create dBase File: " + fil.getName());
        }
        if (ae.getSource() == this.typeIV) {
            this.menuType.setText("Type: dBaseIV");
            this.typeIV.setState(true);
            this.typeIII.setState(false);
            this.typeFP.setState(false);
        }
        if (ae.getSource() == this.typeIII) {
            this.menuType.setText("Type: dBaseIII");
            this.typeIV.setState(false);
            this.typeIII.setState(true);
            this.typeFP.setState(false);
        }
        if (ae.getSource() == this.typeFP) {
            this.menuType.setText("Type: FoxPro");
            this.typeIV.setState(false);
            this.typeIII.setState(false);
            this.typeFP.setState(true);
        }
        if (ae.getSource() == this.menuInsertBefore) {
            if (this.tableModel.getRowCount() < 1) {
                this.tableModel.insert(0);
            } else if (this.table.getSelectedRow() < 0) {
                this.tableModel.insert(this.tableModel.getRowCount());
            } else {
                this.tableModel.insert(this.table.getSelectedRow());
            }
            this.table.repaint();
        }
        if (ae.getSource() == this.menuInsertAfter) {
            if (this.tableModel.getRowCount() < 1) {
                this.tableModel.insert(0);
            } else if (this.table.getSelectedRow() < 0) {
                this.tableModel.insert(this.tableModel.getRowCount() - 1);
            } else {
                this.tableModel.insert(this.table.getSelectedRow() + 1);
            }
            this.table.repaint();
        }
        if (ae.getSource() == this.menuDelete) {
            if (this.table.getSelectedRow() >= 0) {
                this.tableModel.delete(this.table.getSelectedRow());
            }
            this.table.repaint();
        }
        this.repaint();
    }

    public void setUpColumnModel() {
        JComboBox<String> jcb = new JComboBox<String>();
        jcb.addItem("Char");
        jcb.addItem("Date");
        jcb.addItem("Float");
        jcb.addItem("Logical");
        jcb.addItem("Memo");
        jcb.addItem("Num");
        jcb.addItem("Picture");
        this.table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(jcb));
    }

    public static void main(String[] args) {
        dbfCreate frame = new dbfCreate();
        frame.setSize(400, 125);
        frame.setVisible(true);
    }

    public void windowClosing(WindowEvent we) {
        System.exit(0);
    }

    public void windowOpened(WindowEvent we) {
    }

    public void windowClosed(WindowEvent we) {
        System.exit(0);
    }

    public void windowIconified(WindowEvent we) {
    }

    public void windowDeiconified(WindowEvent we) {
    }

    public void windowActivated(WindowEvent we) {
    }

    public void windowDeactivated(WindowEvent we) {
    }

    public void valueChanged(ListSelectionEvent e) {
        e.getSource();
    }
}

