/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.backup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;

public class PzBackup {
    public void backupPGSQL() {
        try {
            Properties prop = new Properties();
            prop.load(new FileInputStream(new File("backup.properties")));
            String dbNamesStr = prop.getProperty("db.names");
            String[] dbNamesArray = dbNamesStr.split(",");
            Runtime r = Runtime.getRuntime();
            String backupDestination = prop.getProperty("backup.dir");
            String serverIp = prop.getProperty("db.server");
            String user = "pezar";
            String password = "p324r";
            String pgdump = prop.getProperty("pg_dump.dir");
            String prefix = prop.getProperty("backup.prefix");
            TimeZone zonah = TimeZone.getTimeZone("GMT+1");
            Calendar Calendario = GregorianCalendar.getInstance(zonah, new Locale("en"));
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            StringBuffer date = new StringBuffer();
            String yyyy = new SimpleDateFormat("yyyy").format(Calendario.getTime());
            date.append(df.format(Calendario.getTime()));
            int i = 0;
            while (i < dbNamesArray.length) {
                String dbase = dbNamesArray[i].trim().replace("YYYY", yyyy);
                String backupDir = String.valueOf(backupDestination) + File.separator + yyyy + File.separator + (!dbase.equals(yyyy) ? String.valueOf(dbase.replace(yyyy, "")) + File.separator : "");
                File file = new File(backupDir);
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (file.exists()) {
                    StringBuffer fechafile = new StringBuffer();
                    fechafile.append(backupDir);
                    fechafile.append(!dbase.equals(yyyy) ? dbase.replace(yyyy, "") : prefix);
                    fechafile.append(date.toString());
                    fechafile.append(".backup");
                    File ficherofile = new File(fechafile.toString());
                    if (ficherofile.exists()) {
                        ficherofile.delete();
                    }
                    r = Runtime.getRuntime();
                    ProcessBuilder pb = new ProcessBuilder(String.valueOf(pgdump) + "pg_dump.exe", "-f", fechafile.toString(), "-F", "c", "-Z", "9", "-v", "-o", "-h", serverIp, "-U", user, dbase);
                    pb.environment().put("PGPASSWORD", password);
                    pb.redirectErrorStream(true);
                    Process p = pb.start();
                    try {
                        String ll;
                        InputStream is = p.getInputStream();
                        InputStreamReader isr = new InputStreamReader(is);
                        BufferedReader br = new BufferedReader(isr);
                        while ((ll = br.readLine()) != null) {
                            System.out.println(ll);
                        }
                    }
                    catch (IOException e) {
                        System.out.println(e);
                        this.log("ERROR " + e.getMessage());
                    }
                }
                ++i;
            }
        }
        catch (IOException x) {
            System.err.println("Could not invoke browser, command=");
            System.err.println("Caught: " + x.getMessage());
            this.log(x.getMessage());
        }
    }

    private void log(String error) {
        try {
            FileWriter out = new FileWriter(new File("backup.log"));
            out.append(error);
        }
        catch (IOException e) {
            System.err.println("Caught: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        PzBackup p = new PzBackup();
        p.backupPGSQL();
    }
}

