/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultUnitOfWork;
import org.apache.camel.impl.MDCUnitOfWork;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.UnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnitOfWorkProcessor
extends DelegateAsyncProcessor {
    private static final transient Logger LOG = LoggerFactory.getLogger(UnitOfWorkProcessor.class);
    private final RouteContext routeContext;
    private final String routeId;

    public UnitOfWorkProcessor(Processor processor) {
        this(null, processor);
    }

    public UnitOfWorkProcessor(AsyncProcessor processor) {
        this(null, processor);
    }

    public UnitOfWorkProcessor(RouteContext routeContext, Processor processor) {
        super(processor);
        this.routeContext = routeContext;
        this.routeId = routeContext != null ? routeContext.getRoute().idOrCreate(routeContext.getCamelContext().getNodeIdFactory()) : null;
    }

    public UnitOfWorkProcessor(RouteContext routeContext, AsyncProcessor processor) {
        super(processor);
        this.routeContext = routeContext;
        this.routeId = routeContext != null ? routeContext.getRoute().idOrCreate(routeContext.getCamelContext().getNodeIdFactory()) : null;
    }

    @Override
    public String toString() {
        return "UnitOfWork(" + this.processor + ")";
    }

    public RouteContext getRouteContext() {
        return this.routeContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        if (this.routeId != null && exchange.getFromRouteId() == null) {
            exchange.setFromRouteId(this.routeId);
        }
        if (exchange.getUnitOfWork() == null) {
            DefaultUnitOfWork unitOfWork = exchange.getContext().isUseMDCLogging() != false ? new MDCUnitOfWork(exchange) : new DefaultUnitOfWork(exchange);
            final DefaultUnitOfWork uow = unitOfWork;
            exchange.setUnitOfWork(uow);
            try {
                uow.start();
            }
            catch (Exception e) {
                callback.done(true);
                exchange.setException(e);
                return true;
            }
            try {
                return this.processor.process(exchange, new AsyncCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void done(boolean doneSync) {
                        try {
                            callback.done(doneSync);
                        }
                        finally {
                            UnitOfWorkProcessor.this.doneUow(uow, exchange);
                        }
                    }
                });
            }
            catch (Throwable e) {
                LOG.warn("Caught unhandled exception while processing ExchangeId: " + exchange.getExchangeId(), e);
                exchange.setException(e);
                try {
                    callback.done(true);
                }
                finally {
                    this.doneUow(uow, exchange);
                }
                return true;
            }
        }
        return this.processor.process(exchange, callback);
    }

    private void doneUow(UnitOfWork uow, Exchange exchange) {
        try {
            if (exchange.getUnitOfWork() != null) {
                exchange.getUnitOfWork().done(exchange);
            }
        }
        catch (Throwable e) {
            LOG.warn("Exception occurred during done UnitOfWork for Exchange: " + exchange + ". This exception will be ignored.", e);
        }
        try {
            uow.stop();
        }
        catch (Throwable e) {
            LOG.warn("Exception occurred during stopping UnitOfWork for Exchange: " + exchange + ". This exception will be ignored.", e);
        }
        exchange.setUnitOfWork(null);
    }
}

