/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Endpoint;
import org.apache.camel.component.properties.DefaultPropertiesParser;
import org.apache.camel.component.properties.DefaultPropertiesResolver;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.component.properties.PropertiesResolver;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesComponent
extends DefaultComponent {
    public static final String PREFIX_TOKEN = "{{";
    public static final String SUFFIX_TOKEN = "}}";
    private static final Pattern ENV_PATTERN = Pattern.compile("\\$\\{env:(.*?)\\}", 32);
    private static final Pattern SYS_PATTERN = Pattern.compile("\\$\\{(.*?)\\}", 32);
    private static final transient Logger LOG = LoggerFactory.getLogger(PropertiesComponent.class);
    private final Map<String[], Properties> cacheMap = new LRUCache<String[], Properties>(1000);
    private PropertiesResolver propertiesResolver = new DefaultPropertiesResolver();
    private PropertiesParser propertiesParser = new DefaultPropertiesParser();
    private String[] locations;
    private boolean cache = true;

    public PropertiesComponent() {
    }

    public PropertiesComponent(String location) {
        this.setLocation(location);
    }

    public PropertiesComponent(String ... locations) {
        this.setLocations(locations);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String[] paths = this.locations;
        String locations = this.getAndRemoveParameter(parameters, "locations", String.class);
        if (locations != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Overriding default locations with location: " + locations);
            }
            paths = locations.split(",");
        }
        String endpointUri = this.parseUri(remaining, paths);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Endpoint uri parsed as: " + endpointUri);
        }
        return this.getCamelContext().getEndpoint(endpointUri);
    }

    public String parseUri(String uri) throws Exception {
        return this.parseUri(uri, this.locations);
    }

    public String parseUri(String uri, String ... paths) throws Exception {
        Properties prop;
        ObjectHelper.notNull(paths, "paths");
        String[] locations = this.parseLocations(paths);
        Properties properties = prop = this.cache ? this.cacheMap.get(locations) : null;
        if (prop == null) {
            prop = this.propertiesResolver.resolveProperties(this.getCamelContext(), locations);
            if (this.cache) {
                this.cacheMap.put(locations, prop);
            }
        }
        if (!uri.contains(PREFIX_TOKEN) && !uri.startsWith(PREFIX_TOKEN)) {
            uri = PREFIX_TOKEN + uri;
        }
        if (!uri.contains(SUFFIX_TOKEN) && !uri.endsWith(SUFFIX_TOKEN)) {
            uri = uri + SUFFIX_TOKEN;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Parsing uri " + uri + " with properties: " + prop);
        }
        return this.propertiesParser.parseUri(uri, prop, PREFIX_TOKEN, SUFFIX_TOKEN);
    }

    public String[] getLocations() {
        return this.locations;
    }

    public void setLocations(String[] locations) {
        this.locations = locations;
    }

    public void setLocation(String location) {
        this.setLocations(location.split(","));
    }

    public PropertiesResolver getPropertiesResolver() {
        return this.propertiesResolver;
    }

    public void setPropertiesResolver(PropertiesResolver propertiesResolver) {
        this.propertiesResolver = propertiesResolver;
    }

    public PropertiesParser getPropertiesParser() {
        return this.propertiesParser;
    }

    public void setPropertiesParser(PropertiesParser propertiesParser) {
        this.propertiesParser = propertiesParser;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    @Override
    protected void doStop() throws Exception {
        this.cacheMap.clear();
        super.doStop();
    }

    private String[] parseLocations(String[] locations) {
        String[] answer = new String[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            String value;
            String key;
            String location = locations[i];
            LOG.trace("Parsing location: {} ", (Object)location);
            Matcher matcher = ENV_PATTERN.matcher(location);
            while (matcher.find()) {
                key = matcher.group(1);
                value = System.getenv(key);
                if (ObjectHelper.isEmpty(value)) {
                    throw new IllegalArgumentException("Cannot find system environment with key: " + key);
                }
                location = matcher.replaceFirst(value);
                matcher = ENV_PATTERN.matcher(location);
            }
            matcher = SYS_PATTERN.matcher(location);
            while (matcher.find()) {
                key = matcher.group(1);
                value = System.getProperty(key);
                if (ObjectHelper.isEmpty(value)) {
                    throw new IllegalArgumentException("Cannot find JVM system property with key: " + key);
                }
                location = matcher.replaceFirst(value);
                matcher = SYS_PATTERN.matcher(location);
            }
            LOG.debug("Parsed location: {} ", (Object)location);
            answer[i] = location;
        }
        return answer;
    }
}

