/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.commands.BaseCommand;

public class StatusCommand
extends BaseCommand {
    public StatusCommand(File repository, String environment, boolean force) {
        super(repository, environment, force);
    }

    public void execute(String ... params) {
        out.println("ID             Applied At          Description");
        out.println(this.horizontalLine("", 80));
        ArrayList<Change> merged = new ArrayList<Change>();
        List<Change> migrations = this.getMigrations();
        if (this.changelogExists()) {
            List<Change> changelog = this.getChangelog();
            for (Change change : migrations) {
                int index = changelog.indexOf(change);
                if (index > -1) {
                    merged.add(changelog.get(index));
                    continue;
                }
                merged.add(change);
            }
            Collections.sort(merged);
        } else {
            merged.addAll(migrations);
        }
        for (Change change : merged) {
            out.println(change);
        }
        out.println();
    }
}

