/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.reports.dokumentResolver;

import java.math.BigDecimal;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.engine.dokument.PzDokumentResolver;

public class KalkulacijaResolver
extends PzDokumentResolver {
    private Kalkulacija k;

    @Override
    public Object[] getValues(PzEntity ad) {
        Artikalkalkulacija ak = (Artikalkalkulacija)ad;
        String tip = ak.getKalkulacija().getRadnajedinica().getgTip();
        BigDecimal fakturnaCena = BDConverter.getFakturnaCena((double)ak.getFakturnaCena());
        BigDecimal kolicina = BDConverter.getKolicina((double)ak.getKolicina());
        BigDecimal fakturnaVrednost = fakturnaCena.multiply(kolicina);
        BigDecimal stopa = BDConverter.getStopaPDV((double)ak.getTaksa("PDV").getStopa());
        BigDecimal prodCenaBezPDV = null;
        BigDecimal procRabata = BDConverter.getProcRabata100((double)ak.getProcRabata());
        BigDecimal vredRabata = BDConverter.getIznos((BigDecimal)fakturnaVrednost.multiply(procRabata));
        BigDecimal netoNabCena = fakturnaCena.subtract(fakturnaCena.multiply(procRabata));
        BigDecimal zavisniTroskovi = ak.calculateZavTrosak();
        BigDecimal nabVrednost = ak.calculateNabVrednost();
        if (this.k.getArtikalkalkulacijas().indexOf(ak) == this.k.getArtikalkalkulacijas().size() - 1) {
            BigDecimal razl = this.k.calculateRazlikaTroskova();
            zavisniTroskovi = zavisniTroskovi.add(razl);
            nabVrednost = nabVrednost.add(razl);
        }
        BigDecimal prodVrednost = BDConverter.getIznos((BigDecimal)ak.getProdCena().multiply(kolicina));
        BigDecimal prodVrednostBezPDV = new BigDecimal(0);
        BigDecimal ukalkulisaniPorez = BDConverter.getIznos((double)(ak.getProdCena().multiply(stopa).doubleValue() / new BigDecimal("100").add(stopa).doubleValue() * kolicina.doubleValue()));
        if (tip.equals("V")) {
            prodCenaBezPDV = ak.getProdCena();
            prodVrednostBezPDV = prodVrednost;
        } else {
            prodCenaBezPDV = BDConverter.getIznos((double)(prodVrednost.multiply(new BigDecimal("100")).doubleValue() / new BigDecimal("100").add(stopa).doubleValue() / kolicina.doubleValue()));
            prodVrednostBezPDV = BDConverter.getIznos((double)(prodVrednost.multiply(new BigDecimal("100")).doubleValue() / new BigDecimal("100").add(stopa).doubleValue()));
        }
        BigDecimal razlUCeni = BDConverter.getIznos((BigDecimal)prodVrednostBezPDV.subtract(nabVrednost));
        if (ak.getKalkulacija().getTip().equals(TipDokumentConfig.get().PRIJEMNICA_REPRO)) {
            return new Object[]{ak.getSifra(), ak.getNaziv(), ak.getJm(), kolicina, fakturnaCena, BDConverter.getProcRabata((double)ak.getProcRabata()), vredRabata, BDConverter.getIznos((BigDecimal)netoNabCena.multiply(kolicina)), zavisniTroskovi, nabVrednost, BDConverter.getIznos((double)(nabVrednost.doubleValue() / kolicina.doubleValue())), ak.getProcRabata()};
        }
        return new Object[]{ak.getSifra(), ak.getNaziv(), ak.getJm(), kolicina, fakturnaCena, vredRabata, zavisniTroskovi, razlUCeni, prodVrednostBezPDV, prodCenaBezPDV, stopa, ukalkulisaniPorez, prodVrednost, ak.getProdCena(), nabVrednost, BDConverter.getIznos((double)(nabVrednost.doubleValue() / kolicina.doubleValue())), ak.getProcRabata(), ak.getProcMarze()};
    }

    @Override
    public void setDokument(PzDokument dokument) {
        this.k = (Kalkulacija)dokument;
    }

    @Override
    public PzDokument getDokument() {
        return this.k;
    }
}

