/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.lpfr.rest;

import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Proizvodfiskalniracun;
import rs.pezar.db.entity.TaxMap;
import rs.pezar.db.entity.Tekuciracun;
import rs.pezar.kasa.lpfr.LPFRException;
import rs.pezar.kasa.lpfr.model.BuyerIdentification;
import rs.pezar.kasa.lpfr.model.InvoiceItem;
import rs.pezar.kasa.lpfr.model.InvoicePayment;
import rs.pezar.kasa.lpfr.model.InvoiceRequest;
import rs.pezar.kasa.lpfr.model.InvoiceResponse;
import rs.pezar.kasa.lpfr.model.InvoiceTransaction;
import rs.pezar.kasa.lpfr.model.RequestParams;
import rs.pezar.kasa.lpfr.model.StatusResponse;
import rs.pezar.kasa.lpfr.model.TaxGroup;
import rs.pezar.util.PzCacheUtility;

public class LPFRClient {
    public static final String VERSION = "8/1.0";
    private HttpClient client = new DefaultHttpClient();
    private List taxMap;
    private static final Map<String, String> statusMap = new HashMap<String, String>();

    static {
        statusMap.put("0210", "Internet je dostupan");
        statusMap.put("0220", "Internet nije dostupan. Daljinsko i\u0161\u010ditavanje nemogu\u0107e.");
        statusMap.put("1100", "Suvi\u0161e malo slobodnog prostora na disku. Neophodna akcija korisnika.");
        statusMap.put("1300", "Smart kartica nije prisutna. Dalji rad nemogu\u0107.");
        statusMap.put("1400", "Upozorenje! I\u0161\u010ditavanje je neophodno. Suma na kartici je pre\u0161la 75% od dozvoljenog limita.");
        statusMap.put("1500", "Operacija se ne mo\u017ee izvr\u0161iti bez prethodno unetog PIN koda.");
        statusMap.put("1999", "Nedefinisana gre\u0161ka");
        statusMap.put("2100", "Pogre\u0161an PIN kod.");
        statusMap.put("2110", "Smart kartica je zaklju\u010dana. Suvi\u0161e pogre\u0161nih poku\u0161aja unosa PIN koda.");
        statusMap.put("2130", "Licenca za upotrebu softvera nije prona\u0111ena");
        statusMap.put("2131", "Licenca za upotrebu softvera je istekla");
        statusMap.put("2132", "Neispravna licenca za upotrebu softvera");
        statusMap.put("2210", "Bezbednosni element je zaklju\u010dan. Neophodno i\u0161\u010ditavanje za nastavak rada.");
        statusMap.put("2220", "Gre\u0161ka prilikom komunikacije sa bezbednosnim elementom.");
        statusMap.put("2240", "Ra\u010dun ne mo\u017ee biti potpisan jer vreme ure\u0111aja nije logi\u010dno!");
        statusMap.put("2250", "Operacija se ne mo\u017ee izvr\u0161iti. Suvi\u0161e malo slobodnog prostora na disku.");
        statusMap.put("2251", "Operacija se ne mo\u017ee izvr\u0161iti. Suvi\u0161e malo slobodne memorije.");
        statusMap.put("2260", "Aplikacija se a\u017eurira. Molimo, sa\u010dekajte.");
        statusMap.put("2400", "LPFR nije konfigurisan. Neophodan unos PIN koda za nastavak rada.");
    }

    public InvoiceResponse createInvoice(Fiskalniracun racun, RequestParams params) throws LPFRException {
        InvoiceRequest request = new InvoiceRequest();
        request.setInvoiceType(params.getInvoiceType());
        request.setTransactionType(params.getTransactionType());
        request.setBuyerCostCenterId(params.getBuyerCostCenterId());
        request.setBuyerId(params.getBuyerId());
        request.setCashier(racun.getPzuser().getPzusername());
        request.setDateAndTimeOfIssue(params.getDateAndTimeOfIssue());
        request.setInvoiceNumber(VERSION);
        request.setPayment(params.getPayment());
        request.setReferentDocumentNumber(params.getReferentDocumentNumber());
        request.setReferentDocumentDT(params.getReferentDocumentDT());
        InvoiceRequest.JournalOptions journalOptions = new InvoiceRequest.JournalOptions();
        request.setJournalOptions(journalOptions);
        ArrayList<InvoiceItem> items = new ArrayList<InvoiceItem>();
        for (Proizvodfiskalniracun stavka : racun.getProizvodfiskalniracuns()) {
            InvoiceItem item = new InvoiceItem();
            String barkod = stavka.getArtikal().getBarKod();
            barkod = barkod == null ? barkod : (barkod.length() > 7 && barkod.length() < 15 ? barkod : null);
            item.setGtin(barkod);
            item.setName(String.valueOf(stavka.getNaziv().trim()) + "/" + stavka.getJm());
            item.setQuantity(BDConverter.getBigDecimal((String)String.valueOf(stavka.getKolicina()), (DecimalFormat)new DecimalFormat("###,###.000")));
            item.setUnitPrice(BDConverter.getIznos((double)stavka.getCena()));
            item.setTotalAmount(BDConverter.getIznos((double)(stavka.getKolicina() * stavka.getCena())));
            item.setLabels(this.getLabel((PzADTaksa)stavka.getTaksa("PDV")));
            items.add(item);
        }
        request.setItems(items);
        if (racun.getPib() != null && !racun.getPib().equals("")) {
            StringBuffer b = new StringBuffer("\r\n").append("PODACI O KUPCU:\r\n").append(String.valueOf(racun.getNazivKupca()) + "\r\n").append("PIB: " + racun.getPib() + "\r\n").append("MBR: " + racun.getMbr() + "\r\n").append("ADRESA: " + racun.getAdresa() + "\r\n").append("MESTO: " + racun.getGrad() + "\r\n").append("\r\n").append(this.getTekuciRacun());
            journalOptions.setMessage(b.toString());
        } else if (params.getInvoiceType().equals("Proforma")) {
            journalOptions.setMessage(this.getTekuciRacun());
        }
        if (params.getAdvance() != null) {
            journalOptions.setAdvance(params.getAdvance());
            journalOptions.setAdvanceTax(params.getAdvanceTax());
        }
        if (params.getValidTo() != null) {
            journalOptions.appendMessage("\r\n\r\nVALUTA PLA\u0106ANJA: " + new SimpleDateFormat("dd.MM.yyyy.").format(params.getValidTo()));
        }
        if (request.getInvoiceType().equals("Copy") && request.getTransactionType().equals("Sale")) {
            journalOptions.appendMessage("\r\n\r\n\r\n\r\nPOTPIS KUPCA:________________________");
        }
        InvoiceResponse response = this.createInvoice(request);
        if (request.getInvoiceType().equals("Normal") && request.getTransactionType().equals("Refund") || params.isCopyWithSignature()) {
            RequestParams copyParams = RequestParams.getBuilder().withParams(params).withInvoiceType("Copy").withReferentDocumentNumber(response.getInvoiceNumber()).withReferentDocumentDT(response.getSdcDateTime()).build();
            this.createInvoice(racun, copyParams);
        }
        return response;
    }

    public InvoiceResponse createInvoice(PzDokument racun) throws LPFRException {
        InvoiceRequest request = new InvoiceRequest();
        request.setInvoiceType(InvoiceTransaction.NORMAL_SALE.getInvoiceType());
        request.setTransactionType(InvoiceTransaction.NORMAL_SALE.getTransactionType());
        request.setBuyerId(BuyerIdentification.PIB_KUPCA.value(racun.getKomitent().getPib()));
        request.setCashier(racun.getUserKraj().getPzusername());
        request.setInvoiceNumber(VERSION);
        request.setPayment(Arrays.asList(new InvoicePayment(racun.getIznos(), "WireTransfer")));
        ArrayList<InvoiceItem> items = new ArrayList<InvoiceItem>();
        for (PzArtikalDokument stavka : racun.getArtikalDocuments()) {
            InvoiceItem item = new InvoiceItem();
            String barkod = stavka.getArtikal().getBarKod();
            barkod = barkod == null ? barkod : (barkod.length() > 7 && barkod.length() < 15 ? barkod : null);
            item.setGtin(barkod);
            item.setName(String.valueOf(stavka.getNaziv().trim()) + "/" + stavka.getJm());
            item.setQuantity(BDConverter.getBigDecimal((String)String.valueOf(stavka.getKolicina()), (DecimalFormat)new DecimalFormat("###,###.000")));
            item.setUnitPrice(BDConverter.getIznos((double)stavka.getCena()));
            item.setTotalAmount(BDConverter.getIznos((double)(stavka.getKolicina() * stavka.getCena())));
            item.setLabels(this.getLabel(stavka.getTaksa("PDV")));
            items.add(item);
        }
        request.setItems(items);
        if (racun.getKomitent() != null) {
            StringBuffer b = new StringBuffer("\r\n").append("PODACI O KUPCU:\r\n").append(String.valueOf(racun.getKomitent().getNaziv()) + "\r\n").append("PIB: " + racun.getKomitent().getPib() + "\r\n").append("MBR: " + racun.getKomitent().getMatBroj() + "\r\n").append("ADRESA: " + racun.getKomitent().getAdresa() + "\r\n").append("MESTO: " + racun.getKomitent().getGrad() + "\r\n").append("\r\n").append(this.getTekuciRacun());
            request.setJournalOptions(new InvoiceRequest.JournalOptions(b.toString()));
        }
        InvoiceResponse response = this.createInvoice(request);
        if (request.getInvoiceType().equals("Normal") && request.getTransactionType().equals("Refund")) {
            this.createInvoice(racun);
        }
        return response;
    }

    private InvoiceResponse createInvoice(InvoiceRequest request) throws LPFRException {
        String url = this.getAgentUri("/invoices");
        Gson gson = new Gson();
        String json = gson.toJson((Object)request);
        HttpPost post = new HttpPost(url);
        post.addHeader("Content-Type", "application/json");
        post.addHeader("RequestId", request.getCashier());
        post.setEntity((HttpEntity)new StringEntity(json, StandardCharsets.UTF_8));
        InputStream is = null;
        try {
            HttpResponse httpResponse = this.client.execute((HttpUriRequest)post);
            is = httpResponse.getEntity().getContent();
            int status = httpResponse.getStatusLine().getStatusCode();
            if (status == 400) {
                throw new LPFRException("Greska! Podaci nisu dobro formatirani.\r\n" + this.readResponse(httpResponse));
            }
            if (status == 423) {
                String lpfrStatus = this.readResponseCode(httpResponse);
                throw new LPFRException(statusMap.get(lpfrStatus));
            }
            if (status == 406) {
                throw new LPFRException("Jezik nije podr\u017ean");
            }
            InvoiceResponse response = (InvoiceResponse)gson.fromJson((Reader)new InputStreamReader(is), InvoiceResponse.class);
            this.getInvoiceImage(response, request.getCashier());
            InvoiceResponse invoiceResponse = response;
            return invoiceResponse;
        }
        catch (LPFRException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LPFRException("Potpisivanje ra\u010duna nije uspelo", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void getInvoiceImage(InvoiceResponse response, String requestId) throws LPFRException {
        String uri = this.getAgentUri("/receipts/" + requestId);
        HttpGet get = new HttpGet(uri);
        InputStream is = null;
        try {
            try {
                String file = String.valueOf(PzCacheUtility.getJournalDir((String)response.getSdcDateTime().split("T")[0]).getPath()) + File.separator + response.getInvoiceNumber();
                HttpResponse httpResponse = this.client.execute((HttpUriRequest)get);
                is = httpResponse.getEntity().getContent();
                BufferedImage image = ImageIO.read(is);
                ImageIO.write((RenderedImage)image, "PNG", new File(String.valueOf(file) + ".png"));
            }
            catch (IOException e) {
                throw new LPFRException("Gre\u0161ka u komunikaciji sa L-PFR-om", e);
            }
            catch (Exception e) {
                throw new LPFRException("Nije uspelo preuzimanje slike racuna", e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private List<String> getLabel(PzADTaksa taksa) throws LPFRException {
        String label = null;
        Iterator iterator = this.taxMap.iterator();
        while (iterator.hasNext() && label == null) {
            TaxMap tm = (TaxMap)iterator.next();
            if (!tm.getOznTarGr().equals(taksa.getOznTarGr())) continue;
            label = tm.getLabel();
        }
        if (label == null) {
            throw new LPFRException("Poreska stopa nije konfigurisana: " + taksa.getOznTarGr());
        }
        return Arrays.asList(label);
    }

    public void setTaxMap(List taxMap) {
        this.taxMap = taxMap;
    }

    public String verifyPIN(String pin) throws LPFRException {
        String uri = this.getApiUri("/pin");
        HttpPost post = new HttpPost(uri);
        post.addHeader("Content-Type", "application/json");
        try {
            post.setEntity((HttpEntity)new StringEntity(pin));
            HttpResponse httpResponse = this.client.execute((HttpUriRequest)post);
            String lpfrStatus = this.readResponseCode(httpResponse);
            if (statusMap.containsKey(lpfrStatus)) {
                return statusMap.get(lpfrStatus);
            }
            return lpfrStatus;
        }
        catch (LPFRException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new LPFRException("Verifikacija PIN koda nije uspela");
        }
    }

    public String attention() throws LPFRException {
        String uri = this.getApiUri("/attention");
        HttpGet get = new HttpGet(uri);
        try {
            HttpResponse httpResponse = this.client.execute((HttpUriRequest)get);
            return this.readResponse(httpResponse);
        }
        catch (Exception e) {
            throw new LPFRException("Gre\u0161ka u komunikaciji sa L-PFR-om", e);
        }
    }

    public List<TaxGroup.TaxCategory.TaxRate> getTaxRates() throws LPFRException {
        String uri = this.getApiUri("/status");
        HttpGet get = new HttpGet(uri);
        InputStream is = null;
        try {
            HttpResponse httpResponse = this.client.execute((HttpUriRequest)get);
            is = httpResponse.getEntity().getContent();
            Gson gson = new Gson();
            StatusResponse response = (StatusResponse)gson.fromJson((Reader)new InputStreamReader(is), StatusResponse.class);
            ArrayList<TaxGroup.TaxCategory.TaxRate> rates = new ArrayList<TaxGroup.TaxCategory.TaxRate>();
            for (TaxGroup.TaxCategory cat : response.getCurrentTaxRates().getTaxCategories()) {
                rates.addAll(cat.getTaxRates());
            }
            ArrayList<TaxGroup.TaxCategory.TaxRate> arrayList = rates;
            return arrayList;
        }
        catch (Exception e) {
            throw new LPFRException("Gre\u0161ka u komunikaciji sa L-PFR-om", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void getDailyReport(boolean closeDay) throws LPFRException {
        String uri = this.getAgentUri("/reports/daily");
        HttpGet get = new HttpGet(uri);
        get.addHeader("CloseDay", String.valueOf(closeDay));
        try {
            this.client.execute((HttpUriRequest)get);
        }
        catch (Exception exception) {
            throw new LPFRException("\u0160tampanje izve\u0161taja nije uspelo");
        }
    }

    public void getPeriodicReport(String startDate, String endDate) throws LPFRException {
        String uri = this.getAgentUri("/reports/periodic");
        HttpGet get = new HttpGet(uri);
        get.addHeader("StartDate", startDate);
        get.addHeader("EndDate", endDate);
        try {
            this.client.execute((HttpUriRequest)get);
        }
        catch (Exception exception) {
            throw new LPFRException("\u0160tampanje izve\u0161taja nije uspelo");
        }
    }

    private String getTekuciRacun() {
        List racuni;
        block5: {
            racuni = PzEntityManager.getList((String)"SELECT r FROM Tekuciracun r WHERE r.firma IS NOT null");
            if (racuni.size() != 0) break block5;
            return "";
        }
        try {
            Tekuciracun racun = null;
            for (Tekuciracun temp : racuni) {
                if (temp.getPodrazumevani() != 1) continue;
                racun = temp;
                break;
            }
            if (racun == null) {
                racun = (Tekuciracun)racuni.get(0);
            }
            return new StringBuffer("\r\n").append("TEKU\u0106I RA\u010cUN PRODAVCA: \r\n").append(racun.getBrRacuna()).append(", ").append(racun.getBanka()).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private String getApiUri(String path) throws LPFRException {
        String uri = PzApplication.getApplication().getLocalMachineUserSettings().getString("LPFR_URL");
        if (uri == null) {
            uri = "http://localhost:8989";
        }
        uri = String.valueOf(uri) + "/api/v3" + path;
        return uri;
    }

    private String getAgentUri(String path) throws LPFRException {
        String url = PzApplication.getApplication().getLocalMachineUserSettings().getString("LPFR_URL");
        if (url == null) {
            url = "http://localhost:8989";
        }
        url = String.valueOf(url) + "/agent/v3" + path;
        return url;
    }

    private String readResponse(HttpResponse response) throws LPFRException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer buffer = new StringBuffer();
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                line = reader.readLine();
            }
            String string = buffer.toString();
            return string;
        }
        catch (Exception e) {
            throw new LPFRException("Nije uspelo \u010ditanje odgovora", e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String readResponseCode(HttpResponse response) throws LPFRException {
        return this.readResponse(response).replace("\"", "");
    }

    public static String getMessage(String lpfrStatus) {
        return statusMap.get(lpfrStatus);
    }
}

