/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.lpfr.model;

import java.util.Arrays;

public class InvoiceTransaction {
    public static final InvoiceTransaction NORMAL = new InvoiceTransaction("Normal", null, "PROMET");
    public static final InvoiceTransaction NORMAL_SALE = new InvoiceTransaction("Normal", "Sale", "PROMET - PRODAJA");
    public static final InvoiceTransaction NORMAL_REFUND = new InvoiceTransaction("Normal", "Refund", "PROMET - REFUNDACIJA");
    public static final InvoiceTransaction PROFORMA_SALE = new InvoiceTransaction("Proforma", "Sale", "PREDRA\u010cUN - PRODAJA");
    public static final InvoiceTransaction PROFORMA_REFUND = new InvoiceTransaction("Proforma", "Refund", "PREDRA\u010cUN - REFUNDACIJA");
    public static final InvoiceTransaction ADVANCE_SALE = new InvoiceTransaction("Advance", "Sale", "AVANS - PRODAJA");
    public static final InvoiceTransaction ADVANCE_REFUND = new InvoiceTransaction("Advance", "Refund", "AVANS - REFUNDACIJA");
    public static final InvoiceTransaction COPY_SALE = new InvoiceTransaction("Copy", "Sale", "KOPIJA - PRODAJA");
    public static final InvoiceTransaction COPY_REFUND = new InvoiceTransaction("Copy", "Refund", "KOPIJA - REFUNDACIJA");
    public static final InvoiceTransaction TRAINING_SALE = new InvoiceTransaction("Training", "Sale", "OBUKA - PRODAJA");
    public static final InvoiceTransaction TRAINING_REFUND = new InvoiceTransaction("Training", "Refund", "OBUKA - REFUNDACIJA");
    private String invoiceType;
    private String transactionType;
    private String description;

    public InvoiceTransaction(String invoiceType, String transactionType, String description) {
        this.invoiceType = invoiceType;
        this.transactionType = transactionType;
        this.description = description;
    }

    public String getInvoiceType() {
        return this.invoiceType;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return String.valueOf(this.getInvoiceType()) + "-" + (this.getTransactionType() != null ? this.getTransactionType() : "");
    }

    public String toString() {
        return this.description;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.invoiceType == null ? 0 : this.invoiceType.hashCode());
        result = 31 * result + (this.transactionType == null ? 0 : this.transactionType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InvoiceTransaction other = (InvoiceTransaction)obj;
        if (this.invoiceType == null ? other.invoiceType != null : !this.invoiceType.equals(other.invoiceType)) {
            return false;
        }
        return !(this.transactionType == null ? other.transactionType != null : !this.transactionType.equals(other.transactionType));
    }

    public static InvoiceTransaction of(String invoiceTransaction) {
        String[] split = invoiceTransaction.split("\\-");
        return new InvoiceTransaction(split[0], split[1], "");
    }

    public static InvoiceTransaction[] getAll() {
        return new InvoiceTransaction[]{NORMAL_SALE, NORMAL_REFUND, PROFORMA_SALE, PROFORMA_REFUND, ADVANCE_SALE, ADVANCE_REFUND, COPY_SALE, COPY_REFUND, TRAINING_SALE, TRAINING_REFUND};
    }

    public static InvoiceTransaction[] getExtended() {
        return new InvoiceTransaction[]{NORMAL, NORMAL_SALE, NORMAL_REFUND, PROFORMA_SALE, PROFORMA_REFUND, ADVANCE_SALE, ADVANCE_REFUND, COPY_SALE, COPY_REFUND, TRAINING_SALE, TRAINING_REFUND};
    }

    public static boolean isReferenceRequired(InvoiceTransaction it, boolean advance) {
        return advance || Arrays.asList(NORMAL_REFUND, PROFORMA_REFUND, ADVANCE_REFUND, COPY_SALE, COPY_REFUND, TRAINING_REFUND).contains(it);
    }
}

