/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.html.HTMLEditorKit;
import org.eclipse.persistence.indirection.IndirectList;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Proizvod;
import rs.pezar.db.entity.Proizvodfiskalniracun;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.Usluga;
import rs.pezar.kasa.gui.Arhiviranje;
import rs.pezar.kasa.gui.IzborSmene;
import rs.pezar.sifarnici.gui.PzArtikliBrowser;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.sifarnici.gui.PzDialogUsluge;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogIzradaMaloprodajnogRacuna
extends PzDialog {
    private static final long serialVersionUID = 3333439535155147837L;
    private JToolBar toolbar;
    private PzPanel pnlTable;
    private JScrollPane scrpTable;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private PzDoubleField dfIznos;
    private PzDateField dfDatum;
    private PzNumericOnlyTextField nfSmena;
    private PzTextField tfBarKod;
    private PzPanel pnlGlavni;
    private JScrollPane scrollPanePoruke;
    private PzPanel pnlPoruke;
    private PzRadioGroup<String> panelRBs;
    private JLabel lblBarKod;
    private JSeparator jSeparator1;
    private PzButton btnOk;
    private PzDoubleField dfIznosStavke;
    private PzDoubleField dfCenaStanje;
    private JPanel panelInfo;
    private PzDoubleField dfKolicina;
    private PzDoubleField dfCena;
    private JLabel jLabel7;
    private PzTextField opisProizvoda;
    private PzDoubleField dfRaspKol;
    private PzDoubleField dfProcRabata;
    private PzTextField tfSifraProizvoda;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanel panelArhiva;
    private PzTable table;
    private PzToolBarIcon btnArhivaIStampa;
    private PzToolBarIcon btnBrisanjeDokumenta;
    private PzToolBarIcon btnBrisanjeReda;
    private Radnajedinica rj;
    private PzDialog thisDialog = null;
    private Fiskalniracun racun;
    private Usluga u;
    private Artikal a = null;
    private Proizvod p;
    private String sifraDob;
    private static boolean first;
    private static JEditorPane editorPane;

    public PzDialogIzradaMaloprodajnogRacuna(JFrame frame) {
        super(frame);
        this.thisDialog = this;
        this.initGUI();
    }

    public PzDialogIzradaMaloprodajnogRacuna(PzDialog dialog) {
        super(dialog);
        this.rj = (Radnajedinica)this.getSession().getParameter("radnaJedinica");
        this.thisDialog = this;
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            this.pnlGlavni.setGradient(Color.WHITE, Color.BLUE, PzPanel.GRADIENT_WEST_EAST);
            BorderLayout pnlGlavniLayout = new BorderLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlTable = new PzPanel();
            GridBagLayout pnlTableLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlTable, (Object)"Center");
            this.pnlTable.setLayout((LayoutManager)pnlTableLayout);
            pnlTableLayout.rowWeights = new double[]{0.1};
            pnlTableLayout.rowHeights = new int[]{7};
            pnlTableLayout.columnWeights = new double[]{0.1};
            pnlTableLayout.columnWidths = new int[]{7};
            this.pnlTable.setOpaque(false);
            this.scrpTable = new JScrollPane();
            this.pnlTable.add((Component)this.scrpTable, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.table = new PzTable();
            this.scrpTable.setViewportView((Component)this.table);
            this.panelArhiva = new PzPanel();
            this.pnlGlavni.add((Component)this.panelArhiva, (Object)"South");
            GridBagLayout panelArhivaLayout1 = new GridBagLayout();
            panelArhivaLayout1.columnWidths = new int[]{175, 21, 53, 110, 112, 20};
            panelArhivaLayout1.rowHeights = new int[]{25, 25, 25, -1, 25, 25, 25, 20, 7};
            panelArhivaLayout1.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            panelArhivaLayout1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.1};
            this.panelArhiva.setLayout((LayoutManager)panelArhivaLayout1);
            this.panelArhiva.setBorder((Border)BorderFactory.createTitledBorder(null, "Iznos", 4, 0, new Font("Segoe UI", 1, 12), new Color(0, 0, 255)));
            this.panelArhiva.setOpaque(false);
            this.panelArhiva.setPreferredSize(new Dimension(878, 315));
            this.jLabel1 = new JLabel();
            this.panelArhiva.add((Component)this.jLabel1, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.jLabel1.setName("jLabel1");
            this.jLabel2 = new JLabel();
            this.panelArhiva.add((Component)this.jLabel2, (Object)new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.jLabel2.setName("jLabel2");
            this.jLabel3 = new JLabel();
            this.panelArhiva.add((Component)this.jLabel3, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.jLabel3.setName("jLabel3");
            this.tfSifraProizvoda = new PzTextField();
            this.panelArhiva.add((Component)this.tfSifraProizvoda, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfSifraProizvoda.setName("tfSifraArtikla");
            this.tfSifraProizvoda.setVerifyInput(true);
            this.tfSifraProizvoda.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == 10) {
                        if (PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.getVal().toLowerCase().startsWith("u")) {
                            if (PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.getVal().length() == 1) {
                                PzDialogIzradaMaloprodajnogRacuna.this.getSession().putParameter("izradaMaloprodajnogRacuna", (Object)true);
                                PzDialogIzradaMaloprodajnogRacuna.this.getSession().putParameter("usluga", null);
                                PzDialogIzradaMaloprodajnogRacuna.this.showDialog(PzDialogUsluge.class);
                                PzDialogIzradaMaloprodajnogRacuna.this.u = (Usluga)PzDialogIzradaMaloprodajnogRacuna.this.getSession().getParameter("usluga");
                                if (PzDialogIzradaMaloprodajnogRacuna.this.u != null) {
                                    PzDialogIzradaMaloprodajnogRacuna.this.setUslugaData(PzDialogIzradaMaloprodajnogRacuna.this.u);
                                    PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.setVal((Object)PzDialogIzradaMaloprodajnogRacuna.this.u.getSfrProizvod());
                                } else {
                                    PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.setText("");
                                    PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.requestFocus();
                                }
                            } else {
                                PzDialogIzradaMaloprodajnogRacuna.this.u = (Usluga)PzDialogIzradaMaloprodajnogRacuna.this.getProizvod(PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.getVal(), true);
                                if (PzDialogIzradaMaloprodajnogRacuna.this.u == null) {
                                    JOptionPane.showMessageDialog(null, "Ne postoji usluga " + PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.getVal() + "!", "Informacija", 1);
                                    PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.setText("");
                                    PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.requestFocus();
                                } else {
                                    PzDialogIzradaMaloprodajnogRacuna.this.setUslugaData(PzDialogIzradaMaloprodajnogRacuna.this.u);
                                }
                            }
                        } else if (PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.getVal().length() == 0) {
                            Stanjeartikal stanje = PzArtikliBrowser.getStanjeArtikal((PzDialog)PzDialogIzradaMaloprodajnogRacuna.this.thisDialog, (Radnajedinica)PzDialogIzradaMaloprodajnogRacuna.this.rj);
                            if (stanje != null && !PzDialogIzradaMaloprodajnogRacuna.this.setArtikalData(stanje.getId().getSfrProizvod())) {
                                JOptionPane.showMessageDialog(null, "Proizvod " + stanje.getId().getSfrProizvod() + " do sada nije imao promet u izabranoj radnoj jedinici! Unos nije mogu\u0107!", "Informacija", 1);
                                PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.setText("");
                                PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.requestFocus();
                            }
                        } else {
                            PzDialogIzradaMaloprodajnogRacuna.this.a = (Artikal)PzDialogIzradaMaloprodajnogRacuna.this.getProizvod(PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.getVal(), false);
                            if (PzDialogIzradaMaloprodajnogRacuna.this.a == null) {
                                JOptionPane.showMessageDialog(null, "Ne postoji artikal " + PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.getVal() + "!", "Informacija", 1);
                                PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.setText("");
                                PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.requestFocus();
                            } else if (!PzDialogIzradaMaloprodajnogRacuna.this.setArtikalData(PzDialogIzradaMaloprodajnogRacuna.this.a.getSfrProizvod())) {
                                JOptionPane.showMessageDialog(null, "Proizvod " + PzDialogIzradaMaloprodajnogRacuna.this.a.getSfrProizvod() + " do sada nije imao promet u izabranoj radnoj jedinici! Unos nije mogu\u0107!", "Informacija", 1);
                                PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.setText("");
                                PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.requestFocus();
                            }
                        }
                    }
                }
            });
            this.dfProcRabata = new PzDoubleField();
            this.panelArhiva.add((Component)this.dfProcRabata, (Object)new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfProcRabata.setName("dfProcRabata");
            this.dfProcRabata.setDecimalFormat(PzFormatFactory.getProcRabataFormat());
            this.dfProcRabata.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogIzradaMaloprodajnogRacuna.this.dfProcRabata.getVal() != 0.0) {
                        PzDialogIzradaMaloprodajnogRacuna.this.dfIznosStavke.setVal((Object)(PzDialogIzradaMaloprodajnogRacuna.this.dfIznosStavke.getVal() - PzDialogIzradaMaloprodajnogRacuna.this.dfIznosStavke.getVal() * PzDialogIzradaMaloprodajnogRacuna.this.dfProcRabata.getVal() / 100.0));
                    }
                    return true;
                }
            });
            this.dfKolicina = new PzDoubleField();
            this.panelArhiva.add((Component)this.dfKolicina, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfKolicina.setName("dfKolicina");
            this.dfKolicina.setLimit(5, 3);
            final PzDoubleField thisField = null;
            this.dfKolicina.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogIzradaMaloprodajnogRacuna.this.dfKolicina.getVal() <= 0.0) {
                        return false;
                    }
                    if (PzDialogIzradaMaloprodajnogRacuna.this.dfKolicina.getVal() > PzDialogIzradaMaloprodajnogRacuna.this.dfRaspKol.getVal() && !PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.getVal().startsWith("U")) {
                        block8: {
                            if (!PzDialogIzradaMaloprodajnogRacuna.this.racun.getRadnajedinica().getMinusKolicine().equals("ZABRANJEN")) break block8;
                            PzSwingUtility.showErrorMessage(null, (String)"Nema dovoljno raspolo\u017eive koli\u010dine! Unos nije mogu\u0107!");
                            return false;
                        }
                        try {
                            int rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot(null), "Nema dovoljno raspolo\u017eive koli\u0161ine! Nastavak rada?", "Informacija", 0);
                            if (rez == 1) {
                                PzDialogIzradaMaloprodajnogRacuna.this.dfKolicina.setVal((Object)0.0);
                                if (((String)PzDialogIzradaMaloprodajnogRacuna.this.panelRBs.getSelectedValue()).equals("\u0160ifra artikla")) {
                                    PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.requestFocus();
                                } else {
                                    PzDialogIzradaMaloprodajnogRacuna.this.tfBarKod.requestFocus();
                                }
                                return false;
                            }
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)thisField, (Throwable)e);
                        }
                    }
                    PzDialogIzradaMaloprodajnogRacuna.this.dfIznosStavke.setVal((Object)(PzDialogIzradaMaloprodajnogRacuna.this.dfCena.getVal() * PzDialogIzradaMaloprodajnogRacuna.this.dfKolicina.getVal()));
                    return true;
                }
            });
            this.dfRaspKol = new PzDoubleField();
            this.panelArhiva.add((Component)this.dfRaspKol, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 1, 0), 0, 0));
            this.dfRaspKol.setName("dfRaspKol");
            this.dfRaspKol.setFocusable(false);
            this.dfRaspKol.setLimit(5, 3);
            this.opisProizvoda = new PzTextField();
            this.panelArhiva.add((Component)this.opisProizvoda, (Object)new GridBagConstraints(4, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 1, 19), 0, 0));
            this.opisProizvoda.setName("opisArtikla");
            this.opisProizvoda.setFocusable(false);
            this.jLabel7 = new JLabel();
            this.panelArhiva.add((Component)this.jLabel7, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.jLabel7.setName("jLabel7");
            this.dfCena = new PzDoubleField();
            this.panelArhiva.add((Component)this.dfCena, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.dfCena.setName("dfCena");
            this.dfCena.setLimit(7, 2);
            this.dfCena.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogIzradaMaloprodajnogRacuna.this.dfCena.getVal() <= 0.0) {
                        return false;
                    }
                    PzDialogIzradaMaloprodajnogRacuna.this.dfIznosStavke.setVal((Object)(PzDialogIzradaMaloprodajnogRacuna.this.dfCena.getVal() * PzDialogIzradaMaloprodajnogRacuna.this.dfKolicina.getVal()));
                    return true;
                }
            });
            this.dfCenaStanje = new PzDoubleField();
            this.panelArhiva.add((Component)this.dfCenaStanje, (Object)new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 1, 0), 0, 0));
            this.dfCenaStanje.setName("dfCenaStanje");
            this.dfCenaStanje.setFocusable(false);
            this.dfCenaStanje.setLimit(7, 2);
            this.dfIznosStavke = new PzDoubleField();
            this.panelArhiva.add((Component)this.dfIznosStavke, (Object)new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.dfIznosStavke.setName("iznosStavke");
            this.dfIznosStavke.setFocusable(false);
            this.panelInfo = new JPanel();
            GridBagLayout panelInfoLayout = new GridBagLayout();
            panelInfoLayout.columnWidths = new int[]{84, 7};
            panelInfoLayout.rowHeights = new int[]{45, 25, 25};
            panelInfoLayout.columnWeights = new double[]{0.0, 0.1};
            panelInfoLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            this.panelArhiva.add((Component)this.panelInfo, (Object)new GridBagConstraints(0, 3, 1, 4, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelInfo.setLayout(panelInfoLayout);
            this.panelInfo.setOpaque(false);
            this.jLabel4 = new JLabel();
            this.panelInfo.add((Component)this.jLabel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.jLabel4.setName("jLabel4");
            this.jLabel5 = new JLabel();
            this.panelInfo.add((Component)this.jLabel5, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.jLabel5.setName("jLabel5");
            this.nfSmena = new PzNumericOnlyTextField();
            this.panelInfo.add((Component)this.nfSmena, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 0), 0, 0));
            this.nfSmena.setName("nfSmena");
            this.nfSmena.setFocusable(false);
            this.dfDatum = new PzDateField();
            this.panelInfo.add((Component)this.dfDatum, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 0), 0, 0));
            this.dfDatum.setName("dfDatum");
            this.dfDatum.setFocusable(false);
            this.dfIznos = new PzDoubleField();
            this.panelInfo.add((Component)this.dfIznos, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfIznos.setName("dfIznos");
            this.dfIznos.setBackground(Color.WHITE);
            this.dfIznos.setFocusable(false);
            this.btnOk = new PzButton();
            this.panelArhiva.add((Component)this.btnOk, (Object)new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(1, 0, 2, 0), 0, 0));
            this.btnOk.setPreferredSize(new Dimension(80, 30));
            this.btnOk.setName("btnOk");
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.btnOk.setActionCommand("potvrdi");
            this.jSeparator1 = new JSeparator();
            this.jSeparator1.setOrientation(1);
            this.panelArhiva.add((Component)this.jSeparator1, (Object)new GridBagConstraints(1, 0, 1, 7, 0.0, 0.0, 11, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.lblBarKod = new JLabel();
            this.panelArhiva.add((Component)this.lblBarKod, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.lblBarKod.setName("lblBarKod");
            this.lblBarKod.setEnabled(false);
            this.tfBarKod = new PzTextField();
            this.panelArhiva.add((Component)this.tfBarKod, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfBarKod.setFocusable(false);
            this.tfBarKod.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogIzradaMaloprodajnogRacuna.this.tfBarKod.getVal().length() == 0) {
                        return false;
                    }
                    PzDialogIzradaMaloprodajnogRacuna.this.a = (Artikal)PzDialogIzradaMaloprodajnogRacuna.this.getBarKodProizvod(PzDialogIzradaMaloprodajnogRacuna.this.tfBarKod.getVal());
                    if (PzDialogIzradaMaloprodajnogRacuna.this.a == null) {
                        JOptionPane.showMessageDialog(null, "Ne postoji artikal sa bar kodom " + PzDialogIzradaMaloprodajnogRacuna.this.tfBarKod.getVal() + "!", "Informacija", 1);
                        PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.setText("");
                        return false;
                    }
                    if (!PzDialogIzradaMaloprodajnogRacuna.this.setArtikalData(PzDialogIzradaMaloprodajnogRacuna.this.a.getSfrProizvod())) {
                        JOptionPane.showMessageDialog(null, "Proizvod " + PzDialogIzradaMaloprodajnogRacuna.this.a.getSfrProizvod() + " do sada nije imao promet u izabranoj radnoj jedinici! Unos nije mogu\u0107!", "Informacija", 1);
                        PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.setText("");
                        return false;
                    }
                    return true;
                }
            });
            this.panelRBs = new PzRadioGroup((Object[])new String[]{"\u0160ifra artikla", "Bar kod"});
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRBs, 1);
            this.panelRBs.setLayout((LayoutManager)panelRBsLayout);
            this.panelArhiva.add(this.panelRBs, (Object)new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs.setBorder((Border)BorderFactory.createTitledBorder("Izbor"));
            this.panelRBs.setSelectedValue((Object)"\u0160ifra artikla");
            this.panelRBs.setOpaque(false);
            this.panelRBs.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals("\u0160ifra artikla")) {
                            PzDialogIzradaMaloprodajnogRacuna.this.lblBarKod.setEnabled(false);
                            PzDialogIzradaMaloprodajnogRacuna.this.tfBarKod.setFocusable(false);
                            PzDialogIzradaMaloprodajnogRacuna.this.jLabel3.setEnabled(true);
                            PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.setFocusable(true);
                        } else if (evt.getValue().equals("Bar kod")) {
                            PzDialogIzradaMaloprodajnogRacuna.this.lblBarKod.setEnabled(true);
                            PzDialogIzradaMaloprodajnogRacuna.this.tfBarKod.setFocusable(true);
                            PzDialogIzradaMaloprodajnogRacuna.this.jLabel3.setEnabled(false);
                            PzDialogIzradaMaloprodajnogRacuna.this.tfSifraProizvoda.setFocusable(false);
                        }
                    }
                }
            });
            this.pnlPoruke = new PzPanel();
            BorderLayout pnlPorukeLayout1 = new BorderLayout();
            this.pnlPoruke.setLayout((LayoutManager)pnlPorukeLayout1);
            GridBagLayout pnlPorukeLayout = new GridBagLayout();
            this.panelArhiva.add((Component)this.pnlPoruke, (Object)new GridBagConstraints(0, 7, 6, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlPoruke.setBorder((Border)BorderFactory.createTitledBorder("Info Ure\u0111aja"));
            pnlPorukeLayout.rowWeights = new double[]{0.1, 0.1};
            pnlPorukeLayout.rowHeights = new int[]{7, 7};
            pnlPorukeLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlPorukeLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlPoruke.setOpaque(false);
            this.scrollPanePoruke = new JScrollPane();
            this.pnlPoruke.add((Component)this.scrollPanePoruke, (Object)"Center");
            this.scrollPanePoruke.setPreferredSize(new Dimension(146, 40));
            editorPane = new JEditorPane();
            this.scrollPanePoruke.setViewportView(editorPane);
            editorPane.setEditorKit(new HTMLEditorKit());
            editorPane.setFont(new Font("SansSerif", 0, 14));
            editorPane.setPreferredSize(new Dimension(454, 37));
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)"North");
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.btnBrisanjeReda = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnBrisanjeReda);
            this.btnBrisanjeReda.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/row_delete.png")));
            this.btnBrisanjeReda.setActionCommand("brisanje");
            this.btnBrisanjeReda.addActionListener((ActionListener)((Object)this));
            this.btnBrisanjeReda.setShortcut("delete");
            this.btnBrisanjeReda.setText("Brisanje|reda|(Delete)");
            this.btnBrisanjeDokumenta = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnBrisanjeDokumenta);
            this.btnBrisanjeDokumenta.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/note_delete.png")));
            this.btnBrisanjeDokumenta.setActionCommand("brisanjeSvega");
            this.btnBrisanjeDokumenta.addActionListener((ActionListener)((Object)this));
            this.btnBrisanjeDokumenta.setShortcut("CTRL+Q");
            this.btnBrisanjeDokumenta.setText("Brisanje|svega|(Ctrl+Q)");
            this.btnArhivaIStampa = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnArhivaIStampa);
            this.btnArhivaIStampa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/printer_preferences.png")));
            this.btnArhivaIStampa.setActionCommand("ArhivaStampa");
            this.btnArhivaIStampa.addActionListener((ActionListener)((Object)this));
            this.btnArhivaIStampa.setShortcut("ctrl+w");
            this.btnArhivaIStampa.setText("Arhiva i|\u0161tampa|(Ctrl+W)");
            this.pack();
            this.setSize(800, 765);
            this.setMinimumSize(new Dimension(800, 765));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        block18: {
            EntityManager em = PzEntityManager.getEm();
            try {
                try {
                    PzButton button = (PzButton)e.getSource();
                    String actionCommand = button.getActionCommand();
                    if (actionCommand.equals("potvrdi")) {
                        this.dodajArtikal(em);
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().commit();
                        }
                        break block18;
                    }
                    if (actionCommand.equals("brisanjeSvega")) {
                        int rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)((Object)this)), "Da li ste sigurni?!", "Brisanje", 0);
                        if (rez == 0) {
                            em.getTransaction().begin();
                            em.remove(em.find(Fiskalniracun.class, (Object)this.racun.getIdDok()));
                            for (Proizvodfiskalniracun p : this.racun.getProizvodfiskalniracuns()) {
                                Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(p.getId().getSfrProizvod(), this.rj));
                                s.setAlocKolicina(s.getAlocKolicina() - p.getKolicina());
                            }
                            this.createFiskalniRacun(em);
                            this.refreshDataTable();
                            this.emptyFields(true);
                            this.refreshIznos();
                            this.tfSifraProizvoda.requestFocus();
                            if (em.getTransaction().isActive()) {
                                em.getTransaction().commit();
                            }
                        }
                        break block18;
                    }
                    if (actionCommand.equals("brisanje")) {
                        em.getTransaction().begin();
                        Proizvodfiskalniracun proizvod = (Proizvodfiskalniracun)this.table.getSelectedEntity();
                        if (!proizvod.getSifra().toLowerCase().startsWith("u")) {
                            Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(proizvod.getId().getSfrProizvod(), this.rj));
                            s.setAlocKolicina(s.getAlocKolicina() - proizvod.getKolicina());
                        }
                        this.table.removeSelectedEntity(true, em);
                        em.getTransaction().commit();
                        this.table.commitRemove();
                        this.refreshIznos();
                        if (((String)this.panelRBs.getSelectedValue()).equals("\u0160ifra artikla")) {
                            this.tfSifraProizvoda.requestFocus();
                        } else {
                            this.tfBarKod.requestFocus();
                        }
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().commit();
                        }
                        break block18;
                    }
                    if (!actionCommand.equals("ArhivaStampa")) break block18;
                    if (this.racun.getProizvodfiskalniracuns().size() == 0) {
                        PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Arhiviranje ra\u010duna nije dozvoljeno jer isti nema stavke");
                        break block18;
                    }
                    this.getSession().putParameter("racun", (Object)this.racun);
                    this.getSession().putParameter("parameter", (Object)"izradaRacuna");
                    this.showDialog(Arhiviranje.class);
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                    em.close();
                }
            }
            finally {
                em.close();
            }
        }
    }

    private void dodajArtikal(EntityManager em) {
        Proizvodfiskalniracun proizvod = this.racun.getProizvod(this.tfSifraProizvoda.getVal(), this.racun.getIdDok(), this.dfCena.getVal().doubleValue(), this.dfProcRabata.getVal().doubleValue());
        if (proizvod != null) {
            PzSwingUtility.showErrorMessage(null, (String)"Proizvod ve\u0107 postoji ali sa drugom cenom ili rabatom!");
            this.tfSifraProizvoda.requestFocus();
            return;
        }
        em.getTransaction().begin();
        if (!this.tfSifraProizvoda.getVal().startsWith("U")) {
            Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(this.tfSifraProizvoda.getVal(), this.rj));
            s.setAlocKolicina(s.getAlocKolicina() + this.dfKolicina.getVal());
        }
        proizvod = new Proizvodfiskalniracun();
        this.p = (Proizvod)em.find(Proizvod.class, (Object)this.tfSifraProizvoda.getVal());
        proizvod.init(this.racun, this.p);
        proizvod.setKolicina(this.dfKolicina.getVal().doubleValue());
        proizvod.setBliziOpis(this.a != null ? this.a.getBliziOpis() : "");
        proizvod.setJm(this.a != null ? this.a.getJedMere() : "");
        proizvod.setNaziv(this.opisProizvoda.getVal());
        proizvod.setProcRabata(this.dfProcRabata.getVal().doubleValue());
        proizvod.setCena(this.dfCena.getVal().doubleValue());
        proizvod.setDobSifra(this.sifraDob);
        this.racun.getProizvodfiskalniracuns().add(proizvod);
        em.merge((Object)this.racun);
        this.table.setData(this.racun.getProizvodfiskalniracuns(), Proizvodfiskalniracun.class);
        this.emptyFields(true);
        this.refreshIznos();
        if (((String)this.panelRBs.getSelectedValue()).equals("\u0160ifra artikla")) {
            this.tfSifraProizvoda.requestFocus();
        } else {
            this.tfBarKod.requestFocus();
        }
    }

    public void emptyFields(Boolean all) {
        this.dfRaspKol.setVal((Object)0);
        this.opisProizvoda.setVal((Object)"");
        this.dfCena.setVal((Object)0);
        this.dfCenaStanje.setVal((Object)0);
        this.dfKolicina.setVal((Object)1);
        this.dfProcRabata.setVal((Object)0);
        if (all.booleanValue()) {
            this.tfBarKod.setText("");
            this.tfSifraProizvoda.setText("");
            this.dfKolicina.setVal((Object)0.0);
            this.dfIznosStavke.setVal((Object)0.0);
        }
    }

    public void refreshIznos() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogIzradaMaloprodajnogRacuna.this.dfIznos.setVal((Object)PzDialogIzradaMaloprodajnogRacuna.this.racun.getIznosRacuna());
            }
        });
    }

    private void refreshTable() {
        this.table.requestFocus();
        this.table.setRowSelectionInterval(0, 0);
    }

    public void refreshDataTable() {
        this.table.setData(this.racun.getProizvodfiskalniracuns(), Proizvodfiskalniracun.class);
    }

    private boolean setArtikalData(String sifra) {
        boolean stanje = true;
        try {
            Stanje s = (Stanje)PzEntityManager.find(Stanje.class, (Object)new StanjePK(sifra, this.rj));
            if (s == null) {
                stanje = false;
            } else {
                Artikal a = (Artikal)PzEntityManager.find(Artikal.class, (Object)sifra);
                this.tfSifraProizvoda.setVal((Object)a.getSfrProizvod());
                this.dfRaspKol.setVal((Object)(s != null ? s.getRaspolozivaKolicina() : 0.0));
                this.dfKolicina.setVal((Object)1);
                this.dfCena.setVal((Object)(s != null ? s.getProdCena() : 0.0));
                this.dfCenaStanje.setVal((Object)(s != null ? s.getProdCena() : 0.0));
                this.opisProizvoda.setVal((Object)a.getNaziv());
                this.sifraDob = a.getDobSifra();
                System.out.println("bar kod je: " + a.getBarKod());
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        return stanje;
    }

    private void setUslugaData(Usluga u) {
        this.opisProizvoda.setVal((Object)u.getNaziv());
        this.dfCenaStanje.setVal((Object)u.getCena());
        this.dfCena.setVal((Object)u.getCena());
        this.dfKolicina.setVal((Object)1);
        this.dfRaspKol.setVal((Object)0);
        this.sifraDob = "";
    }

    private PzEntity getProizvod(String sfrProizvod, boolean usluga) {
        EntityManager em = PzEntityManager.getEm();
        try {
            if (usluga) {
                Usluga u = (Usluga)em.find(Usluga.class, (Object)sfrProizvod);
                return u;
            }
            Artikal a = (Artikal)em.find(Artikal.class, (Object)sfrProizvod);
            return a;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return null;
        }
    }

    public static void setInfoUredjaj(String message, String boja) {
        String color = "#000000";
        String text = "";
        if (boja.equals("H")) {
            color = "#FF0000";
        } else if (boja.equals("M")) {
            color = "#0000FF";
        } else if (boja.equals("L")) {
            color = "#00FF00";
        }
        if (editorPane != null) {
            if (!first) {
                editorPane.setText("<html><font color=" + color + ">" + message + "</font></html>");
                first = true;
            } else {
                text = editorPane.getText().replace("</body>", "<br><font color=" + color + ">" + message + "</font></body>");
                editorPane.setText(text);
            }
        }
    }

    private PzEntity getBarKodProizvod(String barKod) {
        Query q;
        block3: {
            EntityManager em = PzEntityManager.getEm();
            try {
                q = em.createQuery("Select a from Artikal a where a.barKod='" + barKod + "'");
                if (q.getResultList().size() != 0) break block3;
                return null;
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                return null;
            }
        }
        return (Artikal)q.getSingleResult();
    }

    public boolean shouldBeShown() {
        this.rj = PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf('E')});
        if (this.rj != null) {
            this.setVisible(false);
            this.setTitle("Izrada maloprodajnog ra\u010duna iz: " + this.rj.getPunNaziv());
            int smena = IzborSmene.getSmena(this.rj, this);
            if (smena == 0) {
                return false;
            }
            this.dfDatum.setVal(this.getSession().getParameter("datum"));
            this.nfSmena.setVal((Object)smena);
            first = false;
            if (this.getFiskalniRacun().booleanValue()) {
                this.dfIznos.setVal((Object)this.racun.getIznosRacuna());
            } else {
                EntityManager em = PzEntityManager.getEm();
                em.getTransaction().begin();
                try {
                    try {
                        this.createFiskalniRacun(em);
                        em.getTransaction().commit();
                    }
                    catch (Exception e1) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                        em.close();
                        return false;
                    }
                }
                finally {
                    em.close();
                }
            }
            this.refreshDataTable();
            if (this.table.getDataSize() != 0) {
                this.table.setRowSelectionInterval(0, 0);
            }
            this.setFirstComponentInFocus((Component)this.panelRBs);
            return true;
        }
        this.setVisible(false);
        return false;
    }

    public void createFiskalniRacun(EntityManager em) throws Exception {
        this.racun = new Fiskalniracun();
        Calendar cal = Calendar.getInstance();
        int sat = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        cal.setTime(this.dfDatum.getVal());
        cal.set(11, sat);
        cal.set(12, min);
        cal.set(13, sec);
        cal.set(14, 0);
        Timestamp datum = new Timestamp(cal.getTimeInMillis());
        this.racun.setVreme(datum);
        this.racun.setRadnajedinica(this.rj);
        this.racun.setTaksafiskalniracuns((List)new IndirectList());
        this.racun.setCekovi(new BigDecimal(0.0));
        this.racun.setKartice(new BigDecimal(0.0));
        this.racun.setArhiviran((short)0);
        this.racun.setStorno(0);
        this.racun.setIznos(new BigDecimal(0));
        this.racun.setPzuser(PzApplication.getApplication().getSession().getLoggedUser());
        this.racun.setProizvodfiskalniracuns((List)new IndirectList());
        PzDokumentManager.getInstance().snimiDokument((PzDokument)this.racun, true, null, em);
    }

    private Boolean getFiskalniRacun() {
        Boolean res = false;
        try {
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            q = em.createQuery("SELECT f FROM Fiskalniracun f where f.arhiviran=0 and f.radnajedinica=:rj and f.pzuser=:user");
            q.setParameter("rj", (Object)this.rj);
            q.setParameter("user", (Object)PzApplication.getApplication().getSession().getLoggedUser());
            if (q.getResultList().size() != 0) {
                this.racun = (Fiskalniracun)q.getSingleResult();
                res = true;
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
        return res;
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogIzradaMaloprodajnogRacuna(Boolean.FALSE);
    }

    public PzDialogIzradaMaloprodajnogRacuna(Boolean initGUI) {
    }
}

