/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.efaktura;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Komitentparameter;
import rs.pezar.efaktura.util.DataValidator;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.util.PzDateUtility;

public class EDokumentValidator {
    private PzDokument dokument;
    private Firma firma;

    private EDokumentValidator(PzDokument dokument, Firma firma) {
        this.dokument = dokument;
        this.firma = firma;
    }

    public static EDokumentValidator create(PzDokument dokument) throws Exception {
        Firma f = PzFirma.getFirma();
        return new EDokumentValidator(dokument, f);
    }

    public static EDokumentValidator create(PzDokument dokument, Firma f) {
        return new EDokumentValidator(dokument, f);
    }

    public void validate() throws PzInfoException {
        ArrayList<String> errors = new ArrayList<String>();
        this.validate(errors);
        if (errors.size() > 0) {
            throw new PzInfoException(StringUtils.join(errors, (String)"\r\n"));
        }
    }

    public void validate(List<String> errors) {
        this.checkEquals(this.dokument.getDatum().toString(), PzDateUtility.getServerDate().toString(), "Datum dokumenta mora biti danasnji", errors);
        this.checkEmpty(this.firma.getPib(), "Nedostaje PIB vaseg preduzeca", errors);
        this.checkPib(this.firma.getPib(), "PIB vaseg preduzeca nije ispravan", errors);
        this.checkEmpty(this.firma.getMatBroj(), "Nedostaje maticni broj vaseg preduzeca", errors);
        this.checkMbr(this.firma.getMatBroj(), "Maticni broj vaseg preduzeca nije ispravan", errors);
        this.checkEmpty(this.firma.getEmail(), "Nedostaje email adresa vaseg preduzeca", errors);
        this.checkPattern(this.firma.getEmail().trim(), "^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", "E-mail adresa vaseg preduzeca nije validna", errors);
        this.checkEmpty(this.dokument.getKomitent(), "Dokument nema povezanog komitenta", errors);
        Komitent k = this.dokument.getKomitent();
        if (k.getDomaciKomitent() == 1) {
            Komitentparameter jbkjs;
            this.checkEmpty(k.getPib(), "Komitent nema definisan PIB", errors);
            this.checkPib(k.getPib(), "PIB komitenta nije ispravan", errors);
            this.checkEmpty(k.getMatBroj(), "Komitent nema definisan maticni broj", errors);
            this.checkMbr(k.getMatBroj(), "Maticni broj komitenta nije ispravan", errors);
            this.checkEmpty(k.getEmail(), "Komitent nema definisanu e-mail adresu", errors);
            this.checkPattern(k.getEmail(), "^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", "E-mail adresa komitenta nije validna", errors);
            this.checkEmpty(k.getAdresa(), "Komitent nema definisanu poslovnu adresu", errors);
            this.checkEmpty(k.getGrad(), "Komitent nema definisan grad", errors);
            if (!this.isNull(k.getKomitentparameter("JBKJS")) && !this.isEmpty((jbkjs = k.getKomitentparameter("JBKJS")).getValue())) {
                this.checkPattern(jbkjs.getValue(), "\\d{5,5}", "JBKJS broj komitenta nije ispravan", errors);
            }
        }
        this.checkItems(errors);
    }

    private void checkEmpty(Object val, String message, List<String> errors) {
        if (val instanceof String && this.isEmpty(val.toString())) {
            errors.add(message);
        } else if (this.isNull(val)) {
            errors.add(message);
        }
    }

    private boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    private boolean isNull(Object val) {
        return val == null;
    }

    private void checkPattern(String value, String pattern, String message, List<String> errors) {
        if (this.isEmpty(value)) {
            return;
        }
        Matcher matcher = Pattern.compile(pattern, 2).matcher(value);
        if (!matcher.matches()) {
            errors.add(message);
        }
    }

    private void checkPib(String value, String message, List<String> errors) {
        if (this.isEmpty(value)) {
            return;
        }
        if (!DataValidator.isPIBValid(value) && !DataValidator.isJMBGValid(value)) {
            errors.add(message);
        }
    }

    private void checkMbr(String value, String message, List<String> errors) {
        if (this.isEmpty(value)) {
            return;
        }
        if (!DataValidator.isMBValid(value) && !DataValidator.isJMBGValid(value)) {
            errors.add(message);
        }
    }

    private void checkEquals(Object o1, Object o2, String message, List<String> errors) {
        if (!o1.equals(o2)) {
            errors.add(message);
        }
    }

    private void checkItems(List<String> errors) {
        if (this.dokument.getArtikalDocuments() != null && this.dokument.getArtikalDocuments().size() > 0) {
            for (PzArtikalDokument a : this.dokument.getArtikalDocuments()) {
                PzADTaksa t;
                if (this.firma.getPdvObveznik() == 1) {
                    if (a.getTaksa("PDV") == null) {
                        errors.add("Artikal " + a.getArtikal().getSfrProizvod() + " nema definisanu stopu PDV");
                    } else {
                        t = a.getTaksa("PDV");
                        if (new BigDecimal(t.getStopa()).setScale(2).compareTo(BigDecimal.ZERO) == 0) {
                            errors.add("Artikal " + a.getArtikal().getSfrProizvod() + " ima nedozvoljenu stopu PDV.");
                        }
                    }
                    if (!(a.getKolicina() * a.getProdCena().doubleValue() < 0.0)) continue;
                    errors.add("Artikal " + a.getArtikal().getSfrProizvod() + " ima negativnu kolicinu ili cenu.");
                    continue;
                }
                t = a.getTaksa("PDV");
                if (t == null || new BigDecimal(t.getStopa()).setScale(2).compareTo(BigDecimal.ZERO) == 0) continue;
                errors.add("Artikal " + a.getArtikal().getSfrProizvod() + " ima nedozvoljenu stopu PDV.");
            }
        }
    }
}

