/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.efaktura;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UnitConverter {
    private static final List<Entry> UNITS = new ArrayList<Entry>();

    static {
        UNITS.add(new Entry(new String[]{"kom"}, "H87"));
        UNITS.add(new Entry(new String[]{"kg"}, "KGM"));
        UNITS.add(new Entry(new String[]{"km"}, "KMT"));
        UNITS.add(new Entry(new String[]{"g", "gr", "grm", "gram"}, "GRM"));
        UNITS.add(new Entry(new String[]{"m", "met", "metar"}, "MTR"));
        UNITS.add(new Entry(new String[]{"l", "li", "lit", "litar"}, "LTR"));
        UNITS.add(new Entry(new String[]{"t", "ton", "tona"}, "TNE"));
        UNITS.add(new Entry(new String[]{"m2"}, "MTK"));
        UNITS.add(new Entry(new String[]{"m3"}, "MTQ"));
        UNITS.add(new Entry(new String[]{"min"}, "MIN"));
        UNITS.add(new Entry(new String[]{"h", "sat"}, "HUR"));
        UNITS.add(new Entry(new String[]{"d", "dan"}, "DAY"));
        UNITS.add(new Entry(new String[]{"mes", "mesec"}, "MON"));
        UNITS.add(new Entry(new String[]{"god"}, "ANN"));
        UNITS.add(new Entry(new String[]{"kwh"}, "KWH"));
    }

    public static String convert(String unit) {
        String result = null;
        Iterator<Entry> iterator = UNITS.iterator();
        while (iterator.hasNext() && result == null) {
            Entry p = iterator.next();
            if (!p.containsOption(unit)) continue;
            result = p.getValue();
        }
        result = result != null ? result : "H87";
        System.out.println("UnitConverter: " + unit + " -> " + result);
        return result;
    }

    private static class Entry {
        private String[] options;
        private String value;

        public Entry(String[] options, String value) {
            this.options = options;
            this.value = value;
        }

        private boolean containsOption(String option) {
            if (option == null || option.equals("")) {
                return false;
            }
            String lowerCase = option.toLowerCase().trim();
            boolean found = false;
            int i = 0;
            while (i < this.options.length && !found) {
                if (lowerCase.equals(this.options[i])) {
                    found = true;
                }
                ++i;
            }
            return found;
        }

        private String getValue() {
            return this.value;
        }
    }
}

