/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.efaktura;

import com.helger.jaxb.IJAXBWriter;
import com.helger.ubl21.UBL21WriterBuilder;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AttachmentType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CountryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CustomerPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.FinancialAccountType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyLegalEntityType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyTaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.SupplierPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSubtotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.EmbeddedDocumentBinaryObjectType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.EndpointIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InstructionNoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PaymentIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxableAmountType;
import rs.pezar.core.PzApplication;
import rs.pezar.core.log.PzLogger;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Komitentparameter;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Tekuciracun;
import rs.pezar.efaktura.EDokumentValidator;
import rs.pezar.efaktura.util.XMLUtil;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzFileExtensionFilter;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzCacheUtility;

public abstract class EDokumentExporter<T extends PzDokument, E> {
    protected static final String PROFILE_ID = "eRacun";
    protected static final String DOCUMENT_CURRENCY_CODE = "RSD";
    protected static final String COUNTRY_SCHEME = "9948";
    protected static final String COUNTRY_CODE = "RS";
    protected static final String CURRENCY_ID = "RSD";
    private T dokument;
    private Firma firma;
    private File cacheDir;
    private List<DocumentReferenceType> additionalDocumentReferences;

    public EDokumentExporter(T dokument) {
        this.dokument = dokument;
    }

    public EDokumentExporter<T, E> init() throws Exception {
        this.firma = PzFirma.getFirma();
        this.cacheDir = PzCacheUtility.getReportCacheDir(this.dokument);
        this.validateRequiredData();
        return this;
    }

    public void setAdditionalDocumentReferences(List<DocumentReferenceType> references) {
        this.additionalDocumentReferences = references;
    }

    public List<DocumentReferenceType> additionalDocumentReferences() {
        return this.additionalDocumentReferences;
    }

    public abstract E build() throws Exception;

    protected Firma getFirma() {
        return this.firma;
    }

    public void export(Component parent) throws Exception {
        JFileChooser fc = new JFileChooser();
        String dir = (String)PzApplication.getApplication().getLocalMachineUserSettings().getProperty("E_DOKUMENT_EXPORT_DIR");
        String selectedFile = String.valueOf(this.dokument.getOznDokumenta().replace("/", "-")) + ".xml";
        PzFileExtensionFilter txtFilter = new PzFileExtensionFilter();
        txtFilter.setExtension(".xml");
        txtFilter.setDescription("XML file (.xml)");
        fc.setFileFilter((FileFilter)txtFilter);
        fc.setSelectedFile(new File(dir != null ? String.valueOf(dir) + File.separator + selectedFile : selectedFile));
        if (fc.showSaveDialog(parent) == 0) {
            String file = fc.getSelectedFile().getPath();
            dir = new File(file).getParent();
            if (dir != null) {
                PzApplication.getApplication().getLocalMachineUserSettings().setProperty("E_DOKUMENT_EXPORT_DIR", (Object)dir);
            }
            if (!file.endsWith(".xml")) {
                file = String.valueOf(file) + ".xml";
            }
            if (new File(file).exists() && PzSwingUtility.daNeDijalog((Component)parent, (Object)"Fajl sa izabranim imenom postoji. Da li zelite da ga prepisete?", (String)"", null, (boolean)true) != 0) {
                return;
            }
            FileWriter writer = null;
            try {
                writer = new FileWriter(file);
                writer.append(this.toXML());
                JOptionPane.showMessageDialog(parent, "E-Faktura je uspesno eksportovana");
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    protected abstract UBL21WriterBuilder<E> builder();

    public String toXML() throws Exception {
        UBL21WriterBuilder<E> b = this.builder();
        b.setCharset(StandardCharsets.UTF_8);
        b.setFormattedOutput(true);
        b.setUseSchema(false);
        MapBasedNamespaceContext nsctx = (MapBasedNamespaceContext)b.getNamespaceContext();
        nsctx.addMapping("sbt", "http://mfin.gov.rs/srbdt/srbdtext");
        StringWriter writer = new StringWriter();
        b.write(this.build(), new IJAXBWriter.IJAXBMarshaller<E>(){

            public void doMarshal(@Nonnull Marshaller m, @Nonnull JAXBElement<E> e) throws JAXBException {
                DocumentBuilderFactory.newInstance();
                m.marshal(e, (Writer)writer);
            }
        });
        String xml = XMLUtil.fixNamespaces(writer.toString());
        System.out.println(xml);
        return xml;
    }

    protected DocumentReferenceType contractReference() {
        Komitentparameter ugovor = this.dokument.getKomitent().getKomitentparameter("BROJ_UGOVORA");
        Komitentparameter jbkjs = this.dokument.getKomitent().getKomitentparameter("JBKJS");
        if (!this.isNull(ugovor) && !this.isEmpty(ugovor.getValue())) {
            DocumentReferenceType ref = new DocumentReferenceType();
            ref.setID(ugovor.getValue());
            return ref;
        }
        if (!(this.isNull(jbkjs) || this.isNull(jbkjs.getValue()) || this.isEmpty(jbkjs.getValue()))) {
            DocumentReferenceType ref = new DocumentReferenceType();
            ref.setID(this.dokument.getOznDokumenta());
            return ref;
        }
        return null;
    }

    protected TaxCategoryType taxCategory(Tarifnagrupa t) {
        if (this.firma.getPdvObveznik() == 1) {
            return this.taxCategory("VAT", new BigDecimal(t.getStopa()).setScale(0));
        }
        return this.taxCategory("SS", "VAT", BigDecimal.ZERO);
    }

    protected TaxCategoryType taxCategory(PzADTaksa at) {
        if (this.firma.getPdvObveznik() == 1) {
            if (this.documentTaxExemptionCode() != null) {
                return this.taxCategory("VAT", BigDecimal.ZERO);
            }
            return this.taxCategory("VAT", new BigDecimal(at.getStopa()).setScale(0));
        }
        return this.taxCategory("SS", "VAT", BigDecimal.ZERO);
    }

    protected TaxCategoryType taxCategory(String id, String scheme, BigDecimal percent) {
        TaxCategoryType c = new TaxCategoryType();
        c.setID(id);
        if (percent != null) {
            c.setPercent(percent);
        }
        c.setTaxScheme(this.taxScheme(scheme));
        return c;
    }

    protected TaxCategoryType taxCategory(String scheme, BigDecimal percent) {
        if (this.documentTaxExemptionCode() != null) {
            String[] exemption = this.documentTaxExemptionCode().split("\\s");
            String code = exemption[0];
            String cat = exemption[1].replaceAll("\\(|\\)", "");
            TaxCategoryType c = this.taxCategory(cat, "VAT", BigDecimal.ZERO);
            c.setTaxExemptionReasonCode(code);
            return c;
        }
        return this.taxCategory("S", "VAT", percent);
    }

    protected TaxTotalType taxTotal(List<PzTaksaDokument> list) {
        TaxTotalType total = new TaxTotalType();
        BigDecimal amount = BigDecimal.ZERO;
        if (this.getFirma().getPdvObveznik() == 1) {
            for (PzTaksaDokument t : list) {
                amount = amount.add(t.getIznos());
            }
        }
        List<TaxSubtotalType> s = this.taxSubTotal(list);
        total.setTaxSubtotal(s);
        total.setTaxAmount(this.taxAmount(s));
        return total;
    }

    protected TaxTotalType taxTotal() {
        return this.taxTotal(this.taksaDokuments());
    }

    protected TaxSubtotalType taxSubTotal(PzTaksaDokument t) {
        TaxSubtotalType tax = new TaxSubtotalType();
        tax.setTaxableAmount(this.taxableAmount(t.getOsnovica()));
        tax.setTaxAmount(this.taxAmount(t.getIznos()));
        tax.setTaxCategory(this.taxCategory(t.getTarifnagrupa()));
        return tax;
    }

    protected List<TaxSubtotalType> taxSubTotal(List<PzTaksaDokument> list) {
        ArrayList<TaxSubtotalType> taxes = new ArrayList<TaxSubtotalType>();
        if (this.firma.getPdvObveznik() == 1) {
            if (this.documentTaxExemptionCode() != null) {
                this.documentTaxExemptionCode().split("\\s");
                TaxSubtotalType tax = new TaxSubtotalType();
                tax.setTaxableAmount(this.taxableAmount(this.dokument.getIznos()));
                tax.setTaxAmount(this.taxAmount(BigDecimal.ZERO));
                TaxCategoryType c = this.taxCategory("VAT", BigDecimal.ZERO);
                tax.setTaxCategory(c);
                taxes.add(tax);
            } else {
                for (PzTaksaDokument t : list) {
                    TaxSubtotalType tax = this.taxSubTotal(t);
                    taxes.add(tax);
                }
            }
            ArrayList<TaxSubtotalType> summary = new ArrayList<TaxSubtotalType>();
            for (TaxSubtotalType tax : taxes) {
                TaxSubtotalType found = this.findByRate(summary, tax);
                if (found != null) {
                    found.setTaxableAmount(found.getTaxableAmountValue().add(tax.getTaxableAmountValue()));
                    found.setTaxAmount(found.getTaxAmountValue().add(tax.getTaxAmountValue()));
                    continue;
                }
                summary.add(tax);
            }
            taxes = summary;
        } else {
            TaxSubtotalType tax = new TaxSubtotalType();
            tax.setTaxableAmount(this.taxableAmount(this.dokument.getIznos()));
            tax.setTaxAmount(this.taxAmount(BigDecimal.ZERO));
            TaxCategoryType c = this.taxCategory("SS", "VAT", BigDecimal.ZERO);
            c.setTaxExemptionReasonCode("PDV-RS-33");
            tax.setTaxCategory(c);
            taxes.add(tax);
        }
        return taxes;
    }

    protected List<PzTaksaDokument> taksaDokuments() {
        return this.dokument.getTaksadokuments();
    }

    protected abstract String documentTaxExemptionCode();

    protected BigDecimal taxableAmount() {
        List<TaxSubtotalType> list = this.taxSubTotal(this.taksaDokuments());
        BigDecimal sum = BigDecimal.ZERO;
        for (TaxSubtotalType s : list) {
            sum = sum.add(s.getTaxableAmountValue());
        }
        return sum;
    }

    protected BigDecimal taxAmount() {
        List<TaxSubtotalType> list = this.taxSubTotal(this.taksaDokuments());
        BigDecimal sum = BigDecimal.ZERO;
        for (TaxSubtotalType s : list) {
            sum = sum.add(s.getTaxAmountValue());
        }
        return sum;
    }

    private TaxSubtotalType findByRate(List<TaxSubtotalType> taxes, TaxSubtotalType tax) {
        TaxSubtotalType found = null;
        Iterator<TaxSubtotalType> iterator = taxes.iterator();
        while (iterator.hasNext() && found == null) {
            TaxSubtotalType temp = iterator.next();
            if (temp.getTaxCategory().getPercentValue().compareTo(tax.getTaxCategory().getPercentValue()) != 0) continue;
            found = temp;
        }
        return found;
    }

    protected TaxableAmountType taxableAmount(BigDecimal value) {
        TaxableAmountType a = new TaxableAmountType(value);
        a.setCurrencyID("RSD");
        return a;
    }

    protected TaxAmountType taxAmount(BigDecimal value) {
        TaxAmountType a = new TaxAmountType(value);
        a.setCurrencyID("RSD");
        return a;
    }

    protected TaxAmountType taxAmount(List<TaxSubtotalType> subtotals) {
        BigDecimal amount = BigDecimal.ZERO;
        for (TaxSubtotalType s : subtotals) {
            amount = amount.add(s.getTaxAmountValue());
        }
        return this.taxAmount(amount);
    }

    protected SupplierPartyType supplier() throws Exception {
        PartyType p = new PartyType();
        p.setEndpointID(this.endpointIdType(COUNTRY_SCHEME, this.firma.getPib()));
        p.addPartyName(this.partyName(this.firma.getNaziv()));
        p.setPostalAddress(this.postalAddress(this.firma.getAdresa(), this.firma.getPostBroj(), this.firma.getGrad(), COUNTRY_CODE));
        p.addPartyTaxScheme(this.partyTaxScheme("VAT", this.firma.getPib(), COUNTRY_CODE));
        p.addPartyLegalEntity(this.partyLegalEntity(this.firma.getMatBroj(), this.firma.getNaziv()));
        p.setContact(this.contact(this.firma.getEmail()));
        SupplierPartyType s = new SupplierPartyType();
        s.setParty(p);
        return s;
    }

    protected CustomerPartyType customer() {
        Komitent k = this.dokument.getKomitent();
        PartyType p = new PartyType();
        p.setEndpointID(this.endpointIdType(COUNTRY_SCHEME, k.getPib()));
        Komitentparameter jbkjs = k.getKomitentparameter("JBKJS");
        if (jbkjs != null && jbkjs.getValue() != null && !jbkjs.getValue().trim().equals("")) {
            p.addPartyIdentification(this.partyIdentification("JBKJS", jbkjs.getValue()));
        }
        p.addPartyName(this.partyName(k.getNaziv()));
        p.setPostalAddress(this.postalAddress(k.getAdresa(), k.getPostBroj(), k.getGrad(), COUNTRY_CODE));
        p.addPartyTaxScheme(this.partyTaxScheme("VAT", k.getPib(), COUNTRY_CODE));
        p.addPartyLegalEntity(this.partyLegalEntity(k.getMatBroj(), k.getNaziv()));
        p.setContact(this.contact(k.getEmail()));
        CustomerPartyType c = new CustomerPartyType();
        c.setParty(p);
        return c;
    }

    protected PartyLegalEntityType partyLegalEntity(String id, String name) {
        PartyLegalEntityType l = new PartyLegalEntityType();
        l.setCompanyID(id);
        l.setRegistrationName(name);
        return l;
    }

    protected ContactType contact(String email) {
        ContactType c = new ContactType();
        c.setElectronicMail(email);
        return c;
    }

    protected PartyTaxSchemeType partyTaxScheme(String scheme, String id, String countryCode) {
        PartyTaxSchemeType t = new PartyTaxSchemeType();
        t.setCompanyID(String.valueOf(countryCode) + id);
        t.setTaxScheme(this.taxScheme(scheme));
        return t;
    }

    protected TaxSchemeType taxScheme(String id) {
        TaxSchemeType s = new TaxSchemeType();
        s.setID(id);
        return s;
    }

    protected AddressType postalAddress(String address, String post, String city, String countryCode) {
        AddressType a = new AddressType();
        a.setStreetName(address);
        a.setPostalZone(post);
        a.setCityName(city);
        AddressLineType l = new AddressLineType();
        l.setLine(String.valueOf(address) + ", " + post + " " + city);
        a.addAddressLine(l);
        CountryType c = new CountryType();
        c.setIdentificationCode(countryCode);
        a.setCountry(c);
        return a;
    }

    protected LocalDate date(Date date) {
        return date.toLocalDate();
    }

    protected BigDecimal decimal(double val, int scale) {
        return new BigDecimal(val).setScale(scale, RoundingMode.HALF_UP);
    }

    protected EndpointIDType endpointIdType(String scheme, String id) {
        EndpointIDType e = new EndpointIDType();
        e.setSchemeID(COUNTRY_SCHEME);
        e.setValue(id);
        return e;
    }

    protected PartyIdentificationType partyIdentification(String scheme, String id) {
        PartyIdentificationType p = new PartyIdentificationType();
        p.setID(String.valueOf(scheme) + ":" + id);
        return p;
    }

    protected PartyNameType partyName(String name) {
        PartyNameType n = new PartyNameType();
        n.setName(name);
        return n;
    }

    protected PaymentMeansType paymentMeans(String id) {
        PaymentMeansType p = new PaymentMeansType();
        p.setPaymentMeansCode("30");
        p.setPaymentID(Arrays.asList(new PaymentIDType(id)));
        p.addInstructionNote(new InstructionNoteType("Placanje po racunu"));
        FinancialAccountType f = new FinancialAccountType();
        f.setID(COUNTRY_CODE + this.getBankAccount());
        p.setPayeeFinancialAccount(f);
        return p;
    }

    protected String getBankAccount() {
        List racuni;
        block5: {
            racuni = PzEntityManager.getList((String)"SELECT r FROM Tekuciracun r WHERE r.firma IS NOT null");
            if (racuni.size() != 0) break block5;
            return "";
        }
        try {
            Tekuciracun racun = null;
            for (Tekuciracun temp : racuni) {
                if (temp.getPodrazumevani() != 1) continue;
                racun = temp;
                break;
            }
            if (racun == null) {
                racun = (Tekuciracun)racuni.get(0);
            }
            return racun.getBrRacuna();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    protected DocumentReferenceType originalPDF() {
        if (this.cacheDir == null) {
            return null;
        }
        JasperPrint jp = PzReportManager.loadReportFromCache(this.dokument, (File)this.cacheDir);
        if (jp == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            JasperExportManager.exportReportToPdfStream((JasperPrint)jp, (OutputStream)os);
        }
        catch (JRException e1) {
            PzLogger.getInstance().logException((Throwable)e1);
            return null;
        }
        DocumentReferenceType ref = new DocumentReferenceType();
        if (this.dokument.getOznDokumenta() != null) {
            ref.setID(this.dokument.getOznDokumenta().replace("/", "-"));
        }
        AttachmentType att = new AttachmentType();
        EmbeddedDocumentBinaryObjectType e = new EmbeddedDocumentBinaryObjectType();
        e.setMimeCode("application/pdf");
        e.setValue(os.toByteArray());
        att.setEmbeddedDocumentBinaryObject(e);
        ref.setAttachment(att);
        try {
            os.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return ref;
    }

    protected void validateRequiredData() throws PzInfoException {
        EDokumentValidator.create(this.dokument, this.firma).validate();
    }

    private boolean isEmpty(String value) {
        return value == null || "".equals(value.trim());
    }

    private boolean isNull(Object val) {
        return val == null;
    }

    protected String kbr(String oznDokumenta) {
        BigDecimal brrac = new BigDecimal(oznDokumenta.replaceAll("\\D", ""));
        BigDecimal temp1 = brrac.multiply(new BigDecimal("100")).divide(new BigDecimal("97"), 2, 3);
        BigDecimal temp2 = new BigDecimal(brrac.multiply(new BigDecimal("100")).toBigInteger().divide(new BigInteger("97")));
        BigDecimal raz = temp1.subtract(temp2).setScale(2, 3);
        int result = new BigDecimal("98").subtract(raz.multiply(new BigDecimal(97).setScale(2, 3))).intValue();
        return String.format("%02d", result);
    }

    protected String pb(String oznDokumenta) {
        return "(mod97) " + this.kbr(oznDokumenta) + "-" + oznDokumenta.replace("/", "");
    }
}

