/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.reports;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Vector;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import rs.pezar.db.PzEntity;
import rs.pezar.reports.util.PzReportUtil;

public class PzHashMapDataSource
implements JRDataSource {
    private Vector<? extends PzEntity> eData;
    private int size = 0;
    private HashMap<String, BigDecimal> hm;

    public PzHashMapDataSource(Vector<? extends PzEntity> externalData, HashMap<String, BigDecimal> data) {
        this.hm = data;
        this.eData = externalData;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object result = null;
        try {
            if (field.getName().indexOf("_") != -1) {
                String className = field.getName().split("_")[0];
                result = this.getClassFieldValue(this.eData, field.getName().split("_")[1], className);
            } else {
                String key = field.getName();
                result = this.hm.get(key);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Naziv polja nije dobar. Polje: [" + field.getName() + "]. Naziv je identican sa kljucem HashMap-e ");
        }
        return result;
    }

    public boolean next() throws JRException {
        boolean hasnext = false;
        if (this.size != 1) {
            hasnext = true;
            ++this.size;
        }
        return hasnext;
    }

    public void reset() throws Exception {
        this.size = 0;
    }

    private Object getClassFieldValue(Vector<? extends PzEntity> entities, String fieldName, String className) {
        Object res = null;
        for (PzEntity pzEntity : entities) {
            res = PzReportUtil.getClassFieldValue(pzEntity, fieldName, className);
            if (res != null) break;
        }
        return res;
    }
}

