/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.reports;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.core.PzApplication;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.custom.PzDialogEmail;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogJournal
extends PzDialog {
    private JScrollPane jScrollPane1;
    private JLabel lblImage;
    private JPanel jPanel1;
    private JToolBar toolBar;
    private PzButton icnEmail;
    private BufferedImage receipt;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogJournal inst = new PzDialogJournal(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogJournal(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogJournal(PzDialog frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setPreferredSize(new Dimension(440, 730));
            this.jPanel1 = new JPanel();
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.getContentPane().add((Component)this.jPanel1, "Center");
            this.jPanel1.setPreferredSize(new Dimension(384, 691));
            jPanel1Layout.rowWeights = new double[]{0.0, 0.1};
            int[] nArray = new int[2];
            nArray[1] = 7;
            jPanel1Layout.rowHeights = nArray;
            jPanel1Layout.columnWeights = new double[]{0.1};
            jPanel1Layout.columnWidths = new int[]{7};
            this.jPanel1.setLayout(jPanel1Layout);
            this.toolBar = new JToolBar();
            GridBagConstraints gbc_toolBar = new GridBagConstraints();
            gbc_toolBar.anchor = 17;
            gbc_toolBar.insets = new Insets(0, 0, 0, 0);
            gbc_toolBar.gridx = 0;
            gbc_toolBar.gridy = 0;
            this.jPanel1.add((Component)this.toolBar, gbc_toolBar);
            this.icnEmail = new PzButton();
            this.toolBar.add((Component)this.icnEmail);
            this.icnEmail.setText("Email|(Ctrl+E)");
            this.icnEmail.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/reports/img/mail_earth_small.png")));
            this.icnEmail.setToolTipText("Po\u0161alji kao email (CTRL+E)");
            this.icnEmail.setActionCommand("email");
            this.icnEmail.addActionListener((ActionListener)((Object)this));
            this.icnEmail.setShortcut("ctrl+e");
            this.jScrollPane1 = new JScrollPane();
            this.jPanel1.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 10, 10), 0, 0));
            this.lblImage = new JLabel();
            this.receipt = (BufferedImage)this.getSession().getParameter("RECEIPT");
            this.lblImage.setIcon(new ImageIcon(this.receipt));
            this.jScrollPane1.setViewportView(this.lblImage);
            this.setSize(500, 730);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String client = PzParameter.getParameterValue((String)"TIP_MAIL_KLIJENTA", (String)"interni");
        final String exportFilename = String.valueOf(this.getSession().getParameter("PFR-BROJ").toString()) + ".png";
        if (client.equals("interni")) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)this.receipt, "PNG", os);
                PzDialogEmail dialog = new PzDialogEmail((PzDialog)this, os, exportFilename, "Ra\u010dun " + exportFilename.replace(".png", ""));
                dialog.setLocationRelativeTo((Component)((Object)this));
                dialog.setModal(true);
                dialog.setVisible(true);
            }
            catch (IOException e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        } else {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String cmd = PzParameter.getParameterValue((String)"MAIL_CLIENT_COMMAND");
                        if (cmd == null || "".equals(cmd)) {
                            PzSwingUtility.showErrorMessage((Component)((Object)PzDialogJournal.this), (String)"Nije definisana komanda za pokretanje mejl klijenta");
                        } else {
                            String tmpfile = String.valueOf(PzDialogJournal.this.getXlsTmpDir()) + File.separator + PzDialogEmail.normalizeAttachmentName((String)(exportFilename != null ? exportFilename : "Receipt.png"));
                            ImageIO.write((RenderedImage)PzDialogJournal.this.receipt, "PNG", new File(tmpfile));
                            String[] cmdarr = cmd.replace("$file", tmpfile).replace("$subject", exportFilename).split("#");
                            new ProcessBuilder(cmdarr).start();
                        }
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Throwable)e);
                    }
                }
            });
            t.start();
        }
    }

    public String getXlsTmpDir() {
        String path = PzApplication.getApplication().getDataFolder() + File.separator + "xls";
        File file = new File(path);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file = new File(path = PzApplication.getApplication().getDataFolder() + File.separator + "xls" + File.separator + "tmp")).exists()) {
            file.mkdir();
        }
        return String.valueOf(path) + File.separator;
    }
}

