/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.widget.duznici;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import rs.pezar.analitike.gui.komitenti.ukupnoDugovanje.UkupnoDugovanjeUtil;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.util.PzDateUtility;

public class PnlDuznici
extends JXTitledPanel {
    private static final long serialVersionUID = -504871399794511530L;
    private JXTable table;
    private PzPanel pnlContent;
    private PzNumericOnlyTextField howMany;
    private JButton btnOsvezi;
    private GridBagConstraints gbc_scrollPane;
    private JScrollPane scrollPane;
    private JXLayer<PzPanel> layer;
    private JLabel lblHowMany;
    private PzBusyPainterUI layerUI;

    public PnlDuznici() {
        this.setPaintBorderInsets(false);
        this.setTitleFont(new Font("Tahoma", 1, 16));
        String datum = String.valueOf(PzFormatFactory.getDateFormat().format(PzDateUtility.getServerDate())) + ".";
        this.setTitle("Najve\u0107i du\u017enici (" + datum + ")");
        this.initGUI();
        this.paintGradient();
    }

    private void paintGradient() {
        this.pnlContent.setPaintGradient(true);
        this.pnlContent.setGradient(Color.LIGHT_GRAY, Color.WHITE, PzPanel.GRADIENT_SOUTH_NORTH);
    }

    private void initGUI() {
        try {
            this.pnlContent = new PzPanel();
            this.pnlContent.setBorder((Border)new EmptyBorder(0, 5, 2, 5));
            this.setContentContainer((Container)this.getLayer(this.pnlContent));
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.columnWidths = new int[]{10, 20, 10};
            gridBagLayout.rowHeights = new int[]{150, 30};
            gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0};
            gridBagLayout.rowWeights = new double[]{0.1, 0.0};
            this.pnlContent.setLayout((LayoutManager)gridBagLayout);
            this.scrollPane = new JScrollPane();
            this.scrollPane.setVisible(false);
            this.gbc_scrollPane = new GridBagConstraints();
            this.gbc_scrollPane.insets = new Insets(0, 0, 2, 0);
            this.gbc_scrollPane.fill = 1;
            this.gbc_scrollPane.gridx = 0;
            this.gbc_scrollPane.gridy = 0;
            this.pnlContent.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.table = new JXTable();
            this.table.setEditable(false);
            this.table.addHighlighter(HighlighterFactory.createSimpleStriping());
            this.table.getTableHeader().setFont(new Font("SansSerif", 1, 13));
            this.table.getTableHeader().setAlignmentY(0.0f);
            this.scrollPane.setViewportView((Component)this.table);
            this.btnOsvezi = new JButton("Prika\u017ei du\u017enike");
            this.btnOsvezi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (PnlDuznici.this.howMany.getText().length() == 0) {
                        PnlDuznici.this.howMany.setVal((Object)PzParameter.getParameterValue((String)"TOP_DUZNICI", (String)"5"));
                    }
                    try {
                        PzParameter.setParameter((String)"TOP_DUZNICI", (String)String.valueOf(PnlDuznici.this.howMany.getIntVal()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    PnlDuznici.this.initData();
                }
            });
            this.lblHowMany = new JLabel();
            this.pnlContent.add((Component)this.lblHowMany, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(2, 2, 3, 0), 0, 0));
            this.lblHowMany.setText("Prikazati top:");
            this.howMany = new PzNumericOnlyTextField();
            this.howMany.setColumns(5);
            this.howMany.setVal((Object)PzParameter.getParameterValue((String)"TOP_DUZNICI", (String)"5"));
            this.pnlContent.add((Component)this.howMany, (Object)new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 1, new Insets(2, 0, 3, 5), 0, 0));
            this.btnOsvezi.setIcon(new ImageIcon(PnlDuznici.class.getResource("/rs/pezar/analitike/resource/img/refresh.png")));
            this.pnlContent.add((Component)this.btnOsvezi, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(1, 0, 2, 0), 0, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initData() {
        this.layerUI.setLocked(true);
        SwingWorker<List<Object[]>, Object> worker = new SwingWorker<List<Object[]>, Object>(){

            @Override
            protected List<Object[]> doInBackground() throws Exception {
                String baseQuery = UkupnoDugovanjeUtil.createDependentQuery(0, 1, 0, 0, PzDateUtility.getCurrentDate(), false, true);
                EntityManager em = PzEntityManager.getEm();
                Query q = em.createNativeQuery(baseQuery);
                return q.getResultList();
            }

            @Override
            protected void done() {
                try {
                    try {
                        BigDecimal ukupanDug = new BigDecimal(0);
                        List duznici = (List)this.get();
                        DefaultTableModel model = new DefaultTableModel();
                        ArrayList<Duznik> listaDuznika = new ArrayList<Duznik>(duznici.size());
                        for (Object[] k : duznici) {
                            String komitent = String.valueOf(k[0].toString()) + ", " + k[1].toString();
                            BigDecimal fakturisano = new BigDecimal(k[2] != null ? k[2].toString() : "0.00");
                            new BigDecimal(k[3] != null ? k[3].toString() : "0.00");
                            BigDecimal uplate = new BigDecimal(k[4] != null ? k[4].toString() : "0.00");
                            new BigDecimal(k[5] != null ? k[5].toString() : "0.00");
                            BigDecimal dug = fakturisano.subtract(uplate);
                            if (dug.compareTo(BigDecimal.ZERO) != 1) continue;
                            listaDuznika.add(new Duznik(komitent, dug));
                        }
                        Collections.sort(listaDuznika);
                        int brojDuznika = listaDuznika.size() < PnlDuznici.this.howMany.getIntVal() ? listaDuznika.size() : PnlDuznici.this.howMany.getIntVal();
                        Object[][] data = new Object[brojDuznika + 1][3];
                        int i = 0;
                        while (i < brojDuznika) {
                            Duznik duznik = (Duznik)listaDuznika.get(i);
                            data[i] = new Object[]{String.valueOf(i + 1) + ".", duznik.getKomitent(), duznik.getDug()};
                            ukupanDug = ukupanDug.add(duznik.getIznosDuga());
                            ++i;
                        }
                        data[brojDuznika] = new Object[]{"", "<html><strong>UKUPNO</strong></html>", "<html><strong>" + PzFormatFactory.getIznosFormat().format(ukupanDug) + "</strong></html>"};
                        model.setDataVector(data, new String[]{"RBR", "Komitent", "Dugovanje"});
                        PnlDuznici.this.table.setModel((TableModel)model);
                        PnlDuznici.this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
                        PnlDuznici.this.table.getColumnModel().getColumn(0).setMaxWidth(50);
                        DefaultTableCellRenderer renderer0 = new DefaultTableCellRenderer();
                        renderer0.setHorizontalAlignment(0);
                        PnlDuznici.this.table.getColumnModel().getColumn(0).setCellRenderer(renderer0);
                        DefaultTableCellRenderer renderer1 = new DefaultTableCellRenderer();
                        PnlDuznici.this.table.getColumnModel().getColumn(1).setMinWidth(125);
                        renderer1.setHorizontalAlignment(2);
                        PnlDuznici.this.table.getColumnModel().getColumn(1).setCellRenderer(renderer1);
                        DefaultTableCellRenderer renderer2 = new DefaultTableCellRenderer();
                        renderer2.setHorizontalAlignment(4);
                        PnlDuznici.this.table.getColumnModel().getColumn(2).setPreferredWidth(90);
                        PnlDuznici.this.table.getColumnModel().getColumn(2).setMaxWidth(90);
                        PnlDuznici.this.table.getColumnModel().getColumn(2).setCellRenderer(renderer2);
                        PnlDuznici.this.table.setSortable(false);
                        PnlDuznici.this.scrollPane.setVisible(true);
                    }
                    catch (Exception exception) {
                        PnlDuznici.this.scrollPane.setVisible(false);
                        PnlDuznici.this.layerUI.setLocked(false);
                    }
                }
                finally {
                    PnlDuznici.this.layerUI.setLocked(false);
                }
            }
        };
        worker.execute();
    }

    public JXLayer<PzPanel> getLayer(PzPanel pnl) {
        if (this.layerUI == null) {
            this.layerUI = new PzBusyPainterUI();
            this.layer = new JXLayer((Component)pnl, (LayerUI)this.layerUI);
        }
        return this.layer;
    }

    private class Duznik
    implements Comparable<Duznik> {
        private final String komitent;
        private final String dug;
        private final BigDecimal iznosDuga;

        public Duznik(String komitent, BigDecimal iznosDuga) {
            this.komitent = komitent;
            this.iznosDuga = iznosDuga;
            this.dug = PzFormatFactory.getIznosFormat().format(iznosDuga);
        }

        public String getKomitent() {
            return this.komitent;
        }

        public String getDug() {
            return this.dug;
        }

        public BigDecimal getIznosDuga() {
            return this.iznosDuga;
        }

        @Override
        public int compareTo(Duznik other) {
            return other.iznosDuga.compareTo(this.iznosDuga);
        }

        public String toString() {
            return String.valueOf(this.komitent) + " " + this.dug;
        }
    }
}

