/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.transformation;

import java.awt.Component;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import rs.pezar.analitike.gui.artikli.nivelacije.PzDialogNivelacijeArhivaPregled;
import rs.pezar.analitike.transformation.DialogProcenat;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.transformation.DefaultDokumentTransformer;
import rs.pezar.core.transformation.DokumentTransformer;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Artikalnivelacija;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class NivelacijaTransformer
extends DokumentTransformer {
    public static final String PARAMETER_PROCENAT = "PROCENAT";
    public static final String PARAMETER_RJ = "RJ";

    public PzDokument toDokument(Lista lista, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        if (parameters == null) {
            return null;
        }
        Double procenat = (Double)parameters.get(PARAMETER_PROCENAT) / 100.0;
        Radnajedinica rj = (Radnajedinica)parameters.get(PARAMETER_RJ);
        Nivelacija n = new Nivelacija();
        n.setTip("NIVELACIJA");
        n.setDatum(PzDateUtility.getCurrentDate());
        n.setRadnajedinica(rj);
        PzDokumentManager.getInstance().snimiDokument((PzDokument)n, true, null, em);
        em.merge((Object)n);
        String cenaStr = BDConverter.getIznos((double)(procenat * 100.0)).doubleValue() != 100.0 ? "ROUND(CAST(s.prodCena*:procenat AS NUMERIC))" : "a.cena";
        String query = "INSERT INTO ArtikalNivelacija (idDok, sfrProizvod, rBroj, naziv, bliziOpis, jm, kolicina, cenaStara, cenaNova) (SELECT :idDok, a.sfrProizvod, a.rBroj, art.naziv, art.bliziOpis, art.jedMere, (s.kolicina - s.alocKolicina), s.prodCena, " + cenaStr + " FROM ArtikalLista a, Artikal art, Stanje s WHERE idLista=:idLista AND art.sfrProizvod=a.sfrProizvod AND s.sfrProizvod = a.sfrProizvod AND s.oznRj = ':oznRj' AND s.oznOgranak=':oznOgranak')";
        query = query.replaceAll(":idDok", "" + n.getIdDok()).replaceAll(":idLista", "" + lista.getIdLista()).replaceAll(":oznRj", rj.getId().getOznRj()).replaceAll(":oznOgranak", rj.getId().getOznOgranak()).replaceAll(":procenat", "" + procenat);
        Query q = em.createNativeQuery(query);
        q.executeUpdate();
        query = "INSERT INTO ANTaksa (oznTarGr, idDok, sfrProizvod, rBroj, oznVrstaTG, stopa, opis) (SELECT tga.oznTarGr, :idDok, tga.sfrProizvod, an.rBroj, tg.oznVrstaTg, tg.stopa, '' FROM TGArtikal tga, ArtikalNivelacija an, TarifnaGrupa tg WHERE an.idDok=:idDok AND tga.sfrProizvod = an.sfrProizvod AND tg.oznTarGr = tga.oznTarGr)";
        query = query.replaceAll(":idDok", "" + n.getIdDok());
        q = em.createNativeQuery(query);
        q.executeUpdate();
        return n;
    }

    public Lista toLista(PzDokument dokument, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        Nivelacija cfr_ignored_0 = (Nivelacija)dokument;
        return new DefaultDokumentTransformer(Nivelacija.class, Artikalnivelacija.class).toLista(dokument, parameters, em);
    }

    public String getName() {
        return "Transformator nivelacije";
    }

    public String getDescription() {
        return "Nivelacija <-> Lista";
    }

    public Class<? extends PzDokument> getDokumentClass() {
        return Nivelacija.class;
    }

    public HashMap<String, Object> getDokumentParameters(PzDialog parent, Lista l) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        double procenat = DialogProcenat.getProcenat(parent);
        parameters.put(PARAMETER_PROCENAT, procenat + 100.0);
        Radnajedinica rj = PzDialogRJ.getRJ((PzDialog)parent);
        if (rj == null) {
            return null;
        }
        parameters.put(PARAMETER_RJ, rj);
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        Query qn = em.createQuery("SELECT count(n) FROM Nivelacija n WHERE n.radnajedinica = :rj AND n.userPoc=:user and n.arhiviran=0");
        qn.setParameter("rj", (Object)rj);
        qn.setParameter("user", (Object)PzApplication.getApplication().getSession().getLoggedUser());
        Long br = (Long)qn.getSingleResult();
        em.close();
        if (br > 0L) {
            PzSwingUtility.showErrorMessage((Component)parent, (String)("Ve\u0107 postoji jedna nivelacija u pripremi u radnoj jedinici " + rj.getId().getOznRj() + ". Morate prvo arhivirati ili obrisati nivelaciju iz pripreme."));
            return null;
        }
        return parameters;
    }

    public PzDokument getDokumentToTransform(PzDialog parent) {
        return PzDialogNivelacijeArhivaPregled.getNivelacijaIzArhive(parent);
    }
}

