/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.pregledi.analizaProdajeNaplateDugovanja;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Valuta;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogDugovanjeKupcaPoRj
extends PzDialog {
    private static final String NA_NIVOU_FIRME = "Na nivou firme";
    private static final String ODREDJENA_RJ = "Odre\u0111ena RJ";
    private static final String KUPAC_PO_RJ = "Kupac po PJ";
    private PzPanel pnlGlavni;
    private PzPanel pnlRadioButton;
    private JLabel lblKupac;
    private PzComboBox cbValuta;
    private PzPanel pnlValuta;
    private PzFieldIndikator indKupac;
    private PzTextField tfNazivKupca;
    private PzTextField tfKupac;
    private PzFieldIndikator indRadnaJedinica;
    private PzTextField tfNazivRadneJedinice;
    private PzNumericOnlyTextField tfRadnaJedinica;
    private JLabel lblRadnaJedinica;
    private PzRadioGroup<String> panelRbs;
    private PzButton btnPotvrdi;
    private Komitent komitent;
    private Radnajedinica rj;
    private ScrollableCursor cursor = null;

    public PzDialogDugovanjeKupcaPoRj(JFrame frame) {
        super(frame);
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
        Iterator i = q.getResultList().iterator();
        this.cbValuta.addItem((Object)new PzChoice("", (Object)""));
        while (i.hasNext()) {
            Valuta v = (Valuta)i.next();
            this.cbValuta.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
        }
        this.setEnabledKupac(false);
        this.setEnabledRj(false);
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Dugovanje kupca");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            this.pnlGlavni.setPreferredSize(new Dimension(475, 204));
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{51, 44, 36, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlRadioButton = new PzPanel();
            GridBagLayout pnlRadioButtonLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlRadioButton, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlRadioButtonLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlRadioButtonLayout.rowHeights = new int[]{39, 15, 25, 25, 10, 7};
            pnlRadioButtonLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlRadioButtonLayout.columnWidths = new int[]{12, 125, 100, 91, 90, 241, 20};
            this.pnlRadioButton.setLayout((LayoutManager)pnlRadioButtonLayout);
            this.panelRbs = new PzRadioGroup((Object[])new String[]{NA_NIVOU_FIRME, ODREDJENA_RJ, KUPAC_PO_RJ});
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRbs, 1);
            this.panelRbs.setLayout((LayoutManager)panelRBsLayout);
            this.pnlRadioButton.add(this.panelRbs, (Object)new GridBagConstraints(2, 1, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRbs.setBorder((Border)BorderFactory.createTitledBorder("Izbor"));
            this.panelRbs.setSelectedValue((Object)NA_NIVOU_FIRME);
            this.panelRbs.setOpaque(false);
            this.panelRbs.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(PzDialogDugovanjeKupcaPoRj.ODREDJENA_RJ)) {
                            PzDialogDugovanjeKupcaPoRj.this.setEnabledKupac(false);
                        } else if (evt.getValue().equals(PzDialogDugovanjeKupcaPoRj.KUPAC_PO_RJ)) {
                            PzDialogDugovanjeKupcaPoRj.this.setEnabledRj(false);
                            PzDialogDugovanjeKupcaPoRj.this.setEnabledKupac(true);
                        } else if (evt.getValue().equals(PzDialogDugovanjeKupcaPoRj.NA_NIVOU_FIRME)) {
                            PzDialogDugovanjeKupcaPoRj.this.setEnabledRj(false);
                            PzDialogDugovanjeKupcaPoRj.this.setEnabledKupac(false);
                        }
                    }
                }
            });
            this.lblRadnaJedinica = new JLabel();
            this.pnlRadioButton.add((Component)this.lblRadnaJedinica, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblRadnaJedinica.setText("Radne jedinica");
            this.tfRadnaJedinica = new PzNumericOnlyTextField();
            this.pnlRadioButton.add((Component)this.tfRadnaJedinica, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfRadnaJedinica.setMaxLength(9);
            this.tfRadnaJedinica.setFocusable(false);
            this.tfRadnaJedinica.setEditable(false);
            this.tfNazivRadneJedinice = new PzTextField();
            this.pnlRadioButton.add((Component)this.tfNazivRadneJedinice, (Object)new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 0, 10), 0, 0));
            this.tfNazivRadneJedinice.setFocusable(false);
            this.tfNazivRadneJedinice.setEditable(false);
            this.indRadnaJedinica = new PzFieldIndikator();
            this.pnlRadioButton.add((Component)this.indRadnaJedinica, (Object)new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
            this.lblKupac = new JLabel();
            this.pnlRadioButton.add((Component)this.lblKupac, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblKupac.setText("Kupac");
            this.tfKupac = new PzTextField();
            this.pnlRadioButton.add((Component)this.tfKupac, (Object)new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfKupac.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.tfNazivKupca = new PzTextField();
            this.pnlRadioButton.add((Component)this.tfNazivKupca, (Object)new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 0, 10), 0, 0));
            this.tfNazivKupca.setFocusable(false);
            this.tfNazivKupca.setEditable(false);
            this.indKupac = new PzFieldIndikator();
            this.pnlRadioButton.add((Component)this.indKupac, (Object)new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
            this.btnPotvrdi = new PzButton();
            this.pnlRadioButton.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 5, 7, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(115, 33));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pnlValuta = new PzPanel();
            this.pnlRadioButton.add((Component)this.pnlValuta, (Object)new GridBagConstraints(1, 1, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlValuta.setLayout(null);
            this.pnlValuta.setBorder((Border)BorderFactory.createTitledBorder("Izbor strane valute"));
            this.cbValuta = new PzComboBox();
            this.pnlValuta.add((Component)this.cbValuta);
            this.cbValuta.setBounds(7, 25, 102, 26);
            this.tfKupac.setStateIndikator(this.indKupac);
            this.tfRadnaJedinica.setStateIndikator(this.indRadnaJedinica);
            this.pack();
            this.setSize(678, 252);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void setEnabledRj(boolean enabled) {
        this.lblRadnaJedinica.setEnabled(enabled);
        this.tfRadnaJedinica.setFocusable(enabled);
        this.indRadnaJedinica.setEnabled(enabled);
        this.tfRadnaJedinica.setText("");
        this.tfNazivRadneJedinice.setText("");
    }

    private void setEnabledKupac(boolean enabled) {
        this.lblKupac.setEnabled(enabled);
        this.tfKupac.setEditable(enabled);
        this.tfKupac.setFocusable(enabled);
        this.indKupac.setEnabled(enabled);
        if (!enabled) {
            this.tfKupac.setText("");
            this.tfNazivKupca.setText("");
            this.komitent = null;
            this.indKupac.setState(PzFieldIndikator.STATE_INVALID);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (((String)this.panelRbs.getSelectedValue()).equals(KUPAC_PO_RJ) && this.komitent == null) {
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Ne mo\u017eete nastaviti dalje dok ne popunite sva neophodna polja.");
            this.indKupac.setState(PzFieldIndikator.STATE_INVALID);
            return;
        }
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            if (((String)this.panelRbs.getSelectedValue()).equals(ODREDJENA_RJ)) {
                this.rj = PzDialogRJ.getRJ((PzDialog)this);
                if (this.rj != null) {
                    this.tfRadnaJedinica.setVal((Object)this.rj.getId().getOznRj());
                    this.tfNazivRadneJedinice.setVal((Object)this.rj.getNaziv());
                } else {
                    return;
                }
            }
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogDugovanjeKupcaPoRj.this.cursor != null) {
                        PzDialogDugovanjeKupcaPoRj.this.cursor.close();
                    }
                    String upit = "";
                    String avansi = "";
                    Query q = null;
                    String valuta = PzDialogDugovanjeKupcaPoRj.this.cbValuta.getSelectedChoice().getValue().toString();
                    if (((String)PzDialogDugovanjeKupcaPoRj.this.panelRbs.getSelectedValue()).equals(PzDialogDugovanjeKupcaPoRj.ODREDJENA_RJ) || ((String)PzDialogDugovanjeKupcaPoRj.this.panelRbs.getSelectedValue()).equals(PzDialogDugovanjeKupcaPoRj.NA_NIVOU_FIRME)) {
                        upit = "Select k.sfrKomitent, k.naziv,sum((f.iznos-f.stornoIznos)%valuta%), sum((f.uplata)%valuta%), sum((u.iznosSaPorezom)%valuta%) From  Radnajedinica rj, Faktura f LEFT JOIN Opstidokument u ON u.str1= '%tipF%' AND u.tip= '%tipU%' AND u.discriminator='UPLATA' AND f.sfrKomitent = u.sfrKomitent LEFT JOIN Komitent k ON k.sfrKomitent= f.sfrKomitent %valutaF% Where %valutaW% f.datValute <= ':datum' AND f.storno = 0 AND f.arhiviran = 1 AND f.iznos-f.stornoIznos-f.uplata <> 0 AND f.tip IN ('%tipF%', '%tipFS%', '%tipFU%') and f.oznRj = rj.oznRj AND f.oznOgranak = rj.oznOgranak  and rj.oznRj IN (%listaRj%) ";
                        if (((String)PzDialogDugovanjeKupcaPoRj.this.panelRbs.getSelectedValue()).equals(PzDialogDugovanjeKupcaPoRj.ODREDJENA_RJ)) {
                            upit = String.valueOf(upit) + " AND rj.oznRj = ':rj' AND rj.oznOgranak=':ogranak'";
                            upit = upit.replace(":rj", PzDialogDugovanjeKupcaPoRj.this.rj.getId().getOznRj());
                            upit = upit.replace(":ogranak", PzDialogDugovanjeKupcaPoRj.this.rj.getId().getOznOgranak());
                        }
                        upit = String.valueOf(upit) + " GROUP BY k.sfrKomitent, k.naziv ORDER BY  lpad(k.sfrKomitent, 5, '0')";
                        upit = upit.replace(":datum", PzDateUtility.getCurrentDate().toString());
                        if (PzDialogRJ.getAvaliableRjString().equals("")) {
                            throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                        }
                        upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                        upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                        upit = upit.replace("%tipFU%", TipDokumentConfig.get().FAKTURA_USLUGA);
                        upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                        upit = upit.replace("%tipU%", TipDokumentConfig.get().UPLATA_DAT_AVANS);
                    } else if (((String)PzDialogDugovanjeKupcaPoRj.this.panelRbs.getSelectedValue()).equals(PzDialogDugovanjeKupcaPoRj.KUPAC_PO_RJ)) {
                        avansi = avansi.replace(":komitent", PzDialogDugovanjeKupcaPoRj.this.komitent.getSfrKomitent().toString());
                        upit = "Select rj.oznRj, rj.naziv,sum((f.iznos-f.stornoIznos)%valuta%), sum((f.uplata)%valuta%), sum((u.iznosSaPorezom)%valuta%) From Komitent k, Radnajedinica rj, Faktura f LEFT JOIN Opstidokument u ON u.str1='%tipF%' AND u.tip= '%tipU%' AND u.discriminator='UPLATA' AND f.sfrKomitent = u.sfrKomitent %valutaF% Where %valutaW% f.sfrKomitent = k.sfrKomitent AND f.datValute <= ':datum' AND f.storno = 0 and f.arhiviran = 1 AND f.iznos-f.stornoIznos-f.uplata <> 0 AND f.oznRj = rj.oznRj AND f.oznOgranak = rj.oznOgranak AND f.tip IN ('%tipF%', '%tipFS%', '%tipFU%') and rj.oznRj IN (%listaRj%) and k.sfrKomitent = ':komitent' GROUP BY rj.oznRj, rj.naziv ORDER BY rj.oznRj";
                        upit = upit.replace(":datum", PzDateUtility.getCurrentDate().toString());
                        upit = upit.replace(":komitent", PzDialogDugovanjeKupcaPoRj.this.komitent.getSfrKomitent().toString());
                        if (PzDialogRJ.getAvaliableRjString().equals("")) {
                            throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                        }
                        upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                        upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                        upit = upit.replace("%tipFU%", TipDokumentConfig.get().FAKTURA_USLUGA);
                        upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                        upit = upit.replace("%tipU%", TipDokumentConfig.get().UPLATA_DAT_AVANS);
                    }
                    upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                    upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = f.datPrometa");
                    upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and ");
                    q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    PzDialogDugovanjeKupcaPoRj.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzDialogDugovanjeKupcaPoRj.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        if (PzDialogDugovanjeKupcaPoRj.this.cursor.size() == 0) {
                            JOptionPane.showMessageDialog(PzDialogDugovanjeKupcaPoRj.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                            PzWorkerDialog.hideStatus();
                            return;
                        }
                        try {
                            PzDialogDugovanjeKupcaPoRj.this.showReports();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogDugovanjeKupcaPoRj.this), (Throwable)e);
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                    }
                }
            };
            worker.execute();
        }
    }

    private void showReports() throws Exception {
        Vector<Object> data = new Vector<Object>();
        Date today = PzDateUtility.getCurrentDate();
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String title = "";
        String fname = "";
        String izbor = "";
        String izborTekst = "";
        String valuta = "Vrednosti su izra\u017eene u valuti: " + (this.cbValuta.getSelectedChoice().getValue().equals("") ? "Dinar" : this.cbValuta.getSelectedChoice().getText());
        title = "PREGLED KUPCA sa isteklom valutom pla\u0107anja";
        fname = "rs/pezar/analitike/resource/reports/compiled/pregled.dugovanja.kupca.jasper";
        if (((String)this.panelRbs.getSelectedValue()).equals(ODREDJENA_RJ)) {
            izbor = "rj";
            izborTekst = "[ " + this.rj.getId().getOznRj() + " ] " + this.rj.getNaziv();
        } else if (((String)this.panelRbs.getSelectedValue()).equals(NA_NIVOU_FIRME)) {
            izbor = "firma";
            izborTekst = "";
        } else {
            izbor = "izborTest";
            izborTekst = "[ " + this.komitent.getSfrKomitent() + " ] " + this.komitent.getNaziv();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", title);
        params.put("datum", today);
        params.put("izborT", izborTekst);
        params.put("izbor", izbor);
        params.put("reklama", "");
        params.put("valuta", valuta);
        data.add(PzFirma.getFirma());
        if (((String)this.panelRbs.getSelectedValue()).equals(ODREDJENA_RJ)) {
            data.add(this.rj);
        }
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource(fname), params, (String)title);
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            this.tfKupac.setVal((Object)this.komitent.getSfrKomitent());
            this.tfNazivKupca.setVal((Object)this.komitent.getNaziv());
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogDugovanjeKupcaPoRj(Boolean.FALSE);
    }

    public PzDialogDugovanjeKupcaPoRj(Boolean initGUI) {
    }
}

