/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.pregledi.analizaNabavkeProdajeArtikala;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Robnagrupa;
import rs.pezar.db.entity.Valuta;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.sifarnici.gui.PzDialogRobneGrupe;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzScrollableTable;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzCalculatedField;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.util.PzDateUtility;

public class PzDialogRucRobnaGrupa
extends PzDialog {
    private PzPanel pnlGlavni;
    private PzPanel pnlFields;
    private PzDateField dfKrajnjiDatum;
    private JLabel lblRazlika;
    private JLabel lblKrajnjiDatum;
    private PzDateField dfPocetniDatum;
    private JLabel lblPocetniDatum;
    private PzTextField tfNazivRobneGrupe;
    private PzFieldIndikator indRobnaGrupa;
    private PzPanel pnlValuta;
    private PzButton btnTrazi;
    private PzCalculatedField dfRazlika;
    private PzTextField tfRobnaGrupa;
    private JLabel lblRobnaGrupa;
    private PzScrollableTable tabelaArtikli;
    private JScrollPane scrollPane;
    private Robnagrupa entRobnaGrupa;
    private Radnajedinica rj;
    private JToolBar toolbar;
    private PzComboBox cbValuta;
    private PzToolBarIcon icnStampaDetaljno;
    private PzToolBarIcon icnStampaZbirno;
    private ScrollableCursor cursor = null;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public PzDialogRucRobnaGrupa(JFrame frame) {
        super(frame);
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
        Iterator i = q.getResultList().iterator();
        this.cbValuta.addItem((Object)new PzChoice("", (Object)""));
        while (i.hasNext()) {
            Valuta v = (Valuta)i.next();
            this.cbValuta.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            this.pnlGlavni.setPreferredSize(new Dimension(717, 356));
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{93, 92, 7, 7, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1};
            pnlGlavniLayout.columnWidths = new int[]{7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            pnlFieldsLayout.rowHeights = new int[]{6, 25, 25, 25};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{112, 120, 118, 105, 10, 127, 7};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.lblRobnaGrupa = new JLabel();
            this.pnlFields.add((Component)this.lblRobnaGrupa, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 0, 0), 0, 0));
            this.lblRobnaGrupa.setText("Robna grupa");
            this.tfRobnaGrupa = new PzTextField();
            this.pnlFields.add((Component)this.tfRobnaGrupa, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.tfRobnaGrupa.setFKField(Robnagrupa.class, PzDialogRobneGrupe.class, true, null);
            this.indRobnaGrupa = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indRobnaGrupa, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 5, 0, 0), 0, 0));
            this.tfNazivRobneGrupe = new PzTextField();
            this.pnlFields.add((Component)this.tfNazivRobneGrupe, (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 3, 0), 0, 0));
            this.tfNazivRobneGrupe.setFocusable(false);
            this.lblPocetniDatum = new JLabel();
            this.pnlFields.add((Component)this.lblPocetniDatum, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 0, 0), 0, 0));
            this.lblPocetniDatum.setText("Po\u010detni datum");
            this.dfPocetniDatum = new PzDateField();
            this.pnlFields.add((Component)this.dfPocetniDatum, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfPocetniDatum.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
            this.lblKrajnjiDatum = new JLabel();
            this.pnlFields.add((Component)this.lblKrajnjiDatum, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 25, 0, 0), 0, 0));
            this.lblKrajnjiDatum.setText("Krajnji datum");
            this.dfKrajnjiDatum = new PzDateField();
            this.pnlFields.add((Component)this.dfKrajnjiDatum, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.lblRazlika = new JLabel();
            this.pnlFields.add((Component)this.lblRazlika, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 0, 0), 0, 0));
            this.lblRazlika.setText("Razlika u ceni");
            this.btnTrazi = new PzButton();
            this.pnlFields.add((Component)this.btnTrazi, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnTrazi.setText("Tra\u017ei (ENTER)");
            this.btnTrazi.setFont(new Font("Tahoma", 1, 12));
            this.btnTrazi.setActionCommand("trazi");
            this.btnTrazi.addActionListener((ActionListener)((Object)this));
            this.btnTrazi.setShortcut("enter");
            this.pnlValuta = new PzPanel();
            GridBagLayout pnlValutaLayout = new GridBagLayout();
            this.pnlFields.add((Component)this.pnlValuta, (Object)new GridBagConstraints(5, 1, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlValuta.setBorder((Border)BorderFactory.createTitledBorder("Izbor strane valute"));
            pnlValutaLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            pnlValutaLayout.rowHeights = new int[]{15, 27, 7};
            pnlValutaLayout.columnWeights = new double[]{0.0, 0.1, 0.1};
            pnlValutaLayout.columnWidths = new int[]{12, 7, 7};
            this.pnlValuta.setLayout((LayoutManager)pnlValutaLayout);
            this.cbValuta = new PzComboBox();
            this.pnlValuta.add((Component)this.cbValuta, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.scrollPane = new JScrollPane();
            this.pnlGlavni.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 2, 4, 3, 0.0, 0.0, 10, 1, new Insets(5, 7, 7, 7), 0, 0));
            this.scrollPane.setBackground(new Color(255, 255, 255));
            this.tabelaArtikli = new PzScrollableTable();
            this.scrollPane.setViewportView((Component)this.tabelaArtikli);
            this.dfRazlika = this.tabelaArtikli.createExpresionField("$4$");
            this.pnlFields.add((Component)this.dfRazlika, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfRazlika.setFocusable(false);
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(-1, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnStampaDetaljno = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnStampaDetaljno);
            this.icnStampaDetaljno.setText("\u0160tampa-detaljno|(F2)");
            this.icnStampaDetaljno.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.icnStampaDetaljno.setActionCommand("detaljno");
            this.icnStampaDetaljno.addActionListener((ActionListener)((Object)this));
            this.icnStampaDetaljno.setShortcut("F2");
            this.icnStampaZbirno = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnStampaZbirno);
            this.icnStampaZbirno.setText("\u0160tampa-zbirno|(F3)");
            this.icnStampaZbirno.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.icnStampaZbirno.setActionCommand("zbirno");
            this.icnStampaZbirno.addActionListener((ActionListener)((Object)this));
            this.icnStampaZbirno.setShortcut("F3");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("   Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.tfRobnaGrupa.setStateIndikator(this.indRobnaGrupa);
            this.pack();
            this.setSize(976, 568);
            this.setMinimumSize(new Dimension(654, 568));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("trazi")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogRucRobnaGrupa.this.cursor != null) {
                        PzDialogRucRobnaGrupa.this.cursor.close();
                    }
                    String upit = "";
                    Query q = null;
                    String valuta = PzDialogRucRobnaGrupa.this.cbValuta.getSelectedChoice().getValue().toString();
                    upit = "SELECT ad1.sfrProizvod, ad1.naziv, ad1.jm, sum(CASE WHEN (ad2.kolicina IS NULL ) THEN ad1.kolicina ELSE ad1.kolicina-ad2.kolicina END), sum(CASE WHEN (ad2.kolicina IS NULL ) THEN (ad1.kolicina*(ad1.prodCena-ad1.nabCena))%valuta% ELSE ((ad1.kolicina-ad2.kolicina)*(ad1.prodCena-ad1.nabCena))%valuta% END), ad1.prodCena%valuta%, ad1.nabCena%valuta%, d1.datum, d1.oznDokumenta FROM RobnaGrupa rg, Artikal a, Radnajedinica rj, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE a.sfrProizvod = ad1.sfrProizvod %valutaW% and d1.oznRj = rj.oznRj AND d1.oznOgranak = rj.oznOgranak AND rj.oznRj=':rj' AND rj.oznOgranak=':ogranak' AND a.oznRobGr = rg.oznRobGr AND rg.oznRobGr IN :oznRobGr AND d1.storno = 0 and d1.arhiviran = 1 AND d1.datum>=':datumOd' AND d1.datum<=':datumDo' AND rj.oznRj IN (%listaRj%) and d1.tip IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%') GROUP BY ad1.sfrProizvod, ad1.sfrSort, ad1.naziv, ad1.jm, d1.datum, d1.oznDokumenta, ad1.prodCena, ad1.nabCena %valutaG% ORDER BY ad1.sfrSort, d1.oznDokumenta";
                    upit = upit.replace(":datumOd", PzDialogRucRobnaGrupa.this.dfPocetniDatum.getVal().toString());
                    upit = upit.replace(":datumDo", PzDialogRucRobnaGrupa.this.dfKrajnjiDatum.getVal().toString());
                    upit = upit.replace(":oznRobGr", PzDialogRucRobnaGrupa.this.entRobnaGrupa.getRobnaGrupaListAsString());
                    upit = upit.replace(":rj", PzDialogRucRobnaGrupa.this.rj.getId().getOznRj());
                    upit = upit.replace(":ogranak", PzDialogRucRobnaGrupa.this.rj.getId().getOznOgranak());
                    upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/k.srednji/k.jedinica");
                    upit = upit.replace("%valutaG%", valuta.equals("") ? " " : ",k.srednji, k.jedinica");
                    upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs k ON k.datum = d1.datPrometa");
                    upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " and k.oznValuta='" + valuta + "'");
                    if (PzDialogRJ.getAvaliableRjString().equals("")) {
                        throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                    }
                    upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                    upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                    upit = upit.replace("%tipFI%", TipDokumentConfig.get().FISKALNI_IZVESTAJ);
                    upit = upit.replace("%tipFR%", TipDokumentConfig.get().FISKALNI_RACUN);
                    upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                    q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    PzDialogRucRobnaGrupa.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzDialogRucRobnaGrupa.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        try {
                            this.get();
                            if (PzDialogRucRobnaGrupa.this.cursor != null) {
                                PzDialogRucRobnaGrupa.this.tabelaArtikli.read(PzDialogRucRobnaGrupa.this.cursor, PzDialogRucRobnaGrupa.this.getColumnNames());
                                if (PzDialogRucRobnaGrupa.this.cursor.size() > 0) {
                                    RowFilter filter = RowFilter.numberFilter(RowFilter.ComparisonType.NOT_EQUAL, 0.0, 3);
                                    PzDialogRucRobnaGrupa.this.tabelaArtikli.setRowFilter(filter);
                                }
                                if (PzDialogRucRobnaGrupa.this.tabelaArtikli.getRowCount() > 0) {
                                    PzDialogRucRobnaGrupa.this.tabelaArtikli.setRowSelectionInterval(0, 0);
                                    PzDialogRucRobnaGrupa.this.tabelaArtikli.requestFocusInWindow();
                                }
                                PzDialogRucRobnaGrupa.this.tabelaArtikli.calculateFields();
                                PzDialogRucRobnaGrupa.this.brDok.setText(String.valueOf(PzDialogRucRobnaGrupa.this.tabelaArtikli.getRowCount()));
                            }
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogRucRobnaGrupa.this), (Throwable)e);
                            PzWorkerDialog.hideStatus();
                            PzWorkerDialog.hideStatus();
                            em.close();
                        }
                    }
                    finally {
                        PzWorkerDialog.hideStatus();
                        em.close();
                    }
                }
            };
            worker.execute();
        } else if (actionCommand.equals("detaljno")) {
            try {
                this.showReports(true);
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        } else if (actionCommand.equals("zbirno")) {
            try {
                this.showReports(false);
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        }
    }

    public String[] getColumnNames() {
        return new String[]{"\u0160ifra", "Naziv", "JM", "Koli\u010dina", "Razlika u ceni", "Prod cena", "Nab cena", "Datum", "Ra\u010dun"};
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Robnagrupa) {
            this.entRobnaGrupa = (Robnagrupa)entity;
            this.tfRobnaGrupa.setVal((Object)this.entRobnaGrupa.getOznRobGr());
            this.tfNazivRobneGrupe.setVal((Object)this.entRobnaGrupa.getNaziv());
        }
        this.pnlFields.updateAllFieldsState();
    }

    public boolean shouldBeShown() {
        try {
            this.rj = PzDialogRJ.getRJ((PzDialog)this);
            if (this.rj == null) {
                return false;
            }
            this.setTitle("Pregled prodaje i razlike u ceni u RJ: [ " + this.rj.getId().getOznRj() + " ] " + this.rj.getNaziv());
            return true;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return false;
        }
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    private void showReports(boolean detaljno) throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        Date today = PzDateUtility.getCurrentDate();
        PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.tabelaArtikli, data);
        String title = "PREGLED PRODAJE ARTIKALA ROBNE GRUPE [ " + this.tfRobnaGrupa.getVal() + " ] " + this.entRobnaGrupa.getNaziv();
        String subtitle = "u periodu od " + PzDateUtility.formatDate((Date)this.dfPocetniDatum.getVal()) + " do " + PzDateUtility.formatDate((Date)this.dfKrajnjiDatum.getVal());
        HashMap<String, Object> params = new HashMap<String, Object>();
        String valuta = "Vrednosti su izra\u017eene u valuti: " + (this.cbValuta.getSelectedChoice().getValue().equals("") ? "Dinar" : this.cbValuta.getSelectedChoice().getText());
        params.put("title", title);
        params.put("datum", today);
        params.put("subtitle", subtitle);
        params.put("subtitle", valuta);
        params.put("reklama", "");
        params.put("rj", "[" + this.rj.getId().getOznRj() + "] " + this.rj.getNaziv());
        data.add(PzFirma.getFirma());
        String fname = "";
        fname = detaljno ? "rs/pezar/analitike/resource/reports/compiled/RUC.robna.grupa.detaljno.jasper" : "rs/pezar/analitike/resource/reports/compiled/RUC.robna.grupa.zbirno.jasper";
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource(fname), params, (String)title);
    }
}

