/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.pregledi.analizaNabavkeProdajeArtikala;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Valuta;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.util.PzDateUtility;

public class PzDialogRucPoRaznimOsnovama
extends PzDialog {
    private static final String NA_NIVOU_FIRME = "Na nivou firme";
    private static final String NA_NIVOU_RJ = "Na nivou RJ";
    private static final String NA_NIVOU_FAKTURE = "Na nivou fakture";
    private static final String NA_NIVOU_USER_A = "Na nivou USER-a";
    private static final String NA_NIVOU_KUPCA = "Na nivou kupca";
    private static final String NA_NIVOU_ARTIKLA = "Na nivou artikla";
    private static final String BEZ_OGRANICENJA = "Bez ograni\u010denja";
    private static final String U_ZADATOM_PERIODU = "U zadatom periodu";
    private static final String DETALJAN_PREGLED = "Detaljni pregled";
    private static final String ZBIRNI_PREGLED = "Zbirni pregled";
    private PzPanel pnlGlavni;
    private PzPanel pnlRadioButton;
    private PzPanel pnlDatum;
    private PzDateField dfKrajnji;
    private PzPanel pnlValute;
    private JLabel lblKrajnjuDatum;
    private PzDateField dfPocetni;
    private JLabel lblPocetniDatum;
    private PzRadioGroup<String> panelRBs1;
    private PzRadioGroup<String> panelRBs2;
    private PzRadioGroup<String> panelRBs3;
    private PzRadioGroup<String> panelRBs4;
    private PzButton btnPotvrdi;
    private ScrollableCursor cursor = null;
    private PzComboBox cbValute;
    private Radnajedinica rj;

    public PzDialogRucPoRaznimOsnovama(JFrame frame) {
        super(frame);
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
        Iterator i = q.getResultList().iterator();
        this.cbValute.addItem((Object)new PzChoice("", (Object)""));
        while (i.hasNext()) {
            Valuta v = (Valuta)i.next();
            this.cbValute.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.pnlGlavni.setPreferredSize(new Dimension(645, 326));
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{73, 49, 79, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlRadioButton = new PzPanel();
            GridBagLayout pnlRadioButtonLayout1 = new GridBagLayout();
            GridBagLayout pnlRadioButtonLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlRadioButton, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlRadioButtonLayout1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlRadioButtonLayout1.rowHeights = new int[]{13, 35, 35, 35, 35, 7};
            pnlRadioButtonLayout1.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlRadioButtonLayout1.columnWidths = new int[]{7, 130, 5, 131, 5, 130, 8, 7};
            this.pnlRadioButton.setLayout((LayoutManager)pnlRadioButtonLayout1);
            pnlRadioButtonLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            pnlRadioButtonLayout.rowHeights = new int[]{9, 7, 7, 7};
            pnlRadioButtonLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.1, 0.1, 0.1};
            pnlRadioButtonLayout.columnWidths = new int[]{11, 128, 10, 7, 7, 7, 7};
            this.panelRBs1 = new PzRadioGroup((Object[])new String[]{NA_NIVOU_FIRME, NA_NIVOU_RJ});
            BoxLayout panelRBs1Layout = new BoxLayout((Container)this.panelRBs1, 1);
            this.panelRBs1.setLayout((LayoutManager)panelRBs1Layout);
            this.pnlRadioButton.add(this.panelRBs1, (Object)new GridBagConstraints(1, 1, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs1.setBorder((Border)BorderFactory.createTitledBorder("Izbor"));
            this.panelRBs1.setSelectedValue((Object)NA_NIVOU_FIRME);
            this.panelRBs1.setOpaque(false);
            this.panelRBs2 = new PzRadioGroup((Object[])new String[]{NA_NIVOU_FAKTURE, NA_NIVOU_USER_A, NA_NIVOU_KUPCA, NA_NIVOU_ARTIKLA});
            BoxLayout panelRBs2Layout = new BoxLayout((Container)this.panelRBs2, 1);
            this.panelRBs2.setLayout((LayoutManager)panelRBs2Layout);
            this.pnlRadioButton.add(this.panelRBs2, (Object)new GridBagConstraints(3, 1, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs2.setBorder((Border)BorderFactory.createTitledBorder("Izbor"));
            this.panelRBs2.setSelectedValue((Object)NA_NIVOU_FAKTURE);
            this.panelRBs2.setOpaque(false);
            this.panelRBs3 = new PzRadioGroup((Object[])new String[]{BEZ_OGRANICENJA, U_ZADATOM_PERIODU});
            BoxLayout panelRBs3Layout = new BoxLayout((Container)this.panelRBs3, 1);
            this.panelRBs3.setLayout((LayoutManager)panelRBs3Layout);
            this.pnlRadioButton.add(this.panelRBs3, (Object)new GridBagConstraints(5, 1, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs3.setBorder((Border)BorderFactory.createTitledBorder("Ograni\u010denja"));
            this.panelRBs3.setSelectedValue((Object)BEZ_OGRANICENJA);
            this.panelRBs3.setOpaque(false);
            this.panelRBs3.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(PzDialogRucPoRaznimOsnovama.BEZ_OGRANICENJA)) {
                            PzDialogRucPoRaznimOsnovama.this.lblKrajnjuDatum.setEnabled(false);
                            PzDialogRucPoRaznimOsnovama.this.lblPocetniDatum.setEnabled(false);
                            PzDialogRucPoRaznimOsnovama.this.dfPocetni.setFocusable(false);
                            PzDialogRucPoRaznimOsnovama.this.dfPocetni.setEditable(false);
                            PzDialogRucPoRaznimOsnovama.this.dfKrajnji.setFocusable(false);
                            PzDialogRucPoRaznimOsnovama.this.dfKrajnji.setEditable(false);
                        } else if (evt.getValue().equals(PzDialogRucPoRaznimOsnovama.U_ZADATOM_PERIODU)) {
                            PzDialogRucPoRaznimOsnovama.this.lblKrajnjuDatum.setEnabled(true);
                            PzDialogRucPoRaznimOsnovama.this.lblPocetniDatum.setEnabled(true);
                            PzDialogRucPoRaznimOsnovama.this.dfPocetni.setFocusable(true);
                            PzDialogRucPoRaznimOsnovama.this.dfPocetni.setEditable(true);
                            PzDialogRucPoRaznimOsnovama.this.dfKrajnji.setFocusable(true);
                            PzDialogRucPoRaznimOsnovama.this.dfKrajnji.setEditable(true);
                        }
                    }
                }
            });
            this.panelRBs4 = new PzRadioGroup((Object[])new String[]{DETALJAN_PREGLED, ZBIRNI_PREGLED});
            BoxLayout panelRBs4Layout = new BoxLayout((Container)this.panelRBs4, 1);
            this.panelRBs4.setLayout((LayoutManager)panelRBs4Layout);
            this.pnlRadioButton.add(this.panelRBs4, (Object)new GridBagConstraints(5, 3, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs4.setBorder((Border)BorderFactory.createTitledBorder("Pregled"));
            this.panelRBs4.setSelectedValue((Object)DETALJAN_PREGLED);
            this.panelRBs4.setOpaque(false);
            this.pnlDatum = new PzPanel();
            GridBagLayout pnlDatumLayout = new GridBagLayout();
            this.pnlRadioButton.add((Component)this.pnlDatum, (Object)new GridBagConstraints(7, 1, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlDatumLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlDatumLayout.rowHeights = new int[]{11, 25, 25, 7};
            pnlDatumLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlDatumLayout.columnWidths = new int[]{42, 46, 101, 7};
            this.pnlDatum.setLayout((LayoutManager)pnlDatumLayout);
            this.lblPocetniDatum = new JLabel();
            this.pnlDatum.add((Component)this.lblPocetniDatum, (Object)new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lblPocetniDatum.setName("lblPocetniDatum");
            this.lblPocetniDatum.setEnabled(false);
            this.dfPocetni = new PzDateField();
            this.pnlDatum.add((Component)this.dfPocetni, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfPocetni.setFocusable(false);
            this.dfPocetni.setEditable(false);
            this.lblKrajnjuDatum = new JLabel();
            this.pnlDatum.add((Component)this.lblKrajnjuDatum, (Object)new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblKrajnjuDatum.setName("lblKrajnjuDatum");
            this.lblKrajnjuDatum.setEnabled(false);
            this.dfKrajnji = new PzDateField();
            this.pnlDatum.add((Component)this.dfKrajnji, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfKrajnji.setFocusable(false);
            this.dfKrajnji.setEditable(false);
            this.btnPotvrdi = new PzButton();
            this.pnlRadioButton.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(5, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(130, 35));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pnlValute = new PzPanel();
            GridBagLayout pnlValuteLayout = new GridBagLayout();
            this.pnlRadioButton.add((Component)this.pnlValute, (Object)new GridBagConstraints(1, 3, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlValute.setBorder((Border)BorderFactory.createTitledBorder("Izbor strane valute"));
            pnlValuteLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            pnlValuteLayout.rowHeights = new int[]{9, 26, 7};
            pnlValuteLayout.columnWeights = new double[]{0.1, 0.1, 0.1};
            pnlValuteLayout.columnWidths = new int[]{7, 7, 7};
            this.pnlValute.setLayout((LayoutManager)pnlValuteLayout);
            this.cbValute = new PzComboBox();
            this.pnlValute.add((Component)this.cbValute, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pack();
            this.setSize(652, 291);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            if (((String)this.panelRBs1.getSelectedValue()).equals(NA_NIVOU_RJ)) {
                this.rj = PzDialogRJ.getRJ((PzDialog)this);
                if (this.rj == null) {
                    JOptionPane.showMessageDialog(this.getParent(), "Niste izabrali radnu jedninicu", "Informacija", 1);
                    return;
                }
            }
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogRucPoRaznimOsnovama.this.cursor != null) {
                        PzDialogRucPoRaznimOsnovama.this.cursor.close();
                    }
                    String upit = "";
                    Query q = null;
                    String valuta = PzDialogRucPoRaznimOsnovama.this.cbValute.getSelectedChoice().getValue().toString();
                    if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs4.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.ZBIRNI_PREGLED) && !((String)PzDialogRucPoRaznimOsnovama.this.panelRBs2.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_FAKTURE)) {
                        if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs2.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_USER_A)) {
                            upit = "SELECT d1.usernamepoc, sum(CASE WHEN (d1.tip = '%tipF%'  or d1.tip = '%tipFR%') THEN (ad1.kolicina*ad1.prodCena*(1-ad1.procRabata/100))%valuta% WHEN (d1.tip = '%tipFS%' or d1.tip = '%tipFI%') THEN (ad1.kolicina*ad1.prodCena)%valuta% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%'  or d2.tip = '%tipFR%') THEN (ad2.kolicina*ad2.prodCena*(1-ad2.procRabata/100))%valuta% WHEN (d2.tip = '%tipFS%' or d2.tip = '%tipFI%') THEN (ad2.kolicina*ad2.prodCena)%valuta% ELSE 0 END), sum((ad1.kolicina*ad1.nabCena)%valuta%), sum((ad2.kolicina*ad2.nabCena)%valuta%) FROM Radnajedinica rj, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE %valutaW% d1.oznRj = rj.oznRj and d1.oznOgranak = rj.oznOgranak and d1.storno = 0 and d1.arhiviran = 1 and rj.oznRj IN (%listaRj%) and d1.tip IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%') ";
                        } else if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs2.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_KUPCA)) {
                            upit = "SELECT k.sfrKomitent, k.naziv, sum(CASE WHEN (d1.tip = '%tipF%'  or d1.tip = '%tipFR%') THEN (ad1.kolicina*ad1.prodCena*(1-ad1.procRabata/100))%valuta% WHEN (d1.tip = '%tipFS%' or d1.tip = '%tipFI%') THEN (ad1.kolicina*ad1.prodCena)%valuta% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%' or d2.tip = '%tipFR%') THEN (ad2.kolicina*ad2.prodCena*(1-ad2.procRabata/100))%valuta% WHEN (d2.tip = '%tipFS%' or d2.tip = '%tipFI%') THEN (ad2.kolicina*ad2.prodCena)%valuta% ELSE 0 END), sum((ad1.kolicina*ad1.nabCena)%valuta%), sum((ad2.kolicina*ad2.nabCena)%valuta%) FROM Radnajedinica rj, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok LEFT JOIN Komitent k ON d1.sfrKomitent = k.sfrKomitent %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE %valutaW% d1.oznRj = rj.oznRj and d1.oznOgranak = rj.oznOgranak and d1.storno = 0 and d1.arhiviran = 1 and rj.oznRj IN (%listaRj%) and d1.tip IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%')";
                        } else if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs2.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_ARTIKLA)) {
                            upit = "SELECT ad1.sfrProizvod, ad1.naziv, sum(CASE WHEN (d1.tip = '%tipF%'  or d1.tip = '%tipFR%') THEN (ad1.kolicina*ad1.prodCena*(1-ad1.procRabata/100))%valuta% WHEN (d1.tip = '%tipFS%' or d1.tip = '%tipFI%') THEN (ad1.kolicina*ad1.prodCena)%valuta% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%' or d2.tip = '%tipFR%') THEN (ad2.kolicina*ad2.prodCena*(1-ad2.procRabata/100))%valuta% WHEN (d2.tip = '%tipFS%' or d2.tip = '%tipFI%') THEN (ad2.kolicina*ad2.prodCena)%valuta% ELSE 0 END), sum((ad1.kolicina*ad1.nabCena)%valuta%), sum((ad2.kolicina*ad2.nabCena)%valuta%) FROM Radnajedinica rj, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE %valutaW% d1.oznRj = rj.oznRj and d1.oznOgranak = rj.oznOgranak and d1.storno = 0 and d1.arhiviran = 1 and rj.oznRj IN (%listaRj%) and d1.tip IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%')";
                        }
                        if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs1.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_RJ)) {
                            upit = String.valueOf(upit) + " and rj.oznRj=':oznRj' and rj.oznOgranak=':oznOgranak' ";
                            upit = upit.replace(":oznRj", PzDialogRucPoRaznimOsnovama.this.rj.getId().getOznRj());
                            upit = upit.replace(":oznOgranak", PzDialogRucPoRaznimOsnovama.this.rj.getId().getOznOgranak());
                        }
                        if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs3.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.U_ZADATOM_PERIODU)) {
                            upit = String.valueOf(upit) + " and d1.datum>=':datumOd' and d1.datum<=':datumDo' ";
                            upit = upit.replace(":datumOd", PzDialogRucPoRaznimOsnovama.this.dfPocetni.getVal().toString());
                            upit = upit.replace(":datumDo", PzDialogRucPoRaznimOsnovama.this.dfKrajnji.getVal().toString());
                        }
                        if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs2.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_USER_A)) {
                            upit = String.valueOf(upit) + " GROUP BY d1.usernamepoc  ORDER BY d1.usernamepoc";
                        } else if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs2.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_KUPCA)) {
                            upit = String.valueOf(upit) + " GROUP BY k.sfrKomitent, k.naziv  ORDER BY k.sfrKomitent";
                        } else if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs2.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_ARTIKLA)) {
                            upit = String.valueOf(upit) + " GROUP BY ad1.sfrProizvod, ad1.sfrSort, ad1.naziv ORDER BY ad1.sfrSort";
                        }
                        upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                        upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = d1.datPrometa");
                        upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and");
                        if (PzDialogRJ.getAvaliableRjString().equals("")) {
                            throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                        }
                        upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                        upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                        upit = upit.replace("%tipFI%", TipDokumentConfig.get().FISKALNI_IZVESTAJ);
                        upit = upit.replace("%tipFR%", TipDokumentConfig.get().FISKALNI_RACUN);
                        upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                    } else {
                        if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs2.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_ARTIKLA)) {
                            upit = "SELECT ad1.sfrProizvod, ad1.naziv, sum(ad1.kolicina), sum(ad2.kolicina),ad1.prodCena%valuta%, ad1.nabCena%valuta%, ad1.procRabata, d1.oznDokumenta FROM Radnajedinica rj, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok LEFT JOIN Komitent k ON d1.sfrKomitent = k.sfrKomitent %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE %valutaW% d1.oznRj = rj.oznRj AND d1.oznOgranak = rj.oznOgranak AND rj.oznRj IN (%listaRj%) and d1.tip IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%') AND d1.storno = 0 and d1.arhiviran = 1 ";
                        } else if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs2.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_FAKTURE)) {
                            upit = "SELECT k.sfrKomitent, k.naziv, d1.oznDokumenta, sum(CASE WHEN (d1.tip = '%tipF%' or d1.tip = '%tipFR%') THEN (ad1.kolicina*ad1.prodCena*(1-ad1.procRabata/100))%valuta% WHEN (d1.tip = '%tipFS%' or d1.tip = '%tipFI%') THEN (ad1.kolicina*ad1.prodCena)%valuta% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%' or d2.tip = '%tipFR%') THEN (ad2.kolicina*ad2.prodCena*(1-ad2.procRabata/100))%valuta% WHEN (d2.tip = '%tipFS%' or d2.tip = '%tipFI%') THEN (ad2.kolicina*ad2.prodCena)%valuta% ELSE 0 END), sum((ad1.kolicina*ad1.nabCena)%valuta%), sum((ad2.kolicina*ad2.nabCena)%valuta%) FROM Radnajedinica rj, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok LEFT JOIN Komitent k ON d1.sfrKomitent = k.sfrKomitent %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE %valutaW% d1.oznRj=rj.oznRj and d1.oznOgranak=rj.oznOgranak and d1.storno = 0 and d1.arhiviran = 1 and rj.oznRj IN (%listaRj%) and d1.tip IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%')";
                        } else if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs2.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_USER_A)) {
                            upit = "SELECT d1.usernamepoc, d1.oznDokumenta, sum(CASE WHEN (d1.tip = '%tipF%'  or d1.tip = '%tipFR%') THEN (ad1.kolicina*ad1.prodCena*(1-ad1.procRabata/100))%valuta% WHEN (d1.tip = '%tipFS%' or d1.tip = '%tipFI%') THEN (ad1.kolicina*ad1.prodCena)%valuta% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%'  or d2.tip = '%tipFR%') THEN (ad2.kolicina*ad2.prodCena*(1-ad2.procRabata/100))%valuta% WHEN (d2.tip = '%tipFS%' or d2.tip = '%tipFI%') THEN (ad2.kolicina*ad2.prodCena)%valuta% ELSE 0 END), sum((ad1.kolicina*ad1.nabCena)%valuta%), sum((ad2.kolicina*ad2.nabCena)%valuta%), k.sfrKomitent, k.naziv FROM Radnajedinica rj, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok LEFT JOIN Komitent k ON d1.sfrKomitent = k.sfrKomitent %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE d1.oznRj=rj.oznRj and %valutaW% d1.oznOgranak=rj.oznOgranak and d1.storno = 0 and d1.arhiviran = 1 and rj.oznRj IN (%listaRj%) and d1.tip IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%')";
                        } else if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs2.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_KUPCA)) {
                            upit = "SELECT k.sfrKomitent, k.naziv, d1.oznDokumenta, sum(CASE WHEN (d1.tip = '%tipF%' or d1.tip = '%tipFR%') THEN (ad1.kolicina*ad1.prodCena*(1-ad1.procRabata/100))%valuta% WHEN (d1.tip = '%tipFS%' or d1.tip = '%tipFI%') THEN (ad1.kolicina*ad1.prodCena)%valuta% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%' or d2.tip = '%tipFR%') THEN (ad2.kolicina*ad2.prodCena*(1-ad2.procRabata/100))%valuta% WHEN (d2.tip = '%tipFS%' or d2.tip = '%tipFI%') THEN (ad2.kolicina*ad2.prodCena)%valuta% ELSE 0 END), sum((ad1.kolicina*ad1.nabCena)%valuta%), sum((ad2.kolicina*ad2.nabCena)%valuta%) FROM Radnajedinica rj, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok LEFT JOIN Komitent k ON d1.sfrKomitent = k.sfrKomitent %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE %valutaW% d1.oznRj=rj.oznRj and d1.oznOgranak=rj.oznOgranak and d1.storno = 0 and d1.arhiviran = 1 and rj.oznRj IN (%listaRj%) and d1.tip IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%')";
                        }
                        if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs1.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_RJ)) {
                            upit = String.valueOf(upit) + " and rj.oznRj=':oznRj' and rj.oznOgranak=':oznOgranak'";
                            upit = upit.replace(":oznRj", PzDialogRucPoRaznimOsnovama.this.rj.getId().getOznRj());
                            upit = upit.replace(":oznOgranak", PzDialogRucPoRaznimOsnovama.this.rj.getId().getOznOgranak());
                        }
                        if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs3.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.U_ZADATOM_PERIODU)) {
                            upit = String.valueOf(upit) + " and d1.datum>=':datumOd' and d1.datum<=':datumDo' ";
                            upit = upit.replace(":datumOd", PzDialogRucPoRaznimOsnovama.this.dfPocetni.getVal().toString());
                            upit = upit.replace(":datumDo", PzDialogRucPoRaznimOsnovama.this.dfKrajnji.getVal().toString());
                        }
                        if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs2.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_USER_A)) {
                            upit = String.valueOf(upit) + " GROUP BY d1.usernamepoc, d1.oznDokumenta, k.sfrKomitent, k.naziv ORDER BY d1.usernamepoc, d1.oznDokumenta, k.sfrKomitent";
                        } else if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs2.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_KUPCA)) {
                            upit = String.valueOf(upit) + " GROUP BY k.sfrKomitent, k.naziv, d1.oznDokumenta ORDER BY k.sfrKomitent, d1.oznDokumenta";
                        } else if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs2.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_FAKTURE)) {
                            upit = String.valueOf(upit) + " GROUP BY k.sfrKomitent, k.naziv, d1.oznDokumenta  ORDER BY d1.oznDokumenta";
                        } else if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs2.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_ARTIKLA)) {
                            upit = String.valueOf(upit) + " GROUP BY ad1.sfrProizvod, ad1.sfrSort, ad1.naziv, ad1.kolicina, ad1.prodCena, ad1.nabCena, ad1.procRabata, k.sfrKomitent, k.naziv, d1.usernamepoc, d1.oznDokumenta %valutaG% ORDER BY ad1.sfrSort, d1.oznDokumenta";
                        }
                        if (((String)PzDialogRucPoRaznimOsnovama.this.panelRBs2.getSelectedValue()).equals(PzDialogRucPoRaznimOsnovama.NA_NIVOU_ARTIKLA)) {
                            upit = upit.replace("%valutaG%", valuta.equals("") ? " " : ",kurs.srednji, kurs.jedinica");
                        }
                        upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                        upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = d1.datPrometa");
                        upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and ");
                        if (PzDialogRJ.getAvaliableRjString().equals("")) {
                            throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                        }
                        upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                        upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                        upit = upit.replace("%tipFI%", TipDokumentConfig.get().FISKALNI_IZVESTAJ);
                        upit = upit.replace("%tipFR%", TipDokumentConfig.get().FISKALNI_RACUN);
                        upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                    }
                    q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    PzDialogRucPoRaznimOsnovama.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzDialogRucPoRaznimOsnovama.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        if (PzDialogRucPoRaznimOsnovama.this.cursor.size() == 0) {
                            JOptionPane.showMessageDialog(PzDialogRucPoRaznimOsnovama.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                            PzWorkerDialog.hideStatus();
                            return;
                        }
                        try {
                            PzDialogRucPoRaznimOsnovama.this.showReports();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogRucPoRaznimOsnovama.this), (Throwable)e);
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                    }
                }
            };
            worker.execute();
        }
    }

    private void showReports() throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        Date today = PzDateUtility.getCurrentDate();
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String subtitle = "";
        String title = "";
        String fname = "";
        String valuta = "Vrednosti su izra\u017eene u valuti: " + (this.cbValute.getSelectedChoice().getValue().equals("") ? "Dinar" : this.cbValute.getSelectedChoice().getText());
        if (((String)this.panelRBs2.getSelectedValue()).equals(NA_NIVOU_FAKTURE)) {
            title = "ORENTACIONA RAZLIKA U CENI NA NIVOU FAKTURE";
            fname = "rs/pezar/analitike/resource/reports/compiled/RUC.nivo.fakture.detaljno.jasper";
        } else if (((String)this.panelRBs2.getSelectedValue()).equals(NA_NIVOU_USER_A)) {
            fname = ((String)this.panelRBs4.getSelectedValue()).equals(ZBIRNI_PREGLED) ? "rs/pezar/analitike/resource/reports/compiled/RUC.nivo.usera.zbirno.jasper" : "rs/pezar/analitike/resource/reports/compiled/RUC.nivo.usera.detaljno.jasper";
            title = "ORENTACIONA RAZLIKA U CENI NA NIVOU KORISNIKA-A I FAKTURE";
        } else if (((String)this.panelRBs2.getSelectedValue()).equals(NA_NIVOU_KUPCA)) {
            fname = ((String)this.panelRBs4.getSelectedValue()).equals(ZBIRNI_PREGLED) ? "rs/pezar/analitike/resource/reports/compiled/RUC.nivo.kupca.zbirno.jasper" : "rs/pezar/analitike/resource/reports/compiled/RUC.nivo.kupca.detaljno.jasper";
            title = "ORENTACIONA RAZLIKA U CENI NA NIVOU KUPCA I FAKTURE";
        } else if (((String)this.panelRBs2.getSelectedValue()).equals(NA_NIVOU_ARTIKLA)) {
            fname = ((String)this.panelRBs4.getSelectedValue()).equals(ZBIRNI_PREGLED) ? "rs/pezar/analitike/resource/reports/compiled/RUC.nivo.artikal.zbirno.jasper" : "rs/pezar/analitike/resource/reports/compiled/RUC.nivo.artikal.detaljno.jasper";
            title = "ORENTACIONA RAZLIKA U CENI NA NIVOU ARTIKLA I FAKTURE";
        }
        if (((String)this.panelRBs3.getSelectedValue()).equals(U_ZADATOM_PERIODU)) {
            subtitle = "u periodu od " + PzDateUtility.formatDate((Date)this.dfPocetni.getVal()) + " do " + PzDateUtility.formatDate((Date)this.dfKrajnji.getVal());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", title);
        params.put("subtitle", subtitle);
        params.put("datum", today);
        params.put("reklama", "");
        params.put("valuta", valuta);
        data.add(PzFirma.getFirma());
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource(fname), params, (String)title);
    }
}

