/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.porez.popdv.form;

import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import rs.pezar.swing.util.RegexFormatter;

public class Vrednost {
    private String id;
    private LongProperty iznos;
    private IntegerField polje;
    private List<Vrednost> vezaneVrednosti = new ArrayList<Vrednost>();

    public Vrednost(String id, BigDecimal iznos) {
        this.id = id;
        this.polje = new IntegerField(15);
        this.iznos = new LongProperty(this.polje);
        this.setIznos(iznos);
    }

    public Vrednost(String id, Vrednost bind) {
        this.id = id;
        this.polje = new IntegerField(15);
        this.iznos = new LongProperty(this.polje);
        this.addAndBind(bind);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BigDecimal getIznos() {
        return new BigDecimal(this.iznos.get());
    }

    public Long getIznosAsInt() {
        return this.iznos.get();
    }

    public void setIznos(BigDecimal iznos) {
        this.iznos.set(iznos.longValue());
        this.polje.setVal(new Long(iznos.intValue()));
    }

    public IntegerField getPolje() {
        return this.polje;
    }

    public void addAndBind(Vrednost v) {
        this.vezaneVrednosti.add(v);
        this.setIznos(this.getIznos().add(v.getIznos()));
        v.iznos.addPropertyChangeListener(this.getPropChangeListener());
        if (v.vezaneVrednosti.size() > 0) {
            for (Vrednost vezanaVrednost : v.vezaneVrednosti) {
                vezanaVrednost.iznos.addPropertyChangeListener(this.getPropChangeListener());
            }
        }
    }

    public void addListener(PropertyChangeListener listener) {
        this.iznos.addPropertyChangeListener(listener);
    }

    private PropertyChangeListener getPropChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                BigDecimal sum = BigDecimal.ZERO;
                for (Vrednost vrednost : Vrednost.this.vezaneVrednosti) {
                    sum = sum.add(vrednost.getIznos());
                }
                Vrednost.this.setIznos(sum);
            }
        };
    }

    public String toString() {
        return "ID: " + this.id + " , IZN: " + this.iznos.get();
    }

    public static class IntegerField
    extends JFormattedTextField {
        private static final long serialVersionUID = 1L;

        public IntegerField(int length) {
            RegexFormatter formatter = new RegexFormatter("-{0,1}\\d{0," + length + "}");
            DefaultFormatterFactory factory = new DefaultFormatterFactory((JFormattedTextField.AbstractFormatter)formatter, (JFormattedTextField.AbstractFormatter)formatter, (JFormattedTextField.AbstractFormatter)formatter);
            formatter.setAllowsInvalid(false);
            formatter.setCommitsOnValidEdit(true);
            this.setFormatterFactory(factory);
            this.setHorizontalAlignment(4);
            this.setFont(new Font("SansSerif", 1, 12));
        }

        public Long getVal() {
            return new Long(!this.getText().equals("") ? this.getText() : "0");
        }

        public void setVal(Long value) {
            if (value == null) {
                return;
            }
            this.setText(value.toString());
        }
    }

    private static class LongProperty {
        private Long value = new Long(0L);
        private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
        private IntegerField field;

        public LongProperty(final IntegerField fld) {
            this.field = fld;
            fld.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent arg0) {
                    LongProperty.this.set(new Long(!fld.getText().equals("") ? fld.getText() : "0"));
                }
            });
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.add(listener);
        }

        public Long get() {
            return this.value;
        }

        public void set(final Long newValue) {
            final Long oldValue = this.value;
            this.value = newValue;
            if (this.listeners.size() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (PropertyChangeListener listener : LongProperty.this.listeners) {
                            listener.propertyChange(new PropertyChangeEvent(LongProperty.this.field, "value", oldValue, newValue));
                        }
                    }
                });
            }
        }
    }
}

