/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.pocetnaStanja.pocetnoStanjeKonto;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Konto;
import rs.pezar.db.entity.KontoPK;
import rs.pezar.db.entity.Nzk;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadnajedinicaPK;
import rs.pezar.db.entity.Slobodnaanalitika;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.db.entity.StavkanzkPK;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipAnalitika;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogKontniPlan;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.sifarnici.gui.PzDialogStopePoreza;
import rs.pezar.sifarnici.gui.kontniPlan.PzDialogAnalitikaKonta;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class Dodavanje
extends PzDialogInsert {
    private PzPanel pnlGlavni;
    private PzPanel pnlFields;
    private PzTextField tfNazivKonta;
    private PzFieldIndikator indKonto;
    private PzDoubleField dfPotrazuje;
    private JLabel lblPotrazuje;
    private PzDoubleField dfDuguje;
    private JLabel lblDuguje;
    private PzTextField tfAnalitika;
    private PzTextField tfKonto;
    private JLabel lblKonto;
    private PzButton btnPotvrdi;
    private Konto konto;
    private Stavkanzk stavka;
    private BigDecimal duguje;
    private BigDecimal potrazuje;
    private Radnajedinica rj;

    public Dodavanje(PzDialog dialog) {
        super(dialog);
    }

    protected void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{60, 55, 41, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlGlavni.setPreferredSize(new Dimension(548, 266));
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{49, 25, 25, 25, 20};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{96, 120, 83, 120, 20};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.pnlFields.setOpaque(false);
            this.lblKonto = new JLabel();
            this.pnlFields.add((Component)this.lblKonto, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 40, 0, 0), 0, 0));
            this.lblKonto.setName("lblKonto");
            this.tfKonto = new PzTextField();
            this.pnlFields.add((Component)this.tfKonto, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfKonto.setFKField(Konto.class, PzDialogKontniPlan.class, true, null);
            this.tfKonto.setMaxLength(6);
            this.tfKonto.setCustomInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    try {
                        return Dodavanje.this.validateKonto();
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)Dodavanje.this), (Throwable)e);
                        return false;
                    }
                }
            });
            this.tfKonto.setEntityChecker(new PzEntityChecker(){

                public PzEntity getEntity() {
                    try {
                        return (PzEntity)((EntityManager)Dodavanje.this.getSession().getParameter("em")).find(Konto.class, (Object)new KontoPK(Dodavanje.this.tfKonto.getVal(), ""));
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)Dodavanje.this), (Throwable)e);
                        return null;
                    }
                }
            });
            this.tfAnalitika = new PzTextField();
            this.pnlFields.add((Component)this.tfAnalitika, (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 1, 0), 0, 0));
            this.tfAnalitika.setFocusable(false);
            this.tfNazivKonta = new PzTextField();
            this.pnlFields.add((Component)this.tfNazivKonta, (Object)new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfNazivKonta.setFocusable(false);
            this.lblDuguje = new JLabel();
            this.pnlFields.add((Component)this.lblDuguje, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 40, 0, 0), 0, 0));
            this.lblDuguje.setName("lblDuguje");
            this.dfDuguje = new PzDoubleField();
            this.pnlFields.add((Component)this.dfDuguje, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblPotrazuje = new JLabel();
            this.pnlFields.add((Component)this.lblPotrazuje, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 30, 0, 0), 0, 0));
            this.lblPotrazuje.setName("lblPotrazuje");
            this.dfPotrazuje = new PzDoubleField();
            this.pnlFields.add((Component)this.dfPotrazuje, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.indKonto = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indKonto, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.btnPotvrdi = new PzButton();
            this.pnlFields.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 4, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(120, 35));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.tfKonto.setStateIndikator(this.indKonto);
            this.pack();
            this.setSize(565, 290);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        EntityManager em = (EntityManager)this.getSession().getParameter("em");
        Nzk nalog = (Nzk)this.getSession().getParameter("nalog");
        PzTable tablela = (PzTable)this.getSession().getParameter("tabela");
        try {
            em.getTransaction().begin();
            if (!((Boolean)this.getSession().getParameter("update")).booleanValue()) {
                Konto k = (Konto)em.find(Konto.class, (Object)new KontoPK(this.tfKonto.getText(), this.tfAnalitika.getVal()));
                if (k == null) {
                    k = new Konto(this.tfKonto.getText(), this.tfAnalitika.getVal(), "", this.konto.getNaziv());
                    em.persist((Object)k);
                }
                if (this.postojiStavka(k, nalog, em)) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Oznaka konta se ve\u0107 nalaz u po\u010detnom stanju");
                    this.tfKonto.requestFocus();
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().commit();
                    }
                    return;
                }
                System.out.println("Oznaka konta je:" + k.getId().getOznKonto());
                this.stavka = new Stavkanzk();
                this.stavka.setId(new StavkanzkPK(k.getId().getOznKonto(), k.getId().getAnalitika(), nalog.getIdNalog(), Integer.valueOf(this.getBrojac(em, nalog))));
                this.stavka.setKonto(k);
                this.stavka.setNazivKonta(this.konto.getNaziv());
                this.stavka.setNazivAnalitike(this.getNazivAnalitike(this.konto, em));
                this.stavka.setNzk(nalog);
                this.stavka.setOpis("Pocetno stanje");
                this.stavka.setDatKnjizenja(PzDateUtility.getFirstDayOfCurrentYear());
                if (this.rj != null) {
                    this.stavka.setRadnajedinica(this.rj);
                }
            }
            this.stavka.setDuguje(this.dfDuguje.getBigDecimal());
            this.stavka.setPotrazuje(this.dfPotrazuje.getBigDecimal());
            this.stavka.setSaldo(this.dfDuguje.getBigDecimal().subtract(this.dfPotrazuje.getBigDecimal()));
            if (!((Boolean)this.getSession().getParameter("update")).booleanValue()) {
                if (nalog.getStavkanzks() != null && nalog.getStavkanzks().size() > 0) {
                    for (Stavkanzk st : nalog.getStavkanzks()) {
                        if (!st.getKonto().getId().equals((Object)this.stavka.getKonto().getId())) continue;
                        throw new PzInfoException("Po\u010detno stanje za uneti konto ve\u0107 postoji. Ne mo\u017eete uneti 2 po\u010detna stanja za isti konto.");
                    }
                }
                tablela.insert((PzEntity)this.stavka, em);
                em.getTransaction().commit();
                tablela.commitInsert();
            } else {
                tablela.updateSelectedEntity((PzEntity)this.stavka, true);
                em.getTransaction().commit();
                tablela.commitUpdate();
            }
            this.dispose();
        }
        catch (Exception ex) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            tablela.rollBack();
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
        }
    }

    private boolean postojiStavka(Konto k, Nzk nalog, EntityManager em) {
        Vector data = (Vector)em.createQuery("Select s From Stavkanzk s where s.id.oznKonto='" + k.getId().getOznKonto() + "'" + " and s.id.idNalog=" + nalog.getIdNalog() + " and s.id.analitika=" + "'" + k.getId().getAnalitika() + "'").getResultList();
        return data.size() != 0;
    }

    private int getBrojac(EntityManager em, Nzk nalog) {
        Integer rBroj = (Integer)em.createQuery("Select Max(s.id.rBroj) From Stavkanzk s where s.id.idNalog=" + nalog.getIdNalog()).getSingleResult();
        if (rBroj == null) {
            rBroj = 0;
        }
        return rBroj;
    }

    private String getNazivAnalitike(Konto k, EntityManager em) {
        if (TipAnalitika.ANALITIKA_RJ.equals(k.getTipAnalitike())) {
            String oznRj = this.tfAnalitika.getVal().replaceAll("[^\\d.]", "");
            Radnajedinica rj = (Radnajedinica)em.find(Radnajedinica.class, (Object)new RadnajedinicaPK("1", String.valueOf(Integer.parseInt(oznRj))));
            return rj.getNaziv();
        }
        if (TipAnalitika.ANALITIKA_KOMINTENTI.equals(k.getTipAnalitike())) {
            String sifra = this.tfAnalitika.getVal().replaceAll("^0+", "");
            return ((Komitent)em.find(Komitent.class, (Object)sifra)).getNaziv();
        }
        if (TipAnalitika.ANALITIKA_SLOBODNA.equals(k.getTipAnalitike())) {
            return ((Slobodnaanalitika)em.find(Slobodnaanalitika.class, (Object)this.tfAnalitika.getVal())).getNaziv();
        }
        if (TipAnalitika.ANALITIKA_POREZ.equals(k.getTipAnalitike())) {
            Tarifnagrupa tg = (Tarifnagrupa)em.find(Tarifnagrupa.class, (Object)this.tfAnalitika.getVal());
            return String.valueOf(tg.getVrstatg().getOznVrstaTG()) + " " + tg.getStopa();
        }
        return null;
    }

    private boolean validateKonto() throws Exception {
        if (this.konto == null) {
            return false;
        }
        if (this.konto.getTipAnalitike() != null && !this.konto.getTipAnalitike().equals("")) {
            boolean ok = false;
            if (this.konto.getTipAnalitike().equals(TipAnalitika.ANALITIKA_RJ)) {
                this.rj = PzDialogRJ.getRJ((PzDialog)this);
                if (this.rj != null) {
                    ok = true;
                    this.tfAnalitika.setVal((Object)(String.valueOf(PzEntityUtil.strZero((String)this.rj.getId().getOznRj(), (int)3)) + this.rj.getgTip()));
                } else {
                    this.tfKonto.requestFocusInWindow();
                }
            } else if (this.konto.getTipAnalitike().equals(TipAnalitika.ANALITIKA_KOMINTENTI)) {
                Komitent komitent = (Komitent)this.launchSifarnik((PzDialog)new PzDialogKomintenti((PzDialog)this));
                if (komitent != null) {
                    ok = true;
                    this.tfAnalitika.setVal((Object)komitent.getSfrKomitent());
                } else {
                    this.tfKonto.requestFocusInWindow();
                }
            } else if (this.konto.getTipAnalitike().equals(TipAnalitika.ANALITIKA_POREZ)) {
                Tarifnagrupa tg = (Tarifnagrupa)this.launchSifarnik((PzDialog)new PzDialogStopePoreza((PzDialog)this));
                if (tg != null) {
                    ok = true;
                    this.tfAnalitika.setVal((Object)tg.getOznTarGr());
                } else {
                    this.tfKonto.requestFocusInWindow();
                }
            } else if (this.konto.getTipAnalitike().equals(TipAnalitika.ANALITIKA_SLOBODNA)) {
                Slobodnaanalitika analitika = (Slobodnaanalitika)this.launchSifarnik((PzDialog)new PzDialogAnalitikaKonta((PzDialog)this));
                if (analitika != null) {
                    ok = true;
                    this.tfAnalitika.setVal((Object)analitika.getOznAnalitika());
                } else {
                    this.tfKonto.requestFocusInWindow();
                }
            }
            if (ok) {
                this.tfKonto.setVal((Object)this.konto.getId().getOznKonto());
            }
        } else {
            this.tfKonto.setVal((Object)this.konto.getId().getOznKonto());
            this.tfAnalitika.setVal((Object)this.konto.getId().getAnalitika());
        }
        return true;
    }

    private PzEntity launchSifarnik(PzDialog dlg) {
        dlg.setLocationRelativeTo((Component)((Object)this));
        dlg.setModal(true);
        dlg.setCloseOnEnter(true);
        dlg.restoreSize();
        dlg.setVisible(true);
        PzEntity entity = PzTable.selectedEntity;
        PzTable.selectedEntity = null;
        return entity;
    }

    protected void onInsert() {
        this.setTitle("DODAVANJE");
        this.pnlFields.updateAllFieldsState();
    }

    protected void onUpdate() {
        this.setTitle("IZMENA");
        this.stavka = (Stavkanzk)((PzTable)this.getSession().getParameter("tabela")).getSelectedEntity();
        this.tfKonto.setVal((Object)this.stavka.getId().getOznKonto());
        this.tfAnalitika.setVal((Object)this.stavka.getId().getAnalitika());
        this.tfNazivKonta.setVal((Object)this.stavka.getKonto().getNaziv());
        this.dfDuguje.setVal((Object)this.stavka.getDuguje());
        this.dfPotrazuje.setVal((Object)this.stavka.getPotrazuje());
        this.tfKonto.setFocusable(false);
        this.tfAnalitika.setFocusable(false);
        this.tfNazivKonta.setFocusable(false);
        this.pnlFields.updateAllFieldsState();
        this.duguje = this.stavka.getDuguje();
        this.potrazuje = this.stavka.getPotrazuje();
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity == null) {
            return;
        }
        this.konto = (Konto)entity;
        this.tfKonto.setVal((Object)this.konto.getId().getOznKonto());
        this.tfNazivKonta.setVal((Object)this.konto.getNaziv());
        if (!"".equals(this.konto.getId().getAnalitika())) {
            this.tfAnalitika.setVal((Object)this.konto.getId().getAnalitika());
        }
        this.tfNazivKonta.setVal((Object)this.konto.getNaziv());
        this.tfKonto.transferFocus();
    }

    protected void setHeaderOnInsert() {
    }

    protected void setHeaderOnUpdate() {
    }
}

