/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.komitenti;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.analitike.gui.Settings;
import rs.pezar.analitike.gui.komitenti.PzDialogKarticaKomitenata;
import rs.pezar.analitike.gui.komitenti.kartcaKomitenata.IzborKomitenta;
import rs.pezar.analitike.gui.komitenti.obracunKamate.DodajDokument;
import rs.pezar.analitike.gui.komitenti.obracunKamate.DodavanjeBezAnalitike;
import rs.pezar.analitike.gui.komitenti.obracunKamate.IzmenaDokumenta;
import rs.pezar.analitike.gui.komitenti.obracunKamate.ObracunKamate;
import rs.pezar.analitike.gui.komitenti.obracunKamate.ObracunKamateFakturaStavka;
import rs.pezar.analitike.gui.komitenti.obracunKamate.PzDialogKamatneStope;
import rs.pezar.analitike.gui.komitenti.obracunKamate.adapters.ObracunKamateAdapter;
import rs.pezar.analitike.tableModels.PzTableModelObracunKamate;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Brojac;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Kamatnastopa;
import rs.pezar.db.entity.Komitent;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.swing.PzCheckbox;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.util.PzDateUtility;

public class PzDialogObracunKamate
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private PzPanel pzPanel1;
    private JToolBar toolbar;
    private PzToolBarIcon icnUpitUNalog;
    private PzToolBarIcon icnStampaDatum;
    private PzToolBarIcon icnNadjiDokument;
    private JLabel jLabel5;
    private JLabel jLabel4;
    private PzCheckbox pzCheckbox1;
    private PzDateField pzDateField1;
    private PzPanel pzPanel3;
    private PzPanel pzPanel2;
    private JLabel lblDatumObracuna;
    private PzDateField dateDatumIzrade;
    private JLabel lblMesto;
    private JLabel lblKontakt;
    private JLabel lblSifra;
    private JLabel jLabel9;
    private JLabel lblNaziv;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private PzTable table;
    private PzPanel pnlKomitent;
    private PzToolBarIcon icnGarancije;
    private PzToolBarIcon icnUpitUPodatke;
    private PzToolBarIcon icnSlikaDokumenta;
    private Komitent komitent;
    private IzborKomitenta izborKomitenta;
    private String rtitle;
    private PzComponentGroup fieldGroup;
    private Vector<Kamatnastopa> kamatneStope;
    private List<PzDokument> data;

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource().equals(this.icnStampaDatum)) {
                this.onObradaPressed();
                return;
            }
            if (e.getSource().equals(this.icnSlikaDokumenta)) {
                this.onKamatnePressed();
                return;
            }
            if (e.getSource().equals(this.icnUpitUPodatke)) {
                this.onIzmenaPressed();
                return;
            }
            if (e.getSource().equals(this.icnUpitUNalog)) {
                this.onBezAnalitikePressed();
                return;
            }
            if (e.getSource().equals(this.icnGarancije)) {
                this.onBrisiPressed();
                return;
            }
            if (e.getSource().equals(this.icnNadjiDokument)) {
                this.onDodajPressed();
                return;
            }
            if (e.getSource().equals(this.pzCheckbox1)) {
                if (this.pzCheckbox1.isSelected()) {
                    this.pzDateField1.setEnabled(true);
                } else {
                    this.pzDateField1.setEnabled(false);
                }
                return;
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public PzDialogObracunKamate(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    public PzDialogObracunKamate(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Obra\u010dun kamate");
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setLocationByPlatform(true);
            this.pzPanel1 = new PzPanel();
            this.pzPanel1.setPaintGradient(true);
            new BorderLayout();
            this.getContentPane().add((Component)this.pzPanel1, "Center");
            this.pzPanel1.setLayout((LayoutManager)new BorderLayout(0, 0));
            this.toolbar = new JToolBar();
            this.pzPanel1.add((Component)this.toolbar, (Object)"North");
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setAlignmentY(0.5f);
            this.toolbar.setOpaque(false);
            this.icnSlikaDokumenta = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSlikaDokumenta);
            this.icnSlikaDokumenta.setText("Kamatne|Stope (F2)");
            this.icnSlikaDokumenta.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/percent_new.png")));
            this.icnSlikaDokumenta.setActionCommand("kamatne");
            this.icnSlikaDokumenta.setToolTipText("Pode\u0161avanje kamatnih stopa");
            this.icnSlikaDokumenta.setPreferredSize(new Dimension(91, 84));
            this.icnSlikaDokumenta.addActionListener((ActionListener)((Object)this));
            this.icnSlikaDokumenta.setShortcut("F2");
            this.icnNadjiDokument = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnNadjiDokument);
            this.icnNadjiDokument.setText("Dodaj(INS)");
            this.icnNadjiDokument.setActionCommand("dodaj");
            this.icnNadjiDokument.setPreferredSize(new Dimension(91, 84));
            this.icnNadjiDokument.setToolTipText("Uklju\u010duje novi dokument u prpra\u010dun kamate");
            this.icnNadjiDokument.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/row_add.png")));
            this.icnNadjiDokument.setSize(91, 84);
            this.icnNadjiDokument.addActionListener((ActionListener)((Object)this));
            this.icnNadjiDokument.setShortcut("INSERT");
            this.icnUpitUPodatke = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnUpitUPodatke);
            this.icnUpitUPodatke.setText("Izmena(F3)");
            this.icnUpitUPodatke.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/row_edit.png")));
            this.icnUpitUPodatke.setActionCommand("izmena");
            this.icnUpitUPodatke.setPreferredSize(new Dimension(91, 84));
            this.icnUpitUPodatke.setToolTipText("Izmena stavki sa fakture");
            this.icnUpitUPodatke.setSize(91, 84);
            this.icnUpitUPodatke.addActionListener((ActionListener)((Object)this));
            this.icnUpitUPodatke.setShortcut("F3");
            this.icnUpitUNalog = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnUpitUNalog);
            this.icnUpitUNalog.setText("Dodavanje|bez analitike(F5)");
            this.icnUpitUNalog.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/table_add.png")));
            this.icnUpitUNalog.setActionCommand("bezanalitike");
            this.icnUpitUNalog.setPreferredSize(new Dimension(99, 84));
            this.icnUpitUNalog.setToolTipText("dodaje dokument za prera\u010dun kamate. Ovaj dokument se ne\u0107e odraziti nina\u0161ta drugo");
            this.icnUpitUNalog.setSize(91, 84);
            this.icnUpitUNalog.addActionListener((ActionListener)((Object)this));
            this.icnUpitUNalog.setShortcut("F5");
            this.icnGarancije = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnGarancije);
            this.icnGarancije.setText("Bri\u0161i (DEL)");
            this.icnGarancije.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/row_delete.png")));
            this.icnGarancije.setActionCommand("brisi");
            this.icnGarancije.setPreferredSize(new Dimension(91, 84));
            this.icnGarancije.setToolTipText("Isklju\u010duje dokument iz prora\u010duna kamate");
            this.icnGarancije.setSize(91, 84);
            this.icnGarancije.addActionListener((ActionListener)((Object)this));
            this.icnGarancije.setShortcut("DELETE");
            this.icnStampaDatum = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnStampaDatum);
            this.icnStampaDatum.setText("Obrada(CTRL+W)");
            this.icnStampaDatum.setActionCommand("obrada");
            this.icnStampaDatum.setPreferredSize(new Dimension(106, 84));
            this.icnStampaDatum.setToolTipText("Arhiva i \u0161tampanje dokumenta.");
            this.icnStampaDatum.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.icnStampaDatum.addActionListener((ActionListener)((Object)this));
            this.icnStampaDatum.setShortcut("CTRL+W");
            this.fieldGroup = new PzComponentGroup();
            this.pzPanel3 = new PzPanel();
            GridBagLayout pzPanel3Layout = new GridBagLayout();
            this.pzPanel1.add((Component)this.pzPanel3, (Object)"Center");
            pzPanel3Layout.rowWeights = new double[]{0.0, 0.1};
            pzPanel3Layout.rowHeights = new int[]{99, 362};
            pzPanel3Layout.columnWeights = new double[]{0.1};
            pzPanel3Layout.columnWidths = new int[]{7};
            this.pzPanel3.setLayout((LayoutManager)pzPanel3Layout);
            this.pzPanel2 = new PzPanel();
            this.pzPanel2.setMinimumSize(new Dimension(368, 10));
            this.pzPanel3.add((Component)this.pzPanel2, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            GridBagLayout pzPanel2Layout = new GridBagLayout();
            pzPanel2Layout.rowWeights = new double[]{0.0, 0.0, 0.0};
            pzPanel2Layout.rowHeights = new int[]{39, 30, 39};
            pzPanel2Layout.columnWeights = new double[]{0.1, 0.1, 0.0, 0.0, 0.0, 0.1};
            pzPanel2Layout.columnWidths = new int[]{7, 7, 277, 50, 186, 20};
            this.pzPanel2.setLayout((LayoutManager)pzPanel2Layout);
            this.pzPanel2.add((Component)this.getLblDatumObracuna(), (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.pzPanel2.add((Component)this.getDateDatumIzrade(), (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.pnlKomitent = new PzPanel();
            this.pnlKomitent.setMinimumSize(new Dimension(10, 10));
            this.pzPanel2.add((Component)this.pnlKomitent, (Object)new GridBagConstraints(0, 0, 3, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            GridBagLayout pnlKomitentLayout = new GridBagLayout();
            this.pnlKomitent.setLayout((LayoutManager)pnlKomitentLayout);
            this.pnlKomitent.setBounds(12, 109, 314, 83);
            this.pnlKomitent.setBorder((Border)BorderFactory.createTitledBorder("Komitent"));
            this.pnlKomitent.setBackground(new Color(236, 233, 216));
            this.pnlKomitent.setOpaque(false);
            pnlKomitentLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            pnlKomitentLayout.rowHeights = new int[]{-4, -7, 14, 11, 4, 7};
            pnlKomitentLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1, 0.0};
            pnlKomitentLayout.columnWidths = new int[]{7, 49, 7, 7, 6};
            this.jLabel1 = new JLabel();
            this.pnlKomitent.add((Component)this.jLabel1, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setText("\u0160ifra");
            this.jLabel2 = new JLabel();
            this.pnlKomitent.add((Component)this.jLabel2, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel2.setText("Naziv");
            this.jLabel3 = new JLabel();
            this.pnlKomitent.add((Component)this.jLabel3, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel3.setText("Mesto");
            this.lblNaziv = new JLabel();
            this.pnlKomitent.add((Component)this.lblNaziv, (Object)new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblNaziv.setText("Naziv");
            this.lblNaziv.setHorizontalAlignment(4);
            this.lblNaziv.setFont(new Font("Tahoma", 1, 11));
            this.jLabel9 = new JLabel();
            this.pnlKomitent.add((Component)this.jLabel9, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel9.setText("Kontakt");
            this.lblSifra = new JLabel();
            this.pnlKomitent.add((Component)this.lblSifra, (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblSifra.setText("lblsifra");
            this.lblSifra.setDebugGraphicsOptions(4);
            this.lblSifra.setHorizontalAlignment(4);
            this.lblSifra.setFont(new Font("Tahoma", 1, 11));
            this.lblKontakt = new JLabel();
            this.pnlKomitent.add((Component)this.lblKontakt, (Object)new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblKontakt.setText("lblKontakt");
            this.lblKontakt.setHorizontalTextPosition(4);
            this.lblKontakt.setHorizontalAlignment(4);
            this.lblKontakt.setFont(new Font("Tahoma", 1, 11));
            this.lblMesto = new JLabel();
            this.pnlKomitent.add((Component)this.lblMesto, (Object)new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblMesto.setText("lblMesto");
            this.lblMesto.setHorizontalAlignment(4);
            this.lblMesto.setFont(new Font("Tahoma", 1, 11));
            this.pzDateField1 = new PzDateField();
            this.pzPanel2.add((Component)this.pzDateField1, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.pzDateField1.setName("pzDateField1");
            this.pzDateField1.setEnabled(false);
            this.pzDateField1.setSize(181, 14);
            this.pzCheckbox1 = new PzCheckbox();
            this.pzPanel2.add((Component)this.pzCheckbox1, (Object)new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pzCheckbox1.addActionListener((ActionListener)((Object)this));
            this.pzCheckbox1.setSelected(false);
            this.pzCheckbox1.setOpaque(false);
            this.jLabel4 = new JLabel();
            this.pzPanel2.add((Component)this.jLabel4, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel4.setName("jLabel4");
            this.jLabel5 = new JLabel();
            this.pzPanel2.add((Component)this.jLabel5, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel5.setName("jLabel5");
            this.jScrollPane1 = new JScrollPane();
            this.pzPanel3.add((Component)this.jScrollPane1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 7, 7, 7), 0, 0));
            this.jScrollPane1.setBounds(12, 204, 826, 429);
            this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.table = new PzTable();
            this.jScrollPane1.setViewportView((Component)this.table);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
            this.pack();
            this.setSize(779, 634);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean shouldBeShown() {
        this.izborKomitenta = IzborKomitenta.GetNewInstance(this, false, false, IzborKomitenta.TIP_KUPAC);
        this.komitent = this.izborKomitenta.GetKomitentIstance();
        if (this.komitent != null) {
            this.fillInTheInfo();
            return true;
        }
        return false;
    }

    private void fillInTheInfo() {
        this.lblSifra.setText(String.valueOf(this.komitent.getSfrKomitent()) + "/" + new String("Kupac"));
        this.lblNaziv.setText(this.komitent.getNaziv());
        this.lblKontakt.setText(String.valueOf(this.komitent.getKontakt()) + "  " + this.komitent.getTelefoni());
        this.lblMesto.setText(this.komitent.getGrad());
        this.data = new Vector<PzDokument>();
        this.table = new PzTable();
        PzTableModelObracunKamate model = new PzTableModelObracunKamate((Vector)this.data);
        this.table.setModel((TableModel)((Object)model));
        this.jScrollPane1.setViewportView((Component)this.table);
    }

    private void showReport() {
        Vector<Object> data = new Vector<Object>();
        Vector<PzDokument> dok = new Vector<PzDokument>();
        int i = 0;
        while (i < this.table.getModel().getRowCount()) {
            dok.add((PzDokument)this.table.getEntity(i));
            ++i;
        }
        if (dok.size() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Nema podataka za obradu.");
            return;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        Date today = PzDateUtility.getCurrentDate();
        this.kamatneStope = PzDialogKamatneStope.getKamatneStope();
        Date datumObracuna = this.dateDatumIzrade.getVal();
        Integer metod = this.getMetod(this);
        if (metod == null) {
            return;
        }
        Date pocetniDatum = null;
        if (this.pzCheckbox1.isSelected()) {
            pocetniDatum = this.pzDateField1.getVal();
        }
        ObracunKamate obracunKamate = null;
        try {
            obracunKamate = new ObracunKamate(dok, this.kamatneStope, datumObracuna, pocetniDatum, metod);
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog((Component)((Object)this), e2.getMessage(), "Gre\u0161ka", 0);
            e2.printStackTrace();
            return;
        }
        obracunKamate.printInfo();
        EntityManager em = PzEntityManager.getEm();
        Integer broj = this.dodeliBroj(em);
        em.close();
        PzDataSourceExtended ds = new PzDataSourceExtended(data, obracunKamate.getListaStavki());
        ds.setAdapter((PzDataSourceAdapter)new ObracunKamateAdapter());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("title", this.rtitle);
        params.put("datum_obracuna", formatter.format(datumObracuna));
        params.put("datum", formatter.format(today));
        params.put("brojdokumenta", String.format("%d", broj));
        try {
            data.add(this.komitent);
            data.add(PzFirma.getFirma());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)"rs/pezar/reports/compiled/obracun.kamate.jasper", params, (String)("obracun_kamate_" + this.komitent.getSfrKomitent()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Integer getMetod(PzDialog parent) {
        PzChoice choice2;
        PzChoice choice1 = new PzChoice("Komformna metoda (do 25.12.2012.)", (Object)1);
        PzChoice[] choices = new PzChoice[]{choice1, choice2 = new PzChoice("Prost kamatni ra\u010dun (od 26.12.2012.)", (Object)2)};
        Integer choice = (Integer)PzDialogChoice.showPzDialogChoice((PzDialog)this, (PzChoice[])choices, (String)"Izaberi metod");
        if (choice == null) {
            return null;
        }
        Integer metod = choice == 1 ? ObracunKamateFakturaStavka.METHOD_KONFORMNI : ObracunKamateFakturaStavka.METHOD_PROST_RACUN;
        return metod;
    }

    private void onObradaPressed() {
        this.showReport();
    }

    private void onBrisiPressed() {
        this.table.removeSelectedEntity(true, false);
    }

    private void onBezAnalitikePressed() {
        Dokument a = DodavanjeBezAnalitike.getBezAnalitike(this);
        if (a != null) {
            this.table.insert((PzEntity)a, false);
        }
    }

    private void onIzmenaPressed() {
        PzDokument dok = (PzDokument)this.table.getSelectedEntity();
        if (dok != null) {
            IzmenaDokumenta a = new IzmenaDokumenta(this, true, null, (Object)dok);
            a.setModal(true);
            a.setVisible(true);
        }
        this.table.repaint();
    }

    private void onKamatnePressed() {
        PzDialogKamatneStope a = new PzDialogKamatneStope(this);
        a.setModal(true);
        a.setVisible(true);
    }

    private void onDodajPressed() {
        PzDokument a = DodajDokument.getDokument(this, this.komitent);
        this.dodajDokument(a);
    }

    private void dodajDokument(PzDokument dok) {
        if (dok != null) {
            for (PzDokument dokument : this.data) {
                if (dokument.getOznDokumenta().equals(dok.getOznDokumenta()) && dokument.getTip().equals(dok.getTip())) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Izabrani dokument je ve\u0107 uba\u010den u listu", "Info", 1);
                    return;
                }
                if (dokument.getOznDokumenta().equals(dok.getOznDokumenta()) && !dokument.getTip().equals("UPLATA_KUPCA") && !dokument.getTip().equals("UPLATA_DOBAVLJACU")) continue;
            }
            this.table.insert((PzEntity)dok, false);
            Vector<PzDokument> uplate = PzDialogObracunKamate.uplateZaDokument(dok);
            for (PzDokument upl : uplate) {
                this.table.insert((PzEntity)upl, false);
            }
        }
    }

    public static void showObracunKamateDialog(PzDialog parent, Komitent komitent) {
        PzDialogObracunKamate pzDialogObracunKamate = new PzDialogObracunKamate(parent);
        pzDialogObracunKamate.komitent = komitent;
        pzDialogObracunKamate.fillInTheInfo();
        pzDialogObracunKamate.setModal(true);
        pzDialogObracunKamate.setVisible(true);
    }

    public static void showObracunKamateDialog(PzDialog parent, Komitent komitent, Vector<String> listaId) {
        PzDialogObracunKamate pzDialogObracunKamate = new PzDialogObracunKamate(parent);
        pzDialogObracunKamate.komitent = komitent;
        pzDialogObracunKamate.fillInTheInfo();
        Query q = null;
        EntityManager em = PzEntityManager.getEm();
        String tempLista = PzDialogObracunKamate.createSelectionListInt(listaId);
        if (tempLista == null || tempLista.length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)pzDialogObracunKamate), "Nema uslova za obra\u010dun kamate!", "Nema uslova!", 1);
            return;
        }
        String query = "Select a from Dokument a where a.arhiviran = 1 and a.storno = 0 and a.idDok in (%s) ORDER BY a.datum";
        query = String.format(query, tempLista);
        q = em.createQuery(query);
        Vector result = (Vector)q.getResultList();
        em.close();
        int i = 0;
        while (i < result.size()) {
            pzDialogObracunKamate.dodajDokument((PzDokument)result.get(i));
            ++i;
        }
        pzDialogObracunKamate.setModal(true);
        pzDialogObracunKamate.setLocationRelativeTo((Component)parent);
        pzDialogObracunKamate.setVisible(true);
    }

    private static Vector<PzDokument> uplateZaDokument(PzDokument a) {
        Query q = null;
        new ScrollableCursor();
        EntityManager em = PzEntityManager.getEm();
        String query = "Select a from Dokument a where a.oznDokumenta=:ozn and a.komitent=:kom and a.arhiviran = 1 and a.storno = 0 and a.tip in (%s) ORDER BY a.datum";
        query = String.format(query, PzDialogObracunKamate.createSelectionList(Settings.obracunKamateUplateKupac));
        q = em.createQuery(query);
        q.setParameter("ozn", (Object)a.getOznDokumenta());
        q.setParameter("kom", (Object)a.getKomitent());
        Vector result = (Vector)q.getResultList();
        em.close();
        return result;
    }

    private String createSelectionList(String[] selectionList) {
        String list = new String();
        int i = 0;
        while (i < selectionList.length) {
            list = String.valueOf(list) + "'" + selectionList[i] + "', ";
            ++i;
        }
        list = list.substring(0, list.length() - 2);
        return list;
    }

    private static String createSelectionList(Vector<String> selectionList) {
        String list = new String();
        int i = 0;
        while (i < selectionList.size()) {
            list = String.valueOf(list) + "'" + selectionList.get(i) + "', ";
            ++i;
        }
        list = list.substring(0, list.length() - 2);
        return list;
    }

    private static String createSelectionListInt(Vector<String> selectionList) {
        String list = new String();
        if (selectionList.size() > 0) {
            int i = 0;
            while (i < selectionList.size()) {
                list = String.valueOf(list) + selectionList.get(i) + ", ";
                ++i;
            }
            list = list.substring(0, list.length() - 2);
        }
        return list;
    }

    private Integer dodeliBroj(EntityManager em) {
        em.getTransaction().begin();
        Brojac brojac = (Brojac)em.find(Brojac.class, (Object)"OBRACUN_KAMATE");
        if (brojac == null) {
            brojac = new Brojac();
            brojac.setTip("OBRACUN_KAMATE");
            brojac.setrBroj(0);
        }
        brojac.setrBroj(brojac.getrBroj() + 1);
        em.merge((Object)brojac);
        em.getTransaction().commit();
        return brojac.getrBroj();
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogKarticaKomitenata(Boolean.FALSE);
    }

    public PzDialogObracunKamate(Boolean initGUI) {
    }

    private PzDateField getDateDatumIzrade() {
        if (this.dateDatumIzrade == null) {
            this.dateDatumIzrade = new PzDateField();
            this.dateDatumIzrade.setName("dateDatumIzrade");
        }
        return this.dateDatumIzrade;
    }

    private JLabel getLblDatumObracuna() {
        if (this.lblDatumObracuna == null) {
            this.lblDatumObracuna = new JLabel();
            this.lblDatumObracuna.setName("lblDatumObracuna");
        }
        return this.lblDatumObracuna;
    }
}

