/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.knjiznoZaduzenjeRazduzenje;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Brojac;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaopstidokument;
import rs.pezar.db.entity.Id_gen;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Taksafod;
import rs.pezar.db.entity.Taksaopstidokument;
import rs.pezar.db.entity.ZaduzenjeOdobrenje;
import rs.pezar.db.entity.Zapisnik;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.util.PzDateUtility;

public class ZaduzenjeOdobrenjeEngine {
    public static String ZADUZENJE_ODOBRENJE_KUPCI = "KUPAC";
    public static String ZADUZENJE_ODOBRENJE_DOBAVLJACI = "DOBAVLJAC";
    public static String ZADUZENJE = "ZADUZENJE";
    public static String ODOBRENJE = "ODOBRENJE";

    public static void arhivirajZaduzenjeOdobrenje(PzDokument dokument, boolean azuriranjeStavki, String parameter, String komitent) throws Exception {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                em.getTransaction().begin();
                ZaduzenjeOdobrenjeEngine.arhivirajZaduzenjeOdobrenje(dokument, azuriranjeStavki, parameter, komitent, em);
                em.getTransaction().commit();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                throw e;
            }
        }
        finally {
            if (em.isOpen()) {
                em.close();
            }
        }
    }

    private static void arhivirajZaduzenjeOdobrenje(PzDokument dokumentK, boolean azuriranjeStavki, String parameter, String komitent, EntityManager em) throws Exception {
        if (dokumentK.getUserPoc() == null) {
            dokumentK.setUserPoc((Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername()));
        }
        dokumentK.setUserKraj((Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername()));
        dokumentK.setCvProdajna((short)1);
        Brojac rBroj = null;
        if (parameter.equalsIgnoreCase(ZADUZENJE)) {
            rBroj = (Brojac)em.find(Brojac.class, (Object)ZADUZENJE);
            if (rBroj == null) {
                rBroj = new Brojac();
                rBroj.setTip(ZADUZENJE);
                rBroj.setrBroj(0);
                em.persist((Object)rBroj);
            }
        } else {
            rBroj = (Brojac)em.find(Brojac.class, (Object)ODOBRENJE);
            if (rBroj == null) {
                rBroj = new Brojac();
                rBroj.setTip(ODOBRENJE);
                rBroj.setrBroj(0);
                em.persist((Object)rBroj);
            }
        }
        if (dokumentK.getIdDok() == 0) {
            Id_gen dokId = (Id_gen)em.find(Id_gen.class, (Object)"DOKUMENT_ID");
            if (dokId == null) {
                dokId = new Id_gen();
                dokId.setIdName("DOKUMENT_ID");
                dokId.setIdVal(1);
            }
            dokId.setIdVal(dokId.getIdVal() + 1);
            em.merge((Object)dokId);
            dokumentK.setIdDok(dokId.getIdVal());
        }
        rBroj.setrBroj(rBroj.getrBroj() + 1);
        dokumentK.setrBroj(rBroj.getrBroj());
        if (azuriranjeStavki) {
            dokumentK.adjust();
        }
        dokumentK.setArhiviran((short)1);
        dokumentK.setDatArh(PzDateUtility.getCurrentDate());
        if (azuriranjeStavki) {
            dokumentK.addTaksas();
        }
        if (!(dokumentK instanceof Dokument)) {
            dokumentK.updateDokument(azuriranjeStavki);
        }
        dokumentK.setRbrDok(0);
        if (!(dokumentK instanceof Dokument)) {
            dokumentK.getDokument().setRbrKepu(0);
        }
        if (dokumentK.getOznDokumenta() == null || dokumentK.getOznDokumenta().length() == 0) {
            dokumentK.formirajOznaku();
            dokumentK.getDokument().setOznDokumenta(dokumentK.getOznDokumenta());
            dokumentK.getDokument().setOpis(((Opstidokument)dokumentK).getPoruka());
        } else {
            dokumentK.getDokument().setOznDokumenta(dokumentK.getOznDokumenta());
            dokumentK.getDokument().setOpis(((Opstidokument)dokumentK).getPoruka());
        }
        em.merge((Object)dokumentK);
        if (komitent.equalsIgnoreCase(ZADUZENJE_ODOBRENJE_KUPCI)) {
            int i = 0;
            while (i < ((ZaduzenjeOdobrenje)dokumentK).getFakturaopstidokuments().size()) {
                Dokument d = new Dokument();
                if (d.getIdDok() == 0) {
                    Id_gen dokId = (Id_gen)em.find(Id_gen.class, (Object)"DOKUMENT_ID");
                    if (dokId == null) {
                        dokId = new Id_gen();
                        dokId.setIdName("DOKUMENT_ID");
                        dokId.setIdVal(1);
                    }
                    dokId.setIdVal(dokId.getIdVal() + 1);
                    em.merge((Object)dokId);
                    d.setIdDok(dokId.getIdVal());
                    if (parameter.equalsIgnoreCase(ZADUZENJE)) {
                        d.setTip(TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA_STAVKA);
                    } else {
                        d.setTip(TipDokumentConfig.get().KNJIZNO_ODOBRENJE_KUPCA_STAVKA);
                    }
                    d.setOznDokumenta(((Fakturaopstidokument)((ZaduzenjeOdobrenje)dokumentK).getFakturaopstidokuments().get(i)).getFaktura().getOznDokumenta());
                    d.setDatum(dokumentK.getDatum());
                    d.setDatArh(dokumentK.getDatArh());
                    d.setIznos(((Fakturaopstidokument)((ZaduzenjeOdobrenje)dokumentK).getFakturaopstidokuments().get(i)).getIznos());
                    d.setArhiviran((short)1);
                    d.setrBroj(dokumentK.getrBroj());
                    d.setKomitent(((Fakturaopstidokument)((ZaduzenjeOdobrenje)dokumentK).getFakturaopstidokuments().get(i)).getFaktura().getKomitent());
                    d.setRadnajedinica(((Fakturaopstidokument)((ZaduzenjeOdobrenje)dokumentK).getFakturaopstidokuments().get(i)).getFaktura().getRadnajedinica());
                    d.setUserKraj(dokumentK.getUserKraj());
                    d.setUserPoc(dokumentK.getUserPoc());
                    d.setCvProdajna((short)1);
                    d.setVrsta("N");
                    d.setOriginal(dokumentK.getDokument());
                    em.merge((Object)d);
                }
                ++i;
            }
        }
        if (komitent.equalsIgnoreCase(ZADUZENJE_ODOBRENJE_DOBAVLJACI)) {
            Kalkulacija kalk = (Kalkulacija)em.find(Kalkulacija.class, (Object)((Zapisnik)dokumentK).getKalkulacijaId());
            if (parameter.equalsIgnoreCase(ZADUZENJE)) {
                kalk.setStornoIznos(kalk.getStornoIznos().subtract(dokumentK.getIznos()));
            } else {
                kalk.setStornoIznos(kalk.getStornoIznos().add(dokumentK.getIznos()));
            }
        } else if (komitent.equalsIgnoreCase(ZADUZENJE_ODOBRENJE_KUPCI)) {
            int i = 0;
            while (i < ((ZaduzenjeOdobrenje)dokumentK).getFakturaopstidokuments().size()) {
                Faktura fakt = (Faktura)em.find(Faktura.class, (Object)((Fakturaopstidokument)((ZaduzenjeOdobrenje)dokumentK).getFakturaopstidokuments().get(i)).getFaktura().getIdDok());
                if (parameter.equalsIgnoreCase(ZADUZENJE)) {
                    fakt.setStornoIznos(fakt.getStornoIznos().subtract(((Fakturaopstidokument)((ZaduzenjeOdobrenje)dokumentK).getFakturaopstidokuments().get(i)).getIznos()));
                } else {
                    fakt.setStornoIznos(fakt.getStornoIznos().add(((Fakturaopstidokument)((ZaduzenjeOdobrenje)dokumentK).getFakturaopstidokuments().get(i)).getIznos()));
                }
                ++i;
            }
        }
    }

    public static void setOriginalStorno(PzDokument dok, String tipKomitent, String parameter, EntityManager em) {
        if (tipKomitent.equalsIgnoreCase(ZADUZENJE_ODOBRENJE_DOBAVLJACI)) {
            Kalkulacija kalk = (Kalkulacija)em.find(Kalkulacija.class, (Object)((ZaduzenjeOdobrenje)dok).getKalkulacijaId());
            if (parameter.equalsIgnoreCase(TipDokumentConfig.get().KNJIZNO_ZADUZENJE_DOBAVLJACA)) {
                kalk.setStornoIznos(kalk.getStornoIznos().subtract(dok.getIznos()));
            } else {
                kalk.setStornoIznos(kalk.getStornoIznos().add(dok.getIznos()));
            }
        } else if (tipKomitent.equalsIgnoreCase(ZADUZENJE_ODOBRENJE_KUPCI)) {
            int i = 0;
            while (i < ((ZaduzenjeOdobrenje)dok).getFakturaopstidokuments().size()) {
                Faktura fakt = (Faktura)em.find(Faktura.class, (Object)((Fakturaopstidokument)((ZaduzenjeOdobrenje)dok).getFakturaopstidokuments().get(i)).getFaktura().getIdDok());
                if (parameter.equalsIgnoreCase(TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA)) {
                    fakt.setStornoIznos(fakt.getStornoIznos().subtract(((Fakturaopstidokument)((ZaduzenjeOdobrenje)dok).getFakturaopstidokuments().get(i)).getIznos()));
                } else {
                    fakt.setStornoIznos(fakt.getStornoIznos().add(((Fakturaopstidokument)((ZaduzenjeOdobrenje)dok).getFakturaopstidokuments().get(i)).getIznos()));
                }
                ++i;
            }
        }
    }

    public static PzDokument getStavkaZaduzenja(Fakturaopstidokument fod, EntityManager em, String parameter) {
        ZaduzenjeOdobrenje d = null;
        d = new ZaduzenjeOdobrenje();
        if (d.getIdDok() == 0) {
            Id_gen dokId = (Id_gen)em.find(Id_gen.class, (Object)"DOKUMENT_ID");
            if (dokId == null) {
                dokId = new Id_gen();
                dokId.setIdName("DOKUMENT_ID");
                dokId.setIdVal(1);
                em.persist((Object)dokId);
            } else {
                dokId.setIdVal(dokId.getIdVal() + 1);
            }
            d.setIdDok(dokId.getIdVal());
        }
        if (parameter.equalsIgnoreCase(ZADUZENJE)) {
            d.setTip(TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA_STAVKA);
        } else {
            d.setTip(TipDokumentConfig.get().KNJIZNO_ODOBRENJE_KUPCA_STAVKA);
        }
        d.setrBrDokumenta(fod.getZaduzenjeodobrenje().getrBrDokumenta());
        d.setrBroj(fod.getZaduzenjeodobrenje().getrBrDokumenta());
        d.setOznDokumenta(fod.getFaktura().getOznDokumenta());
        d.setDatum(fod.getZaduzenjeodobrenje().getDatum());
        d.setDatArh(fod.getZaduzenjeodobrenje().getDatArh());
        d.setIznos(fod.getIznos());
        d.setKomitent(fod.getFaktura().getKomitent());
        d.setRadnajedinica(fod.getFaktura().getRadnajedinica());
        d.setVrsta("N");
        if (fod.getPorez().equalsIgnoreCase("SA_PDV")) {
            d.setPdv(fod.getPorez());
        } else {
            d.setPdv(fod.getSapravom());
        }
        if (d.getTaksaopstidokuments() == null) {
            d.setTaksaopstidokuments((List)new IndirectList());
        }
        int i = 0;
        while (i < fod.getTaksafods().size()) {
            Taksaopstidokument tod = new Taksaopstidokument(d.getIdDok(), ((Taksafod)fod.getTaksafods().get(i)).getTarifnagrupa().getOznTarGr(), "N");
            tod.setVrsta("PDV");
            tod.setTip("N");
            tod.setTarifnagrupa(((Taksafod)fod.getTaksafods().get(i)).getTarifnagrupa());
            tod.setIznos(((Taksafod)fod.getTaksafods().get(i)).getIznos());
            tod.setOsnovica(((Taksafod)fod.getTaksafods().get(i)).getOsnovica());
            d.getTaksaopstidokuments().add(tod);
            ++i;
        }
        return d;
    }

    public static Brojac rBrojDokumenta(String parameter, EntityManager em) {
        Brojac rBroj = null;
        if (parameter.equalsIgnoreCase(ZADUZENJE)) {
            rBroj = (Brojac)em.find(Brojac.class, (Object)ZADUZENJE);
            if (rBroj == null) {
                rBroj = new Brojac();
                rBroj.setTip(ZADUZENJE);
                rBroj.setrBroj(0);
                em.persist((Object)rBroj);
            }
        } else {
            rBroj = (Brojac)em.find(Brojac.class, (Object)ODOBRENJE);
            if (rBroj == null) {
                rBroj = new Brojac();
                rBroj.setTip(ODOBRENJE);
                rBroj.setrBroj(0);
                em.persist((Object)rBroj);
            }
        }
        return rBroj;
    }

    public static Brojac getRBroj(String parameter, EntityManager em1) {
        Brojac rb = ZaduzenjeOdobrenjeEngine.rBrojDokumenta(parameter, em1);
        rb.setrBroj(rb.getrBroj() + 1);
        em1.persist((Object)rb);
        return rb;
    }

    public static Kalkulacija findKalkulacija(int kalkulacijaId) {
        Kalkulacija k = null;
        ArrayList<String> podTipovi = new ArrayList<String>();
        podTipovi.add(TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA);
        podTipovi.add(TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA);
        String query = "SELECT k FROM Kalkulacija k WHERE k.arhiviran = 1 AND k.storno = 0 AND (k.podTip NOT IN :podTipovi OR k.podTip IS NULL) AND k.idDok=:kalkIdDok";
        EntityManager em1 = PzEntityManager.getEm();
        Query q = em1.createQuery(query).setParameter("podTipovi", podTipovi).setParameter("kalkIdDok", (Object)kalkulacijaId);
        if (q.getSingleResult() != null) {
            k = (Kalkulacija)q.getSingleResult();
        }
        em1.clear();
        em1.close();
        return k;
    }

    public static BigDecimal getIznosDokumenta(Kalkulacija entity) {
        EntityManager em = PzEntityManager.getEm();
        BigDecimal zaduzenje = new BigDecimal(0.0);
        BigDecimal odobrenje = new BigDecimal(0.0);
        String query = "SELECT SUM(z.iznosSaPorezom) FROM ZaduzenjeOdobrenje z WHERE z.tip = :tipDok AND z.arhiviran=1 AND z.kalkulacijaId=" + entity.getIdDok();
        Query q = em.createQuery(query).setParameter("tipDok", (Object)TipDokumentConfig.get().KNJIZNO_ZADUZENJE_DOBAVLJACA);
        if (q.getSingleResult() != null) {
            zaduzenje = (BigDecimal)q.getSingleResult();
        }
        if ((q = em.createQuery(query = "SELECT SUM(z.iznosSaPorezom) FROM ZaduzenjeOdobrenje z WHERE z.tip = :tipDok AND z.arhiviran=1 AND z.kalkulacijaId=" + entity.getIdDok()).setParameter("tipDok", (Object)TipDokumentConfig.get().KNJIZNO_ODOBRENJE_DOBAVLJACA)).getSingleResult() != null) {
            odobrenje = (BigDecimal)q.getSingleResult();
        }
        em.clear();
        em.close();
        return zaduzenje.subtract(odobrenje);
    }

    public static void setPorezi(ZaduzenjeOdobrenje dokument) {
        if (dokument.getFakturaopstidokuments() != null) {
            boolean dodat = false;
            if (dokument.getTaksaopstidokuments() == null) {
                dokument.setTaksaopstidokuments((List)new IndirectList());
            } else {
                dokument.getTaksadokuments().clear();
            }
            int i = 0;
            while (i < dokument.getFakturaopstidokuments().size()) {
                Fakturaopstidokument fo = (Fakturaopstidokument)dokument.getFakturaopstidokuments().get(i);
                if (fo.getTaksafods() != null) {
                    int j = 0;
                    while (j < fo.getTaksafods().size()) {
                        dodat = false;
                        if (dokument.getTaksaopstidokuments().size() == 0) {
                            Taksaopstidokument tod = new Taksaopstidokument(dokument.getIdDok(), ((Taksafod)fo.getTaksafods().get(j)).getTarifnagrupa().getOznTarGr(), PzTaksaDokument.TIP_ULAZ);
                            tod.setVrsta("PDV");
                            tod.setTarifnagrupa(((Taksafod)fo.getTaksafods().get(j)).getTarifnagrupa());
                            tod.setIznos(((Taksafod)fo.getTaksafods().get(j)).getIznos());
                            tod.setOsnovica(((Taksafod)fo.getTaksafods().get(j)).getOsnovica());
                        } else {
                            int k = 0;
                            while (k < dokument.getTaksaopstidokuments().size()) {
                                if (((Taksaopstidokument)dokument.getTaksaopstidokuments().get(k)).getTarifnagrupa().getOznTarGr().equals(((Taksafod)fo.getTaksafods().get(j)).getTarifnagrupa().getOznTarGr())) {
                                    ((Taksaopstidokument)dokument.getTaksaopstidokuments().get(k)).setIznos(((Taksaopstidokument)dokument.getTaksaopstidokuments().get(k)).getIznos().add(((Taksafod)fo.getTaksafods().get(j)).getIznos()));
                                    ((Taksaopstidokument)dokument.getTaksaopstidokuments().get(k)).setOsnovica(((Taksaopstidokument)dokument.getTaksaopstidokuments().get(k)).getOsnovica().add(((Taksafod)fo.getTaksafods().get(j)).getOsnovica()));
                                    dodat = true;
                                }
                                ++k;
                            }
                            if (!dodat) {
                                Taksaopstidokument tod = new Taksaopstidokument(dokument.getIdDok(), ((Taksafod)fo.getTaksafods().get(j)).getTarifnagrupa().getOznTarGr(), PzTaksaDokument.TIP_ULAZ);
                                tod.setVrsta("PDV");
                                tod.setTarifnagrupa(((Taksafod)fo.getTaksafods().get(j)).getTarifnagrupa());
                                tod.setIznos(((Taksafod)fo.getTaksafods().get(j)).getIznos());
                                tod.setOsnovica(((Taksafod)fo.getTaksafods().get(j)).getOsnovica());
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public static void setIdDokumenta(ZaduzenjeOdobrenje dokument) throws Exception {
        if (dokument.getIdDok() == 0) {
            EntityManager em1 = PzEntityManager.getEm();
            try {
                try {
                    em1.getTransaction().begin();
                    Id_gen dokId = (Id_gen)em1.find(Id_gen.class, (Object)"DOKUMENT_ID");
                    if (dokId == null) {
                        dokId = new Id_gen();
                        dokId.setIdName("DOKUMENT_ID");
                        dokId.setIdVal(1);
                    }
                    dokId.setIdVal(dokId.getIdVal() + 1);
                    em1.merge((Object)dokId);
                    dokument.setIdDok(dokId.getIdVal());
                    em1.getTransaction().commit();
                }
                catch (Exception e) {
                    if (em1.getTransaction().isActive()) {
                        em1.getTransaction().rollback();
                    }
                    throw e;
                }
            }
            finally {
                if (em1.isOpen()) {
                    em1.close();
                }
            }
        }
    }
}

