/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.uvecanje_umanjenje;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.analitike.PzExtensionLoader;
import rs.pezar.analitike.gui.artikli.uvecanje_umanjenje.PzDialogUmanjenje;
import rs.pezar.db.PZDBF;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzDialogDokumentiUmanjenje
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanjeKalkulacije;
    private PzToolBarIcon icnIzmenaKalk;
    private PzToolBarIcon icnDodKalk;
    private JScrollPane scrollPane;
    private PzTable table;
    private PzPanel mainPanel;
    private PzComponentGroup kIcnGroup;
    private Opstidokument umanjenjeBrisanje;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogDokumentiUmanjenje inst = new PzDialogDokumentiUmanjenje(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogDokumentiUmanjenje(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogDokumentiUmanjenje(JFrame frame, String parameter) {
        super(frame);
        this.initGUI();
        this.table = new PzTable((List)PZDBF.getDokumenti((Pzuser)PzExtensionLoader.getLoggedUser(), (String)parameter, (int)0, (int)0, (String)"UMANJENJE_LAGERA"), Opstidokument.class);
        this.table.setEnterAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PzDialogDokumentiUmanjenje.this.table.getSelectedRow() == -1) {
                    return;
                }
                PzDialogDokumentiUmanjenje.this.getSession().putParameter("update", (Object)true);
                PzDialogDokumentiUmanjenje.this.getSession().putParameter("tabela", (Object)PzDialogDokumentiUmanjenje.this.table);
                PzDialogDokumentiUmanjenje.this.showDialog(PzDialogUmanjenje.class);
            }
        });
        this.scrollPane.setViewportView((Component)this.table);
        this.refresh();
    }

    private void initGUI() {
        try {
            this.setTitle("Umanjenje zaliha u pripremi za korisnika " + PzExtensionLoader.getLoggedUser().getPzusername() + " (" + PzExtensionLoader.getLoggedUser().getIme() + " " + PzExtensionLoader.getLoggedUser().getPrezime() + ")");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{98, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.kIcnGroup = new PzComponentGroup();
            this.toolbar.setOpaque(false);
            this.icnDodKalk = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnDodKalk);
            this.toolbar.add((Component)this.icnDodKalk);
            this.icnDodKalk.setText("Novo umanjenje|lagera (ins)");
            this.icnDodKalk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_add.png")));
            this.icnDodKalk.addActionListener((ActionListener)((Object)this));
            this.icnDodKalk.setActionCommand("insert_umanjenje");
            this.icnDodKalk.setShortcut("insert");
            this.icnIzmenaKalk = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnIzmenaKalk);
            this.toolbar.add((Component)this.icnIzmenaKalk);
            this.icnIzmenaKalk.setText("Izmena umanjenja|lagera (f3)");
            this.icnIzmenaKalk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_edit.png")));
            this.icnIzmenaKalk.setActionCommand("update_umanjenje");
            this.icnIzmenaKalk.addActionListener((ActionListener)((Object)this));
            this.icnIzmenaKalk.setShortcut("f3");
            this.icnBrisanjeKalkulacije = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnBrisanjeKalkulacije);
            this.toolbar.add((Component)this.icnBrisanjeKalkulacije);
            this.icnBrisanjeKalkulacije.setText("Brisanje umanjenja |lagera (del)");
            this.icnBrisanjeKalkulacije.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_delete.png")));
            this.icnBrisanjeKalkulacije.addActionListener((ActionListener)((Object)this));
            this.icnBrisanjeKalkulacije.setActionCommand("delete_umanjenje");
            this.icnBrisanjeKalkulacije.setShortcut("delete");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj dokumenata");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(985, 665);
            this.setMinimumSize(new Dimension(985, 665));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzToolBarIcon)e.getSource()).getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            if (actionCommand.equals("insert_umanjenje")) {
                this.getSession().putParameter("update", (Object)false);
                this.getSession().putParameter("tabela", (Object)this.table);
                this.showDialog(PzDialogUmanjenje.class);
            } else if (actionCommand.equals("update_umanjenje")) {
                if (this.table.getRowCount() != 0) {
                    this.getSession().putParameter("update", (Object)true);
                    this.getSession().putParameter("tabela", (Object)this.table);
                    this.showDialog(PzDialogUmanjenje.class);
                }
            } else if (actionCommand.equals("delete_umanjenje")) {
                boolean result;
                this.umanjenjeBrisanje = (Opstidokument)this.table.getSelectedEntity();
                if (this.umanjenjeBrisanje == null) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Niste odabrali dokument za brisanje.", "Obavestenje", 1);
                    return;
                }
                boolean bl = result = JOptionPane.showConfirmDialog((Component)((Object)this), "Da li ste sigurni?", "Brisanje", 0) == 0;
                if (!result) {
                    return;
                }
                em.getTransaction().begin();
                em.remove(em.find(Opstidokument.class, (Object)this.umanjenjeBrisanje.getIdDok()));
                em.getTransaction().commit();
                this.table.removeSelectedEntity(false, false);
                return;
            }
            try {
                this.table.refreshData();
                this.refresh();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        }
        finally {
            em.close();
        }
    }

    public void finish() {
        this.table.removeSelectedEntity(false, false);
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogDokumentiUmanjenje.this.brDok.setText(String.valueOf(PzDialogDokumentiUmanjenje.this.table.getRowCount()) + " ");
            }
        });
    }
}

