/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.transfer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.analitike.PzExtensionLoader;
import rs.pezar.analitike.gui.artikli.transfer.PzDialogTransfer;
import rs.pezar.db.PZDBF;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzDialogDokumenti
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanjeKalkulacije;
    private PzToolBarIcon icnIzmenaKalk;
    private PzToolBarIcon icnDodKalk;
    private JScrollPane scrollPane;
    private PzTable table;
    private PzPanel mainPanel;
    private PzComponentGroup kIcnGroup;
    private Opstidokument transferBrisanje;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogDokumenti inst = new PzDialogDokumenti(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogDokumenti(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogDokumenti(JFrame frame, String parameter) {
        super(frame);
        this.initGUI();
        this.table = new PzTable((List)PZDBF.getDokumenti((Pzuser)PzExtensionLoader.getLoggedUser(), (String)parameter, (int)0, (int)0, (String)"TRANSFER"), Opstidokument.class);
        this.table.setEnterAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PzDialogDokumenti.this.table.getSelectedRow() == -1) {
                    return;
                }
                PzDialogDokumenti.this.showDialog(PzDialogTransfer.class, true, PzDialogDokumenti.this.table, PzDialogDokumenti.this.table.getSelectedEntity());
            }
        });
        this.scrollPane.setViewportView((Component)this.table);
    }

    private void initGUI() {
        try {
            this.setTitle("Transfer koli\u010dina u pripremi za korisnika " + PzExtensionLoader.getLoggedUser().getPzusername() + " (" + PzExtensionLoader.getLoggedUser().getIme() + " " + PzExtensionLoader.getLoggedUser().getPrezime() + ")");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.kIcnGroup = new PzComponentGroup();
            this.toolbar.setOpaque(false);
            this.icnDodKalk = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnDodKalk);
            this.toolbar.add((Component)this.icnDodKalk);
            this.icnDodKalk.setText("Novi transfer|(ins)");
            this.icnDodKalk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_add.png")));
            this.icnDodKalk.addActionListener((ActionListener)((Object)this));
            this.icnDodKalk.setActionCommand("insert_transfer");
            this.icnDodKalk.setShortcut("insert");
            this.icnIzmenaKalk = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnIzmenaKalk);
            this.toolbar.add((Component)this.icnIzmenaKalk);
            this.icnIzmenaKalk.setText("Izmena transfera|(f3)");
            this.icnIzmenaKalk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_edit.png")));
            this.icnIzmenaKalk.setActionCommand("update_transfer");
            this.icnIzmenaKalk.addActionListener((ActionListener)((Object)this));
            this.icnIzmenaKalk.setShortcut("f3");
            this.icnBrisanjeKalkulacije = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnBrisanjeKalkulacije);
            this.toolbar.add((Component)this.icnBrisanjeKalkulacije);
            this.icnBrisanjeKalkulacije.setText("Brisanje transfera |(del)");
            this.icnBrisanjeKalkulacije.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_delete.png")));
            this.icnBrisanjeKalkulacije.addActionListener((ActionListener)((Object)this));
            this.icnBrisanjeKalkulacije.setActionCommand("delete_transfer");
            this.icnBrisanjeKalkulacije.setShortcut("delete");
            this.pack();
            this.setSize(900, 768);
            this.setMinimumSize(new Dimension(900, 600));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzToolBarIcon)e.getSource()).getActionCommand();
        boolean izmena = false;
        if (!actionCommand.equals("insert_transfer")) {
            if (actionCommand.equals("update_transfer")) {
                izmena = true;
            } else if (actionCommand.equals("delete_transfer")) {
                boolean result;
                EntityManager em = PzEntityManager.getEm();
                this.transferBrisanje = (Opstidokument)this.table.getSelectedEntity();
                if (this.transferBrisanje == null) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Niste odabrali transfer za brisanje.", "Obave\u0161tenje", 1);
                    return;
                }
                boolean bl = result = JOptionPane.showConfirmDialog((Component)((Object)this), "Da li ste sigurni?", "Brisanje", 0) == 0;
                if (!result) {
                    return;
                }
                try {
                    em.getTransaction().begin();
                    em.createQuery("DELETE FROM Aodtaksa t WHERE t.id.idDok=" + this.transferBrisanje.getIdDok()).executeUpdate();
                    em.createQuery("DELETE FROM Artikalopstidokument a WHERE a.id.idDok=" + this.transferBrisanje.getIdDok()).executeUpdate();
                    em.remove(em.find(Opstidokument.class, (Object)this.transferBrisanje.getIdDok()));
                    em.getTransaction().commit();
                    this.table.removeSelectedEntity(false, false);
                    return;
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                }
                finally {
                    em.close();
                }
            }
        }
        this.showDialog(PzDialogTransfer.class, izmena, this.table, null);
        this.table.refreshData();
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogDokumenti(Boolean.FALSE);
    }

    public PzDialogDokumenti(Boolean initGUI) {
    }

    public void finish() {
        this.table.removeSelectedEntity(false, false);
    }
}

