/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.otpis;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import javax.persistence.EntityManager;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import rs.pezar.analitike.gui.artikli.otpis.PzDialogOtpis;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Brojacrj;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzTextAreaPanel;

public class Arhiviranje
extends PzDialog {
    private PzPanel mainPanel;
    private PzPanel pnlNorth;
    private JLabel jLabel7;
    private PzButton btnOk;
    private JLabel jLabel1;
    private PzPanel pnlButtons;
    private PzPanel pnlSouth;
    private Opstidokument otpis;
    private Brojacrj brojac;
    private PzDateField datum;
    private PzTextAreaPanel razlog;
    private ButtonGroup buttonGroupNivelacija;
    private JRadioButton saNivelacijom;
    private JRadioButton bezNivelacije;
    private PzDialogOtpis parent;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                Arhiviranje inst = new Arhiviranje(frame);
                inst.setVisible(true);
            }
        });
    }

    public Arhiviranje(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public Arhiviranje(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.parent = (PzDialogOtpis)dialog;
        this.otpis = (Opstidokument)this.getSession().getParameter("otpis");
    }

    protected void initGUI() {
        try {
            this.setTitle("Arhiviranje otpisa");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout pnlMainLayout = new GridBagLayout();
            pnlMainLayout.columnWidths = new int[]{7};
            pnlMainLayout.rowHeights = new int[]{3, 76, 247, 3};
            pnlMainLayout.columnWeights = new double[]{0.1};
            pnlMainLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 2.0};
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setLayout((LayoutManager)pnlMainLayout);
            this.pnlNorth = new PzPanel();
            GridBagLayout pnlNorthLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlNorth, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlNorthLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            pnlNorthLayout.rowHeights = new int[]{38, 16, 24};
            pnlNorthLayout.columnWeights = new double[]{0.0, 0.0, 1.0, 0.1};
            pnlNorthLayout.columnWidths = new int[]{106, 125, 7, 20};
            this.pnlNorth.setLayout((LayoutManager)pnlNorthLayout);
            this.pnlNorth.setPreferredSize(new Dimension(583, 44));
            this.pnlNorth.setOpaque(false);
            this.jLabel7 = new JLabel();
            this.pnlNorth.add((Component)this.jLabel7, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel7.setText("Datum izrade:");
            this.datum = new PzDateField();
            this.pnlNorth.add((Component)this.datum, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
            this.buttonGroupNivelacija = new ButtonGroup();
            this.saNivelacijom = new JRadioButton("Sa nivelacijom na otpisanu koli\u010dinu");
            this.saNivelacijom.setActionCommand("saNivelacijom");
            this.saNivelacijom.setOpaque(false);
            this.saNivelacijom.setSelected(true);
            this.bezNivelacije = new JRadioButton("Bez nivelacije");
            this.bezNivelacije.setActionCommand("bezNivelacije");
            this.bezNivelacije.setOpaque(false);
            this.buttonGroupNivelacija.add(this.saNivelacijom);
            this.buttonGroupNivelacija.add(this.bezNivelacije);
            this.pnlNorth.add((Component)this.saNivelacijom, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
            this.pnlNorth.add((Component)this.bezNivelacije, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
            this.pnlSouth = new PzPanel();
            GridBagLayout pnlSouthLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlSouth, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlSouthLayout.rowWeights = new double[]{0.0, 0.1};
            pnlSouthLayout.rowHeights = new int[]{25, 7};
            pnlSouthLayout.columnWeights = new double[]{5.0};
            pnlSouthLayout.columnWidths = new int[1];
            this.pnlSouth.setLayout((LayoutManager)pnlSouthLayout);
            this.pnlSouth.setOpaque(false);
            this.jLabel1 = new JLabel();
            this.pnlSouth.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 18, 0, 0), 0, 0));
            this.jLabel1.setText("Razlog izrade");
            this.jLabel1.setPreferredSize(new Dimension(123, 14));
            this.razlog = new PzTextAreaPanel();
            this.pnlSouth.add((Component)this.razlog, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 6, 0, 6), 0, 0));
            this.pnlButtons = new PzPanel();
            GridBagLayout pnlButtonsLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlButtons, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlButtons.setLayout((LayoutManager)pnlButtonsLayout);
            this.pnlButtons.setOpaque(false);
            this.pnlButtons.setPreferredSize(new Dimension(583, 65));
            this.btnOk = new PzButton();
            this.pnlButtons.add((Component)this.btnOk, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOk.setText("OK");
            this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnOk.setSize(100, 40);
            this.btnOk.setPreferredSize(new Dimension(160, 40));
            this.btnOk.setActionCommand("arhiva");
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.btnOk.setShortcut("ctrl+w");
            pnlButtonsLayout.rowWeights = new double[]{0.1};
            pnlButtonsLayout.rowHeights = new int[]{7};
            pnlButtonsLayout.columnWeights = new double[]{0.0};
            pnlButtonsLayout.columnWidths = new int[]{325};
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("arhiva")) {
                this.arhiviraj();
            }
            this.dispose();
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void arhiviraj() {
        boolean saNivel = false;
        if (this.saNivelacijom.isSelected()) {
            saNivel = true;
        } else if (this.bezNivelacije.isSelected()) {
            saNivel = false;
        }
        Stanje stanje = null;
        EntityManager em = PzEntityManager.getEm();
        try {
            em.getTransaction().begin();
            this.otpis.setDatum(this.datum.getVal());
            this.otpis.setDatArh(new Date(new java.util.Date().getTime()));
            this.otpis.setPoruka(this.razlog.getVal());
            this.otpis.setIznosBezPoreza(new BigDecimal("0.00"));
            this.otpis.setIznosSaPorezom(new BigDecimal("0.00"));
            this.otpis.setPdvIznos(new BigDecimal("0.00"));
            boolean cenePrnc = this.otpis.getRadnajedinica().getNacinVodjenja().equals("PRNC");
            Nivelacija nivelacija = null;
            if (saNivel && (nivelacija = PzEntityUtil.createNivelacija((PzDokument)this.otpis, (boolean)false, (boolean)true, (EntityManager)em)) != null) {
                PzDokumentManager.getInstance().arhivirajDokument((PzDokument)nivelacija, true, null, em);
            }
            for (Artikalopstidokument aotpis : this.otpis.getArtikalopstidokuments()) {
                StanjePK stanjepk = new StanjePK(aotpis.getId().getSfrProizvod(), this.otpis.getRadnajedinica());
                stanje = (Stanje)em.find(Stanje.class, (Object)stanjepk);
                if (stanje == null) {
                    stanje = new Stanje();
                    stanje.setId(stanjepk);
                    stanje.setAlocKolicina(0.0);
                    stanje.setKolicina(-aotpis.getKolicina());
                    stanje.setDatZadIzlaza(this.datum.getVal());
                    stanje.setKumIzlaza(aotpis.getKolicina());
                    stanje.setProdCena(aotpis.getCenaSaPorezom());
                    em.persist((Object)stanje);
                    aotpis.setProdCena(new BigDecimal(aotpis.getCenaSaPorezom()));
                    em.merge((Object)aotpis);
                } else {
                    if ((!this.otpis.getRadnajedinica().getgTip().equals("E") || !this.otpis.getRadnajedinica().getpTip().equals("V") && !this.otpis.getRadnajedinica().getpTip().equals("W")) && stanje.getKolicina() - stanje.getAlocKolicina() < aotpis.getKolicina()) {
                        JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Nedovoljna koli\u010dina na artiklu" + aotpis.getSifra(), "Obavestenje", 1);
                        em.getTransaction().rollback();
                        return;
                    }
                    stanje.setKolicina(stanje.getKolicina() - aotpis.getKolicina());
                    stanje.setDatZadIzlaza(this.datum.getVal());
                    stanje.setKumIzlaza(stanje.getKumIzlaza() + aotpis.getKolicina());
                    if (cenePrnc) {
                        aotpis.setProdCena(new BigDecimal(stanje.getProdCena()));
                    }
                    em.merge((Object)stanje);
                    em.merge((Object)aotpis);
                }
                this.otpis.setIznosBezPoreza(this.otpis.getIznosBezPoreza().add(BDConverter.getIznos((double)(aotpis.getKolicina() * aotpis.getCenaBezPoreza()))));
                this.otpis.setIznosSaPorezom(this.otpis.getIznosSaPorezom().add(BDConverter.getIznos((double)(aotpis.getKolicina() * aotpis.getCenaSaPorezom()))));
                this.otpis.setPdvIznos(this.otpis.getIznosSaPorezom().subtract(this.otpis.getIznosBezPoreza()));
            }
            PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.otpis, true, null, em);
            em.getTransaction().commit();
            PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.otpis);
            if (saNivel && nivelacija != null) {
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)nivelacija);
            }
            this.parent.finish();
            this.dispose();
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new Arhiviranje(Boolean.FALSE);
    }

    public Arhiviranje(Boolean initGUI) {
    }
}

