/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.nivelacije;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.analitike.gui.artikli.nivelacije.ObracunMaloprodajneCene.IzmenaCene;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalnivelacija;
import rs.pezar.db.entity.ArtikalnivelacijaPK;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadnajedinicaPK;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzBeanDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzTableCheckboxListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogObracunMaloprodajneCene
extends PzDialog {
    private JToolBar toolbar;
    private PzPanel pnlGlavni;
    private PzToolBarIcon icnIzmenaCena;
    private PzToolBarIcon icnDeselektuj;
    private PzTextField tfNazivMaloprodaje;
    private PzTextField tfMaloprodaja;
    private JLabel lblMaloporodaja;
    private PzPanel pnlFields;
    private PzTextField tfNazivVelikoprodaje;
    private PzTextField tfVelikoprodaja;
    private JLabel lblVelikoprodaja;
    private PzTable tabelaArtikli;
    private PzRadioGroup<String> panelRBs;
    private JScrollPane scrollPaneTable;
    private PzToolBarIcon icnSelektuj;
    private PzToolBarIcon icnArhiva;
    private PzDialog thisDialog;
    private Radnajedinica rjV = null;
    private Radnajedinica rjM = null;
    private ScrollableCursor cursor = null;
    private List<Artikalnivelacija> lista;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public PzDialogObracunMaloprodajneCene(JFrame frame) {
        super(frame);
        this.thisDialog = this;
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Formiranje cena u maloprodaji preko cena u velikoprodaji");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{83, 88, 7, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{13, 25, 25, 9, 7};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{189, 138, 96, 7, 252, 7};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.pnlFields.setOpaque(false);
            this.panelRBs = new PzRadioGroup((Object[])new String[]{"Popuni sve cene", "Popuni cene koje ne postoje"});
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRBs, 1);
            this.panelRBs.setLayout((LayoutManager)panelRBsLayout);
            this.pnlFields.add(this.panelRBs, (Object)new GridBagConstraints(0, 0, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.panelRBs.setBorder((Border)BorderFactory.createTitledBorder("Izbor cena"));
            this.panelRBs.setSelectedValue((Object)"Popuni sve cene");
            this.panelRBs.setOpaque(false);
            this.lblVelikoprodaja = new JLabel();
            this.pnlFields.add((Component)this.lblVelikoprodaja, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 40, 0, 0), 0, 0));
            this.lblVelikoprodaja.setName("lblVelikoprodaja");
            this.tfVelikoprodaja = new PzTextField();
            this.pnlFields.add((Component)this.tfVelikoprodaja, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfVelikoprodaja.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogObracunMaloprodajneCene.this.tfVelikoprodaja.getVal().equals("")) {
                        PzDialogObracunMaloprodajneCene.this.rjV = PzDialogRJ.getRJ((PzDialog)PzDialogObracunMaloprodajneCene.this.thisDialog, (Character[])new Character[]{Character.valueOf('V')});
                    } else {
                        PzDialogObracunMaloprodajneCene.this.rjV = (Radnajedinica)PzEntityManager.getEm().find(Radnajedinica.class, (Object)new RadnajedinicaPK("1", PzDialogObracunMaloprodajneCene.this.tfVelikoprodaja.getVal()));
                        if (PzDialogObracunMaloprodajneCene.this.rjV == null) {
                            PzSwingUtility.showErrorMessage((Component)PzDialogObracunMaloprodajneCene.this.thisDialog, (String)"Oznaka radne jedinice NIJE nadjena");
                            return false;
                        }
                        if (!PzDialogObracunMaloprodajneCene.this.rjV.getgTip().equals("V")) {
                            PzSwingUtility.showErrorMessage((Component)PzDialogObracunMaloprodajneCene.this.thisDialog, (String)"Radna jedinica nije velikoprodaja!");
                            return false;
                        }
                    }
                    if (PzDialogObracunMaloprodajneCene.this.rjV != null) {
                        PzDialogObracunMaloprodajneCene.this.tfVelikoprodaja.setVal((Object)PzDialogObracunMaloprodajneCene.this.rjV.getId().getOznRj());
                        PzDialogObracunMaloprodajneCene.this.tfNazivVelikoprodaje.setVal((Object)PzDialogObracunMaloprodajneCene.this.rjV.getNaziv());
                    }
                    return true;
                }
            });
            this.tfNazivVelikoprodaje = new PzTextField();
            this.pnlFields.add((Component)this.tfNazivVelikoprodaje, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNazivVelikoprodaje.setFont(new Font("Tahoma", 1, 14));
            this.tfNazivVelikoprodaje.setForeground(new Color(255, 0, 0));
            this.tfNazivVelikoprodaje.setFocusable(false);
            this.tfNazivVelikoprodaje.setEditable(false);
            this.lblMaloporodaja = new JLabel();
            this.pnlFields.add((Component)this.lblMaloporodaja, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 40, 0, 0), 0, 0));
            this.lblMaloporodaja.setName("lblMaloporodaja");
            this.tfMaloprodaja = new PzTextField();
            this.pnlFields.add((Component)this.tfMaloprodaja, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfMaloprodaja.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogObracunMaloprodajneCene.this.tfMaloprodaja.getVal().equals("")) {
                        PzDialogObracunMaloprodajneCene.this.rjM = PzDialogRJ.getRJ((PzDialog)PzDialogObracunMaloprodajneCene.this.thisDialog, (Character[])new Character[]{Character.valueOf('E')});
                    } else {
                        PzDialogObracunMaloprodajneCene.this.rjM = (Radnajedinica)PzEntityManager.getEm().find(Radnajedinica.class, (Object)new RadnajedinicaPK("1", PzDialogObracunMaloprodajneCene.this.tfMaloprodaja.getVal()));
                        if (PzDialogObracunMaloprodajneCene.this.rjM == null) {
                            PzSwingUtility.showErrorMessage((Component)PzDialogObracunMaloprodajneCene.this.thisDialog, (String)"Oznaka radne jedinice NIJE nadjena");
                            return false;
                        }
                        if (!PzDialogObracunMaloprodajneCene.this.rjM.getgTip().equals(Character.valueOf('E'))) {
                            PzSwingUtility.showErrorMessage((Component)PzDialogObracunMaloprodajneCene.this.thisDialog, (String)"Radna jedinica nije maloprodaja!");
                            return false;
                        }
                    }
                    if (PzDialogObracunMaloprodajneCene.this.rjM != null) {
                        PzDialogObracunMaloprodajneCene.this.tfMaloprodaja.setVal((Object)PzDialogObracunMaloprodajneCene.this.rjM.getId().getOznRj());
                        PzDialogObracunMaloprodajneCene.this.tfNazivMaloprodaje.setVal((Object)PzDialogObracunMaloprodajneCene.this.rjM.getNaziv());
                        PzDialogObracunMaloprodajneCene.this.fillTable();
                    }
                    return true;
                }
            });
            this.tfNazivMaloprodaje = new PzTextField();
            this.pnlFields.add((Component)this.tfNazivMaloprodaje, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNazivMaloprodaje.setFont(new Font("Tahoma", 1, 12));
            this.tfNazivMaloprodaje.setForeground(new Color(255, 0, 0));
            this.tfNazivMaloprodaje.setFocusable(false);
            this.tfNazivMaloprodaje.setEditable(false);
            this.scrollPaneTable = new JScrollPane();
            this.pnlGlavni.add((Component)this.scrollPaneTable, (Object)new GridBagConstraints(0, 2, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.tabelaArtikli = new PzTable();
            this.scrollPaneTable.setViewportView((Component)this.tabelaArtikli);
            this.tabelaArtikli.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Artikalnivelacija dok = (Artikalnivelacija)entity;
                    return new Object[]{dok.getId().getSfrProizvod(), dok.getNaziv(), dok.getJm(), dok.getVrednost(), dok.getCenaStara(), dok.getCenaNova()};
                }

                public String[] getColumnNames() {
                    return new String[]{"\u0160ifra", "Naziv", "Tg", "Cena V", "Stara cena", "Nova cena"};
                }
            });
            this.tabelaArtikli.setCheckboxColumn(0);
            this.tabelaArtikli.getTableHeader().setFocusable(false);
            this.tabelaArtikli.addCheckboxListener(new PzTableCheckboxListener(){

                public void valueChanged(int rowIndex, PzEntity entity, boolean newValue) {
                    if (newValue && (Double)PzDialogObracunMaloprodajneCene.this.tabelaArtikli.getModel().getValueAt(rowIndex, 6) == 0.0) {
                        PzDialogObracunMaloprodajneCene.this.tabelaArtikli.setRowChecked(rowIndex, false);
                    }
                }
            });
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnIzmenaCena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmenaCena);
            this.icnIzmenaCena.setText("Izmena cena|(F3)");
            this.icnIzmenaCena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/product_edit.png")));
            this.icnIzmenaCena.setActionCommand("izmena");
            this.icnIzmenaCena.addActionListener((ActionListener)((Object)this));
            this.icnIzmenaCena.setShortcut("F3");
            this.icnDeselektuj = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDeselektuj);
            this.icnDeselektuj.setText("Deselektuj sve|(Alt+F2)");
            this.icnDeselektuj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/deselect_all.png")));
            this.icnDeselektuj.setActionCommand("deselect");
            this.icnDeselektuj.addActionListener((ActionListener)((Object)this));
            this.icnDeselektuj.setShortcut("Alt+F2");
            this.icnSelektuj = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSelektuj);
            this.icnSelektuj.setText("Selektuj trenutnu|(F2)");
            this.icnSelektuj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/select.png")));
            this.icnSelektuj.setActionCommand("select");
            this.icnSelektuj.addActionListener((ActionListener)((Object)this));
            this.icnSelektuj.setShortcut("F2");
            this.icnArhiva = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiva|(Ctrl+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.icnArhiva.setActionCommand("arhiva");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("Ctrl+w");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setLocationRelativeTo(null);
            this.pack();
            this.setSize(866, 606);
            this.setMinimumSize(new Dimension(866, 606));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        final EntityManager em = PzEntityManager.getEm();
        if (actionCommand.equals("select")) {
            if ((Double)this.tabelaArtikli.getModel().getValueAt(this.tabelaArtikli.getRealSelectedRowIndex(), 6) != 0.0) {
                this.tabelaArtikli.switchIt();
            }
        } else if (actionCommand.equals("deselect")) {
            this.tabelaArtikli.unCheckAll();
        } else if (actionCommand.equals("izmena")) {
            if (this.tabelaArtikli.getRowCount() != 0) {
                this.getSession().putParameter("tabela", (Object)this.tabelaArtikli);
                this.showDialog(IzmenaCene.class);
            }
        } else if (actionCommand.equals("arhiva")) {
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    PzDialogObracunMaloprodajneCene.this.lista = PzDialogObracunMaloprodajneCene.this.tabelaArtikli.getCheckedEntities();
                    for (Artikalnivelacija art : PzDialogObracunMaloprodajneCene.this.lista) {
                        Stanje stanje = (Stanje)em.find(Stanje.class, (Object)new StanjePK(art.getId().getSfrProizvod(), PzDialogObracunMaloprodajneCene.this.rjM));
                        if (stanje != null) {
                            stanje.setProdCena(art.getCenaNova());
                            em.merge((Object)stanje);
                            continue;
                        }
                        stanje = new Stanje();
                        stanje.setId(new StanjePK(art.getId().getSfrProizvod(), PzDialogObracunMaloprodajneCene.this.rjM));
                        stanje.setProdCena(art.getCenaNova());
                        stanje.setRadnajedinica(PzDialogObracunMaloprodajneCene.this.rjM);
                        stanje.setArtikal((Artikal)em.find(Artikal.class, (Object)art.getId().getSfrProizvod()));
                        em.persist((Object)stanje);
                    }
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        try {
                            this.get();
                            PzDialogObracunMaloprodajneCene.this.showReports();
                            PzDialogObracunMaloprodajneCene.this.dispose();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)PzDialogObracunMaloprodajneCene.this.thisDialog, (Throwable)e);
                            em.close();
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
            };
            worker.execute();
        }
    }

    public void unCheckOrCheck() {
        if ((Double)this.tabelaArtikli.getModel().getValueAt(this.tabelaArtikli.getRealSelectedRowIndex(), 6) != 0.0) {
            this.tabelaArtikli.setRowChecked(this.tabelaArtikli.getRealSelectedRowIndex(), true);
        } else {
            this.tabelaArtikli.setRowChecked(this.tabelaArtikli.getRealSelectedRowIndex(), false);
        }
    }

    private void fillTable() {
        this.tfMaloprodaja.setEditable(false);
        this.tfVelikoprodaja.setEditable(false);
        this.tfMaloprodaja.setFocusable(false);
        this.tfVelikoprodaja.setFocusable(false);
        IndirectList listaArt = new IndirectList();
        final EntityManager em = PzEntityManager.getEm();
        PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
        SwingWorker<List<Artikalnivelacija>, Object> worker = new SwingWorker<List<Artikalnivelacija>, Object>((List)listaArt){
            private final /* synthetic */ List val$listaArt;
            {
                this.val$listaArt = list;
            }

            @Override
            protected List<Artikalnivelacija> doInBackground() throws Exception {
                em.getTransaction().begin();
                if (PzDialogObracunMaloprodajneCene.this.cursor != null) {
                    PzDialogObracunMaloprodajneCene.this.cursor.close();
                }
                String upit = "";
                upit = "SELECT DISTINCT stanje.sfrProizvod, stanje.naziv, (Select tg.oznTarGr From TGartikal tg where tg.sfrProizvod=stanje.sfrProizvod), (Select s.prodCena From Stanje s, Radnajedinica rj Where s.sfrProizvod=stanje.sfrProizvod and s.oznRj=rj.oznRj and s.oznOgranak=rj.oznOgranak and rj.oznRj=':oznRjV' and rj.oznOgranak=':oznOgranakV'), stanje.prodCena, (Select s.prodCena+(s.prodCena*tg.stopa/100) From Stanje s, Radnajedinica rj, Tarifnagrupa tg, TGartikal tga where s.oznRj=rj.oznRj and s.oznOgranak=rj.oznOgranak and rj.oznRj=':oznRjV' and rj.oznOgranak=':oznOgranakV' and s.sfrProizvod=stanje.sfrProizvod and stanje.sfrProizvod=tga.sfrProizvod and tg.oznTarGr=tga.oznTarGr) From Stanjeartikal stanje, Radnajedinica rj where stanje.oznRj=rj.oznRj and stanje.oznOgranak=rj.oznOgranak and rj.oznOgranak=':oznOgranakM' and rj.oznRj=':oznRjM'";
                if (((String)PzDialogObracunMaloprodajneCene.this.panelRBs.getSelectedValue()).equals("Popuni cene koje ne postoje")) {
                    upit = String.valueOf(upit) + "  and stanje.prodCena IS NULL";
                }
                upit = String.valueOf(upit) + " ORDER BY stanje.sfrProizvod";
                upit = upit.replace(":oznRjM", PzDialogObracunMaloprodajneCene.this.rjM.getId().getOznRj());
                upit = upit.replace(":oznOgranakM", PzDialogObracunMaloprodajneCene.this.rjM.getId().getOznOgranak());
                upit = upit.replace(":oznRjV", PzDialogObracunMaloprodajneCene.this.rjV.getId().getOznRj());
                upit = upit.replace(":oznOgranakV", PzDialogObracunMaloprodajneCene.this.rjV.getId().getOznOgranak());
                Query q = em.createNativeQuery(upit);
                q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                PzDialogObracunMaloprodajneCene.this.cursor = (ScrollableCursor)q.getSingleResult();
                System.out.println("Cursor je nasao " + PzDialogObracunMaloprodajneCene.this.cursor.size());
                PzDialogObracunMaloprodajneCene.this.brDok.setText(String.valueOf(PzDialogObracunMaloprodajneCene.this.cursor.size()));
                if (PzDialogObracunMaloprodajneCene.this.cursor.size() == 0) {
                    PzSwingUtility.showErrorMessage((Component)PzDialogObracunMaloprodajneCene.this.thisDialog, (String)"Ne postoje artikli u datom intervalu lokacija!");
                } else {
                    Object[] stanje = null;
                    int idDok = 0;
                    int rBroj = 0;
                    while (PzDialogObracunMaloprodajneCene.this.cursor.hasNext()) {
                        stanje = (Object[])PzDialogObracunMaloprodajneCene.this.cursor.next();
                        Artikalnivelacija artNiv = new Artikalnivelacija();
                        artNiv.setId(new ArtikalnivelacijaPK(idDok, (String)stanje[0], rBroj));
                        artNiv.setNaziv((String)stanje[1]);
                        artNiv.setJm((String)stanje[2]);
                        artNiv.setVrednost((BigDecimal)stanje[3] == null ? new BigDecimal(0) : (BigDecimal)stanje[3]);
                        artNiv.setCenaStara((BigDecimal)stanje[4] == null ? 0.0 : ((BigDecimal)stanje[4]).doubleValue());
                        artNiv.setCenaNova((Double)stanje[5] == null ? 0.0 : (Double)stanje[5]);
                        this.val$listaArt.add(artNiv);
                        ++idDok;
                        ++rBroj;
                    }
                    em.getTransaction().commit();
                }
                return this.val$listaArt;
            }

            @Override
            protected void done() {
                try {
                    try {
                        if (this.get() != null) {
                            PzDialogObracunMaloprodajneCene.this.tabelaArtikli.setData((List)this.get(), Artikalnivelacija.class);
                            PzDialogObracunMaloprodajneCene.this.tabelaArtikli.requestFocusInWindow();
                            PzDialogObracunMaloprodajneCene.this.tabelaArtikli.setRowSelectionInterval(0, 0);
                            PzDialogObracunMaloprodajneCene.this.check();
                        }
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)PzDialogObracunMaloprodajneCene.this.thisDialog, (Throwable)e);
                        PzDialogObracunMaloprodajneCene.this.cursor.close();
                        em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    PzDialogObracunMaloprodajneCene.this.cursor.close();
                    em.close();
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }

    public void check() {
        if (this.tabelaArtikli.getCheckboxColumn() != -1) {
            int i = 0;
            while (i < this.tabelaArtikli.getModel().getRowCount()) {
                if ((Double)this.tabelaArtikli.getModel().getValueAt(i, 6) == 0.0) {
                    this.tabelaArtikli.setRowChecked(i, false);
                } else {
                    this.tabelaArtikli.setRowChecked(i, true);
                }
                ++i;
            }
        }
    }

    public void showReports() throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        data.add(PzFirma.getFirma());
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.lista);
        ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
        HashMap<String, Object> params = new HashMap<String, Object>();
        String title = "IZVE\u0160TAJ O PROMENI CENA U RJ: " + this.rjM.getId().getOznRj() + " " + this.rjM.getNaziv();
        params.put("title", title);
        params.put("reklama", "");
        params.put("datum", PzDateUtility.getCurrentDate());
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/reports/compiled/obracun.maloprodajne.cene.jasper"), params, (String)title);
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogObracunMaloprodajneCene(Boolean.FALSE);
    }

    public PzDialogObracunMaloprodajneCene(Boolean initGUI) {
    }
}

