/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.nivelacije;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.analitike.NivelacijaManager;
import rs.pezar.analitike.PzExtensionLoader;
import rs.pezar.analitike.gui.artikli.nivelacije.IzmCena.ArhiviranjeNivelacije;
import rs.pezar.analitike.gui.artikli.nivelacije.IzmCena.Dodaj;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Artikalnivelacija;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzScrollableTableEntity;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class IzmenaCena
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private JToolBar toolbar;
    private PzToolBarIcon icnStampa;
    private PzToolBarIcon icnDodaj;
    private PzDoubleField dblRazlika;
    private JLabel lblRazlika;
    private JScrollPane jScrollPane1;
    private PzScrollableTableEntity table;
    private PzPanel pnlContent;
    private PzToolBarIcon icnBrisiSve;
    private PzToolBarIcon icnBrisiRed;
    Nivelacija n;
    Radnajedinica rj;
    private ScrollableCursor cursor;
    private EntityManager em;
    private PzPanel pnlTable;
    private PzStatusBar statusBar;
    private JLabel lblBrojStavki;
    private PzNumericOnlyTextField numBrojStavki;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                IzmenaCena inst = new IzmenaCena(frame);
                inst.setVisible(true);
            }
        });
    }

    public IzmenaCena() {
        this.initGUI();
    }

    public IzmenaCena(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public IzmenaCena(PzDialog dialog, boolean izmena, Object data1, Object data2) {
        this.n = (Nivelacija)data1;
        this.rj = this.n.getRadnajedinica();
        this.initGUI();
    }

    public void setTable() {
        this.table = new PzScrollableTableEntity(Artikalnivelacija.class);
        this.dblRazlika = this.table.createExpresionField("$6$");
        this.dblRazlika.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        this.dblRazlika.setOpaque(false);
        this.dblRazlika.setEditable(false);
        this.dblRazlika.setFocusable(false);
        this.dblRazlika.setColumns(10);
        this.statusBar.add((Component)this.dblRazlika);
        this.em = PzEntityManager.getEm();
        Query q = this.em.createQuery("SELECT an FROM Artikalnivelacija an WHERE an.id.idDok = " + this.n.getIdDok());
        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
        q.setHint("eclipselink.read-only", (Object)"True");
        this.cursor = (ScrollableCursor)q.getSingleResult();
        this.jScrollPane1.setViewportView((Component)this.table);
        this.table.read(this.cursor);
        this.numBrojStavki.setVal((Object)this.table.getRowCount());
        this.table.calculateFields();
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                IzmenaCena.this.numBrojStavki.setVal((Object)IzmenaCena.this.table.getRowCount());
            }
        });
    }

    public static Object getGUIBuilderInstance() {
        return new IzmenaCena(Boolean.FALSE);
    }

    public IzmenaCena(Boolean initGUI) {
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlContent = new PzPanel();
            this.pnlContent.setLayout((LayoutManager)new BorderLayout());
            this.pnlContent.setPaintGradient(true);
            this.getContentPane().add((Component)this.pnlContent, "Center");
            this.setFocusableWindowState(true);
            this.setPreferredSize(new Dimension(831, 593));
            this.toolbar = new JToolBar();
            this.pnlContent.add((Component)this.toolbar, (Object)"North");
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setHgap(10);
            toolbarLayout.setVgap(0);
            toolbarLayout.setAlignment(0);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnDodaj = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodaj);
            this.icnDodaj.setText("Dodaj | (INS)");
            this.icnDodaj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/row_add.png")));
            this.icnDodaj.setActionCommand("unos");
            this.icnDodaj.addActionListener((ActionListener)((Object)this));
            this.icnDodaj.setShortcut("INSERT");
            this.icnBrisiRed = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisiRed);
            this.icnBrisiRed.setText("Bri\u0161i red|(DEL)");
            this.icnBrisiRed.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/row_delete.png")));
            this.icnBrisiRed.setActionCommand("brisiRed");
            this.icnBrisiRed.addActionListener((ActionListener)((Object)this));
            this.icnBrisiRed.setShortcut("DELETE");
            this.icnBrisiSve = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisiSve);
            this.icnBrisiSve.setText("Bri\u0161i sve | (CTRL+Q)");
            this.icnBrisiSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/delete.png")));
            this.icnBrisiSve.setActionCommand("brisiSve");
            this.icnBrisiSve.addActionListener((ActionListener)((Object)this));
            this.icnBrisiSve.setShortcut("CTRL+Q");
            this.icnBrisiSve.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnBrisiSve.setPreferredSize(new Dimension(53, 86));
            this.icnStampa = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnStampa);
            this.icnStampa.setText("Arhiva i \u0160tampa|(CTRL+W)");
            this.icnStampa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.icnStampa.setActionCommand("arhiviraj");
            this.icnStampa.addActionListener((ActionListener)((Object)this));
            this.icnStampa.setShortcut("CTRL+W");
            this.pnlTable = new PzPanel();
            this.pnlContent.add((Component)this.pnlTable, (Object)"Center");
            GridBagLayout gbl_pnlTable = new GridBagLayout();
            int[] nArray = new int[2];
            nArray[0] = 133;
            gbl_pnlTable.columnWidths = nArray;
            int[] nArray2 = new int[2];
            nArray2[0] = 73;
            gbl_pnlTable.rowHeights = nArray2;
            gbl_pnlTable.columnWeights = new double[]{1.0, Double.MIN_VALUE};
            gbl_pnlTable.rowWeights = new double[]{1.0, Double.MIN_VALUE};
            this.pnlTable.setLayout((LayoutManager)gbl_pnlTable);
            this.pnlTable.setOpaque(false);
            this.jScrollPane1 = new JScrollPane();
            GridBagConstraints gbc_jScrollPane1 = new GridBagConstraints();
            gbc_jScrollPane1.insets = new Insets(10, 10, 10, 10);
            gbc_jScrollPane1.fill = 1;
            gbc_jScrollPane1.gridx = 0;
            gbc_jScrollPane1.gridy = 0;
            this.pnlTable.add((Component)this.jScrollPane1, (Object)gbc_jScrollPane1);
            this.statusBar = new PzStatusBar();
            this.pnlContent.add((Component)this.statusBar, (Object)"South");
            this.lblBrojStavki = new JLabel("Broj stavki:");
            this.statusBar.add((Component)this.lblBrojStavki);
            this.numBrojStavki = new PzNumericOnlyTextField();
            this.numBrojStavki.setColumns(5);
            this.numBrojStavki.setOpaque(false);
            this.numBrojStavki.setFocusable(false);
            this.numBrojStavki.setEditable(false);
            this.numBrojStavki.setVal((Object)0);
            this.numBrojStavki.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
            this.statusBar.add((Component)this.numBrojStavki);
            this.lblRazlika = new JLabel();
            this.statusBar.add((Component)this.lblRazlika);
            this.lblRazlika.setText("Ukupna razlika u ceni");
            this.pack();
            this.setSize(781, 491);
            this.setMinimumSize(new Dimension(781, 491));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        block23: {
            try {
                PzButton button = (PzButton)e.getSource();
                String actionCommand = button.getActionCommand();
                if (actionCommand.equalsIgnoreCase("unos")) {
                    actionCommand = "Dodaj";
                    this.getSession().putParameter("rj", (Object)this.rj);
                    this.getSession().putParameter("table", (Object)this.table);
                    this.getSession().putParameter("update", (Object)false);
                    this.getSession().putParameter("nivelacija", (Object)this.n);
                    this.showDialog(Dodaj.class);
                    break block23;
                }
                if (actionCommand.equalsIgnoreCase("brisiRed")) {
                    if (this.table.getRowCount() == 0) {
                        return;
                    }
                    Artikalnivelacija an = (Artikalnivelacija)this.table.getSelectedEntity();
                    EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                    try {
                        try {
                            em.getTransaction().begin();
                            Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(an.getId().getSfrProizvod(), this.n.getRadnajedinica()));
                            s.setProdCena(an.getCenaStara());
                            this.table.removeSelectedEntity(true, em);
                            em.getTransaction().commit();
                            this.table.commitRemove();
                        }
                        catch (Exception e1) {
                            if (em.getTransaction().isActive()) {
                                em.getTransaction().rollback();
                            }
                            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                            em.close();
                        }
                        break block23;
                    }
                    finally {
                        em.close();
                    }
                }
                if (actionCommand.equals("brisiSve")) {
                    if (this.table.getRowCount() == 0) {
                        return;
                    }
                    int rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)((Object)this)), "Da li ste sigurni?!", "Brisanje", 0);
                    if (rez != 0) break block23;
                    EntityManager em = PzEntityManager.getEm();
                    try {
                        try {
                            em.getTransaction().begin();
                            List lista = em.createQuery("SELECT a.id.sfrProizvod, a.cenaStara FROM Artikalnivelacija a WHERE a.id.idDok=" + this.n.getIdDok()).getResultList();
                            if (lista.size() > 0) {
                                for (Object[] o : lista) {
                                    String sifra = (String)o[0];
                                    BigDecimal prodCena = BDConverter.getProdCena((double)((Double)o[1]));
                                    em.createQuery("UPDATE Stanje s SET s.prodCena=:prodCena WHERE s.radnajedinica=:rj AND s.id.sfrProizvod=:sifra").setParameter("prodCena", (Object)prodCena.doubleValue()).setParameter("rj", (Object)this.n.getRadnajedinica()).setParameter("sifra", (Object)sifra).executeUpdate();
                                }
                            }
                            em.remove(em.find(Nivelacija.class, (Object)this.n.getIdDok()));
                            em.getTransaction().commit();
                            this.dispose();
                        }
                        catch (Exception e1) {
                            if (em.getTransaction().isActive()) {
                                em.getTransaction().rollback();
                            }
                            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                            em.close();
                        }
                        break block23;
                    }
                    finally {
                        em.close();
                    }
                }
                if (actionCommand.equalsIgnoreCase("arhiviraj")) {
                    if (this.table.getRowCount() == 0) {
                        PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Nema podataka za arhiviranje!");
                        return;
                    }
                    this.arhiviraj(this.n);
                }
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        }
    }

    public void arhiviraj(Nivelacija nivel) {
        this.showDialog(ArhiviranjeNivelacije.class);
        if (!this.getSession().allParamsExist(new String[]{"nivelacija_datum", "nivelacija_napomena"})) {
            return;
        }
        Date datum = (Date)this.getSession().popParameter("nivelacija_datum");
        String napomena = (String)this.getSession().popParameter("nivelacija_napomena");
        nivel.setDatum(datum);
        nivel.setPoruka(napomena);
        NivelacijaManager.arhivirajNivelaciju(nivel, this);
    }

    public boolean shouldBeShown() {
        boolean res = false;
        this.rj = PzDialogRJ.getRJ((PzDialog)this);
        if (this.rj != null) {
            if (!this.getNivelacija()) {
                this.n = this.createNivelacija();
                this.setTitle("Izmena cena u " + this.rj.getOgranak().getNaziv() + "-" + this.rj.getNaziv());
                this.setTable();
            } else {
                this.setTitle("Izmena cena u " + this.rj.getOgranak().getNaziv() + "-" + this.rj.getNaziv());
                this.setTable();
            }
            res = true;
        }
        return res;
    }

    public boolean getNivelacija() {
        EntityManager em = PzEntityManager.getEm();
        Query q = null;
        q = em.createQuery("SELECT n FROM Nivelacija n where n.userKraj=:user and n.arhiviran = 0 and n.radnajedinica=:rj and n.tip=:tipNiv");
        q.setParameter("user", (Object)PzExtensionLoader.getLoggedUser());
        q.setParameter("rj", (Object)this.rj);
        q.setParameter("tipNiv", (Object)TipDokumentConfig.get().NIVELACIJA);
        Iterator i = q.getResultList().iterator();
        boolean res = false;
        if (i.hasNext()) {
            this.n = (Nivelacija)i.next();
            System.out.println("nasao nivelacija" + this.n.getRbrDok());
            res = true;
        }
        em.close();
        return res;
    }

    public Nivelacija createNivelacija() {
        Nivelacija n = new Nivelacija();
        n.setDatArh(null);
        n.setNovaVrednost(new BigDecimal(0));
        n.setTip(TipDokumentConfig.get().NIVELACIJA);
        n.setPodTip(TipDokumentConfig.get().PODTIP_NIVELACIJA_STANDARDNA);
        n.setArhiviran((short)0);
        n.setProknjizen((short)0);
        n.setRadnajedinica(this.rj);
        n.setUserPoc(PzExtensionLoader.getLoggedUser());
        n.setUserKraj(PzExtensionLoader.getLoggedUser());
        n.setDatum(PzDateUtility.getCurrentDate());
        return n;
    }

    protected void thisWindowClosing(WindowEvent evt) {
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
        }
        super.thisWindowClosing(evt);
    }
}

