/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.karticaAlociranihKolicina;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import rs.pezar.analitike.gui.Settings;
import rs.pezar.analitike.gui.artikli.IzborArtikla;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.data.models.PzTableModelKarticaAlociranihKolicina;

public class KarticaAlociranihKolicina
extends IzborArtikla {
    private static final long serialVersionUID = 1L;
    private HashMap<String, String> tables = new HashMap();
    private Radnajedinica rj;
    private Artikal artikal;
    private PzTable table;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                KarticaAlociranihKolicina inst = new KarticaAlociranihKolicina(frame);
                inst.setVisible(true);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.onBtnOkPressed();
    }

    public KarticaAlociranihKolicina(JFrame frame) {
        super(frame);
        this.initGUI();
        this.tables.put("Artikalfaktura", "SELECT a FROM Artikalfaktura a WHERE %s AND a.faktura.arhiviran=0 AND a.artikal.sfrProizvod=:art AND a.faktura.radnajedinica =:rj");
        this.tables.put("Artikalinterniracun", "SELECT a FROM Artikalinterniracun a WHERE %s AND a.interniracun.arhiviran=0 AND a.artikal.sfrProizvod=:art AND a.interniracun.izlaznaRJ =:rj");
        this.tables.put("Artikalkonsignacija", "SELECT a FROM Artikalkonsignacija a WHERE %s AND a.konsignacija.arhiviran=0 AND a.artikal.sfrProizvod=:art AND a.konsignacija.radnajedinica =:rj");
    }

    public boolean shouldBeShown() {
        this.rj = PzDialogRJ.getRJ((PzDialog)this);
        return this.rj != null;
    }

    public void onBtnOkPressed() {
        this.artikal = this.getArtikalInstance();
        if (this.artikal != null) {
            if (!this.fillInTheInfo()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Nema alociranih koli\u010dina za ovaj artikal na ovoj radnoj jedinici.");
            } else {
                this.showReport();
            }
        } else {
            this.dispose();
        }
    }

    private void showReport() {
        Vector<Object> data = new Vector<Object>();
        try {
            data.add(this.artikal);
            data.add(PzFirma.getFirma());
            data.add(this.rj);
            data.add(this.rj.getOgranak());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.table, data);
        try {
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)"rs/pezar/reports/compiled/KarticaAlociranihKolicina.jasper", null, (String)("karticaAlocKolic_" + this.artikal.getSfrProizvod()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean fillInTheInfo() {
        Query q = null;
        Vector data = new Vector();
        EntityManager em = PzEntityManager.getEm();
        String query = this.getQuery("Artikalfaktura");
        q = em.createQuery(query);
        q.setParameter("rj", (Object)this.rj);
        q.setParameter("art", (Object)this.artikal.getSfrProizvod());
        data.addAll((Vector)q.getResultList());
        em.clear();
        em.close();
        if (data.size() == 0) {
            return false;
        }
        this.table = new PzTable();
        PzTableModelKarticaAlociranihKolicina model = new PzTableModelKarticaAlociranihKolicina(data);
        this.table.setModel((TableModel)model);
        return true;
    }

    private String getQuery(String tabela) {
        String dokumenta = new String();
        int i = 0;
        while (i < Settings.karticaAlociranihKolicina.length) {
            if (Settings.karticaAlociranihKolicina[i][0].equalsIgnoreCase(tabela)) {
                dokumenta = String.valueOf(dokumenta) + "a.faktura.tip = '" + Settings.karticaAlociranihKolicina[i][1] + "' OR ";
            }
            ++i;
        }
        dokumenta = "(" + dokumenta.subSequence(0, dokumenta.length() - 3) + ")";
        return String.format(this.tables.get(tabela), dokumenta);
    }
}

