/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.kartica;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.analitike.PzFinansijeManager;
import rs.pezar.analitike.gui.artikli.IzborArtiklaSaKolicinama;
import rs.pezar.analitike.gui.artikli.izgubljeneVrednosti.IzgubljeneVrednosti;
import rs.pezar.analitike.gui.artikli.kartica.RuleKarticaArtikla;
import rs.pezar.analitike.gui.komitenti.PzDialogKarticaKomitenata;
import rs.pezar.analitike.tableModels.PzTableModelKarticaArtikla;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadnajedinicaPK;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.sifarnici.gui.artikli.Upit;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzScrollableTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;

public class PzDialogPojedinacnaKartica
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private PzPanel panel;
    private PzToolBarIcon icnUpitUNalog;
    private PzToolBarIcon icnKarticaKomitenta;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private PzDoubleField pzDoubleKolicinaIzlaza;
    private PzDoubleField pzDoubleKolicinaUlaza;
    private PzDoubleField pzDoublePrometCena;
    private PzDoubleField pzDoubleSize;
    private JLabel lblProsecna;
    private PzDoubleField doubleProsecnaNabavna;
    private JLabel lblIzgubljene;
    private PzDoubleField doubleIzgubljene;
    private PzPanel pzPanel5;
    private JScrollPane jScrollPane1;
    private JPanel pzPanel1;
    private JLabel jLabel8;
    private JLabel jLabelOgr;
    private JLabel lblArtikal;
    private JLabel jLabel9;
    private JPanel jPanel2;
    private JLabel jLabelOgranak;
    private PzDoubleField pzDoubleIzgubljeneVrednosti;
    private JLabel jLabel7;
    private PzToolBarIcon icnOdustajanje;
    private PzToolBarIcon icnStampa;
    private PzToolBarIcon icnUpitURj;
    private JLabel jLabel4;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private PzDoubleField pzDoubleCena;
    private PzDoubleField pzDoubleKolicina;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JPanel panelPocetnoStanje;
    private PzToolBarIcon icnSlikaDokumenta;
    private JToolBar toolbar;
    private JLabel jLabelSailiBezOtpremnica;
    private JLabel jLabelRj;
    private Radnajedinica rj;
    private Artikal artikal;
    private double pocetnoKolicina;
    private double pocetnoCena;
    private double kolicinaUlaza;
    private double kolicinaIzlaza;
    private double stanje;
    private double cena;
    private double prosNabCena;
    private PzScrollableTable table;
    private ScrollableCursor cursor;
    private double trenutnoStanje;
    private BigDecimal izgubljeneVrednosti = BigDecimal.ZERO;
    private String tipKartice = "PRODAJNA";
    private PzPanel mainPanel;
    private EntityManager em;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Artikal art = new Artikal();
                art.setSfrProizvod("47002");
                Radnajedinica rj = new Radnajedinica();
                RadnajedinicaPK id = new RadnajedinicaPK();
                id.setOznOgranak("1");
                id.setOznRj("0");
                rj.setId(id);
            }
        });
    }

    public PzDialogPojedinacnaKartica(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogPojedinacnaKartica(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            AnchorLayout thisLayout = new AnchorLayout();
            this.getContentPane().add((Component)this.mainPanel);
            this.mainPanel.setLayout((LayoutManager)thisLayout);
            this.setTitle("Analiticka kartica artikla");
            this.setPreferredSize(new Dimension(1053, 800));
            this.panel = new PzPanel();
            this.panel.setOpaque(false);
            BorderLayout panelLayout = new BorderLayout();
            this.mainPanel.add((Component)this.panel, (Object)new AnchorConstraint(0, 1000, 1003, 0, 1, 1, 1, 1));
            this.mainPanel.add((Component)this.getJScrollPane1(), (Object)new AnchorConstraint(244, 995, 5, 5, 2, 1, 2, 2));
            this.mainPanel.add((Component)this.getPzPanel1(), (Object)new AnchorConstraint(108, 1000, 332, 0, 2, 1, 0, 1));
            this.panel.setTransferFocusOnEnter(true);
            this.panel.setPreferredSize(new Dimension(1045, 768));
            this.panel.setLayout((LayoutManager)panelLayout);
            this.panel.setOpaque(false);
            this.jLabelSailiBezOtpremnica = new JLabel();
            this.panel.add((Component)this.jLabelSailiBezOtpremnica, (Object)"North");
            this.panel.add((Component)this.getJLabel7(), (Object)"South");
            this.panel.add((Component)this.getPzDoubleIzgubljeneVrednosti(), (Object)"South");
            this.toolbar = new JToolBar();
            this.toolbar.setOpaque(false);
            this.panel.add((Component)this.toolbar, (Object)"North");
            AnchorLayout toolbarLayout = new AnchorLayout();
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setPreferredSize(new Dimension(1045, 105));
            this.icnSlikaDokumenta = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSlikaDokumenta, new AnchorConstraint(4, 97, 985, 7, 1, 1, 1, 1));
            this.toolbar.add((Component)this.getIcnKarticaKomitenta(), new AnchorConstraint(4, 183, 985, 92, 1, 1, 1, 1));
            this.toolbar.add((Component)this.getIcnUpitUNalog(), new AnchorConstraint(14, 277, 985, 188, 1, 1, 1, 1));
            this.toolbar.add((Component)this.getIcnUpitURj(), new AnchorConstraint(23, 346, 985, 281, 1, 1, 1, 1));
            this.toolbar.add((Component)this.getIcnStampa(), new AnchorConstraint(33, 424, 985, 357, 1, 1, 1, 1));
            this.icnSlikaDokumenta.setText("Slika|dokumenta|(F2)");
            this.icnSlikaDokumenta.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document.png")));
            this.icnSlikaDokumenta.setActionCommand("slikadokumenta");
            this.icnSlikaDokumenta.addActionListener((ActionListener)((Object)this));
            this.icnSlikaDokumenta.setShortcut("F2");
            this.icnSlikaDokumenta.setPreferredSize(new Dimension(94, 103));
            this.jLabelSailiBezOtpremnica.setText("Sa Ili Bez prikaza izlaznih otpremnica ");
            this.jLabelSailiBezOtpremnica.setBounds(621, 542, 217, 14);
            this.jLabelSailiBezOtpremnica.setBackground(new Color(192, 192, 192));
            this.jLabelSailiBezOtpremnica.setVisible(false);
            this.jLabel7.setVisible(false);
            this.pzDoubleIzgubljeneVrednosti.setVisible(false);
            this.pack();
            this.setMinimumSize(new Dimension(1014, 650));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("slikadokumenta")) {
                this.onSlikaDokumentaPressed();
            } else if (actionCommand.equals("karticakomitenta")) {
                this.onKarticaKomitentaPressed();
            } else if (actionCommand.equals("upitunalog")) {
                this.onUpitUNalogPressed();
            } else if (actionCommand.equals("upiturj")) {
                this.onUpitURjPressed();
            } else if (actionCommand.equals("stampa")) {
                this.onStampaPressed();
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPojedinacnaKartica(Boolean.FALSE);
    }

    public PzDialogPojedinacnaKartica(Boolean initGUI) {
    }

    private JPanel getPanelPocetnoStanje() {
        if (this.panelPocetnoStanje == null) {
            this.panelPocetnoStanje = new JPanel();
            this.panelPocetnoStanje.setOpaque(false);
            GridBagLayout panelPocetnoStanjeLayout = new GridBagLayout();
            panelPocetnoStanjeLayout.rowWeights = new double[]{0.0, 0.1};
            panelPocetnoStanjeLayout.rowHeights = new int[]{29, 7};
            panelPocetnoStanjeLayout.columnWeights = new double[]{0.0, 0.0, 0.0};
            panelPocetnoStanjeLayout.columnWidths = new int[]{107, 134, 10};
            this.panelPocetnoStanje.setLayout(panelPocetnoStanjeLayout);
            this.panelPocetnoStanje.setOpaque(false);
            this.panelPocetnoStanje.setBorder(BorderFactory.createTitledBorder(null, "Po\u010detno Stanje", 4, 0));
            this.panelPocetnoStanje.setPreferredSize(new Dimension(280, 88));
            this.panelPocetnoStanje.setFocusable(false);
            this.panelPocetnoStanje.add((Component)this.getJLabel1(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panelPocetnoStanje.add((Component)this.getJLabel2(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panelPocetnoStanje.add((Component)this.getPzDoubleKolicina(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panelPocetnoStanje.add((Component)this.getPzDoubleCena(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.panelPocetnoStanje;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Koli\u010dina");
            this.jLabel1.setFocusable(false);
        }
        return this.jLabel1;
    }

    private JLabel getJLabel2() {
        if (this.jLabel2 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("Cena");
            this.jLabel2.setFocusable(false);
        }
        return this.jLabel2;
    }

    private PzDoubleField getPzDoubleKolicina() {
        if (this.pzDoubleKolicina == null) {
            this.pzDoubleKolicina = new PzDoubleField();
            this.pzDoubleKolicina.setOpaque(true);
            this.pzDoubleKolicina.setEditable(false);
            this.pzDoubleKolicina.setEnabled(true);
            this.pzDoubleKolicina.setBackground(new Color(157, 226, 150));
            this.pzDoubleKolicina.setFocusable(false);
            this.pzDoubleKolicina.setName("pzDoubleKolicina");
        }
        return this.pzDoubleKolicina;
    }

    private PzDoubleField getPzDoubleCena() {
        if (this.pzDoubleCena == null) {
            this.pzDoubleCena = new PzDoubleField();
            this.pzDoubleCena.setEditable(false);
            this.pzDoubleCena.setEnabled(true);
            this.pzDoubleCena.setBackground(new Color(157, 226, 150));
            this.pzDoubleCena.setOpaque(true);
            this.pzDoubleCena.setFocusable(false);
            this.pzDoubleCena.setName("pzDoubleCena");
        }
        return this.pzDoubleCena;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            GridBagLayout jPanel1Layout = new GridBagLayout();
            jPanel1Layout.columnWidths = new int[]{7, 86, 135, 14, 48, 11, 136, 20};
            jPanel1Layout.rowHeights = new int[]{29, 7};
            jPanel1Layout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            jPanel1Layout.rowWeights = new double[]{0.0, 0.1};
            this.jPanel1.setOpaque(false);
            this.jPanel1.setBorder(BorderFactory.createTitledBorder("Promet"));
            this.jPanel1.setLayout(jPanel1Layout);
            this.jPanel1.setPreferredSize(new Dimension(462, 88));
            this.jPanel1.setFocusable(false);
            this.jPanel1.add((Component)this.getJLabel3(), new GridBagConstraints(1, 0, 0, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.getJLabel4(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.getPzDoubleSize(), new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.getPzDoublePrometCena(), new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.getPzDoubleKolicinaUlaza(), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.getPzDoubleKolicinaIzlaza(), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.getJLabel5(), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.getJLabel6(), new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.jPanel1;
    }

    private JLabel getJLabel3() {
        if (this.jLabel3 == null) {
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("Koli\u010dina ulaza");
            this.jLabel3.setFocusable(false);
        }
        return this.jLabel3;
    }

    private JLabel getJLabel4() {
        if (this.jLabel4 == null) {
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("Koli\u010dina izlaza");
            this.jLabel4.setFocusable(false);
        }
        return this.jLabel4;
    }

    private PzDoubleField getPzDoubleSize() {
        if (this.pzDoubleSize == null) {
            this.pzDoubleSize = new PzDoubleField();
            this.pzDoubleSize.setEditable(false);
            this.pzDoubleSize.setEnabled(true);
            this.pzDoubleSize.setBackground(new Color(157, 226, 150));
            this.pzDoubleSize.setOpaque(true);
            this.pzDoubleSize.setFocusable(false);
            this.pzDoubleSize.setName("pzDoubleSize");
        }
        return this.pzDoubleSize;
    }

    private PzDoubleField getPzDoublePrometCena() {
        if (this.pzDoublePrometCena == null) {
            this.pzDoublePrometCena = new PzDoubleField();
            this.pzDoublePrometCena.setEditable(false);
            this.pzDoublePrometCena.setEnabled(true);
            this.pzDoublePrometCena.setBackground(new Color(157, 226, 150));
            this.pzDoublePrometCena.setOpaque(true);
            this.pzDoublePrometCena.setFocusable(false);
            this.pzDoublePrometCena.setName("pzDoublePrometCena");
        }
        return this.pzDoublePrometCena;
    }

    private PzDoubleField getPzDoubleKolicinaUlaza() {
        if (this.pzDoubleKolicinaUlaza == null) {
            this.pzDoubleKolicinaUlaza = new PzDoubleField();
            this.pzDoubleKolicinaUlaza.setEditable(false);
            this.pzDoubleKolicinaUlaza.setEnabled(true);
            this.pzDoubleKolicinaUlaza.setBackground(new Color(157, 226, 150));
            this.pzDoubleKolicinaUlaza.setOpaque(true);
            this.pzDoubleKolicinaUlaza.setFocusable(false);
            this.pzDoubleKolicinaUlaza.setName("pzDoubleKolicinaUlaza");
        }
        return this.pzDoubleKolicinaUlaza;
    }

    private PzDoubleField getPzDoubleKolicinaIzlaza() {
        if (this.pzDoubleKolicinaIzlaza == null) {
            this.pzDoubleKolicinaIzlaza = new PzDoubleField();
            this.pzDoubleKolicinaIzlaza.setEditable(false);
            this.pzDoubleKolicinaIzlaza.setEnabled(true);
            this.pzDoubleKolicinaIzlaza.setBackground(new Color(157, 226, 150));
            this.pzDoubleKolicinaIzlaza.setOpaque(true);
            this.pzDoubleKolicinaIzlaza.setFocusable(false);
            this.pzDoubleKolicinaIzlaza.setName("pzDoubleKolicinaIzlaza");
        }
        return this.pzDoubleKolicinaIzlaza;
    }

    private JLabel getJLabel5() {
        if (this.jLabel5 == null) {
            this.jLabel5 = new JLabel();
            this.jLabel5.setText("Stanje");
            this.jLabel5.setFocusable(false);
        }
        return this.jLabel5;
    }

    private JLabel getJLabel6() {
        if (this.jLabel6 == null) {
            this.jLabel6 = new JLabel();
            this.jLabel6.setText("Cena");
            this.jLabel6.setFocusable(false);
        }
        return this.jLabel6;
    }

    private PzScrollableTable getTable() {
        if (this.table == null) {
            DefaultTableModel tableModel = new DefaultTableModel(new String[][]{{"", ""}, {"", ""}}, new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13"});
            this.table = new PzScrollableTable();
            AnchorLayout tableLayout = new AnchorLayout();
            this.table.setLayout((LayoutManager)tableLayout);
            this.table.setModel((TableModel)tableModel);
            this.table.setBounds(116, 221, 825, 295);
            this.table.setPreferredSize(new Dimension(1046, 449));
            this.getTable().getColumnControl().setPreferredSize(new Dimension(15, 23));
            this.getTable().getTableHeader().setPreferredSize(new Dimension(1026, 23));
        }
        return this.table;
    }

    private PzToolBarIcon getIcnKarticaKomitenta() {
        if (this.icnKarticaKomitenta == null) {
            this.icnKarticaKomitenta = new PzToolBarIcon();
            this.icnKarticaKomitenta.setText("Kartica|Komitenta|(ALT+F2)");
            this.icnKarticaKomitenta.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/index_up.png")));
            this.icnKarticaKomitenta.setActionCommand("karticakomitenta");
            this.icnKarticaKomitenta.addActionListener((ActionListener)((Object)this));
            this.icnKarticaKomitenta.setShortcut("alt+f2");
            this.icnKarticaKomitenta.setPreferredSize(new Dimension(95, 103));
        }
        return this.icnKarticaKomitenta;
    }

    private PzToolBarIcon getIcnUpitUNalog() {
        if (this.icnUpitUNalog == null) {
            this.icnUpitUNalog = new PzToolBarIcon();
            this.icnUpitUNalog.setText("Upit u nalog|za knji\u017eenje(F5)");
            this.icnUpitUNalog.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/note.png")));
            this.icnUpitUNalog.setPreferredSize(new Dimension(93, 102));
            this.icnUpitUNalog.setActionCommand("upitunalog");
            this.icnUpitUNalog.addActionListener((ActionListener)((Object)this));
            this.icnUpitUNalog.setShortcut("F5");
        }
        return this.icnUpitUNalog;
    }

    private PzToolBarIcon getIcnUpitURj() {
        if (this.icnUpitURj == null) {
            this.icnUpitURj = new PzToolBarIcon();
            this.icnUpitURj.setText("Upit u radnu| jedinicu (F3)");
            this.icnUpitURj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/factory_new.png")));
            this.icnUpitURj.setPreferredSize(new Dimension(68, 101));
            this.icnUpitURj.setActionCommand("upiturj");
            this.icnUpitURj.addActionListener((ActionListener)((Object)this));
            this.icnUpitURj.setShortcut("F3");
        }
        return this.icnUpitURj;
    }

    private PzToolBarIcon getIcnStampa() {
        if (this.icnStampa == null) {
            this.icnStampa = new PzToolBarIcon();
            this.icnStampa.setText("\u0160tampa|(ALT+S)");
            this.icnStampa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.icnStampa.setPreferredSize(new Dimension(70, 100));
            this.icnStampa.setActionCommand("stampa");
            this.icnStampa.addActionListener((ActionListener)((Object)this));
            this.icnStampa.setShortcut("ALT+S");
        }
        return this.icnStampa;
    }

    private PzToolBarIcon getIcnOdustajanje() {
        if (this.icnOdustajanje == null) {
            this.icnOdustajanje = new PzToolBarIcon();
            this.icnOdustajanje.setText("Testiranje | Ctrl+T");
            this.icnOdustajanje.setPreferredSize(new Dimension(78, 101));
            this.icnOdustajanje.setActionCommand("odustajanje");
            this.icnOdustajanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_edit.png")));
            this.icnOdustajanje.addActionListener((ActionListener)((Object)this));
            this.icnOdustajanje.setName("icnOdustajanje");
            this.icnOdustajanje.setShortcut("CTRL+T");
        }
        return this.icnOdustajanje;
    }

    private JLabel getJLabel7() {
        if (this.jLabel7 == null) {
            this.jLabel7 = new JLabel();
            this.jLabel7.setText("Izgubljene vrednosti:");
            this.jLabel7.setBounds(496, 119, 152, 14);
        }
        return this.jLabel7;
    }

    private PzDoubleField getPzDoubleIzgubljeneVrednosti() {
        if (this.pzDoubleIzgubljeneVrednosti == null) {
            this.pzDoubleIzgubljeneVrednosti = new PzDoubleField();
            this.pzDoubleIzgubljeneVrednosti.setEditable(false);
            this.pzDoubleIzgubljeneVrednosti.setBackground(new Color(255, 128, 128));
            this.pzDoubleIzgubljeneVrednosti.setEnabled(true);
            this.pzDoubleIzgubljeneVrednosti.setOpaque(true);
            this.pzDoubleIzgubljeneVrednosti.setBounds(690, 112, 128, 21);
        }
        return this.pzDoubleIzgubljeneVrednosti;
    }

    private JPanel getPzPanel1() {
        if (this.pzPanel1 == null) {
            this.pzPanel1 = new JPanel();
            this.pzPanel1.setOpaque(false);
            AnchorLayout pzPanel1Layout = new AnchorLayout();
            this.pzPanel1.setLayout(pzPanel1Layout);
            this.pzPanel1.setPreferredSize(new Dimension(1045, 146));
            this.jPanel2 = new JPanel();
            this.pzPanel1.add((Component)this.getPanelPocetnoStanje(), new AnchorConstraint(3, 551, 586, 283, 1, 1, 1, 1));
            this.pzPanel1.add((Component)this.getJPanel1(), new AnchorConstraint(3, 995, 586, 558, 1, 1, 1, 1));
            this.pzPanel1.add((Component)this.jPanel2, new AnchorConstraint(3, 277, 586, 5, 1, 1, 1, 1));
            this.pzPanel1.add((Component)this.getPzPanel5(), new AnchorConstraint(625, 995, 864, 5, 1, 1, 1, 1));
            GridBagLayout jPanel2Layout = new GridBagLayout();
            this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Artikal", 4, 0));
            jPanel2Layout.rowWeights = new double[]{0.0, 0.0, 0.0};
            jPanel2Layout.rowHeights = new int[]{19, 16, 22};
            jPanel2Layout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            jPanel2Layout.columnWidths = new int[]{7, 75, 15, 7};
            this.jPanel2.setLayout(jPanel2Layout);
            this.jPanel2.setPreferredSize(new Dimension(289, 88));
            this.jPanel2.setFocusable(false);
            this.jPanel2.setName("jPanel2");
            this.jPanel2.setOpaque(false);
            this.jLabelOgranak = new JLabel();
            this.jPanel2.add((Component)this.jLabelOgranak, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabelOgranak.setText("Ogranak");
            this.jLabelOgranak.setBounds(14, 6, 60, 14);
            this.jLabelOgranak.setFocusable(false);
            this.jLabelRj = new JLabel();
            this.jPanel2.add((Component)this.jLabelRj, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabelRj.setText("Radna jedinica");
            this.jLabelRj.setBounds(215, 6, 88, 14);
            this.jLabelRj.setFocusable(false);
            this.jLabel9 = new JLabel();
            this.jPanel2.add((Component)this.jLabel9, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel9.setText("Artikal");
            this.jLabel9.setFocusable(false);
            this.lblArtikal = new JLabel();
            this.jPanel2.add((Component)this.lblArtikal, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblArtikal.setFocusable(false);
            this.lblArtikal.setText("Artikal");
            this.jLabelOgr = new JLabel();
            this.jPanel2.add((Component)this.jLabelOgr, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabelOgr.setFocusable(false);
            this.jLabelOgr.setText("Ogranak");
            this.jLabel8 = new JLabel();
            this.jPanel2.add((Component)this.jLabel8, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel8.setFocusable(false);
            this.jLabel8.setText("Radnajedinica");
        }
        return this.pzPanel1;
    }

    private boolean fillInTheInfo(EntityManager em) {
        this.pocetnoKolicina = 0.0;
        this.pocetnoCena = 0.0;
        this.kolicinaUlaza = 0.0;
        this.kolicinaIzlaza = 0.0;
        this.stanje = 0.0;
        this.cena = 0.0;
        this.prosNabCena = 0.0;
        if (this.tipKartice.equals("PRODAJNA")) {
            this.lblProsecna.setVisible(false);
            this.doubleProsecnaNabavna.setVisible(false);
        } else if (this.tipKartice.equals("PROSECNA_NABAVNA")) {
            this.lblProsecna.setVisible(true);
            this.doubleProsecnaNabavna.setVisible(true);
            this.doubleIzgubljene.setVisible(true);
            this.lblIzgubljene.setVisible(true);
        }
        String labelRJText = String.format("%s %s - %s", this.rj.getId().getOznRj(), this.rj.getTip(), this.rj.getNaziv());
        String labelOgranakText = String.format("%s - %s", this.rj.getOgranak().getOznOgranak(), this.rj.getOgranak().getNaziv());
        String labelArtikalText = String.format("[%s] %s", this.artikal.getSfrProizvod(), this.artikal.getNaziv());
        this.setTitle("Analiti\u010dka kartica artikla:" + labelArtikalText + " Rj:" + labelRJText);
        if (this.rj.getTip().startsWith("E") && (this.rj.getpTip().startsWith("V") || this.rj.getpTip().startsWith("W"))) {
            this.jLabel5.setVisible(false);
            this.jLabel1.setVisible(false);
            this.pzDoubleKolicina.setVisible(false);
            this.pzDoubleSize.setVisible(false);
            this.setTitle(String.valueOf(this.getTitle()) + " - VREDNOSNA MALOPRODAJA -");
        }
        if (this.artikal != null && this.artikal.getSfrProizvod() != "") {
            Stanje s = null;
            try {
                s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(this.artikal.getSfrProizvod(), this.rj));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (s == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Izabrani artikal do sada nije imao promet", "Info", 1);
                return false;
            }
            try {
                this.izgubljeneVrednosti = IzgubljeneVrednosti.fetchIzgubljenaVrednost(this.rj, this.artikal.getSfrProizvod(), em);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            RuleKarticaArtikla rule = null;
            try {
                rule = new RuleKarticaArtikla(this.rj, this.tipKartice, 0);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            String documents = rule.getValidVectorDocumentsString();
            Query q = em.createNativeQuery("SELECT d.datum, d.sfrkomitent, d.ozndokumenta, d.tip, d.rbroj, ad.procRabata, ad.cena, ad.kolicina, '', ad.vrsta, d.iddok, d.proknjizen, ad.prodcena, ad.prosnabcena,  (SELECT ak.nabcena FROM artikalkalkulacija ak WHERE ak.iddok=d.iddok AND ak.rbroj=ad.rbroj AND ak.sfrProizvod = '" + this.artikal.getSfrProizvod() + "'), " + "ad.vrednost, " + "d.storno, " + "d.podtip, " + "d.rbrdok, " + "d.rBroj " + "FROM Dokument d, Artikaldokument ad " + "WHERE ad.sfrProizvod = '" + this.artikal.getSfrProizvod() + "' " + "AND d.oznrj='" + this.rj.getId().getOznRj() + "' " + "AND d.oznogranak = '" + this.rj.getId().getOznOgranak() + "' " + "AND d.idDok = ad.idDok " + "AND d.tip IN (" + documents + ") " + "AND d.arhiviran = 1 " + "AND NOT ad.vrsta = 'N' " + "ORDER BY d.datum, d.rbrDok");
            q.setHint("eclipselink.cursor.scrollable", (Object)"True");
            if (this.cursor != null && !this.cursor.isClosed()) {
                this.cursor.close();
            }
            this.cursor = (ScrollableCursor)q.getSingleResult();
            this.table = new PzScrollableTable();
            PzTableModelKarticaArtikla model = new PzTableModelKarticaArtikla(s, this.cursor, rule, this.tipKartice);
            this.table.setModel((TableModel)((Object)model));
            this.jScrollPane1.setViewportView((Component)this.table);
            try {
                this.table.getColumnExt(14).setVisible(false);
            }
            catch (Exception exception) {}
            this.pocetnoKolicina = s.getKolPop();
            this.pocetnoCena = s.getCenaNaPS();
            int i = 0;
            while (i < model.getRowCount()) {
                Double ulaz = (Double)model.getValueAt(i, 6);
                Double izlaz = (Double)model.getValueAt(i, 7);
                this.kolicinaUlaza += ulaz == null ? 0.0 : ulaz;
                this.kolicinaIzlaza += izlaz == null ? 0.0 : izlaz;
                ++i;
            }
            this.cena = s.getProdCena();
            this.prosNabCena = s.getProsNabCena().doubleValue();
            this.trenutnoStanje = this.kolicinaUlaza - this.kolicinaIzlaza;
            this.stanje = this.pocetnoKolicina + this.trenutnoStanje;
            this.jLabel8.setText(labelRJText);
            this.jLabelOgr.setText(labelOgranakText);
            this.lblArtikal.setText(labelArtikalText);
            this.pzDoubleCena.setVal((Object)this.pocetnoCena);
            this.pzDoubleKolicina.setVal((Object)this.pocetnoKolicina);
            this.pzDoubleKolicinaUlaza.setVal((Object)this.kolicinaUlaza);
            this.pzDoublePrometCena.setVal((Object)this.cena);
            this.pzDoubleKolicinaIzlaza.setVal((Object)this.kolicinaIzlaza);
            this.pzDoubleSize.setVal((Object)this.stanje);
            this.doubleProsecnaNabavna.setVal((Object)this.prosNabCena);
            this.doubleIzgubljene.setVal((Object)this.izgubljeneVrednosti);
        }
        return true;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setOpaque(false);
            this.jScrollPane1.setPreferredSize(new Dimension(1045, 522));
            this.jScrollPane1.setViewportView((Component)this.getTable());
        }
        return this.jScrollPane1;
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
        }
    }

    private PzPanel getPzPanel5() {
        if (this.pzPanel5 == null) {
            this.pzPanel5 = new PzPanel();
            this.pzPanel5.setOpaque(false);
            GridBagLayout pzPanel5Layout = new GridBagLayout();
            this.pzPanel5.setPreferredSize(new Dimension(1033, 36));
            this.pzPanel5.setBorder((Border)BorderFactory.createTitledBorder(""));
            this.pzPanel5.setLayout((LayoutManager)pzPanel5Layout);
            pzPanel5Layout.rowWeights = new double[]{0.1};
            pzPanel5Layout.rowHeights = new int[]{7};
            pzPanel5Layout.columnWeights = new double[]{0.0, 0.1, 0.1, 0.0, 0.0, 0.1, 0.0};
            pzPanel5Layout.columnWidths = new int[]{164, 7, 7, 285, 192, 20, 7};
            this.pzPanel5.add((Component)this.getLblIzgubljene(), (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.pzPanel5.add((Component)this.getDoubleIzgubljene(), (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.pzPanel5.add((Component)this.getDoubleProsecnaNabavna(), (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.pzPanel5.add((Component)this.getLblProsecna(), (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.pzPanel5;
    }

    private PzDoubleField getDoubleIzgubljene() {
        if (this.doubleIzgubljene == null) {
            this.doubleIzgubljene = new PzDoubleField();
            this.doubleIzgubljene.setBounds(878, 7, 136, 24);
            this.doubleIzgubljene.setBackground(new Color(255, 119, 119));
            this.doubleIzgubljene.setEditable(false);
            this.doubleIzgubljene.setFocusable(false);
        }
        return this.doubleIzgubljene;
    }

    private JLabel getLblIzgubljene() {
        if (this.lblIzgubljene == null) {
            this.lblIzgubljene = new JLabel();
            this.lblIzgubljene.setText("Izgubljene vrednosti:");
            this.lblIzgubljene.setBounds(724, 13, 142, 14);
        }
        return this.lblIzgubljene;
    }

    private PzDoubleField getDoubleProsecnaNabavna() {
        if (this.doubleProsecnaNabavna == null) {
            this.doubleProsecnaNabavna = new PzDoubleField();
            this.doubleProsecnaNabavna.setBounds(160, 7, 137, 24);
            this.doubleProsecnaNabavna.setEditable(false);
        }
        return this.doubleProsecnaNabavna;
    }

    private JLabel getLblProsecna() {
        if (this.lblProsecna == null) {
            this.lblProsecna = new JLabel();
            this.lblProsecna.setText("Prosecna nabavna cena:");
            this.lblProsecna.setBounds(5, 13, 137, 14);
        }
        return this.lblProsecna;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shouldBeShown() {
        Vector<String> skupZaIzbor = new Vector<String>();
        String prodajna = new String("Prodajna");
        String prosNabavna = new String("Prose\u010dna nabavna");
        skupZaIzbor.add(prodajna);
        skupZaIzbor.add(prosNabavna);
        try {
            block13: {
                block11: {
                    block12: {
                        String prosecnaNabavna;
                        if (this.getSession().getParameter("TRENUTNI_DOKUMENT") != null) {
                            PzDokument dok = (PzDokument)this.getSession().getParameter("TRENUTNI_DOKUMENT");
                            this.rj = dok.getRadnajedinica();
                        }
                        if (this.rj == null) {
                            this.rj = PzDialogRJ.getRJ((PzDialog)this);
                        }
                        if (this.rj == null) {
                            return false;
                        }
                        this.artikal = IzborArtiklaSaKolicinama.getArtikal(this, this.rj);
                        if (this.artikal == null) {
                            return false;
                        }
                        String string = prosecnaNabavna = this.rj.getNacinVodjenja().equals("PRODAJNA") ? "true" : "false";
                        if (!prosecnaNabavna.equals("false") || !this.rj.getTip().startsWith("V") && !this.rj.getTip().startsWith("S")) break block11;
                        if (!this.rj.getTip().startsWith("S")) break block12;
                        this.tipKartice = "PROSECNA_NABAVNA";
                        break block13;
                    }
                    String izborKartice = PzDialogChoice.showPzDialogChoice((PzDialog)this, skupZaIzbor);
                    if (izborKartice == null) {
                        return false;
                    }
                    if (izborKartice.equals(prodajna)) {
                        this.tipKartice = "PRODAJNA";
                        break block13;
                    } else if (izborKartice.equals(prosNabavna)) {
                        this.tipKartice = "PROSECNA_NABAVNA";
                    }
                    break block13;
                }
                this.tipKartice = "PRODAJNA";
            }
            EntityManager em = PzEntityManagerFactory.getInstance().createEm();
            if (!this.fillInTheInfo(em)) {
                em.close();
                if (this.cursor == null) return false;
                this.cursor.close();
                return false;
            }
            em.close();
            return true;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return false;
        }
    }

    private void showReport() {
        Vector<Object> data = new Vector<Object>();
        try {
            data.add(this.artikal);
            data.add(PzFirma.getFirma());
            data.add(this.rj.getOgranak());
            data.add(this.rj);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        HashMap<String, Double> params = new HashMap<String, Double>();
        params.put("pocetno_cena", this.pocetnoCena);
        params.put("pocetno_ulaz", this.pocetnoKolicina);
        PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.table, data);
        if (this.tipKartice.equals("PRODAJNA")) {
            try {
                PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)"rs/pezar/reports/compiled/KarticaArtikla.jasper", params, (String)("karticaArtikla_" + this.artikal.getSfrProizvod()), (int)PzReportManager.REPORT_TYPE_JASPER);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.tipKartice.equals("PROSECNA_NABAVNA")) {
            try {
                PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)"rs/pezar/reports/compiled/KarticaArtikla.prnc.jasper", params, (String)("karticaArtikla_" + this.artikal.getSfrProizvod()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void onOdustajanjePressed() {
    }

    private void onStampaPressed() {
        this.showReport();
    }

    private void onUpitURjPressed() {
        this.showDialog(Upit.class, false, null, this.artikal);
    }

    private void onUpitUNalogPressed() {
        if (this.table.getSelectedRow() == -1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate selektovati dokument iz tabele.", "Info", 1);
            return;
        }
        Integer iddok = (Integer)((PzTableModelKarticaArtikla)((Object)this.table.getModel())).getidDokAt(this.table.convertRowIndexToModel(this.table.getSelectedRow()));
        PzDokument d = null;
        d = (PzDokument)PzEntityManager.findEntity(Dokument.class, (Object)iddok);
        PzFinansijeManager.getInstance().getHelper().showNzk((PzDialog)this, d);
    }

    private void onKarticaKomitentaPressed() {
        Komitent komitent = null;
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow == -1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate obele\u017eiti dokument u tabeli.");
            return;
        }
        String kom = (String)this.table.getValueAt(selectedRow, 1);
        String dokument = (String)this.table.getValueAt(selectedRow, 2);
        Double ulaz = (Double)this.table.getValueAt(selectedRow, 6);
        Double izlaz = (Double)this.table.getValueAt(selectedRow, 7);
        if (kom.equals("")) {
            JOptionPane.showMessageDialog((Component)((Object)this), String.format("Dokument %s uz sebe nema komitenta.", dokument));
            return;
        }
        try {
            byte izborKartice = -1;
            izborKartice = ulaz > izlaz ? (byte)PzDialogKarticaKomitenata.KARTICA_DOBAVLJACA : (byte)PzDialogKarticaKomitenata.KARTICA_KUPCA;
            komitent = (Komitent)PzEntityManager.find(Komitent.class, (Object)kom);
            PzDialogKarticaKomitenata.showKarticaKomitenta(this, komitent, izborKartice);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized void showKarticaArtikla(PzDialog dialog, Artikal art, Radnajedinica r, String tipKartice, EntityManager em) throws Exception {
        if (art != null && r != null) {
            String prodajna = r.getNacinVodjenja().equals("PRODAJNA") ? "true" : "false";
            PzDialogPojedinacnaKartica kartica = new PzDialogPojedinacnaKartica(dialog);
            kartica.rj = r;
            kartica.artikal = art;
            if (tipKartice == "PRODAJNA" || tipKartice == "PROSECNA_NABAVNA") {
                kartica.tipKartice = tipKartice;
            } else if (tipKartice == null) {
                kartica.tipKartice = prodajna.equalsIgnoreCase("true") ? "PRODAJNA" : "PROSECNA_NABAVNA";
            } else {
                throw new Exception("Pogresno prosledjen parametar tipa kartice, tip moze biti PzTableModelKarticaArtikla.TIP_PRODAJNA ili PzTableModelKarticaArtikla.TIP_PROSECNA");
            }
            if (kartica.fillInTheInfo(em)) {
                kartica.restoreSize();
                kartica.setVisible(true);
            } else {
                kartica.dispose();
            }
        } else {
            throw new Exception("artikal i radna jedinica ne smeju biti vrednosti null.");
        }
    }

    private void onSlikaDokumentaPressed() {
        if (this.table.getSelectedRow() == -1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate selektovati dokument iz tabele.", "Info", 1);
            return;
        }
        Integer iddok = (Integer)((PzTableModelKarticaArtikla)((Object)this.table.getModel())).getidDokAt(this.table.convertRowIndexToModel(this.table.getSelectedRow()));
        PzDokument d = null;
        try {
            d = (PzDokument)PzEntityManager.find(Dokument.class, (Object)iddok);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)d);
    }
}

