/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui.unosNaknadneFakture;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.nabavka.gui.PzDialogStornoNaknadneFakture;
import rs.pezar.nabavka.gui.PzDialogUnosNaknadneFakture;
import rs.pezar.nabavka.gui.unosNaknadneFakture.pdv.Dodavanje;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.event.PzTablePropertyListener;

public class PzDialogPDV
extends PzDialog {
    private static final long serialVersionUID = -7745443644331406254L;
    private PzToolBarIcon icnDodavanje;
    private JPanel jPanel1;
    private PzToolBarIcon icnIzmena;
    private PzTable table;
    private JScrollPane scp;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanje;
    private Kalkulacija zapisnik;
    private PzDialogUnosNaknadneFakture nakFaktura;
    private PzDialogStornoNaknadneFakture stornoNakFakture;
    private boolean storno;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogPDV inst = new PzDialogPDV(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogPDV(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogPDV(PzDialog dialog) {
        super(dialog);
        this.zapisnik = (Kalkulacija)this.getSession().getParameter("zapisnik");
        this.initGUI();
        if (dialog instanceof PzDialogUnosNaknadneFakture) {
            this.nakFaktura = (PzDialogUnosNaknadneFakture)dialog;
            this.storno = false;
        } else {
            this.stornoNakFakture = (PzDialogStornoNaknadneFakture)dialog;
            this.icnDodavanje.setEnabled(false);
            this.storno = true;
        }
    }

    private void initGUI() {
        try {
            this.setTitle("PDV");
            this.jPanel1 = new JPanel();
            GridBagLayout jPanel1Layout = new GridBagLayout();
            jPanel1Layout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.rowHeights = new int[]{7, 7, 7, 7};
            jPanel1Layout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.columnWidths = new int[]{7, 7, 7, 7};
            this.jPanel1.setLayout(jPanel1Layout);
            this.getContentPane().add((Component)this.jPanel1, "Center");
            this.jPanel1.setPreferredSize(new Dimension(592, 272));
            this.scp = new JScrollPane();
            this.jPanel1.add((Component)this.scp, new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.scp.setBackground(new Color(211, 242, 210));
            this.table = new PzTable(this.zapisnik.getTaksakalkulacijas(), Taksakalkulacija.class);
            this.scp.setViewportView((Component)this.table);
            this.table.setPropertyListener(new PzTablePropertyListener(){

                public void entityRemoved(PzEntity entity) {
                    if (PzDialogPDV.this.table.getRowCount() == 0 && !PzDialogPDV.this.storno) {
                        PzDialogPDV.this.nakFaktura.getTableGroup().disableAll();
                    }
                    if (PzDialogPDV.this.storno) {
                        PzDialogPDV.this.stornoNakFakture.calculatePDV();
                    }
                }

                public void entityAdded(PzEntity entity) {
                    if (!PzDialogPDV.this.storno) {
                        PzDialogPDV.this.nakFaktura.getTableGroup().enableAll();
                    }
                }
            });
            this.setSize(933, 603);
            this.toolbar = new JToolBar();
            this.getContentPane().add((Component)this.toolbar, "North");
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/box_add.png")));
            this.icnDodavanje.setText("Dodavanje|(INS)");
            this.icnDodavanje.setActionCommand("Dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/box_edit.png")));
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/box_delete.png")));
            this.icnBrisanje.setText("Brisanje| (DEL)");
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("DELETE");
            this.setSize(600, 400);
            this.setLocationRelativeTo(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        boolean izmena = false;
        PzToolBarIcon icon = (PzToolBarIcon)arg0.getSource();
        String actionCommand = icon.getActionCommand();
        if (actionCommand.equalsIgnoreCase("Brisanje")) {
            if (this.table.getSelectedEntity() == null) {
                return;
            }
            if (this.storno) {
                this.table.removeSelectedEntity(true, false);
            } else {
                this.table.removeSelectedEntity(true, true);
            }
        } else {
            if (actionCommand.equalsIgnoreCase("Izmena")) {
                if (this.table.getSelectedEntity() == null) {
                    return;
                }
                izmena = true;
                this.getSession().putParameter("table", (Object)this.table);
                this.getSession().putParameter("update", (Object)izmena);
                this.getSession().putParameter("storno", (Object)this.storno);
                this.getSession().putParameter("zapisnik", this.getSession().getParameter("zapisnik"));
                this.showDialog(Dodavanje.class);
                return;
            }
            this.getSession().putParameter("zapisnik", this.getSession().getParameter("zapisnik"));
            this.getSession().putParameter("table", (Object)this.table);
            this.getSession().putParameter("update", (Object)izmena);
            this.showDialog(Dodavanje.class);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPDV(Boolean.FALSE);
    }

    public PzDialogPDV(Boolean initGUI) {
    }
}

