/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui.neocarinjenaRoba;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikalcarinadokument;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.CarinaDokument;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.nabavka.PzNabavkaUtil;
import rs.pezar.nabavka.gui.neocarinjenaRoba.Kolicina;
import rs.pezar.nabavka.gui.neocarinjenaRoba.PrijemniceIzArhive;
import rs.pezar.reports.PzReportManager;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzCheckbox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.event.PzTableCheckboxListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class StornoPrijemnice
extends PzDialog {
    private static final long serialVersionUID = -7745443644331406254L;
    private PzTextAreaPanel razlog;
    private PzPanel panelRazlog;
    private PzToolBarIcon icnArhiva;
    private PzPanel pnlGlavni;
    private JToolBar toolbar;
    private PzCheckbox cbKalkulacija;
    private PzButton icnInverznaSelekcija;
    private PzButton icnDeselektujSve;
    private PzButton icnSelektujSve;
    private PzButton icnSelektuj;
    private JPanel pnlSelect;
    private CarinaDokument prijemnica;
    private PzPanel pzPanel1;
    private JLabel jLabel3;
    private PzDoubleField dfVrednostV;
    private JLabel jLabel13;
    private PzDoubleField dfVrednostD;
    private PzButton btnOK;
    private PzDateField datIzrade;
    private JLabel jLabel1;
    private PzToolBarIcon icnIzmena;
    private PzTable table;
    private JScrollPane scpArtikli;
    private ButtonGroup buttonGroupNiv;
    private HashMap<String, Double> mapaKolicina = null;
    private final String tableID = "";

    public StornoPrijemnice(PzDialog parent) {
        super(parent);
        try {
            this.prijemnica = (CarinaDokument)this.getSession().getParameter("prijemnica");
            this.mapaKolicina = this.setMapaKolicina(this.prijemnica);
            this.initGUI();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            e.printStackTrace();
        }
        this.paintPanel();
    }

    private HashMap<String, Double> setMapaKolicina(CarinaDokument prijemnica) {
        HashMap<String, Double> rez = new HashMap<String, Double>();
        for (Artikalcarinadokument a : prijemnica.getArtikalcarinadokuments()) {
            rez.put(String.valueOf(a.getId().getSfrProizvod()) + "/" + a.getId().getrBroj(), a.getKolicina());
        }
        return rez;
    }

    public double getKolicinaFor(Artikalcarinadokument af) {
        return this.mapaKolicina.get(String.valueOf(af.getId().getSfrProizvod()) + "/" + af.getId().getrBroj());
    }

    public void setVrednost(List<Artikalcarinadokument> artikli) {
        this.dfVrednostV.setVal((Object)this.prijemnica.getVrednostValuta(artikli));
        this.dfVrednostD.setVal((Object)this.prijemnica.getVrednostDinar(artikli));
    }

    public List<Artikalcarinadokument> prebaciUListuArtikalCarinadokumnet(List<PzEntity> lista) {
        Vector<Artikalcarinadokument> rez = null;
        if (lista != null) {
            rez = new Vector<Artikalcarinadokument>();
            for (PzEntity entitet : lista) {
                rez.add((Artikalcarinadokument)entitet);
            }
        }
        return rez;
    }

    public List<Artikalopstidokument> prebaciUListuArtikalOpstidokument(List<PzEntity> lista) {
        Vector<Artikalopstidokument> rez = null;
        if (lista != null) {
            rez = new Vector<Artikalopstidokument>();
            for (PzEntity entitet : lista) {
                rez.add((Artikalopstidokument)entitet);
            }
        }
        return rez;
    }

    private void paintPanel() {
        this.pnlGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.pnlGlavni = new PzPanel();
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            this.pnlGlavni.setPreferredSize(new Dimension(943, 367));
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{115, 142, 159, 7};
            this.pnlGlavni.setOpaque(false);
            this.scpArtikli = new JScrollPane();
            this.pnlGlavni.add((Component)this.scpArtikli, (Object)new GridBagConstraints(0, 1, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.table = new PzTable(this.prijemnica.getArtikalcarinadokuments(), Artikalcarinadokument.class);
            this.table.setCheckboxColumn(0, KeyStroke.getKeyStroke(113, 0), KeyStroke.getKeyStroke(113, 512), KeyStroke.getKeyStroke(113, 128), KeyStroke.getKeyStroke(113, 640));
            this.table.unCheckAll();
            this.table.addCheckboxListener(new PzTableCheckboxListener(){

                public void valueChanged(int rowIndex, PzEntity entity, boolean newValue) {
                    StornoPrijemnice.this.prijemnica.setArtikalcarinadokuments(StornoPrijemnice.this.table.getCheckedEntities());
                    StornoPrijemnice.this.setVrednost(StornoPrijemnice.this.table.getCheckedEntities());
                }
            });
            this.table.setId("");
            this.scpArtikli.setViewportView((Component)this.table);
            this.table.getTableHeader().setFocusable(false);
            this.table.requestFocusInWindow();
            this.table.setRowSelectionInterval(0, 0);
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setOpaque(false);
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("A\u017euriranje|koli\u010dine|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/product_edit.png")));
            this.icnIzmena.setActionCommand("Kolicina");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnArhiva = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiva|i \u0161tampa|(CTRL+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/printer_preferences.png")));
            this.icnArhiva.setActionCommand("arhiva");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("ctrl+w");
            this.pnlSelect = new JPanel();
            FlowLayout pnlSelectLayout = new FlowLayout();
            pnlSelectLayout.setAlignment(0);
            pnlSelectLayout.setVgap(2);
            this.pnlSelect.setLayout(pnlSelectLayout);
            this.toolbar.add(this.pnlSelect);
            this.pnlSelect.setPreferredSize(new Dimension(221, 113));
            this.pnlSelect.setOpaque(false);
            this.icnSelektuj = new PzButton();
            this.pnlSelect.add((Component)this.icnSelektuj);
            this.icnSelektuj.setText("Selektuj trenutni (f2)");
            this.icnSelektuj.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnSelektuj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/selektuj.png")));
            this.icnSelektuj.setPreferredSize(new Dimension(207, 24));
            this.icnSelektuj.setHorizontalAlignment(10);
            this.icnSelektuj.setFocusable(false);
            this.icnSelektuj.setOpaque(false);
            this.icnSelektuj.addActionListener((ActionListener)((Object)this));
            this.icnSelektujSve = new PzButton();
            this.pnlSelect.add((Component)this.icnSelektujSve);
            this.icnSelektujSve.setText("Selektuj sve (alt+f2)");
            this.icnSelektujSve.setOpaque(false);
            this.icnSelektujSve.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnSelektujSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/selection_sve.png")));
            this.icnSelektujSve.setPreferredSize(new Dimension(207, 24));
            this.icnSelektujSve.setHorizontalAlignment(10);
            this.icnSelektujSve.setFocusable(false);
            this.icnSelektujSve.addActionListener((ActionListener)((Object)this));
            this.icnDeselektujSve = new PzButton();
            this.pnlSelect.add((Component)this.icnDeselektujSve);
            this.icnDeselektujSve.setText("Deselektuj sve (ctrl+f2)");
            this.icnDeselektujSve.setOpaque(false);
            this.icnDeselektujSve.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnDeselektujSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/deselektuj_sve.png")));
            this.icnDeselektujSve.setPreferredSize(new Dimension(207, 24));
            this.icnDeselektujSve.setHorizontalAlignment(10);
            this.icnDeselektujSve.setFocusable(false);
            this.icnDeselektujSve.addActionListener((ActionListener)((Object)this));
            this.icnInverznaSelekcija = new PzButton();
            this.pnlSelect.add((Component)this.icnInverznaSelekcija);
            this.icnInverznaSelekcija.setText("Inverzna selekcija (ctrl+alt+f2)");
            this.icnInverznaSelekcija.setOpaque(false);
            this.icnInverznaSelekcija.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnInverznaSelekcija.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/selektuj inverzno.png")));
            this.icnInverznaSelekcija.setPreferredSize(new Dimension(208, 24));
            this.icnInverznaSelekcija.setHorizontalAlignment(10);
            this.icnInverznaSelekcija.setFocusable(false);
            this.icnInverznaSelekcija.addActionListener((ActionListener)((Object)this));
            this.panelRazlog = new PzPanel();
            this.pnlGlavni.add((Component)this.panelRazlog, (Object)new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout panelRazlogLayout = new GridBagLayout();
            panelRazlogLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            panelRazlogLayout.rowHeights = new int[]{4, 28, 7, 20};
            panelRazlogLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            panelRazlogLayout.columnWidths = new int[]{300, 85, 110, 20};
            this.panelRazlog.setLayout((LayoutManager)panelRazlogLayout);
            this.panelRazlog.setPreferredSize(new Dimension(1295, 163));
            this.panelRazlog.setOpaque(false);
            this.razlog = new PzTextAreaPanel();
            this.panelRazlog.add((Component)this.razlog, (Object)new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
            this.razlog.setPreferredSize(new Dimension(762, 96));
            this.razlog.setTransferFocusOnEnter(true);
            this.razlog.setBorder((Border)BorderFactory.createTitledBorder("Razlog storniranja"));
            this.razlog.setOpaque(false);
            this.jLabel1 = new JLabel();
            this.panelRazlog.add((Component)this.jLabel1, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 10, 0, 5), 0, 0));
            this.jLabel1.setText("Datum izrade:");
            this.jLabel1.setHorizontalAlignment(4);
            this.datIzrade = new PzDateField();
            this.panelRazlog.add((Component)this.datIzrade, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
            this.datIzrade.setFont(new Font("Tahoma", 0, 14));
            this.btnOK = new PzButton();
            this.btnOK.setEnabled(false);
            this.panelRazlog.add((Component)this.btnOK, (Object)new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 13, 0, 60), 0, 0));
            this.btnOK.setText("Dalje");
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/check.png")));
            this.btnOK.setPreferredSize(new Dimension(100, 30));
            this.btnOK.setActionCommand("dalje");
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.btnOK.setShortcut("ctrl+w");
            this.pzPanel1 = new PzPanel();
            this.panelRazlog.add((Component)this.pzPanel1, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            GridBagLayout pzPanel1Layout = new GridBagLayout();
            pzPanel1Layout.columnWidths = new int[]{160, 7};
            pzPanel1Layout.rowHeights = new int[]{25, 25};
            pzPanel1Layout.columnWeights = new double[]{0.0, 0.1};
            pzPanel1Layout.rowWeights = new double[]{0.0, 0.0};
            this.pzPanel1.setBorder((Border)BorderFactory.createTitledBorder("Storno"));
            this.pzPanel1.setLayout((LayoutManager)pzPanel1Layout);
            this.pzPanel1.setOpaque(false);
            this.jLabel13 = new JLabel();
            this.pzPanel1.add((Component)this.jLabel13, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel13.setText("Vrednost u dinarima:");
            this.jLabel13.setFont(new Font("Tahoma", 1, 16));
            this.dfVrednostD = new PzDoubleField();
            this.pzPanel1.add((Component)this.dfVrednostD, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfVrednostD.setFont(new Font("Tahoma", 1, 14));
            this.dfVrednostD.setEditable(false);
            this.dfVrednostD.setForeground(new Color(0, 0, 255));
            this.dfVrednostD.setPreferredSize(new Dimension(150, 25));
            this.dfVrednostD.setSize(150, 25);
            this.dfVrednostD.setFocusable(false);
            this.jLabel3 = new JLabel();
            this.pzPanel1.add((Component)this.jLabel3, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel3.setText("Vrednost u valuti:");
            this.jLabel3.setFont(new Font("Tahoma", 1, 16));
            this.dfVrednostV = new PzDoubleField();
            this.pzPanel1.add((Component)this.dfVrednostV, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfVrednostV.setFont(new Font("Tahoma", 1, 14));
            this.dfVrednostV.setEditable(false);
            this.dfVrednostV.setForeground(new Color(0, 0, 255));
            this.dfVrednostV.setPreferredSize(new Dimension(150, 25));
            this.dfVrednostV.setSize(150, 25);
            this.dfVrednostV.setFocusable(false);
            this.cbKalkulacija = new PzCheckbox();
            this.panelRazlog.add((Component)this.cbKalkulacija, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.cbKalkulacija.setText("Napravi klakulaciju u pripremi");
            this.cbKalkulacija.setOpaque(false);
            this.cbKalkulacija.setSelected(true);
            this.setLocationRelativeTo(null);
            this.pack();
            this.setSize(1098, 618);
            this.setMinimumSize(new Dimension(1098, 618));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.icnSelektujSve) {
            this.table.checkAll();
        } else if (arg0.getSource() == this.icnDeselektujSve) {
            this.table.unCheckAll();
        } else if (arg0.getSource() == this.icnInverznaSelekcija) {
            this.table.inverseCheck();
        } else if (arg0.getSource() == this.icnSelektuj) {
            this.table.switchIt();
        } else {
            String actionCommand = ((AbstractButton)arg0.getSource()).getActionCommand();
            if (actionCommand.equalsIgnoreCase("kolicina")) {
                this.getSession().putParameter("tabela", (Object)this.table);
                this.getSession().putParameter("artikal", (Object)this.table.getSelectedEntity());
                this.showDialog(Kolicina.class);
            } else if (actionCommand.equals("arhiva")) {
                this.btnOK.setEnabled(true);
                this.icnArhiva.setActionCommand("dalje");
                this.razlog.getArea().requestFocusInWindow();
            } else if (actionCommand.equals("dalje")) {
                if (this.table.getCheckedEntities().size() == 0) {
                    JOptionPane.showMessageDialog(this.getParent(), "Mora biti selektovan barem jedan artikal!", "Informacija", 1);
                    return;
                }
                if (this.razlog.getVal().trim().length() == 0) {
                    JOptionPane.showMessageDialog(this.getParent(), "Morate uneti razlog storniranja!", "Informacija", 1);
                    this.razlog.requestFocusInWindow();
                    return;
                }
                this.arhiviraj(true);
            }
        }
    }

    private void arhiviraj(Boolean saPotvrdom) {
        Radnajedinica rj;
        EntityManager em;
        block7: {
            em = PzEntityManager.getEm();
            rj = null;
            if (!this.cbKalkulacija.isSelected() || (rj = PzDialogRJ.getRJ((PzDialog)this, (String)"Izaberite rj za kalkulaciju", (Character[])new Character[]{Character.valueOf('V'), Character.valueOf('E')})) != null) break block7;
            em.close();
            return;
        }
        try {
            try {
                em.getTransaction().begin();
                this.prijemnica.setArtikalopstidokuments(null);
                this.prijemnica.setArtikalcarinadokuments(this.table.getCheckedEntities());
                this.prijemnica.setDatum(this.datIzrade.getVal());
                this.prijemnica.setPoruka(this.razlog.getVal());
                this.prijemnica.setStorno(1);
                PzDokumentManager.getInstance().arhivirajStorno((PzDokument)this.prijemnica, PzEntityManager.KOLICINE_UMANJENJE, PzEntityManager.KOLICINA_UKUPNA, false, null, em);
                if (this.cbKalkulacija.isSelected()) {
                    Kalkulacija k = PzNabavkaUtil.convertCarinaToKalkulacija(this.prijemnica, rj, em);
                    PzDokumentManager.getInstance().snimiDokument((PzDokument)k, true, null, em);
                }
                em.getTransaction().commit();
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.prijemnica);
                ((PrijemniceIzArhive)((Object)this.getParent())).refreshData();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                PzSwingUtility.showErrorMessage((Component)this.scpArtikli, (String)"Gre\u0161ka prilikom storniranja prijemnice. Poku\u0161ajte ponovo.");
                em.close();
            }
        }
        catch (Throwable throwable) {
            em.close();
            throw throwable;
        }
        em.close();
        this.dispose();
    }

    private void azuriranjeStanja(CarinaDokument dok, EntityManager em) {
        for (Artikalcarinadokument art : dok.getArtikalcarinadokuments()) {
            Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(art.getSifra(), dok.getRadnajedinica()));
            s.setKolicina(s.getKolicina() - art.getKolicina());
            em.merge((Object)s);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new StornoPrijemnice(Boolean.FALSE);
    }

    public StornoPrijemnice(Boolean initGUI) {
    }
}

