/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui.kalkulacija;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.nabavka.gui.PzDialogKalkulacija;
import rs.pezar.nabavka.gui.kalkulacija.pdv.Dodavanje;
import rs.pezar.nabavka.gui.storniranjeKalkulacije.StornoKalkulacije;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.event.PzTablePropertyListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzGradient;

public class PzDialogPDV
extends PzDialog {
    private static final long serialVersionUID = -7745443644331406254L;
    private PzToolBarIcon icnDodavanje;
    private JPanel jPanel1;
    private PzToolBarIcon icnIzmena;
    private PzTable table;
    private JScrollPane scp;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanje;
    private StornoKalkulacije dlgStorno;
    private Kalkulacija kalkulacija;
    private PzDialogKalkulacija dlgKalk;
    private boolean storno;
    private PzPanel mainPanel;

    public PzDialogPDV(PzDialog parent) {
        super(parent);
        this.kalkulacija = (Kalkulacija)this.getSession().getParameter("kalkulacija");
        this.storno = (Boolean)this.getSession().getParameter("storno");
        if (this.storno) {
            this.dlgStorno = (StornoKalkulacije)parent;
        } else {
            this.dlgKalk = (PzDialogKalkulacija)parent;
        }
        this.initGUI();
        if (this.storno) {
            this.icnDodavanje.setEnabled(false);
        }
        this.paintPanel();
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            BorderLayout mainPanelLayout = new BorderLayout();
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.setTitle("PDV");
            this.jPanel1 = new JPanel();
            GridBagLayout jPanel1Layout = new GridBagLayout();
            jPanel1Layout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.rowHeights = new int[]{7, 7, 7, 7};
            jPanel1Layout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.columnWidths = new int[]{7, 7, 7, 7};
            this.jPanel1.setLayout(jPanel1Layout);
            this.mainPanel.add((Component)this.jPanel1, (Object)"Center");
            this.jPanel1.setPreferredSize(new Dimension(592, 272));
            this.jPanel1.setOpaque(false);
            this.scp = new JScrollPane();
            this.jPanel1.add((Component)this.scp, new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.scp.setBackground(new Color(211, 242, 210));
            this.table = new PzTable((List)((Vector)this.kalkulacija.getTaksakalkulacijas()), Taksakalkulacija.class);
            this.scp.setViewportView((Component)this.table);
            this.table.setPropertyListener(new PzTablePropertyListener(){

                public void entityRemoved(PzEntity entity) {
                    if (PzDialogPDV.this.table.getRowCount() == 0 && !PzDialogPDV.this.storno) {
                        PzDialogPDV.this.dlgKalk.getTableGroup().disableAll();
                    }
                    if (PzDialogPDV.this.storno) {
                        PzDialogPDV.this.dlgStorno.calculatePDV();
                    } else {
                        PzDialogPDV.this.dlgKalk.calculatePDV();
                    }
                }

                public void entityAdded(PzEntity entity) {
                    if (PzDialogPDV.this.storno) {
                        PzDialogPDV.this.dlgStorno.calculatePDV();
                    } else {
                        PzDialogPDV.this.dlgKalk.getTableGroup().enableAll();
                        PzDialogPDV.this.dlgKalk.calculatePDV();
                    }
                }
            });
            this.toolbar = new JToolBar();
            this.toolbar.setOpaque(false);
            this.toolbar.setFloatable(false);
            this.mainPanel.add((Component)this.toolbar, (Object)"North");
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/row_add.png")));
            this.icnDodavanje.setText("Dodavanje|(INS)");
            this.icnDodavanje.setActionCommand("Dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/row_edit.png")));
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/row_delete.png")));
            this.icnBrisanje.setText("Brisanje| (DEL)");
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("DELETE");
            this.setSize(600, 400);
            this.setMinimumSize(new Dimension(600, 400));
            this.setLocationRelativeTo(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        try {
            boolean izmena = false;
            PzToolBarIcon icon = (PzToolBarIcon)arg0.getSource();
            String actionCommand = icon.getActionCommand();
            if (this.table.getSelectedEntity() != null) {
                if (actionCommand.equalsIgnoreCase("Brisanje")) {
                    if (this.storno) {
                        this.table.removeSelectedEntity(true, false);
                    } else {
                        this.table.removeSelectedEntity(true, true);
                    }
                }
                if (actionCommand.equalsIgnoreCase("Izmena")) {
                    izmena = true;
                    this.getSession().putParameter("kalkulacija", (Object)this.kalkulacija);
                    this.getSession().putParameter("update", (Object)izmena);
                    this.getSession().putParameter("table", (Object)this.table);
                    this.showDialog(Dodavanje.class);
                    return;
                }
            }
            if (actionCommand.equalsIgnoreCase("dodavanje")) {
                this.getSession().putParameter("kalkulacija", (Object)this.kalkulacija);
                this.getSession().putParameter("update", (Object)izmena);
                this.getSession().putParameter("table", (Object)this.table);
                this.showDialog(Dodavanje.class);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPDV(Boolean.FALSE);
    }

    public PzDialogPDV(Boolean initGUI) {
    }
}

