/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.db.entity.Trosak;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.nabavka.gui.korekcije.UzmiDokument;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogVratiKalkulacijuUPripremu
extends PzDialog {
    private PzPanel pnlGlavni;
    private PzRadioGroup<String> panelRBs;
    private PzPanel pnlFields;
    private JPanel pnlButton;
    private PzTextField tfOznakaDokumenta;
    private PzTextField tfNazivDobavljaca;
    private PzTextField tfSifraDobavljaca;
    private PzNumericOnlyTextField tfBrojKalkulacije;
    private JLabel lblOznakaDokumenta;
    private JLabel lblSifraDobavljaca;
    private PzPanel pnlRadioButton;
    private JLabel lblBrojKalkulacije;
    private PzButton btnPotvrdi;
    private Radnajedinica rj;
    private Kalkulacija kalkulacija;
    private PzDialog thisDialog;
    private String parameter;

    public PzDialogVratiKalkulacijuUPripremu(JFrame frame, String parameter) {
        super(frame);
        this.parameter = parameter;
        this.thisDialog = this;
        this.initGUI();
    }

    public PzDialogVratiKalkulacijuUPripremu(PzDialog dialog) {
        super(dialog);
        this.parameter = "isporuka";
        this.thisDialog = this;
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{12, 68, 48, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{23, 135, 85, 97, 94, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(2, 0, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{12, 25, 25, 25, 25, 7};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{100, 136, 7};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.pnlFields.setOpaque(false);
            this.lblBrojKalkulacije = new JLabel();
            this.pnlFields.add((Component)this.lblBrojKalkulacije, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.lblBrojKalkulacije.setName("lblBrojKalkulacije");
            this.lblSifraDobavljaca = new JLabel();
            this.pnlFields.add((Component)this.lblSifraDobavljaca, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.lblSifraDobavljaca.setName("lblSifraDobavljaca");
            this.lblOznakaDokumenta = new JLabel();
            this.pnlFields.add((Component)this.lblOznakaDokumenta, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.lblOznakaDokumenta.setName("lblOznakaDokumenta");
            this.tfBrojKalkulacije = new PzNumericOnlyTextField();
            this.pnlFields.add((Component)this.tfBrojKalkulacije, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfBrojKalkulacije.setMaxLength(5);
            this.tfBrojKalkulacije.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogVratiKalkulacijuUPripremu.this.tfBrojKalkulacije.getIntVal() == 0) {
                        return false;
                    }
                    if (PzDialogVratiKalkulacijuUPripremu.this.getKalkulacija(false)) {
                        PzDialogVratiKalkulacijuUPripremu.this.tfSifraDobavljaca.setVal((Object)PzDialogVratiKalkulacijuUPripremu.this.kalkulacija.getKomitent().getSfrKomitent());
                        PzDialogVratiKalkulacijuUPripremu.this.tfNazivDobavljaca.setVal((Object)PzDialogVratiKalkulacijuUPripremu.this.kalkulacija.getKomitent().getNaziv());
                        PzDialogVratiKalkulacijuUPripremu.this.tfOznakaDokumenta.setVal((Object)PzDialogVratiKalkulacijuUPripremu.this.kalkulacija.getOznDokumenta());
                        return true;
                    }
                    PzDialogVratiKalkulacijuUPripremu.this.cleanFields();
                    return false;
                }
            });
            this.tfSifraDobavljaca = new PzTextField();
            this.pnlFields.add((Component)this.tfSifraDobavljaca, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfSifraDobavljaca.setFocusable(false);
            this.tfSifraDobavljaca.setEditable(false);
            this.tfSifraDobavljaca.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    block4: {
                        if (PzDialogVratiKalkulacijuUPripremu.this.tfSifraDobavljaca.getVal().equals("")) {
                            return false;
                        }
                        try {
                            Komitent dobavljac = (Komitent)PzEntityManager.find(Komitent.class, (Object)PzDialogVratiKalkulacijuUPripremu.this.tfSifraDobavljaca.getVal());
                            if (dobavljac != null) {
                                PzDialogVratiKalkulacijuUPripremu.this.tfNazivDobavljaca.setVal((Object)dobavljac.getNaziv());
                                break block4;
                            }
                            PzSwingUtility.showErrorMessage((Component)PzDialogVratiKalkulacijuUPripremu.this.thisDialog, (String)"Sifra komitenta nije u bazi podataka");
                            return false;
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)PzDialogVratiKalkulacijuUPripremu.this.thisDialog, (Throwable)e);
                            return false;
                        }
                    }
                    return true;
                }
            });
            this.tfNazivDobavljaca = new PzTextField();
            this.pnlFields.add((Component)this.tfNazivDobavljaca, (Object)new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 10), 0, 0));
            this.tfNazivDobavljaca.setFocusable(false);
            this.tfNazivDobavljaca.setEditable(false);
            this.tfOznakaDokumenta = new PzTextField();
            this.pnlFields.add((Component)this.tfOznakaDokumenta, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfOznakaDokumenta.setMaxLength(30);
            this.tfOznakaDokumenta.setFocusable(false);
            this.tfOznakaDokumenta.setEditable(false);
            this.tfOznakaDokumenta.setInputVerifier(new InputVerifier(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public boolean verify(JComponent input) {
                    if (PzDialogVratiKalkulacijuUPripremu.this.tfOznakaDokumenta.getVal().equals("")) {
                        PzDialogVratiKalkulacijuUPripremu.this.getSession().putParameter("radnajedinica", (Object)PzDialogVratiKalkulacijuUPripremu.this.rj);
                        PzDialogVratiKalkulacijuUPripremu.this.getSession().putParameter("sifraDobavljaca", (Object)PzDialogVratiKalkulacijuUPripremu.this.tfSifraDobavljaca.getVal());
                        PzDialogVratiKalkulacijuUPripremu.this.showDialog(UzmiDokument.class);
                        if (PzDialogVratiKalkulacijuUPripremu.this.tfOznakaDokumenta.getVal().equals("") || !PzDialogVratiKalkulacijuUPripremu.this.getKalkulacija(true)) return false;
                        PzDialogVratiKalkulacijuUPripremu.this.tfBrojKalkulacije.setVal((Object)PzDialogVratiKalkulacijuUPripremu.this.kalkulacija.getrBroj());
                        return true;
                    } else {
                        if (!PzDialogVratiKalkulacijuUPripremu.this.getKalkulacija(true)) return true;
                        PzDialogVratiKalkulacijuUPripremu.this.tfBrojKalkulacije.setVal((Object)PzDialogVratiKalkulacijuUPripremu.this.kalkulacija.getrBroj());
                    }
                    return true;
                }
            });
            this.pnlButton = new JPanel();
            this.pnlGlavni.add((Component)this.pnlButton, (Object)new GridBagConstraints(0, 3, 6, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlButton.setOpaque(false);
            this.btnPotvrdi = new PzButton();
            this.pnlButton.add((Component)this.btnPotvrdi, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 25, 0, 25), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(144, 36));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pnlRadioButton = new PzPanel();
            this.pnlGlavni.add((Component)this.pnlRadioButton, (Object)new GridBagConstraints(0, 0, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlRadioButton.setOpaque(false);
            this.panelRBs = new PzRadioGroup((Object[])new String[]{"Po broju kalkulacije", "Po oznaci dokumenta"});
            this.pnlRadioButton.add(this.panelRBs);
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRBs, 1);
            this.panelRBs.setLayout((LayoutManager)panelRBsLayout);
            this.panelRBs.setBorder((Border)BorderFactory.createTitledBorder("Izbor dokumenta"));
            this.panelRBs.setSelectedValue((Object)"Po broju kalkulacije");
            this.panelRBs.setPreferredSize(new Dimension(142, 73));
            this.panelRBs.setOpaque(false);
            this.panelRBs.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getValue().equals("Po broju kalkulacije")) {
                        PzDialogVratiKalkulacijuUPripremu.this.tfBrojKalkulacije.setFocusable(true);
                        PzDialogVratiKalkulacijuUPripremu.this.tfBrojKalkulacije.setEditable(true);
                        PzDialogVratiKalkulacijuUPripremu.this.setEditableAndFocusable(false);
                        PzDialogVratiKalkulacijuUPripremu.this.cleanFields();
                    } else if (evt.getValue().equals("Po oznaci dokumenta")) {
                        PzDialogVratiKalkulacijuUPripremu.this.tfBrojKalkulacije.setFocusable(false);
                        PzDialogVratiKalkulacijuUPripremu.this.tfBrojKalkulacije.setEditable(false);
                        PzDialogVratiKalkulacijuUPripremu.this.setEditableAndFocusable(true);
                        PzDialogVratiKalkulacijuUPripremu.this.cleanFields();
                    }
                }
            });
            this.pack();
            this.setSize(573, 215);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void setOznakaDokumenta(String oznaka) {
        this.tfOznakaDokumenta.setVal((Object)oznaka);
    }

    public void setEditableAndFocusable(boolean editableFocusable) {
        this.tfOznakaDokumenta.setFocusable(editableFocusable);
        this.tfSifraDobavljaca.setFocusable(editableFocusable);
        this.tfOznakaDokumenta.setEditable(editableFocusable);
        this.tfSifraDobavljaca.setEditable(editableFocusable);
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (actionCommand.equals("potvrdi")) {
                    if (this.parameter.equals("isporuka")) {
                        this.getSession().putParameter("kalkulacija", (Object)this.kalkulacija);
                    } else {
                        if (this.kalkulacija.getDokument().getProknjizen() == 1) {
                            throw new PzInfoException("Ne mo\u017eete vratiti dokument u pripremu jer je proknji\u017een u finansijskom knjigovodstvu.");
                        }
                        em.getTransaction().begin();
                        Vector<String> nemaDovoljno = new Vector<String>();
                        for (Artikalkalkulacija artikal : this.kalkulacija.getArtikalkalkulacijas()) {
                            StanjePK spk = new StanjePK(artikal.getId().getSfrProizvod(), this.kalkulacija.getRadnajedinica().getId().getOznOgranak(), this.kalkulacija.getRadnajedinica().getId().getOznRj());
                            Stanje s = (Stanje)em.find(Stanje.class, (Object)spk);
                            if (!(s.getRaspolozivaKolicina() < artikal.getKolicina()) || !this.kalkulacija.getRadnajedinica().getMinusKolicine().equals("DOZVOLJEN")) continue;
                            nemaDovoljno.add(" [ " + artikal.getId().getSfrProizvod() + " ] " + artikal.getNaziv());
                        }
                        if (nemaDovoljno.size() > 0) {
                            String poruka = "Slede\u0107i artikli nemaju dovoljno raspolo\u017eive koli\u010dine:\n";
                            for (String str : nemaDovoljno) {
                                poruka = String.valueOf(poruka) + str + "\n";
                            }
                            int izbor = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)(poruka = String.valueOf(poruka) + "Ukoliko vratite kalkulaciju u pripremu, navedeni artikli \u0107e oti\u0107i u minus sa koli\u010dinom.\nDa li ste sigurni da to \u017eelite?"), (String)"Nedovoljna koli\u010dina", null, (boolean)true);
                            if (izbor != 0) {
                                throw new PzInfoException("Operacija vra\u0107anja dokumenta u pripremu je obustavljena.");
                            }
                        }
                        this.kalkulacija.setArhiviran((short)0);
                        this.kalkulacija.getDokument().setArhiviran((short)0);
                        if (this.kalkulacija.getTrosaks() != null && this.kalkulacija.getTrosaks().size() > 0) {
                            for (Trosak tr : this.kalkulacija.getTrosaks()) {
                                tr.setArhiviran((short)0);
                                tr.getDokument().setArhiviran((short)0);
                            }
                        }
                        Pzuser user = (Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername());
                        this.kalkulacija.createLog(5, null, user, em);
                        this.kalkulacija.setUserKraj(user);
                        for (Artikalkalkulacija artikal : this.kalkulacija.getArtikalkalkulacijas()) {
                            StanjePK spk = new StanjePK(artikal.getId().getSfrProizvod(), this.kalkulacija.getRadnajedinica().getId().getOznOgranak(), this.kalkulacija.getRadnajedinica().getId().getOznRj());
                            Stanje s = (Stanje)em.find(Stanje.class, (Object)spk);
                            if (s.getRaspolozivaKolicina() >= artikal.getKolicina() || this.kalkulacija.getRadnajedinica().getMinusKolicine().equals("DOZVOLJEN")) {
                                s.setKolicina(s.getKolicina() - artikal.getKolicina());
                                s.setKumUlaza(s.getKumUlaza() - artikal.getKolicina());
                                continue;
                            }
                            throw new PzInfoException("Artikal [ " + artikal.getId().getSfrProizvod() + " ] " + artikal.getNaziv() + " nema dovoljno raspolo\u017eive koli\u010dine, a odlazak u minus nije dozoljen. Operacija obustavljena!!!");
                        }
                        if (this.kalkulacija.getTaksakalkulacijas() != null) {
                            Iterator iterator = this.kalkulacija.getTaksakalkulacijas().iterator();
                            while (iterator.hasNext()) {
                                Taksakalkulacija tk = (Taksakalkulacija)iterator.next();
                                if (!tk.getTip().equals(PzTaksaDokument.TIP_UKALKULISANI) && !tk.getTip().equals(PzTaksaDokument.TIP_IZRACUNATI)) continue;
                                iterator.remove();
                            }
                        }
                        em.merge((Object)this.kalkulacija);
                        em.getTransaction().commit();
                        JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Kalkulacija broj " + this.kalkulacija.getrBroj() + " je vra\u0107ena u pripremu.", "Informacija", 1);
                    }
                    this.dispose();
                }
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    public void cleanFields() {
        this.tfBrojKalkulacije.setText("");
        this.tfSifraDobavljaca.setText("");
        this.tfNazivDobavljaca.setText("");
        this.tfOznakaDokumenta.setText("");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldBeShown() {
        block7: {
            if (this.parameter.equals("isporuka")) {
                this.pnlGlavni.setPaintGradient(true);
                if (this.getSession().getParameter("gradient") != null) {
                    this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
                } else {
                    this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
                }
            } else {
                this.pnlGlavni.setPaintGradient(true);
            }
            try {
                this.rj = PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("E".charAt(0))});
                if (this.rj == null) return false;
                if (!this.rj.getNacinVodjenja().equals("PRNC")) break block7;
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Modul ne radi u sistemu pra\u0107enja magacina po PRNC");
                return false;
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                return false;
            }
        }
        this.setTitle("KOREKCIJE KALKULACIJE U RJ: " + this.rj.getId().getOznRj() + " " + this.rj.getNaziv());
        return true;
    }

    public boolean getKalkulacija(boolean poOznaci) {
        boolean res = false;
        try {
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            q = poOznaci ? em.createQuery("SELECT k FROM Kalkulacija k WHERE k.tip=:tip AND k.arhiviran=1 and k.radnajedinica=:rj and k.komitent.sfrKomitent=:sifra and k.oznDokumenta=:oznaka") : em.createQuery("SELECT k FROM Kalkulacija k WHERE k.tip=:tip AND k.arhiviran=1 and k.radnajedinica=:rj and k.rBroj=:broj");
            if (poOznaci) {
                q.setParameter("sifra", (Object)this.tfSifraDobavljaca.getVal());
                q.setParameter("oznaka", (Object)this.tfOznakaDokumenta.getVal());
            } else {
                q.setParameter("broj", (Object)this.tfBrojKalkulacije.getIntVal());
            }
            q.setParameter("rj", (Object)this.rj);
            q.setParameter("tip", (Object)TipDokumentConfig.get().KALKULACIJA);
            if (q.getResultList().size() == 0) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Tra\u017eeni broj kalkulacije NIJE PRONA\u0110EN!!!");
            } else if (q.getResultList().size() > 1) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Kalkulacija ima storno dokument. Dalji rad NEMOGU\u0106!!!");
            } else if (q.getResultList().size() == 1) {
                this.kalkulacija = (Kalkulacija)q.getSingleResult();
                res = true;
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
        return res;
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogVratiKalkulacijuUPripremu(Boolean.FALSE);
    }

    public PzDialogVratiKalkulacijuUPripremu(Boolean initGUI) {
    }
}

