/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.dataimport.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.nabavka.dataimport.DataImporterOptionsPanel;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzDialogDataImport
extends PzDialog {
    private static final long serialVersionUID = -7466849259088568673L;
    private PzButton btnPrev;
    private PzButton btnCancel;
    private PzButton btnNext;
    private PzPanel pnlButtons;
    private PzPanelHeader header;
    private PzPanel pnlContent;
    List<DataImporterOptionsPanel> panels = new Vector<DataImporterOptionsPanel>();
    private DataImporterOptionsPanel active = null;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogDataImport inst = new PzDialogDataImport(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogDataImport(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogDataImport(PzDialog parent) {
        super(parent);
        this.panels = (List)this.getSession().getParameter("OPTIONS_PANELS");
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Uvoz podataka");
            this.setRestorable(false);
            this.pnlContent = new PzPanel();
            GridBagLayout pnlContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlContent, "Center");
            pnlContentLayout.rowWeights = new double[]{0.0, 0.1, 0.0};
            pnlContentLayout.rowHeights = new int[]{7, 7, 7};
            pnlContentLayout.columnWeights = new double[]{0.1};
            pnlContentLayout.columnWidths = new int[]{7};
            this.pnlContent.setLayout((LayoutManager)pnlContentLayout);
            this.pnlContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.header = new PzPanelHeader();
            this.header.setTitle("Uvoz podataka sa fakture dobavljaca");
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/import2.png")));
            this.pnlContent.add((Component)this.header, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlButtons = new PzPanel();
            FlowLayout pnlButtonsLayout = new FlowLayout();
            pnlButtonsLayout.setHgap(15);
            pnlButtonsLayout.setAlignment(2);
            this.pnlButtons.setLayout((LayoutManager)pnlButtonsLayout);
            this.pnlContent.add((Component)this.pnlButtons, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnCancel = new PzButton();
            this.pnlButtons.add((Component)this.btnCancel);
            this.btnCancel.setText("Otka\u017ei");
            this.btnCancel.setName("btnCancel");
            this.btnCancel.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/forbidden.png")));
            this.btnCancel.setPreferredSize(new Dimension(100, 31));
            this.btnCancel.addActionListener((ActionListener)((Object)this));
            this.btnPrev = new PzButton();
            this.pnlButtons.add((Component)this.btnPrev);
            this.btnPrev.setName("btnPrev");
            this.btnPrev.setText("Nazad");
            this.btnPrev.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/arrow_left_blue.png")));
            this.btnPrev.setPreferredSize(new Dimension(100, 31));
            this.btnPrev.addActionListener((ActionListener)((Object)this));
            this.btnNext = new PzButton();
            this.pnlButtons.add((Component)this.btnNext);
            this.btnNext.setName("btnNext");
            this.btnNext.setText("Dalje");
            this.btnNext.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/arrow_right_blue.png")));
            this.btnNext.setPreferredSize(new Dimension(100, 31));
            this.btnNext.addActionListener((ActionListener)((Object)this));
            this.getRootPane().setDefaultButton((JButton)this.btnNext);
            if (this.panels.size() > 0) {
                this.display(this.panels.get(0));
            }
            this.setSize(600, 550);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addOptionsPanel(DataImporterOptionsPanel pnl) {
        this.panels.add(pnl);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnNext) {
            this.next();
        } else if (e.getSource() == this.btnPrev) {
            this.previous();
        } else if (e.getSource() == this.btnCancel) {
            this.dispose();
        }
    }

    public void display(DataImporterOptionsPanel pnl) {
        if (this.active != null) {
            this.pnlContent.remove((Component)((Object)this.active));
        }
        if (pnl == null) {
            return;
        }
        this.active = pnl;
        this.active.panelExposed();
        this.pnlContent.add((Component)((Object)this.active), (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.repaint();
        this.header.setText(this.active.getDescription());
    }

    private void next() {
        int pos = this.panels.indexOf((Object)this.active);
        try {
            this.panels.get(pos).validateInputs();
            if (++pos == this.panels.size()) {
                this.end();
            } else {
                this.display(this.panels.get(pos));
            }
        }
        catch (Exception e) {
            --pos;
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void previous() {
        int pos = this.panels.indexOf((Object)this.active);
        pos = pos > 0 ? pos - 1 : 0;
        this.display(this.panels.get(pos));
    }

    private void end() {
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        for (DataImporterOptionsPanel pnl : this.panels) {
            options.putAll(pnl.getOptions());
        }
        this.getSession().putParameter("USER_OPTIONS", options);
        this.dispose();
    }
}

