/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.magacin.gui.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class ESCPrinter {
    private String printer;
    private boolean escp24pin;
    private FileOutputStream ostream;
    private PrintStream pstream;
    private boolean streamOpenSuccess;
    private static int MAX_ADVANCE_9PIN = 216;
    private static int MAX_ADVANCE_24PIN = 180;
    private static int MAX_UNITS = 127;
    private static final float CM_PER_INCH = 2.54f;
    private static final char ESC = '\u001b';
    private static final char AT = '@';
    private static final char LINE_FEED = '\n';
    private static final char PARENTHESIS_LEFT = '(';
    private static final char BACKSLASH = '\\';
    private static final char CR = '\r';
    private static final char TAB = '\t';
    private static final char FF = '\f';
    private static final char g = 'g';
    private static final char p = 'p';
    private static final char t = 't';
    private static final char l = 'l';
    private static final char x = 'x';
    private static final char E = 'E';
    private static final char F = 'F';
    private static final char J = 'J';
    private static final char P = 'P';
    private static final char Q = 'Q';
    private static final char $ = '$';
    private static final char PAGE_LENGTH = 'C';
    private static final char PAGE_LENGTH_INCHES = '0';
    private static final char ARGUMENT_0 = '\u0000';
    private static final char ARGUMENT_1 = '\u0001';
    private static final char ARGUMENT_2 = '\u0002';
    private static final char ARGUMENT_3 = '\u0003';
    private static final char ARGUMENT_4 = '\u0004';
    private static final char ARGUMENT_5 = '\u0005';
    private static final char ARGUMENT_6 = '\u0006';
    private static final char ARGUMENT_7 = '\u0007';
    private static final char ARGUMENT_25 = '\u0019';
    public static final char USA = '\u0001';
    public static final char BRAZIL = '\u0019';

    public ESCPrinter(String printer, boolean escp24pin) {
        this.printer = printer;
        this.escp24pin = escp24pin;
    }

    public void close() {
        try {
            this.pstream.close();
            this.ostream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean initialize() {
        this.streamOpenSuccess = false;
        try {
            this.ostream = new FileOutputStream(this.printer);
            this.pstream = new PrintStream(this.ostream);
            this.pstream.print('\u001b');
            this.pstream.print('@');
            this.select10CPI();
            this.selectDraftPrinting();
            this.setCharacterSet('\u0001');
            this.streamOpenSuccess = true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return this.streamOpenSuccess;
    }

    public void select10CPI() {
        this.pstream.print('\u001b');
        this.pstream.print('P');
    }

    public void select15CPI() {
        this.pstream.print('\u001b');
        this.pstream.print('g');
    }

    public void selectDraftPrinting() {
        this.pstream.print('\u001b');
        this.pstream.print('x');
        this.pstream.print('0');
    }

    public void selectLQPrinting() {
        this.pstream.print('\u001b');
        this.pstream.print('x');
        this.pstream.print('1');
    }

    public void setCharacterSet(char charset) {
        this.pstream.print('\u001b');
        this.pstream.print('(');
        this.pstream.print('t');
        this.pstream.print('\u0003');
        this.pstream.print('\u0000');
        this.pstream.print('\u0001');
        this.pstream.print(charset);
        this.pstream.print('\u0000');
        this.pstream.print('\u001b');
        this.pstream.print('t');
        this.pstream.print('\u0001');
    }

    public void lineFeed() {
        this.pstream.print('\r');
        this.pstream.print('\n');
    }

    public void formFeed() {
        this.pstream.print('\r');
        this.pstream.print('\f');
    }

    public void bold(boolean bold) {
        this.pstream.print('\u001b');
        if (bold) {
            this.pstream.print('E');
        } else {
            this.pstream.print('F');
        }
    }

    public void proportionalMode(boolean proportional) {
        this.pstream.print('\u001b');
        this.pstream.print('p');
        if (proportional) {
            this.pstream.print('1');
        } else {
            this.pstream.print('0');
        }
    }

    public void advanceVertical(float centimeters) {
        float inches = centimeters / 2.54f;
        int units = (int)(inches * (float)(this.escp24pin ? MAX_ADVANCE_24PIN : MAX_ADVANCE_9PIN));
        while (units > 0) {
            char n = units > MAX_UNITS ? (char)MAX_UNITS : (char)units;
            this.pstream.print('\u001b');
            this.pstream.print('J');
            this.pstream.print(n);
            units -= MAX_UNITS;
        }
    }

    public void advanceHorizontal(float centimeters) {
        float inches = centimeters / 2.54f;
        int units_low = (int)(inches * 120.0f) % 256;
        int units_high = (int)(inches * 120.0f) / 256;
        this.pstream.print('\u001b');
        this.pstream.print('\\');
        this.pstream.print((char)units_low);
        this.pstream.print((char)units_high);
    }

    public void setAbsoluteHorizontalPosition(float centimeters) {
        float inches = centimeters / 2.54f;
        int units_low = (int)(inches * 60.0f) % 256;
        int units_high = (int)(inches * 60.0f) / 256;
        this.pstream.print('\u001b');
        this.pstream.print('$');
        this.pstream.print((char)units_low);
        this.pstream.print((char)units_high);
    }

    public void horizontalTab(int tabs) {
        int i = 0;
        while (i < tabs) {
            this.pstream.print('\t');
            ++i;
        }
    }

    public void setMargins(int columnsLeft, int columnsRight) {
        this.pstream.print('\u001b');
        this.pstream.print('l');
        this.pstream.print((char)columnsLeft);
        this.pstream.print('\u001b');
        this.pstream.print('Q');
        this.pstream.print((char)columnsRight);
    }

    public void setPageLength(float centimeters) {
        float inches = centimeters / 2.54f;
        if (this.escp24pin) {
            // empty if block
        }
        this.pstream.print('\u001b');
        this.pstream.print('C');
        this.pstream.print('0');
        this.pstream.print((char)inches);
    }

    public void print(String text) {
        this.pstream.print(text);
    }

    public void printWithTags(String text) {
        new StringBuffer();
        StringBuffer b = new StringBuffer();
        boolean more = true;
        int i = 0;
        while (more && text.length() > 0) {
            char c = text.charAt(i);
            if (c == '$' && text.charAt(i + 1) == '{') {
                String substr = text.substring(i += 2);
                int k = 0;
                while (substr.charAt(k) != '}') {
                    ++k;
                }
                i += k;
                String[] commandsStr = substr.substring(0, k).split(" ");
                char[] commandsChr = new char[commandsStr.length];
                int j = 0;
                while (j < commandsChr.length) {
                    commandsChr[j] = (char)Integer.parseInt(commandsStr[j]);
                    ++j;
                }
                more = false;
                this.pstream.print(b.toString());
                this.pstream.print(commandsChr);
                this.printWithTags(text.substring(i + 1));
                continue;
            }
            b.append(c);
            boolean bl = more = ++i != text.length();
            if (more) continue;
            this.pstream.print(b.toString());
        }
    }

    private char[] getCommand(String substr, int i) {
        int k = 0;
        while (substr.charAt(k) != '}') {
            ++k;
        }
        String[] commandsStr = substr.substring(0, k).split(" ");
        char[] commandsChr = new char[commandsStr.length];
        int j = 0;
        while (j < commandsChr.length) {
            commandsChr[j] = (char)Integer.parseInt(commandsStr[j]);
            ++j;
        }
        return commandsChr;
    }

    public boolean isInitialized() {
        return this.streamOpenSuccess;
    }

    public String getShare() {
        return this.printer;
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        strb.append("<ESCPrinter[share=").append(this.printer).append(", 24pin=").append(this.escp24pin).append("]>");
        return strb.toString();
    }
}

