/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.magacin.gui.stampanjeNalepnica;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.magacin.gui.PzDialogStampanjeNalepnica;
import rs.pezar.magacin.gui.stampanjeNalepnica.UzmiDokument;
import rs.pezar.magacin.gui.util.PzMagacinUtil;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;

public class DopunaPremaKalkulaciji
extends PzDialog {
    private PzPanel pnlGlavni;
    private JLabel lblBrojKalkulacije;
    private JLabel lblSifraDobavljaca;
    private PzTextField tfOznakaDokumenta;
    private PzTextField tfSifraDobavljaca;
    private PzNumericOnlyTextField tfBrojKalkulacije;
    private JLabel lblOznakaDokumenta;
    private Kalkulacija kalkulacija;
    private Radnajedinica rj;
    private Komitent komitent;
    private Artikal artikal;
    private PzTable tabela;

    public DopunaPremaKalkulaciji(PzDialog dialog) {
        super(dialog);
        this.rj = (Radnajedinica)this.getSession().getParameter("radnajedinica");
        this.tabela = (PzTable)this.getSession().getParameter("tabela");
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("DOPUNA PREMA KALKULACIJI");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{29, 25, 25, 25, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{145, 75, 75, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.lblBrojKalkulacije = new JLabel();
            this.pnlGlavni.add((Component)this.lblBrojKalkulacije, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 30, 0, 0), 0, 0));
            this.lblBrojKalkulacije.setName("lblBrojKalkulacije");
            this.lblSifraDobavljaca = new JLabel();
            this.pnlGlavni.add((Component)this.lblSifraDobavljaca, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 30, 0, 0), 0, 0));
            this.lblSifraDobavljaca.setName("lblSifraDobavljaca");
            this.lblOznakaDokumenta = new JLabel();
            this.pnlGlavni.add((Component)this.lblOznakaDokumenta, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 30, 0, 0), 0, 0));
            this.lblOznakaDokumenta.setName("lblOznakaDokumenta");
            this.tfBrojKalkulacije = new PzNumericOnlyTextField();
            this.pnlGlavni.add((Component)this.tfBrojKalkulacije, (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfBrojKalkulacije.setBackground(new Color(255, 255, 255));
            this.tfBrojKalkulacije.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == 10) {
                        if (DopunaPremaKalkulaciji.this.tfBrojKalkulacije.getIntVal() != 0) {
                            DopunaPremaKalkulaciji.this.kalkulacija = DopunaPremaKalkulaciji.this.getKalkulacija(true);
                            if (DopunaPremaKalkulaciji.this.kalkulacija == null) {
                                JOptionPane.showMessageDialog((Component)((Object)DopunaPremaKalkulaciji.this), "Tra\u017eeni broj kalkulacije nije proja\u0111en!!!", "Informacija", 1);
                            } else {
                                System.out.println("Nasao je kalkulaciju" + DopunaPremaKalkulaciji.this.kalkulacija.getOznDokumenta() + " iddok" + DopunaPremaKalkulaciji.this.kalkulacija.getId());
                                DopunaPremaKalkulaciji.this.napraviNalepnice(DopunaPremaKalkulaciji.this.kalkulacija);
                                DopunaPremaKalkulaciji.this.dispose();
                            }
                        } else {
                            DopunaPremaKalkulaciji.this.tfSifraDobavljaca.setFocusable(true);
                            DopunaPremaKalkulaciji.this.tfOznakaDokumenta.setFocusable(true);
                            DopunaPremaKalkulaciji.this.tfSifraDobavljaca.setEditable(true);
                            DopunaPremaKalkulaciji.this.tfOznakaDokumenta.setEditable(true);
                        }
                    }
                }
            });
            this.tfSifraDobavljaca = new PzTextField();
            this.pnlGlavni.add((Component)this.tfSifraDobavljaca, (Object)new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfSifraDobavljaca.setFocusable(false);
            this.tfSifraDobavljaca.setEditable(false);
            this.tfSifraDobavljaca.setBackground(new Color(255, 255, 255));
            this.tfSifraDobavljaca.setInputVerifier(new InputVerifier(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public boolean verify(JComponent input) {
                    if (DopunaPremaKalkulaciji.this.tfSifraDobavljaca.getVal().equals("")) {
                        DopunaPremaKalkulaciji.this.komitent = PzDialogKomintenti.getKomitent((PzDialog)DopunaPremaKalkulaciji.this);
                        if (DopunaPremaKalkulaciji.this.komitent == null) return false;
                        DopunaPremaKalkulaciji.this.tfSifraDobavljaca.setVal((Object)DopunaPremaKalkulaciji.this.komitent.getSfrKomitent());
                        return true;
                    } else {
                        EntityManager em = PzEntityManager.getEm();
                        DopunaPremaKalkulaciji.this.komitent = (Komitent)em.find(Komitent.class, (Object)DopunaPremaKalkulaciji.this.tfSifraDobavljaca.getVal());
                        if (DopunaPremaKalkulaciji.this.komitent != null) return true;
                        JOptionPane.showMessageDialog((Component)((Object)DopunaPremaKalkulaciji.this), "Podatak sa izabranom \u0161ifrom ne postoji u bazi! Molim izaberite drugu \u0161ifru.", "Informacija", 1);
                        return false;
                    }
                }
            });
            this.tfOznakaDokumenta = new PzTextField();
            this.pnlGlavni.add((Component)this.tfOznakaDokumenta, (Object)new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfOznakaDokumenta.setFocusable(false);
            this.tfOznakaDokumenta.setEditable(false);
            this.tfOznakaDokumenta.setBackground(new Color(255, 255, 255));
            this.tfOznakaDokumenta.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (DopunaPremaKalkulaciji.this.tfOznakaDokumenta.getVal().equals("")) {
                        DopunaPremaKalkulaciji.this.getSession().putParameter("tip", (Object)TipDokumentConfig.get().KALKULACIJA);
                        DopunaPremaKalkulaciji.this.getSession().putParameter("komitent", (Object)DopunaPremaKalkulaciji.this.komitent.getSfrKomitent());
                        DopunaPremaKalkulaciji.this.getSession().putParameter("radnajedinica", (Object)DopunaPremaKalkulaciji.this.rj);
                        DopunaPremaKalkulaciji.this.showDialog(UzmiDokument.class);
                        DopunaPremaKalkulaciji.this.dispose();
                    } else {
                        DopunaPremaKalkulaciji.this.kalkulacija = DopunaPremaKalkulaciji.this.getKalkulacija(false);
                        if (DopunaPremaKalkulaciji.this.kalkulacija == null) {
                            JOptionPane.showMessageDialog((Component)((Object)DopunaPremaKalkulaciji.this), "Tra\u017eeni dokument nije prona\u0111en!", "Informacija", 1);
                            return false;
                        }
                        DopunaPremaKalkulaciji.this.napraviNalepnice(DopunaPremaKalkulaciji.this.kalkulacija);
                        DopunaPremaKalkulaciji.this.dispose();
                    }
                    return true;
                }
            });
            this.pack();
            this.setSize(346, 170);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void napraviNalepnice(final Kalkulacija kal) {
        final EntityManager em = PzEntityManager.getEm();
        PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                em.getTransaction().begin();
                String firma = PzFirma.getFirma().getNaziv();
                for (Artikalkalkulacija art : kal.getArtikalkalkulacijas()) {
                    if (PzMagacinUtil.postojiArtikal(DopunaPremaKalkulaciji.this.tabela, art.getId().getSfrProizvod(), (int)art.getKolicina(), em).booleanValue()) continue;
                    DopunaPremaKalkulaciji.this.artikal = (Artikal)PzEntityManager.find(Artikal.class, (Object)art.getSifra());
                    PzMagacinUtil.createNalepnice(DopunaPremaKalkulaciji.this.tabela, DopunaPremaKalkulaciji.this.artikal, art.getProdCena(), (int)art.getKolicina(), firma, em);
                }
                em.getTransaction().commit();
                return null;
            }

            @Override
            protected void done() {
                try {
                    try {
                        this.get();
                        DopunaPremaKalkulaciji.this.tabela.commitInsert();
                        ((PzDialogStampanjeNalepnica)((Object)DopunaPremaKalkulaciji.this.getParent())).refresh();
                    }
                    catch (Exception e1) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        PzMysqlExceptionHandler.handle((Component)((Object)DopunaPremaKalkulaciji.this), (Throwable)e1);
                        em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    em.close();
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }

    private Kalkulacija getKalkulacija(Boolean rBroj) {
        EntityManager em = PzEntityManager.getEm();
        Kalkulacija kal = null;
        String upit = "";
        upit = rBroj != false ? "Select k from Kalkulacija k Where k.radnajedinica=:rj and k.arhiviran=1 and k.storno=0 and k.rBroj=:broj and k.tip='KALKULACIJA'" : "Select k from Kalkulacija k Where k.radnajedinica=:rj and k.arhiviran=1 and k.storno=0 and k.oznDokumenta=:oznaka k.tip='KALKULACIJA'";
        Query q = em.createQuery(upit);
        q.setParameter("rj", (Object)this.rj);
        if (rBroj.booleanValue()) {
            q.setParameter("broj", (Object)this.tfBrojKalkulacije.getIntVal());
        } else {
            q.setParameter("oznaka", (Object)this.tfOznakaDokumenta.getVal());
        }
        if (q.getResultList().size() != 0) {
            kal = (Kalkulacija)q.getSingleResult();
        }
        return kal;
    }

    public void setOznakaDokumenta(String oznaka) {
        this.tfOznakaDokumenta.setVal((Object)oznaka);
    }

    public boolean shouldBeShown() {
        boolean res = false;
        this.rj = PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("E".charAt(0))});
        if (this.rj != null) {
            res = true;
        }
        return res;
    }

    public void actionPerformed(ActionEvent e) {
    }

    public static Object getGUIBuilderInstance() {
        return new DopunaPremaKalkulaciji(Boolean.FALSE);
    }

    public DopunaPremaKalkulaciji(Boolean initGUI) {
    }
}

