/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.magacin.gui;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikalnalog;
import rs.pezar.db.entity.Nalogmagacinu;
import rs.pezar.magacin.PzExtensionLoader;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzSadrzajMag
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private PzPanel jPanel1;
    private JScrollPane jScrollPane1;
    private PzTable table;
    private Nalogmagacinu n;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private String glavniMagacin;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzSadrzajMag inst = new PzSadrzajMag(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzSadrzajMag(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzSadrzajMag(PzDialog parent) {
        super(parent);
        this.n = (Nalogmagacinu)this.getSession().getParameter("nalog");
        try {
            this.glavniMagacin = PzParameter.getParameterValue((String)"GLAVNI_MAGACIN").trim();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Sadr\u017eaj naloga magacinu: " + this.n.getRedniBroj());
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setFocusableWindowState(true);
            this.setPreferredSize(new Dimension(644, 360));
            this.setResizable(true);
            this.jPanel1 = new PzPanel();
            this.jPanel1.setPaintGradient(true);
            AnchorLayout jPanel1Layout1 = new AnchorLayout();
            GridBagLayout jPanel1Layout = new GridBagLayout();
            jPanel1Layout.columnWidths = new int[]{7, 7, 7, 7};
            jPanel1Layout.rowHeights = new int[]{7, 7, 7, 7};
            jPanel1Layout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            this.getContentPane().add((Component)this.jPanel1, "Center");
            this.jPanel1.setPreferredSize(new Dimension(644, 360));
            this.jPanel1.setLayout((LayoutManager)jPanel1Layout1);
            this.jScrollPane1 = new JScrollPane();
            this.jPanel1.add((Component)this.jScrollPane1, (Object)new AnchorConstraint(15, 1000, 1001, 0, 1, 1, 1, 1));
            this.jScrollPane1.setPreferredSize(new Dimension(644, 360));
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            String[] magacini = PzExtensionLoader.getLoggedUser().getOznMagacin().split(",");
            String krit = "";
            int i = 0;
            while (i < magacini.length) {
                krit = String.valueOf(krit) + (i == 0 ? "" : " OR ") + "an.stalaza LIKE '" + magacini[i].trim() + "%'";
                ++i;
            }
            krit = krit.contains(this.glavniMagacin) || PzExtensionLoader.getLoggedUser().getOznMagacin().equals("%") ? "" : "(" + krit + ") AND ";
            q = em.createQuery("SELECT an FROM Artikalnalog an where " + krit + " an.nalogmagacinu = :nalog");
            q.setParameter("nalog", (Object)this.n);
            Vector data = (Vector)q.getResultList();
            this.table = new PzTable((List)data, Artikalnalog.class);
            this.jScrollPane1.setViewportView((Component)this.table);
            this.table.refreshData();
            this.brDok.setText(Integer.toString(data.size()));
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public static Object getGUIBuilderInstance() {
        return new PzSadrzajMag(Boolean.FALSE);
    }

    public PzSadrzajMag(Boolean initGUI) {
    }
}

