/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.magacin.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Nalogprijem;
import rs.pezar.magacin.gui.nalogPrijem.DodavanjeNaloga;
import rs.pezar.magacin.gui.nalogPrijem.IzmenaStavkiNaloga;
import rs.pezar.magacin.gui.nalogPrijem.Pregled;
import rs.pezar.magacin.gui.nalogPrijem.SpakovanNalog;
import rs.pezar.magacin.gui.nalogPrijem.Upit;
import rs.pezar.magacin.gui.util.PzMagacinUtil;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogNalogMagacinu
extends PzDialog {
    private static PzDialogNalogMagacinu instance;
    private JToolBar toolbar;
    private PzPanel pnlGlavni;
    private PzToolBarIcon icnDodajNalog;
    private PzTable tabelaNalog;
    private JScrollPane scrollPane;
    private PzButton icnPakovanje;
    private PzToolBarIcon icnSpakovano;
    private PzToolBarIcon icnCisti;
    private PzToolBarIcon icnVidiNalog;
    private PzToolBarIcon icnPregledi;
    private PzToolBarIcon icnUpit;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private PzToolBarIcon icnOtvaranjeNaloga;

    public PzDialogNalogMagacinu(JFrame frame) {
        super(frame);
        this.initGUI();
        instance = this;
    }

    public static PzDialogNalogMagacinu getInstance() {
        return instance;
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Nalozi magacinu da primi robu");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{119, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1};
            pnlGlavniLayout.columnWidths = new int[]{7};
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.scrollPane = new JScrollPane();
            this.scrollPane.setBackground(new Color(255, 255, 255));
            this.pnlGlavni.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 7, 7, 7), 0, 0));
            this.tabelaNalog = new PzTable();
            this.scrollPane.setViewportView((Component)this.tabelaNalog);
            this.initializeTable(true);
            this.tabelaNalog.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PzDialogNalogMagacinu.this.tabelaNalog.getSelectedRow() == -1) {
                        return;
                    }
                    PzDialogNalogMagacinu.this.getSession().putParameter("nalog", (Object)PzDialogNalogMagacinu.this.tabelaNalog.getSelectedEntity());
                    PzDialogNalogMagacinu.this.showDialog(IzmenaStavkiNaloga.class);
                }
            });
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.toolbar.setPreferredSize(new Dimension(751, 103));
            this.icnOtvaranjeNaloga = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnOtvaranjeNaloga);
            this.icnOtvaranjeNaloga.setText("Ulaz u nalog |(Enter)");
            this.icnOtvaranjeNaloga.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/note_into.png")));
            this.icnOtvaranjeNaloga.setActionCommand("ulaz");
            this.icnOtvaranjeNaloga.addActionListener((ActionListener)((Object)this));
            this.icnOtvaranjeNaloga.setShortcut("ENTER");
            this.icnOtvaranjeNaloga.setPreferredSize(new Dimension(70, 80));
            this.icnDodajNalog = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodajNalog);
            this.icnDodajNalog.setText("Otvaranje novog|naloga(INS)");
            this.icnDodajNalog.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/note_add.png")));
            this.icnDodajNalog.setActionCommand("dodaj");
            this.icnDodajNalog.addActionListener((ActionListener)((Object)this));
            this.icnDodajNalog.setShortcut("INSERT");
            this.icnDodajNalog.setPreferredSize(new Dimension(90, 80));
            this.icnPakovanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnPakovanje);
            this.icnPakovanje.setText("Ide na|pakovanje(F5)");
            this.icnPakovanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/note_pack.png")));
            this.icnPakovanje.setActionCommand("pakovanje");
            this.icnPakovanje.addActionListener((ActionListener)((Object)this));
            this.icnPakovanje.setShortcut("F5");
            this.icnPakovanje.setPreferredSize(new Dimension(70, 80));
            this.icnSpakovano = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSpakovano);
            this.icnSpakovano.setText("Spakovano|(CTRL+W)");
            this.icnSpakovano.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/note_packed.png")));
            this.icnSpakovano.setActionCommand("spakovano");
            this.icnSpakovano.addActionListener((ActionListener)((Object)this));
            this.icnSpakovano.setShortcut("Ctrl+w");
            this.icnSpakovano.setPreferredSize(new Dimension(70, 80));
            this.icnCisti = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnCisti);
            this.icnCisti.setText("\u010cisti spakovano|(CTRL+D)");
            this.icnCisti.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/note_packed_delete.png")));
            this.icnCisti.setActionCommand("cisti");
            this.icnCisti.addActionListener((ActionListener)((Object)this));
            this.icnCisti.setShortcut("CTRL+D");
            this.icnCisti.setPreferredSize(new Dimension(90, 80));
            this.icnVidiNalog = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnVidiNalog);
            this.icnVidiNalog.setText("Vidi nalog|(F2)");
            this.icnVidiNalog.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/note_view.png")));
            this.icnVidiNalog.setActionCommand("vidinalog");
            this.icnVidiNalog.addActionListener((ActionListener)((Object)this));
            this.icnVidiNalog.setShortcut("F2");
            this.icnVidiNalog.setPreferredSize(new Dimension(70, 80));
            this.icnPregledi = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnPregledi);
            this.icnPregledi.setText("Pregledi|(F4)");
            this.icnPregledi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/note_view.png")));
            this.icnPregledi.setActionCommand("pregledi");
            this.icnPregledi.addActionListener((ActionListener)((Object)this));
            this.icnPregledi.setShortcut("F4");
            this.icnPregledi.setPreferredSize(new Dimension(70, 80));
            this.icnUpit = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnUpit);
            this.icnUpit.setText("Upit|(CTRL+F2)");
            this.icnUpit.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/note_upit.png")));
            this.icnUpit.setActionCommand("upit");
            this.icnUpit.addActionListener((ActionListener)((Object)this));
            this.icnUpit.setShortcut("Ctrl+F2");
            this.icnUpit.setPreferredSize(new Dimension(70, 80));
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj naloga");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(800, 600);
            this.setMinimumSize(new Dimension(800, 600));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("dodaj")) {
            Vector<String> skupZaIzbor = new Vector<String>();
            String kalkulacija = new String("Izrada nalog od kalkulacije");
            String prijemnica = new String("Izrada nalog od prijemnice");
            String interniNalog = new String("Izrada nalog od internog naloga");
            skupZaIzbor.add(kalkulacija);
            skupZaIzbor.add(prijemnica);
            skupZaIzbor.add(interniNalog);
            String izborKartice = PzDialogChoice.showPzDialogChoice((PzDialog)this, skupZaIzbor);
            if (izborKartice == null) {
                return;
            }
            if (izborKartice.equals(kalkulacija)) {
                this.getSession().putParameter("dokument", (Object)"kalkulacija");
                this.showDialog(DodavanjeNaloga.class);
                return;
            } else if (izborKartice.equals(prijemnica)) {
                this.getSession().putParameter("dokument", (Object)"prijemnica");
                this.showDialog(DodavanjeNaloga.class);
                return;
            } else {
                if (!izborKartice.equals(interniNalog)) return;
                this.getSession().putParameter("dokument", (Object)"interniNalog");
                this.showDialog(DodavanjeNaloga.class);
            }
            return;
        }
        if (actionCommand.equals("ulaz")) {
            if (this.tabelaNalog.getRowCount() == 0) {
                return;
            }
            this.getSession().putParameter("nalog", (Object)this.tabelaNalog.getSelectedEntity());
            this.showDialog(IzmenaStavkiNaloga.class);
            return;
        }
        if (actionCommand.equals("vidinalog")) {
            try {
                PzMagacinUtil.showReports(this, (Nalogprijem)this.tabelaNalog.getSelectedEntity());
                return;
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
            return;
        }
        if (actionCommand.equals("pakovanje")) {
            EntityManager em = PzEntityManager.getEm();
            try {
                try {
                    em.getTransaction().begin();
                    Nalogprijem nalog = (Nalogprijem)this.tabelaNalog.getSelectedEntity();
                    if (nalog.getStatus() == 2) {
                        PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Nalog je ve\u0107 spakovan");
                    } else if (nalog.getStatus() == 1) {
                        PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Nalog je ve\u0107 u grupi naloga koji se pakuju");
                    } else {
                        String komitent = nalog.getDokument().getKomitent() == null ? "" : nalog.getDokument().getKomitent().getNaziv();
                        int rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot(null), "PROVERA!!!\n    Nalog:            " + nalog.getDokument().getRbrDok() + "\n    Kalkulacija:" + "     " + nalog.getDokument().getrBroj() + "\n    Dobavlja\u010d:" + "      " + komitent + "\n    Dokument:" + "     " + nalog.getDokument().getOznDokumenta() + "\nIDE NA PAKOVANJE???", "Informacija", 0);
                        if (rez == 0) {
                            nalog.setStatus(1);
                            em.merge((Object)nalog);
                            PzMagacinUtil.showReports(this, nalog);
                            this.initializeTable(false);
                        }
                    }
                    if (!em.getTransaction().isActive()) return;
                    em.getTransaction().commit();
                    return;
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                    em.close();
                }
                return;
            }
            finally {
                em.close();
            }
        }
        if (actionCommand.equals("spakovano")) {
            if (this.tabelaNalog.getRowCount() == 0) {
                return;
            }
            if (((Nalogprijem)this.tabelaNalog.getSelectedEntity()).getStatus() == 2) {
                PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Nalog je ve\u0107 spakovan");
                return;
            } else {
                this.getSession().putParameter("nalog", (Object)this.tabelaNalog.getSelectedEntity());
                this.showDialog(SpakovanNalog.class);
            }
            return;
        }
        if (actionCommand.equals("upit")) {
            this.getSession().putParameter("nalog", (Object)this.tabelaNalog.getSelectedEntity());
            this.showDialog(Upit.class);
            return;
        }
        if (actionCommand.equals("pregledi")) {
            this.showDialog(Pregled.class);
            return;
        }
        if (!actionCommand.equals("cisti")) return;
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                em.getTransaction().begin();
                PzMagacinUtil.cistiTabelu(this.tabelaNalog, em);
                if (em.getTransaction().isActive()) {
                    em.getTransaction().commit();
                }
                this.initializeTable(true);
                return;
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
            return;
        }
        finally {
            em.close();
        }
    }

    public void initializeTable(Boolean create) {
        if (create.booleanValue()) {
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            q = em.createQuery("SELECT n FROM Nalogprijem n where n.spakovano=0");
            Vector data = (Vector)q.getResultList();
            this.tabelaNalog.setData(data, Nalogprijem.class);
            em.close();
            this.brDok.setText(Integer.toString(data.size()));
        }
        this.tabelaNalog.refreshData();
        this.tabelaNalog.getTableHeader().setFocusable(false);
        this.tabelaNalog.requestFocusInWindow();
        if (this.tabelaNalog.getDataSize() > 0) {
            this.tabelaNalog.setRowSelectionInterval(0, 0);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogNalogMagacinu(Boolean.FALSE);
    }

    public PzDialogNalogMagacinu(Boolean initGUI) {
    }

    public void addNalog(final int oznNaloga) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Nalogprijem n = (Nalogprijem)PzEntityManager.find(Nalogprijem.class, (Object)oznNaloga);
                    PzDialogNalogMagacinu.this.tabelaNalog.insert((PzEntity)n, false);
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)PzDialogNalogMagacinu.this), (Throwable)e);
                }
            }
        });
    }
}

