/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.magacin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.indirection.IndirectList;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Firma;
import rs.pezar.magacin.gui.deklaracija.Deklaracije;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzBeanDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.sifarnici.gui.PzDialogArtikliExtended;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzFileUtility;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogDeklaracije
extends PzDialog {
    private PzPanel mainPanel;
    private PzTextField tfNaziv;
    private JLabel lblRed;
    private PzNumericOnlyTextField dfRed;
    private JLabel lblOpis;
    private JTextArea txtOpis;
    private JScrollPane scpOpis;
    private PzFieldIndikator indSifra;
    private PzTextField tfSifra;
    private JLabel lblSifra;
    private PzButton btnPotvrdi;
    private PzButton btnTraziSifru;
    private PzNumericOnlyTextField dfPozicija;
    private JLabel lblPozicija;
    private JLabel lblBrojKopija;
    private PzNumericOnlyTextField dfBrojKopija;
    private PzComboBox cbVrstaNalepnice;
    private JLabel lblVrste;
    private PzTextField tfUvoznik;
    private JLabel lblUvoznik;
    private PzTextField tfZemljaPorekla;
    private JLabel lblZemljaPorekla;
    private PzTextField tfProizvodjac;
    private JLabel lblProizvodjac;
    private JLabel lblNaziv;

    public PzDialogDeklaracije() {
    }

    public PzDialogDeklaracije(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("DEKLARACIJE");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0};
            mainPanelLayout.rowHeights = new int[]{20, 20, 20, 20, 7, 20, 7, 20, 7, 20, 7};
            mainPanelLayout.columnWidths = new int[]{170, 130, 106, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.lblNaziv = new JLabel();
            this.mainPanel.add((Component)this.lblNaziv, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 3, 0), 0, 0));
            this.lblNaziv.setName("lblNaziv");
            this.tfNaziv = new PzTextField();
            this.mainPanel.add((Component)this.tfNaziv, (Object)new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
            this.lblProizvodjac = new JLabel();
            this.mainPanel.add((Component)this.lblProizvodjac, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 3, 0), 0, 0));
            this.lblProizvodjac.setName("lblProizvodjac");
            this.tfProizvodjac = new PzTextField();
            this.mainPanel.add((Component)this.tfProizvodjac, (Object)new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
            this.lblZemljaPorekla = new JLabel();
            this.mainPanel.add((Component)this.lblZemljaPorekla, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 3, 0), 0, 0));
            this.lblZemljaPorekla.setName("lblZemljaPorekla");
            this.tfZemljaPorekla = new PzTextField();
            this.mainPanel.add((Component)this.tfZemljaPorekla, (Object)new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
            this.lblUvoznik = new JLabel();
            this.mainPanel.add((Component)this.lblUvoznik, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 3, 0), 0, 0));
            this.lblUvoznik.setName("lblUvoznik");
            this.tfUvoznik = new PzTextField();
            this.mainPanel.add((Component)this.tfUvoznik, (Object)new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
            this.tfUvoznik.setName("tfUvoznik");
            this.lblVrste = new JLabel();
            this.mainPanel.add((Component)this.lblVrste, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 3, 0), 0, 0));
            this.lblVrste.setName("lblVrste");
            this.cbVrstaNalepnice = new PzComboBox();
            this.mainPanel.add((Component)this.cbVrstaNalepnice, (Object)new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
            this.cbVrstaNalepnice.addItem((Object)new PzChoice("Nalepnica 38x21.2", (Object)"38x21.2"));
            this.cbVrstaNalepnice.addItem((Object)new PzChoice("Nalepnica 48x25.4", (Object)"48x25.4"));
            this.cbVrstaNalepnice.setPreferredSize(new Dimension(268, 25));
            this.lblBrojKopija = new JLabel();
            this.mainPanel.add((Component)this.lblBrojKopija, (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 3, 0), 0, 0));
            this.lblBrojKopija.setName("lblBrojKopija");
            this.dfBrojKopija = new PzNumericOnlyTextField();
            this.mainPanel.add((Component)this.dfBrojKopija, (Object)new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
            this.dfBrojKopija.setVal((Object)1);
            this.lblPozicija = new JLabel();
            this.mainPanel.add((Component)this.lblPozicija, (Object)new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 3, 0), 0, 0));
            this.lblPozicija.setText("Startna pozicija po kolonama");
            this.dfPozicija = new PzNumericOnlyTextField();
            this.mainPanel.add((Component)this.dfPozicija, (Object)new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
            this.dfPozicija.setVal((Object)1);
            this.dfPozicija.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogDeklaracije.this.cbVrstaNalepnice.getSelectedChoice().getValue().equals("38x21.2")) {
                        if (PzDialogDeklaracije.this.dfPozicija.getIntVal() > 5) {
                            PzSwingUtility.showInformationMessage((Component)((Object)PzDialogDeklaracije.this), (String)"Broj kolone ne \u043c\u043e\u017ee biti ve\u0107i od broja 5!");
                            return false;
                        }
                    } else if (PzDialogDeklaracije.this.dfPozicija.getIntVal() > 4) {
                        PzSwingUtility.showInformationMessage((Component)((Object)PzDialogDeklaracije.this), (String)"Broj kolone ne \u043c\u043e\u017ee biti ve\u0107i od broja 4!");
                        return false;
                    }
                    return true;
                }
            });
            this.btnTraziSifru = new PzButton();
            this.mainPanel.add((Component)this.btnTraziSifru, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
            this.btnTraziSifru.setName("btnTraziSifru");
            this.btnTraziSifru.setActionCommand("trazi");
            this.btnTraziSifru.addActionListener((ActionListener)((Object)this));
            this.btnTraziSifru.setShortcut("F2");
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 3, 3), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(125, 36));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.lblSifra = new JLabel();
            this.mainPanel.add((Component)this.lblSifra, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 3, 0), 0, 0));
            this.lblSifra.setName("lblSifra");
            this.tfSifra = new PzTextField();
            this.mainPanel.add((Component)this.tfSifra, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
            this.tfSifra.setFKField(Artikal.class, PzDialogArtikliExtended.class, true, null);
            this.tfSifra.setFocusable(false);
            this.tfSifra.setEnabled(false);
            this.indSifra = new PzFieldIndikator();
            this.mainPanel.add((Component)this.indSifra, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 40, 0, 0), 0, 0));
            this.indSifra.setEnabled(false);
            this.scpOpis = new JScrollPane();
            this.mainPanel.add((Component)this.scpOpis, (Object)new GridBagConstraints(1, 5, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
            this.txtOpis = new JTextArea();
            this.scpOpis.setViewportView(this.txtOpis);
            this.txtOpis.setName("txtOpis");
            this.lblOpis = new JLabel();
            this.mainPanel.add((Component)this.lblOpis, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.lblOpis.setName("lblOpis");
            this.lblRed = new JLabel();
            this.mainPanel.add((Component)this.lblRed, (Object)new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 3, 0), 0, 0));
            this.lblRed.setName("lblRed");
            this.dfRed = new PzNumericOnlyTextField();
            this.mainPanel.add((Component)this.dfRed, (Object)new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
            this.dfRed.setVal((Object)1);
            this.dfRed.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogDeklaracije.this.cbVrstaNalepnice.getSelectedChoice().getValue().equals("38x21.2")) {
                        if (PzDialogDeklaracije.this.dfRed.getIntVal() > 13) {
                            PzSwingUtility.showInformationMessage((Component)((Object)PzDialogDeklaracije.this), (String)"Broj reda ne \u043c\u043e\u017ee biti ve\u0107i od broja 13!");
                            return false;
                        }
                    } else if (PzDialogDeklaracije.this.dfRed.getIntVal() > 10) {
                        PzSwingUtility.showInformationMessage((Component)((Object)PzDialogDeklaracije.this), (String)"Broj reda ne \u043c\u043e\u017ee biti ve\u0107i od broja 10!");
                        return false;
                    }
                    return true;
                }
            });
            this.tfSifra.setStateIndikator(this.indSifra);
            this.pack();
            this.setSize(588, 391);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("trazi")) {
            this.tfSifra.setEnabled(true);
            this.tfSifra.setFocusable(true);
            this.tfSifra.requestFocus();
            this.indSifra.setEnabled(true);
            this.btnTraziSifru.setFocusable(false);
        } else if (actionCommand.equals("potvrdi")) {
            Vector<String> skupZaIzbor = new Vector<String>();
            String export = new String("Export u xml");
            String stampa = new String("\u0160tampa");
            skupZaIzbor.add(export);
            skupZaIzbor.add(stampa);
            String izborKartice = PzDialogChoice.showPzDialogChoice((PzDialog)this, skupZaIzbor);
            if (izborKartice == null) {
                return;
            }
            if (izborKartice.equals(export)) {
                try {
                    Deklaracije d = new Deklaracije(this.tfSifra.getVal(), this.tfNaziv.getVal(), this.tfProizvodjac.getVal(), this.tfZemljaPorekla.getVal(), this.tfUvoznik.getVal(), this.cbVrstaNalepnice.getSelectedChoice().getText(), this.dfBrojKopija.getIntVal(), this.dfPozicija.getIntVal(), this.txtOpis.getText());
                    File dir = PzFileUtility.selectDirectory((String)"Izaberite direktorijum u koji se snimaju deklaracije", (PzDialog)this);
                    if (dir == null) {
                        return;
                    }
                    JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Deklaracije.class});
                    Marshaller m = context.createMarshaller();
                    m.setProperty("jaxb.formatted.output", (Object)true);
                    m.marshal((Object)d, new File(String.valueOf(dir.getPath()) + File.separator + d.getSifra()));
                    this.dispose();
                }
                catch (JAXBException e1) {
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                }
            } else {
                try {
                    Deklaracije d = new Deklaracije(this.tfSifra.getVal(), this.tfNaziv.getVal(), this.tfProizvodjac.getVal(), this.tfZemljaPorekla.getVal(), this.tfUvoznik.getVal(), this.cbVrstaNalepnice.getSelectedChoice().getText(), this.dfBrojKopija.getIntVal(), this.dfPozicija.getIntVal(), this.txtOpis.getText());
                    Vector<Firma> data = new Vector<Firma>();
                    data.add(PzFirma.getFirma());
                    IndirectList deklaracije = new IndirectList();
                    int brojKopije = this.dfBrojKopija.getIntVal();
                    String fname = "";
                    if (this.cbVrstaNalepnice.getSelectedChoice().getValue().equals("48x25.4")) {
                        fname = "rs/pezar/magacin/resource/reports/compiled/deklaracija1.jasper";
                        brojKopije += 10 * (this.dfPozicija.getIntVal() - 1) + this.dfRed.getIntVal() - 1;
                    } else {
                        fname = "rs/pezar/magacin/resource/reports/compiled/deklaracija2.jasper";
                        brojKopije += 13 * (this.dfPozicija.getIntVal() - 1) + this.dfRed.getIntVal() - 1;
                    }
                    int i = 0;
                    while (i < brojKopije) {
                        deklaracije.add(d);
                        ++i;
                    }
                    PzDataSourceExtended ds = new PzDataSourceExtended(data, (List)deklaracije);
                    ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("nacin", "kolona");
                    params.put("kolona", this.dfPozicija.getIntVal());
                    params.put("red", this.dfRed.getIntVal());
                    PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource(fname), params, (String)" ", (int)PzReportManager.REPORT_TYPE_JASPER);
                }
                catch (Exception e1) {
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                }
            }
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        try {
            if (entity == null) {
                return;
            }
            Artikal art = (Artikal)entity;
            this.tfSifra.setVal((Object)art.getSfrProizvod());
            this.tfNaziv.setVal((Object)art.getNaziv());
            this.tfNaziv.setEditable(false);
            this.tfNaziv.setFocusable(false);
            this.tfProizvodjac.setVal((Object)(art.getProizvodjac() == null ? "" : art.getProizvodjac().getNaziv()));
            this.tfZemljaPorekla.setVal((Object)(art.getProizvodjac() == null ? "" : art.getProizvodjac().getZemljaKomitenta()));
            this.tfUvoznik.setVal((Object)(String.valueOf(PzFirma.getFirma().getNaziv()) + ", " + PzFirma.getFirma().getAdresa() + ", " + PzFirma.getFirma().getGrad()));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }
}

