/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProviderBase;
import org.fife.ui.autocomplete.Util;

public abstract class AbstractCompletionProvider
extends CompletionProviderBase {
    protected List completions;
    protected Comparator comparator = new CaseInsensitiveComparator();

    public AbstractCompletionProvider() {
        this.clearParameterizedCompletionParams();
    }

    public void addCompletion(Completion c) {
        this.checkProviderAndAdd(c);
        Collections.sort(this.completions);
    }

    public void addCompletions(List completions) {
        int i = 0;
        while (i < completions.size()) {
            Completion c = (Completion)completions.get(i);
            this.checkProviderAndAdd(c);
            ++i;
        }
        Collections.sort(this.completions);
    }

    protected void addWordCompletions(String[] words) {
        int count = words == null ? 0 : words.length;
        int i = 0;
        while (i < count) {
            this.completions.add(new BasicCompletion(this, words[i]));
            ++i;
        }
        Collections.sort(this.completions);
    }

    protected void checkProviderAndAdd(Completion c) {
        if (c.getProvider() != this) {
            throw new IllegalArgumentException("Invalid CompletionProvider");
        }
        this.completions.add(c);
    }

    public void clear() {
        this.completions.clear();
    }

    public List getCompletionByInputText(String inputText) {
        int end = Collections.binarySearch(this.completions, inputText, this.comparator);
        if (end < 0) {
            return null;
        }
        int start = end;
        while (start > 0 && this.comparator.compare(this.completions.get(start - 1), inputText) == 0) {
            --start;
        }
        int count = this.completions.size();
        while (++end < count && this.comparator.compare(this.completions.get(end), inputText) == 0) {
        }
        return this.completions.subList(start, end);
    }

    @Override
    protected List getCompletionsImpl(JTextComponent comp) {
        ArrayList retVal = new ArrayList();
        String text = this.getAlreadyEnteredText(comp);
        if (text != null) {
            int index = Collections.binarySearch(this.completions, text, this.comparator);
            if (index < 0) {
                index = -index - 1;
            } else {
                int pos = index - 1;
                while (pos > 0 && this.comparator.compare(this.completions.get(pos), text) == 0) {
                    retVal.add(this.completions.get(pos));
                    --pos;
                }
            }
            while (index < this.completions.size()) {
                Completion c = (Completion)this.completions.get(index);
                if (!Util.startsWithIgnoreCase(c.getInputText(), text)) break;
                retVal.add(c);
                ++index;
            }
        }
        return retVal;
    }

    public boolean removeCompletion(Completion c) {
        int index = Collections.binarySearch(this.completions, c);
        if (index < 0) {
            return false;
        }
        this.completions.remove(index);
        return true;
    }

    private static class CaseInsensitiveComparator
    implements Comparator,
    Serializable {
        private CaseInsensitiveComparator() {
        }

        public int compare(Object o1, Object o2) {
            Completion c = (Completion)o1;
            return String.CASE_INSENSITIVE_ORDER.compare(c.getInputText(), o2.toString());
        }
    }
}

