/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.msg;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import rs.pezar.msg.msg.Settings;
import rs.pezar.msg.msg.interfaces.ResponseListenerInterface;

public class ResponseListener
implements ResponseListenerInterface {
    String statusCode;
    String statusMessage;
    String infoMessage;
    Timer timer = null;
    Object mutex = new Object();
    Object mutex1;
    Semaphore semaphore = new Semaphore(0);
    Semaphore semaphoreReleaseProducer = new Semaphore(0);

    @Override
    public void newStart() {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new CheckTask(), 20000L);
    }

    public void waitOnResponse() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void waitToDestroyConsumer() {
        try {
            this.semaphoreReleaseProducer.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMessageCode() {
        Object object = this.mutex;
        synchronized (object) {
            return this.statusMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatusCode() {
        Object object = this.mutex;
        synchronized (object) {
            return this.statusCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInfoMessage() {
        Object object = this.mutex;
        synchronized (object) {
            return this.infoMessage;
        }
    }

    @Override
    public boolean isLastOperationSuccess() {
        return !this.statusCode.startsWith(Settings.ERROR_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Message message) {
        ObjectMessage received = (ObjectMessage)message;
        try {
            Object object = this.mutex;
            synchronized (object) {
                if (received != null) {
                    this.statusMessage = received.getStringProperty("MESSAGE");
                    this.statusCode = received.getStringProperty("CODE");
                    this.infoMessage = received.getStringProperty("INFO");
                } else {
                    this.statusMessage = "Isteklo vreme za odgovor, proverite podesavanja i da li je uredjaj ukljucen na mrezu.";
                    this.statusCode = Settings.ERROR01;
                }
                this.timer.cancel();
                this.timer.purge();
                this.semaphore.release();
                this.semaphoreReleaseProducer.release();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class CheckTask
    extends TimerTask {
        CheckTask() {
        }

        @Override
        public void run() {
            System.out.println("Vreme isteklo!");
            ResponseListener.this.onMessage(null);
        }
    }
}

