/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.msg;

import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.msg.PzExtensionLoader;
import rs.pezar.msg.action.interfaces.ActionManagerInterface;
import rs.pezar.msg.chat.interfaces.TextMessageReceiverInterface;
import rs.pezar.msg.device.DeviceManager;
import rs.pezar.msg.device.cashregister.data.DeviceData;
import rs.pezar.msg.msg.JMSConnection;
import rs.pezar.msg.msg.MsgArbiter;
import rs.pezar.msg.msg.StatusManager.StatusManager;
import rs.pezar.msg.msg.control.MsgControl;
import rs.pezar.msg.msg.interfaces.ResponseListenerInterface;

public class MsgProtocol {
    public static final String MSG_PROTOCOL_VERSION = "1.1";
    public static final String MSG_SERVER_ADDRESS = "MSG_SERVER_ADDRESS";
    public static final String TOPIC_PREFIX = "topic.";
    public static final String QUEUE_PREFIX = "queue.";
    public static final String USERS_TOPIC = "topic.users";
    public static final String MSG_DISCOVERY = "DISCOVERY";
    public static final String MSG_TEXT = "TEXT";
    public static final String MSG_TEXT_POPUP = "TEXT_POPUP";
    public static final String MSG_DEVICE_DATA = "DEVICE_DATA";
    public static final String MSG_CONTROL = "CONTROL";
    public static final String MSG_ACTION = "ACTION";
    public static final String MSG_RESPONSE = "RESPONSE";
    public static final String MSG_REFRESH = "REFRESH";
    private static MsgProtocol instance = null;
    JMSConnection conn;
    Topic topicDevices;
    Topic topicUsers;
    Queue queueReceptor;
    String queueReceptorName;
    MsgArbiter arbiter;
    TextMessageReceiverInterface msgReceiver;
    DeviceManager deviceManager;
    ActionManagerInterface actionManager;
    String serverAddress;
    String company;
    String userPosition;
    String user;
    StatusManager statusManager;
    private final Object mutex = new Object();

    public MsgProtocol(String brokerUrl, String userName) throws Exception {
        if (brokerUrl.trim().equals("") || brokerUrl == null) {
            throw new Exception("Pogresan format adrese servera");
        }
        this.statusManager = new StatusManager();
        this.user = userName;
        this.conn = new JMSConnection("failover:(" + brokerUrl + ")?timeout=3000", userName);
        this.serverAddress = brokerUrl;
        instance = this;
        this.company = PzFirma.getFirma().getNaziv();
        try {
            this.userPosition = PzExtensionLoader.getInstance().getApplication().getSession().getLoggedUser().getRadnoMesto().getNaziv();
        }
        catch (Exception exception) {
            this.userPosition = "";
        }
    }

    public void run() throws JMSException {
        this.conn.init();
        this.queueReceptorName = QUEUE_PREFIX + this.user;
        this.arbiter = new MsgArbiter(this.mutex, this);
        this.queueReceptor = this.conn.createQueueAndSubscribe(this.queueReceptorName, this.arbiter);
        this.topicUsers = this.conn.createTopicAndSubscribe(USERS_TOPIC, this.arbiter);
        this.conn.run();
    }

    public Topic registerTopic(String topicName) throws JMSException {
        return this.conn.createTopicAndSubscribe(topicName, this.arbiter);
    }

    public void sendDiscoverMessage(Destination toTopic) throws JMSException {
        if (this.getControl() != null) {
            this.getControl().resetControl();
        }
        this.sendTextMessageToDestination(toTopic, MSG_DISCOVERY, "");
    }

    public void sendDiscoverMessage(String toTopic) throws JMSException {
        if (this.getControl() != null) {
            this.getControl().resetControl();
        }
        this.sendTextMessageToTopic(toTopic, MSG_DISCOVERY, "");
    }

    public HashMap<String, String> sendDeviceDataMessageSync(Destination deviceDestination, DeviceData data) throws JMSException {
        return this.conn.createSendAndRequestSynchronius(deviceDestination, MSG_DEVICE_DATA, data);
    }

    public void sendDeviceDataMessageASync(Destination deviceDestination, DeviceData data, ResponseListenerInterface msgListener) throws JMSException {
        this.conn.createSendAndRequestAsynchronius(deviceDestination, MSG_DEVICE_DATA, data, msgListener);
    }

    public void sendReply(Destination dest, HashMap<String, String> params) throws JMSException {
        this.conn.sendReply(dest, params);
    }

    public void sendTextMessageToDestination(Destination dest, String msgType, String text) throws JMSException {
        this.conn.publishTextMessage(dest, (Destination)this.queueReceptor, msgType, text, dest.toString());
    }

    public void sendTextMessageToTopic(String topic, String msgType, String text) throws JMSException {
        this.conn.publishTextMessageTopic(topic, (Destination)this.queueReceptor, msgType, text, topic);
    }

    public void sendChatTextMessageToDestination(Destination dest, String text) throws JMSException {
        this.conn.publishTextMessage(dest, (Destination)this.queueReceptor, MSG_TEXT, text, dest.toString());
    }

    public void sendActionMessageToDestination(Destination dest, String text) throws JMSException {
        this.conn.publishTextMessage(dest, (Destination)this.queueReceptor, MSG_ACTION, text, dest.toString());
    }

    public void sendChatTextMessageToTopic(String topic, String text) throws JMSException {
        this.conn.publishTextMessageTopic(topic, (Destination)this.queueReceptor, MSG_TEXT, text, topic);
    }

    public void sendChatTextMessageToQueue(String queue, String text) throws JMSException {
        this.conn.publishTextMessageQueue(queue, (Destination)this.queueReceptor, MSG_TEXT, text, queue);
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public JMSConnection getConn() {
        return this.conn;
    }

    public Topic getTopicDevices() {
        return this.topicDevices;
    }

    public Topic getTopicUsers() {
        return this.topicUsers;
    }

    public Queue getQueueReceptor() {
        return this.queueReceptor;
    }

    public String getQueueReceptorName() {
        return this.queueReceptorName;
    }

    public MsgControl getControl() {
        return this.arbiter.getControl();
    }

    public Topic createDestinationFromTopicName(String topicName) throws JMSException {
        return this.conn.createTopic(topicName);
    }

    public Queue createDestinationFromQueueName(String queueName) throws JMSException {
        return this.conn.createQueue(queueName);
    }

    public void setMessageReceiver(TextMessageReceiverInterface messageReceiver) {
        this.msgReceiver = messageReceiver;
    }

    public TextMessageReceiverInterface getMessageReceiver() {
        return this.msgReceiver;
    }

    public void setDeviceManager(DeviceManager devManager) throws JMSException {
        this.deviceManager = devManager;
    }

    public DeviceManager getDeviceManager() {
        return this.deviceManager;
    }

    public void setActionManager(ActionManagerInterface actManager) {
        this.actionManager = actManager;
    }

    public ActionManagerInterface getActionManager() {
        return this.actionManager;
    }

    public void close() throws JMSException {
        this.conn.close();
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public String getCompany() {
        return this.company;
    }

    public String getPosition() {
        return this.userPosition;
    }

    public StatusManager getStatusManager() {
        return this.statusManager;
    }

    public static MsgProtocol getInstance() {
        return instance;
    }

    public static void setInstance(MsgProtocol instance) {
        MsgProtocol.instance = instance;
    }

    public static String getQueueNameFromUserName(String pzUserName, String firstName, String lastName) {
        return QUEUE_PREFIX + pzUserName + "(" + firstName + lastName + ")";
    }

    public static void main(String[] argv) {
        String user = "lazar";
        try {
            MsgProtocol msgProtocol = new MsgProtocol("tcp://localhost:61616", user);
            msgProtocol.sendDiscoverMessage(USERS_TOPIC);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

