/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.msg;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.protobuf.compiler.CommandLineSupport;
import rs.pezar.msg.device.cashregister.data.DeviceData;
import rs.pezar.msg.msg.interfaces.ResponseListenerInterface;

public class JMSConnection {
    public static final String RETURNMSG_MESSAGE = "MESSAGE";
    public static final String RETURNMSG_CODE = "CODE";
    public static final String RETURN_INFO = "INFO";
    private Connection connection;
    private Session session;
    private String receiveMessageQueue;
    private boolean reqQueue;
    private String user;
    private String url;

    public static void main(String[] argv) throws Exception {
        JMSConnection l = new JMSConnection("tcp://localhost:61616", "korisnik1");
        Object[] unknown = CommandLineSupport.setOptions((Object)l, (String[])argv);
        if (unknown.length > 0) {
            System.out.println("Unknown options: " + Arrays.toString(unknown));
            System.exit(-1);
        }
        l.run();
    }

    public JMSConnection(String brokerUrl, String userName) throws JMSException {
        this.url = brokerUrl;
        this.user = userName;
        this.init();
    }

    public void init() throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.url);
        this.connection = factory.createConnection();
        this.session = this.connection.createSession(false, 1);
    }

    public void run() throws JMSException {
        this.connection.start();
        System.out.println("Waiting for messages...");
    }

    public Topic createTopicAndSubscribe(String topicName, MessageListener msgListener) throws JMSException {
        Topic topic = this.session.createTopic(topicName);
        MessageConsumer consumer = this.session.createConsumer((Destination)topic);
        consumer.setMessageListener(msgListener);
        return topic;
    }

    public Topic createTopic(String topicName) throws JMSException {
        Topic topic = this.session.createTopic(topicName);
        return topic;
    }

    public Queue createQueueAndSubscribe(String queueName, MessageListener msgListener) throws JMSException {
        Queue messageQueue = this.session.createQueue(queueName);
        MessageConsumer consumer = this.session.createConsumer((Destination)messageQueue);
        consumer.setMessageListener(msgListener);
        return messageQueue;
    }

    public Queue createQueue(String queueName) throws JMSException {
        Queue messageQueue = this.session.createQueue(queueName);
        return messageQueue;
    }

    @Deprecated
    public HashMap<String, String> createSendAndRequestSynchronius(Destination dest, String msgType, DeviceData data) throws JMSException {
        String returnedStatus = "ERROR";
        String returnedStatusCode = "ERROR";
        TemporaryTopic tempTopic = this.session.createTemporaryTopic();
        MessageConsumer receiver = this.session.createConsumer((Destination)tempTopic);
        MessageProducer publisher = this.session.createProducer(dest);
        TextMessage textMessage = this.session.createTextMessage();
        textMessage.setStringProperty("DEVICEID", data.getDeviceId());
        textMessage.setStringProperty("DEVICETYPE", data.getDeviceType());
        textMessage.setStringProperty("DATA", this.convertToXmlString(data.getData()));
        textMessage.setStringProperty("DESTINATION", "");
        textMessage.setJMSReplyTo((Destination)tempTopic);
        textMessage.setJMSCorrelationID(this.user);
        textMessage.setJMSType(msgType);
        publisher.setTimeToLive(10000L);
        publisher.send((Message)textMessage);
        ObjectMessage received = (ObjectMessage)receiver.receive(20000L);
        if (received == null) {
            return null;
        }
        returnedStatus = received.getStringProperty(RETURNMSG_MESSAGE);
        returnedStatusCode = received.getStringProperty(RETURNMSG_CODE);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(RETURNMSG_MESSAGE, returnedStatus);
        map.put(RETURNMSG_CODE, returnedStatusCode);
        publisher.close();
        receiver.close();
        return map;
    }

    private String convertToXmlString(Object objectToConvert) {
        JAXBContext jaxbContext = null;
        StringWriter sw = new StringWriter();
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{objectToConvert.getClass()});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(objectToConvert, (Writer)sw);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return sw.toString();
    }

    public void createSendAndRequestAsynchronius(Destination dest, String msgType, DeviceData data, ResponseListenerInterface msgListener) throws JMSException {
        TemporaryTopic tempTopic = this.session.createTemporaryTopic();
        MessageConsumer receiver = this.session.createConsumer((Destination)tempTopic);
        MessageProducer publisher = this.session.createProducer(dest);
        publisher.setDeliveryMode(1);
        receiver.setMessageListener((MessageListener)msgListener);
        this.convertToXmlString(data.getData());
        TextMessage textMessage = this.session.createTextMessage();
        textMessage.setStringProperty("DEVICEID", data.getDeviceId());
        textMessage.setStringProperty("DEVICETYPE", data.getDeviceType());
        textMessage.setStringProperty("DATA", this.convertToXmlString(data.getData()));
        textMessage.setStringProperty("DESTINATION", "");
        textMessage.setStringProperty("CLASSNAME", data.getData().getClass().toString());
        textMessage.setJMSReplyTo((Destination)tempTopic);
        textMessage.setJMSCorrelationID(this.user);
        textMessage.setJMSType(msgType);
        msgListener.newStart();
        publisher.send((Message)textMessage);
        publisher.close();
        msgListener.waitToDestroyConsumer();
        receiver.close();
    }

    public MessageConsumer createConsumer(Destination dest) throws JMSException {
        return this.session.createConsumer(dest);
    }

    public void publishTextMessage(Destination dest, Destination returnDest, String msgType, String text, String option) throws JMSException {
        TextMessage msg = this.session.createTextMessage(text);
        MessageProducer publisher = this.session.createProducer(dest);
        publisher.setDeliveryMode(1);
        if (option != null) {
            msg.setStringProperty("DESTINATION", option);
        } else {
            msg.setStringProperty("DESTINATION", "");
        }
        if (returnDest != null) {
            msg.setJMSReplyTo(returnDest);
        }
        msg.setJMSCorrelationID(this.user);
        msg.setJMSType(msgType);
        msg.setJMSExpiration(10000L);
        publisher.send((Message)msg);
        publisher.close();
    }

    public void sendReply(Destination dest, HashMap<String, String> params) throws JMSException {
        ObjectMessage msg = this.session.createObjectMessage();
        MessageProducer publisher = this.session.createProducer(dest);
        publisher.setDeliveryMode(1);
        msg.setJMSCorrelationID(this.user);
        if (params == null) {
            params = new HashMap();
            params.put(RETURNMSG_MESSAGE, "Uredjaj ne vraca nikakve poruke.");
            params.put(RETURNMSG_CODE, "ERROR");
        }
        msg.setStringProperty(RETURNMSG_MESSAGE, params.get(RETURNMSG_MESSAGE));
        msg.setStringProperty(RETURNMSG_CODE, params.get(RETURNMSG_CODE));
        msg.setStringProperty(RETURN_INFO, params.get(RETURN_INFO));
        msg.setJMSType("TEXT");
        publisher.send((Message)msg);
        publisher.close();
    }

    public void publishTextMessageTopic(String destName, Destination returnDest, String msgType, String text, String option) throws JMSException {
        TextMessage msg = this.session.createTextMessage(text);
        Topic dest = this.session.createTopic(destName);
        MessageProducer publisher = this.session.createProducer((Destination)dest);
        publisher.setDeliveryMode(1);
        if (option != null) {
            msg.setStringProperty("DESTINATION", option);
        } else {
            msg.setStringProperty("DESTINATION", "");
        }
        if (returnDest != null) {
            msg.setJMSReplyTo(returnDest);
        }
        msg.setJMSCorrelationID(this.user);
        msg.setJMSType(msgType);
        msg.setJMSExpiration(10000L);
        publisher.send((Message)msg);
        publisher.close();
    }

    public void publishTextMessageQueue(String destName, Destination returnDest, String msgType, String text, String option) throws JMSException {
        TextMessage msg = this.session.createTextMessage(text);
        Queue dest = this.session.createQueue(destName);
        MessageProducer publisher = this.session.createProducer((Destination)dest);
        publisher.setDeliveryMode(1);
        if (option != null) {
            msg.setStringProperty("DESTINATION", option);
        } else {
            msg.setStringProperty("DESTINATION", "");
        }
        if (returnDest != null) {
            msg.setJMSReplyTo(returnDest);
        }
        msg.setJMSCorrelationID(this.user);
        msg.setJMSType(msgType);
        msg.setJMSExpiration(10000L);
        publisher.send((Message)msg);
        publisher.close();
    }

    public void close() throws JMSException {
        this.session.close();
        this.connection.stop();
        this.connection.close();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }
}

