/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.device.cashregister;

import java.util.HashMap;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.JMSException;
import rs.pezar.msg.PzExtensionLoader;
import rs.pezar.msg.device.DeviceManager;
import rs.pezar.msg.device.DevicePickerWindow;
import rs.pezar.msg.device.NetDataWrapper;
import rs.pezar.msg.device.cashregister.data.CashRegisterBill;
import rs.pezar.msg.device.cashregister.data.CashRegisterControl;
import rs.pezar.msg.device.cashregister.data.DeviceData;
import rs.pezar.msg.device.cashregister.exceptions.CRException;
import rs.pezar.msg.msg.MsgProtocol;
import rs.pezar.msg.msg.ResponseListener;
import rs.pezar.msg.tools.xml.NetDeviceSettings;

public class CashRegisterHandler {
    public static HashMap<String, String> sendToDefaultCashRegister(Object cashRegisterData) throws CRException {
        CashRegisterBill bill = null;
        CashRegisterControl control = null;
        String code = null;
        String message = null;
        String infos = null;
        HashMap<String, String> result = new HashMap<String, String>();
        if (cashRegisterData instanceof CashRegisterBill) {
            bill = (CashRegisterBill)cashRegisterData;
        } else if (cashRegisterData instanceof CashRegisterControl) {
            control = (CashRegisterControl)cashRegisterData;
        }
        Vector<NetDeviceSettings> deviceInfos = DeviceManager.getnetDevices();
        if (deviceInfos == null || deviceInfos.size() == 0) {
            throw new CRException("Nije podesen ni jedan uredjaj za stampanje fiskalnih racuna,\n idite na meni za podesavanje uredjaja i podesite uredjaj koji zelite da koristite.");
        }
        NetDeviceSettings deviceSettings = DevicePickerWindow.getDevice(deviceInfos, "TYPE_CASHREGISTER");
        if (deviceSettings == null) {
            throw new CRException("Nije podesena ni jedna kasa za rad.\nIdite na meni za podesavanje uredjaja i podesite kasu koju zelite da koristite.");
        }
        DeviceData data = new DeviceData();
        data.setDeviceId(deviceSettings.getId());
        data.setDeviceType(deviceSettings.getType());
        if (bill != null) {
            data.setData(bill);
        } else {
            data.setData(control);
        }
        if (deviceSettings.getLocal().equals("yes")) {
            NetDataWrapper nw = new NetDataWrapper();
            nw.setData(data);
            nw.setLocalDevice(true);
            HashMap<String, String> temp = PzExtensionLoader.getInstance().getDeviceManager().pushDeviceData(nw);
            if (temp != null && temp.size() != 0) {
                message = temp.get("MESSAGE");
                infos = temp.get("INFO");
                code = temp.get("CODE");
            } else {
                message = "Uredjaj ne vraca nikakve poruke";
                code = "ERROR";
            }
        } else {
            MsgProtocol msgProtocol = MsgProtocol.getInstance();
            if (msgProtocol == null) {
                throw new CRException("Komunacija sa serverom za razmenu poruka nije ostvarena");
            }
            ResponseListener listener = new ResponseListener();
            try {
                msgProtocol.sendDeviceDataMessageASync((Destination)msgProtocol.createDestinationFromQueueName(deviceSettings.getQueue()), data, listener);
            }
            catch (JMSException e) {
                throw new CRException(e.getMessage());
            }
            listener.waitOnResponse();
            code = listener.getStatusCode();
            message = listener.getMessageCode();
            infos = listener.getInfoMessage();
        }
        if (code.equals("ERROR")) {
            CRException crEx = new CRException(message);
            crEx.setMessages(message);
            crEx.setInfos(infos);
            throw crEx;
        }
        if (code.equals("SUCCESS")) {
            result.put("CODE", "SUCCESS");
            result.put("MESSAGE", message);
            result.put("INFOS", infos);
        }
        return result;
    }
}

