/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.device;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rs.pezar.msg.tools.xml.NetDeviceSettings;

public class DevicePickerWindow
extends JDialog
implements ActionListener {
    private static final int MAX_NUM_OF_DEVICES = 30;
    private JPanel jPanel1;
    private JLabel lblUredjaj;
    private JButton btnOdustani;
    private JButton btnOK;
    private JLabel lnlaziv;
    private JComboBox cmbUredjaj;
    private JPanel pnlIzbor;
    private String[] devNames = new String[30];
    private String[] devIds = new String[30];

    public DevicePickerWindow(Vector<NetDeviceSettings> devicesToSelectFrom) {
        int i = 0;
        while (i < devicesToSelectFrom.size()) {
            this.devNames[i] = devicesToSelectFrom.get(i).getName();
            this.devIds[i] = devicesToSelectFrom.get(i).getId();
            ++i;
        }
        this.initGUI();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                DevicePickerWindow.this.cmbUredjaj.setSelectedItem(null);
                DevicePickerWindow.this.dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
    }

    private void initGUI() {
        try {
            this.setTitle("Izbor uredjaja");
            this.jPanel1 = new JPanel();
            this.getContentPane().add((Component)this.jPanel1, "Center");
            this.jPanel1.setLayout(null);
            this.jPanel1.setPreferredSize(new Dimension(391, 203));
            this.pnlIzbor = new JPanel();
            this.jPanel1.add(this.pnlIzbor);
            this.pnlIzbor.setBounds(12, 12, 367, 146);
            this.pnlIzbor.setBorder(BorderFactory.createTitledBorder("Izbor uredjaja"));
            this.pnlIzbor.setLayout(null);
            this.lblUredjaj = new JLabel();
            this.pnlIzbor.add(this.lblUredjaj);
            this.lblUredjaj.setText("Koristi uredjaj(ID):");
            this.lblUredjaj.setBounds(17, 29, 130, 14);
            this.lnlaziv = new JLabel();
            this.pnlIzbor.add(this.lnlaziv);
            this.lnlaziv.setBounds(17, 60, 337, 76);
            DefaultComboBoxModel<String> cmbUredjajModel = new DefaultComboBoxModel<String>(this.devIds);
            this.cmbUredjaj = new JComboBox();
            this.pnlIzbor.add(this.cmbUredjaj);
            this.cmbUredjaj.setModel(cmbUredjajModel);
            this.cmbUredjaj.setBounds(165, 25, 189, 23);
            this.cmbUredjaj.setMaximumRowCount(10);
            this.cmbUredjaj.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (DevicePickerWindow.this.cmbUredjaj.getSelectedIndex() != -1) {
                        DevicePickerWindow.this.lnlaziv.setText(DevicePickerWindow.this.devNames[DevicePickerWindow.this.cmbUredjaj.getSelectedIndex()]);
                    }
                }
            });
            this.lnlaziv.setText(this.devNames[this.cmbUredjaj.getSelectedIndex()]);
            this.lnlaziv.setBorder(BorderFactory.createTitledBorder("Naziv uredjaja"));
            this.btnOK = new JButton();
            this.jPanel1.add(this.btnOK);
            this.btnOK.setText("Ok");
            this.btnOK.setBounds(224, 170, 54, 21);
            this.btnOK.addActionListener(this);
            this.btnOK.setDefaultCapable(true);
            this.getRootPane().setDefaultButton(this.btnOK);
            this.btnOdustani = new JButton();
            this.jPanel1.add(this.btnOdustani);
            this.btnOdustani.setText("Odustani");
            this.btnOdustani.setBounds(283, 170, 96, 21);
            this.btnOdustani.addActionListener(this);
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSelectedId() {
        if (this.cmbUredjaj.getSelectedIndex() == -1) {
            return null;
        }
        return this.cmbUredjaj.getSelectedItem().toString();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.btnOK) {
            this.dispose();
        } else if (arg0.getSource() == this.btnOdustani) {
            this.cmbUredjaj.setSelectedItem(null);
            this.dispose();
        }
    }

    public static NetDeviceSettings getDevice(Vector<NetDeviceSettings> devices, String deviceType) {
        int countOfDevicesWithTheSameType = 0;
        Vector<NetDeviceSettings> deviceFilter = new Vector<NetDeviceSettings>();
        int i = 0;
        while (i < devices.size()) {
            if (devices.get(i).getType().equals(deviceType)) {
                ++countOfDevicesWithTheSameType;
                deviceFilter.add(devices.get(i));
            }
            ++i;
        }
        if (countOfDevicesWithTheSameType == 0) {
            return null;
        }
        if (countOfDevicesWithTheSameType == 1) {
            return (NetDeviceSettings)deviceFilter.get(0);
        }
        if (countOfDevicesWithTheSameType > 1) {
            DevicePickerWindow w = new DevicePickerWindow(devices);
            w.getSelectedId();
            w.setModal(true);
            w.setVisible(true);
            String id = w.getSelectedId();
            if (id == null) {
                return null;
            }
            int i2 = 0;
            while (i2 < devices.size()) {
                if (devices.get(i2).getId().equals(id)) {
                    return devices.get(i2);
                }
                ++i2;
            }
        }
        return null;
    }
}

