/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.fields;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.xBaseJ.DBF;
import org.xBaseJ.DBTFile;
import org.xBaseJ.fields.Field;
import org.xBaseJ.xBaseJException;

public class MemoField
extends Field {
    private static final long serialVersionUID = 1L;
    boolean foxPro = false;
    private DBTFile dbtobj;
    private int originalSize;
    private String value;
    private byte[] byteValue;

    public MemoField() {
    }

    public MemoField(boolean inFoxPro) {
        this.foxPro = inFoxPro;
    }

    public boolean isFoxPro() {
        return this.foxPro;
    }

    public void setDBTObj(DBTFile indbtobj) {
        this.dbtobj = indbtobj;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            MemoField tField = new MemoField(this.Name, null, null);
            return tField;
        }
        catch (xBaseJException xBaseJException2) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public MemoField(String Name, ByteBuffer inBuffer, DBTFile indbtobj) throws xBaseJException, IOException {
        super.setField(Name, 10, inBuffer);
        this.dbtobj = indbtobj;
        this.value = new String("");
    }

    public MemoField(String iName) throws xBaseJException, IOException {
        super.setField(iName, 10, null);
        this.dbtobj = null;
        this.originalSize = 0;
        this.buffer = new byte[10];
        int i = 0;
        while (i < 10) {
            this.buffer[i] = 48;
            ++i;
        }
        this.value = new String("");
    }

    public MemoField(String iName, boolean inFoxPro) throws xBaseJException, IOException {
        super.setField(iName, 10, null);
        this.foxPro = inFoxPro;
        this.dbtobj = null;
        this.originalSize = 0;
        this.buffer = new byte[10];
        int i = 0;
        while (i < 10) {
            this.buffer[i] = 48;
            ++i;
        }
        this.value = new String("");
    }

    @Override
    public char getType() {
        return 'M';
    }

    @Override
    public String get() {
        String s = "";
        if (this.byteValue == null) {
            return "";
        }
        try {
            s = new String(this.byteValue, DBF.encodedType);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            s = new String(this.byteValue);
        }
        if (this.byteValue.length < 2) {
            return s;
        }
        int k = this.byteValue.length;
        while (k > -1 && this.byteValue[k - 1] == 0) {
            --k;
        }
        return s.substring(0, k);
    }

    @Override
    public byte[] getBytes() {
        return this.byteValue;
    }

    @Override
    public void read() throws IOException, xBaseJException {
        super.read();
        this.byteValue = this.dbtobj.readBytes(this.buffer);
        if (this.byteValue == null) {
            this.value = "";
            this.originalSize = 0;
        } else {
            this.value = new String(this.byteValue);
            this.originalSize = this.value.length();
        }
    }

    @Override
    public void put(String invalue) {
        this.value = new String(invalue);
        this.byteValue = this.value.getBytes();
    }

    @Override
    public void put(byte[] inBytes) throws xBaseJException {
        this.byteValue = inBytes;
    }

    @Override
    public void write() throws IOException, xBaseJException {
        this.buffer = this.dbtobj.write(this.value, this.originalSize, true, this.buffer);
        super.write();
    }

    @Override
    public void update() throws IOException, xBaseJException {
        this.buffer = this.dbtobj.write(this.value, this.originalSize, false, this.buffer);
        super.write();
    }
}

