/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.fields;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.xBaseJ.Util;
import org.xBaseJ.fields.Field;
import org.xBaseJ.xBaseJException;

public class LogicalField
extends Field {
    private static final long serialVersionUID = 1L;
    public static final byte BYTETRUE = 84;
    public static final byte BYTEFALSE = 70;

    @Override
    public Object clone() throws CloneNotSupportedException {
        LogicalField tField = (LogicalField)super.clone();
        tField.Name = new String(this.Name);
        tField.Length = 1;
        return tField;
    }

    public LogicalField() {
    }

    public LogicalField(String iName, ByteBuffer inBuffer) throws xBaseJException {
        super.setField(iName, 1, inBuffer);
        this.put('F');
    }

    public LogicalField(String iName) throws xBaseJException, IOException {
        super.setField(iName, 1, null);
    }

    @Override
    public char getType() {
        return 'L';
    }

    @Override
    public void put(String inValue) throws xBaseJException {
        String value = inValue.trim();
        if (!Util.dontTrimFields()) {
            value = inValue;
        }
        if (value.length() == 0) {
            value = "F";
        }
        if (value.length() != 1) {
            throw new xBaseJException("Field length incorrect");
        }
        this.put(value.charAt(0));
    }

    public void put(char inValue) throws xBaseJException {
        switch (inValue) {
            case '1': 
            case 'T': 
            case 'Y': 
            case 't': 
            case 'y': {
                this.buffer[0] = 84;
                break;
            }
            case '0': 
            case 'F': 
            case 'N': 
            case 'f': 
            case 'n': {
                this.buffer[0] = 70;
                break;
            }
            default: {
                throw new xBaseJException("Invalid logical Field value");
            }
        }
    }

    public void put(boolean inValue) {
        this.buffer[0] = inValue ? 84 : 70;
    }

    public char getChar() {
        return (char)this.buffer[0];
    }

    public boolean getBoolean() {
        return this.buffer[0] == 84;
    }
}

