/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.trebovanje;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.ArtikalopstidokumentPK;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.proizvodnja.gui.PzDialogStornoTrebovanja;
import rs.pezar.proizvodnja.gui.trebovanje.PzDialogIzrada;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.util.PzGradient;

public class Arhiviranje
extends PzDialog {
    private PzPanel mainPanel;
    private PzPanel pnlNorth;
    private JLabel jLabel7;
    private PzButton btnOk;
    private JLabel jLabel1;
    private PzPanel pnlButtons;
    private PzPanel pnlSouth;
    private PzDateField datum;
    private PzTextAreaPanel razlog;
    private PzDialogIzrada parent;
    private Opstidokument trebovanje;
    private Opstidokument stornoTrebovanje;
    private boolean storniranje = false;
    private PzDialogStornoTrebovanja parentStorno;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                Arhiviranje inst = new Arhiviranje(frame);
                inst.setVisible(true);
            }
        });
    }

    public Arhiviranje(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public Arhiviranje(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.trebovanje = (Opstidokument)this.getSession().getParameter("trebovanje");
        boolean bl = this.storniranje = this.getSession().getParameter("storniranje") != null;
        if (this.storniranje) {
            this.parentStorno = (PzDialogStornoTrebovanja)dialog;
            this.stornoTrebovanje = (Opstidokument)this.getSession().getParameter("storno");
            this.datum.setVal((Object)this.trebovanje.getDatum());
            this.datum.setEnabled(false);
        } else {
            this.parent = (PzDialogIzrada)dialog;
        }
        this.paintPanel();
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            if (this.getSession().getParameter("storniranje") == null) {
                this.setTitle("Arhiviranje trebovanja");
            } else {
                this.setTitle("Arhiviranje storna trebovanja");
            }
            this.mainPanel = new PzPanel();
            GridBagLayout pnlMainLayout = new GridBagLayout();
            pnlMainLayout.columnWidths = new int[]{7};
            pnlMainLayout.rowHeights = new int[]{3, 76, 247, 3};
            pnlMainLayout.columnWeights = new double[]{0.1};
            pnlMainLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 2.0};
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setLayout((LayoutManager)pnlMainLayout);
            this.pnlNorth = new PzPanel();
            GridBagLayout pnlNorthLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlNorth, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlNorthLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            pnlNorthLayout.rowHeights = new int[]{38, 16, 24};
            pnlNorthLayout.columnWeights = new double[]{0.0, 0.0, 1.0, 0.1};
            pnlNorthLayout.columnWidths = new int[]{106, 125, 7, 20};
            this.pnlNorth.setLayout((LayoutManager)pnlNorthLayout);
            this.pnlNorth.setPreferredSize(new Dimension(583, 44));
            this.pnlNorth.setOpaque(false);
            this.jLabel7 = new JLabel();
            this.pnlNorth.add((Component)this.jLabel7, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel7.setText("Datum izrade:");
            this.datum = new PzDateField();
            this.pnlNorth.add((Component)this.datum, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
            this.datum.setVal((Object)new Date(new java.util.Date().getTime()));
            this.pnlSouth = new PzPanel();
            GridBagLayout pnlSouthLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlSouth, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlSouthLayout.rowWeights = new double[]{0.0, 0.1};
            pnlSouthLayout.rowHeights = new int[]{25, 7};
            pnlSouthLayout.columnWeights = new double[]{5.0};
            pnlSouthLayout.columnWidths = new int[1];
            this.pnlSouth.setLayout((LayoutManager)pnlSouthLayout);
            this.pnlSouth.setOpaque(false);
            this.jLabel1 = new JLabel();
            this.pnlSouth.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 18, 0, 0), 0, 0));
            this.jLabel1.setText("Razlog izrade");
            this.jLabel1.setPreferredSize(new Dimension(123, 14));
            this.razlog = new PzTextAreaPanel();
            this.pnlSouth.add((Component)this.razlog, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 6, 0, 6), 0, 0));
            this.pnlButtons = new PzPanel();
            GridBagLayout pnlButtonsLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlButtons, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlButtons.setLayout((LayoutManager)pnlButtonsLayout);
            this.pnlButtons.setOpaque(false);
            this.pnlButtons.setPreferredSize(new Dimension(583, 65));
            this.btnOk = new PzButton();
            this.pnlButtons.add((Component)this.btnOk, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOk.setText("OK");
            this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/check.png")));
            this.btnOk.setSize(100, 40);
            this.btnOk.setPreferredSize(new Dimension(160, 40));
            this.btnOk.setActionCommand("arhiva");
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.btnOk.setShortcut("ctrl+w");
            pnlButtonsLayout.rowWeights = new double[]{0.1};
            pnlButtonsLayout.rowHeights = new int[]{7};
            pnlButtonsLayout.columnWeights = new double[]{0.0};
            pnlButtonsLayout.columnWidths = new int[]{325};
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("arhiva")) {
                if (this.storniranje) {
                    this.arhivirajStorno();
                } else if (this.trebovanje.getTip().equals("TREBOVANJE")) {
                    this.arhiviraj();
                } else if (this.trebovanje.getTip().equals("TREBOVANJE_SASTAVNICE")) {
                    this.arhivirajSast();
                }
            }
            this.dispose();
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    /*
     * Exception decompiling
     */
    private void arhiviraj() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void arhivirajSast() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[WHILELOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void arhivirajStorno() {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                em.getTransaction().begin();
                Vector artikli = (Vector)this.getSession().getParameter("artikli");
                this.stornoTrebovanje.setArtikalopstidokuments(new Vector());
                Stanje s = null;
                for (Artikalopstidokument aob : artikli) {
                    aob.setAodtaksas(new Vector());
                    aob.setKolicinaBaza(0.0);
                    this.stornoTrebovanje.getArtikalopstidokuments().add(aob);
                    s = (Stanje)PzEntityManager.find(Stanje.class, (Object)new StanjePK(aob.getId().getSfrProizvod(), this.trebovanje.getRadnajedinica()), (EntityManager)em);
                    if (s != null) {
                        s.setKolicina(s.getKolicina() + aob.getKolicina());
                        s.setKumIzlaza(s.getKumIzlaza() - aob.getKolicina());
                        s.setDatZadIzlaza(this.trebovanje.getDatum());
                        em.merge((Object)s);
                    }
                    Artikalopstidokument aobr = (Artikalopstidokument)PzEntityManager.find(Artikalopstidokument.class, (Object)new ArtikalopstidokumentPK(this.trebovanje.getIdDok(), aob.getId().getSfrProizvod(), aob.getId().getrBroj()), (EntityManager)em);
                    aobr.setKolicinaBaza(aobr.getKolicinaBaza() + aob.getKolicina());
                    em.merge((Object)aobr);
                }
                this.stornoTrebovanje.setArhiviran((short)1);
                this.stornoTrebovanje.setOznDokumenta(this.trebovanje.getOznDokumenta());
                this.stornoTrebovanje.setDatArh(new Date(new java.util.Date().getTime()));
                PzDokumentManager.getInstance().arhivirajStorno((PzDokument)this.stornoTrebovanje, PzEntityManager.KOLICINE_NEPROMENJENE, PzEntityManager.KOLICINA_UKUPNA, true, null, em);
                em.getTransaction().commit();
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.stornoTrebovanje);
                this.parentStorno.finish();
                this.dispose();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private HashMap<String, String> kontrolaKolicina(EntityManager em) {
        Query q = null;
        q = em.createQuery("SELECT a.id.sfrProizvod, sum(a.kolicina), a.lokacija FROM Artikalopstidokument a WHERE a.id.idDok =:iddok GROUP BY a.id.sfrProizvod, a.lokacija");
        q.setParameter("iddok", (Object)this.trebovanje.getIdDok());
        Vector stavke = (Vector)q.getResultList();
        for (Object[] obj : stavke) {
            String sifra = (String)obj[0];
            double kol = (Double)obj[1];
            String rj = (String)obj[2];
            Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(sifra, "1", rj));
            if (!s.getRadnajedinica().getMinusKolicine().equals("ZABRANJEN") && (!s.getRadnajedinica().getgTip().equals("S") || !s.getRadnajedinica().getNacinVodjenja().equals("PRNC")) || !(s.getKolicina() - s.getAlocKolicina() < kol)) continue;
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("sifra", sifra);
            hm.put("rj", rj);
            return hm;
        }
        return null;
    }

    private Opstidokument nadjiTrebovanje(Vector<Opstidokument> trebovanja, String oznRJ) {
        for (Opstidokument t : trebovanja) {
            if (!t.getRadnajedinica().getId().getOznRj().equals(oznRJ)) continue;
            return t;
        }
        return null;
    }

    public static Object getGUIBuilderInstance() {
        return new Arhiviranje(Boolean.FALSE);
    }

    public Arhiviranje(Boolean initGUI) {
    }
}

