/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.prijemnice.troskovi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.db.entity.Trosak;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.custom.PzDialogPorez;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzGradient;

public class PzDialogPorezTroskovi
extends PzDialogPorez {
    private static final long serialVersionUID = 3754714125154376114L;
    private PzPanelHeader header;
    private PzPanel panel;
    private PzButton btnOK;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzDoubleField iznos;
    private PzDoubleField osnovica;
    private JCheckBox chckbxPorezkoduvoza;
    private PzPanel mainPanel;

    public PzDialogPorezTroskovi() {
        this.initGUI();
        this.paintPanel();
    }

    public void passSelectedPorez(PzTaksaDokument porez) throws Exception {
        super.passSelectedPorez(porez);
        Taksakalkulacija tt = (Taksakalkulacija)porez;
        Kalkulacija k = (Kalkulacija)this.getParameters().get("kalkulacija");
        String tip = (String)this.getParameters().get("tip");
        Komitent komitent = (Komitent)this.getParameters().get("trosak_komitent");
        if (komitent == null) {
            throw new PzInfoException("Za trenutni tro\u0161ak nije definisan komitent. Morate prvo uneti \u0161ifru komitenta!");
        }
        if (tip.equals(Trosak.TIP_CARINA) || komitent.getTip() == 3) {
            this.chckbxPorezkoduvoza.setVisible(true);
            this.chckbxPorezkoduvoza.setSelected(true);
            this.chckbxPorezkoduvoza.setEnabled(false);
        } else {
            this.chckbxPorezkoduvoza.setVisible(k.getKomitent().getDomaciKomitent() == 0);
            this.chckbxPorezkoduvoza.setSelected(tt.getPorezKodUvoza() == 1);
        }
        this.iznos.setVal((Object)porez.getIznos());
        this.osnovica.setVal((Object)porez.getOsnovica());
    }

    public void modifyPorez() {
        this.getSelectedPorez().setIznos(this.iznos.getBigDecimal());
        this.getSelectedPorez().setOsnovica(this.osnovica.getBigDecimal());
        ((Taksakalkulacija)this.getSelectedPorez()).setPorezKodUvoza((short)(this.chckbxPorezkoduvoza.isSelected() ? 1 : 0));
    }

    public void actionPerformed(ActionEvent e) {
        this.confirmChanges();
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession() != null && this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            BorderLayout mainPanelLayout = new BorderLayout();
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.header = new PzPanelHeader();
            this.header.setTitle("Unos poreza");
            this.header.setOpaque(false);
            this.mainPanel.add((Component)this.header, (Object)"North");
            this.panel = new PzPanel();
            this.panel.setOpaque(false);
            this.mainPanel.add((Component)this.panel, (Object)"Center");
            GridBagLayout gbl_panel = new GridBagLayout();
            gbl_panel.columnWidths = new int[]{80, 130, 10};
            gbl_panel.rowHeights = new int[]{5, 24, 24, 5, 30, 20};
            gbl_panel.columnWeights = new double[]{0.0, 0.0, 0.1};
            gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            this.panel.setLayout((LayoutManager)gbl_panel);
            this.chckbxPorezkoduvoza = new JCheckBox("Porez kod uvoza");
            this.chckbxPorezkoduvoza.setVisible(false);
            GridBagConstraints gbc_chckbxPorezkoduvoza = new GridBagConstraints();
            gbc_chckbxPorezkoduvoza.anchor = 17;
            gbc_chckbxPorezkoduvoza.insets = new Insets(0, -4, 5, 0);
            gbc_chckbxPorezkoduvoza.gridx = 1;
            gbc_chckbxPorezkoduvoza.gridy = 0;
            this.panel.add((Component)this.chckbxPorezkoduvoza, (Object)gbc_chckbxPorezkoduvoza);
            this.jLabel1 = new JLabel();
            GridBagConstraints gbc_jLabel1 = new GridBagConstraints();
            gbc_jLabel1.fill = 2;
            gbc_jLabel1.insets = new Insets(0, 20, 5, 5);
            gbc_jLabel1.gridx = 0;
            gbc_jLabel1.gridy = 1;
            this.panel.add((Component)this.jLabel1, (Object)gbc_jLabel1);
            this.jLabel1.setText("Osnovica:");
            this.osnovica = new PzDoubleField();
            GridBagConstraints gbc_osnovica = new GridBagConstraints();
            gbc_osnovica.fill = 1;
            gbc_osnovica.insets = new Insets(0, 0, 5, 0);
            gbc_osnovica.gridx = 1;
            gbc_osnovica.gridy = 1;
            this.panel.add((Component)this.osnovica, (Object)gbc_osnovica);
            this.jLabel2 = new JLabel();
            GridBagConstraints gbc_jLabel2 = new GridBagConstraints();
            gbc_jLabel2.fill = 2;
            gbc_jLabel2.insets = new Insets(0, 20, 5, 5);
            gbc_jLabel2.gridx = 0;
            gbc_jLabel2.gridy = 2;
            this.panel.add((Component)this.jLabel2, (Object)gbc_jLabel2);
            this.jLabel2.setText("Iznos:");
            this.iznos = new PzDoubleField();
            GridBagConstraints gbc_iznos = new GridBagConstraints();
            gbc_iznos.fill = 1;
            gbc_iznos.insets = new Insets(0, 0, 5, 0);
            gbc_iznos.gridx = 1;
            gbc_iznos.gridy = 2;
            this.panel.add((Component)this.iznos, (Object)gbc_iznos);
            this.iznos.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent evt) {
                    PzDialogPorezTroskovi.this.iznosFocusGained(evt);
                }
            });
            this.btnOK = new PzButton();
            GridBagConstraints gbc_btnOK = new GridBagConstraints();
            gbc_btnOK.fill = 1;
            gbc_btnOK.gridx = 1;
            gbc_btnOK.gridy = 4;
            this.panel.add((Component)this.btnOK, (Object)gbc_btnOK);
            this.btnOK.setText("Potvrdi");
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/check.png")));
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setResizable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void iznosFocusGained(FocusEvent evt) {
        this.iznos.setVal((Object)(this.osnovica.getVal() * Double.valueOf(this.getSelectedPorez().getTarifnagrupa().getStopa()) / 100.0));
    }
}

